#include <gtk/gtk.h>

#ifndef _CMIESIAC_
#define _CMIESIAC_

class CDay
{
  public:

    bool pusty;
    bool swieto;
    int dzien;
    int miesiac;
    int dzien_tygodnia;
    int ktory;

    void Nowy(GDate data)
    {
      dzien = g_date_get_day(&data);
      miesiac = g_date_get_month(&data);
      dzien_tygodnia = g_date_get_weekday(&data);
      ktory = g_date_get_day_of_year(&data);

      swieto = false;
      pusty = false;
    }

    CDay(){pusty=true;}
    ~CDay(){};
};

class CWeek
{
  public:

    bool pusty;
    int ktory;
    CDay dni[7];

    void NowyTydzien(GDate dzien, int msc)
    {
      GDate tmp = dzien;
      int dzienPierwszy = g_date_get_weekday(&dzien);

      for(;;)     //odejmuje od dnia
      {
        int dzienTygodnia = g_date_get_weekday(&dzien);

        if(dzienTygodnia<dzienPierwszy||g_date_get_day(&dzien)==g_date_get_day(&tmp))
          dni[dzienTygodnia-1].Nowy(dzien);
        else
          break;

        if(dzienTygodnia==1)    //jezeli dzien to poniedzialek to oblicz numer tygodnia
          ktory = g_date_get_iso8601_week_of_year(&dzien);//g_date_get_iso8601_week_of_year(&dzien);

        g_date_subtract_days(&dzien, 1);
      }

      for(;;)
      {
        g_date_add_days(&tmp, 1);

        int dzienTygodnia = g_date_get_weekday(&tmp);

        if(dzienTygodnia>dzienPierwszy)
          dni[dzienTygodnia-1].Nowy(tmp);
        else
          break;
      }


      //Jezeli zaden dzien nie nalezy do miesiaca to zostaw pusty
      bool czyNalezyDoMsc = false;

      for(unsigned int i=0; i<7; i++)
        if(dni[i].miesiac==msc)
          czyNalezyDoMsc=true;

      pusty = !czyNalezyDoMsc;
    }

    CWeek(){pusty=true;}
    ~CWeek(){}
};

struct CMiesiac
{
  public:
    bool pusty;
    bool rok_przestepny;
    int ktory;
    int rok;
    CWeek  tygodnie[6];

    void Nowy(int msc, int r)
    {
      if(r<2||r>4000)   //jezeli rok jest niepoprawny
      {
        pusty = true;
        return;
      }

      if(msc<1||msc>12)   //jezeli miesiac jest niepoprawny
      {
        pusty=true;
        return;
      }

      GDate* data = g_date_new_dmy(1, (GDateMonth)msc, r);

      for (unsigned int i = 0; i<6;i++)
      {
        tygodnie[i].NowyTydzien(*data, msc);
        g_date_add_days(data, 7);
      }



      g_date_free(data);

      rok_przestepny = g_date_is_leap_year(r);
      ktory = msc;
      rok = r;
      pusty=false;
    }

    void DodajSwieto(int msc, int dz)
    {
      if(pusty)
        return;

      if(ktory!=msc)
        return;

      for(unsigned int i=0;i<6;i++)
        if(tygodnie[i].pusty)
          break;
        else
          for(unsigned int d =0; d<7;d++)
            if(tygodnie[i].dni[d].dzien==dz&&tygodnie[i].dni[d].miesiac==msc)
              tygodnie[i].dni[d].swieto = true;
    }

    void DodajSwieto(int dz)
    {
      int ile_dni[12] = {31,29,31,30,31,30,31,31,30,31,30,31};
      int dzien_buf = 0;
      int ktory_msc = 0;

      if(dz<1 || dz>366)
        return;

      while(dz>dzien_buf)
      {
        dzien_buf += ile_dni[ktory_msc];
        ktory_msc++;
      }

      dzien_buf -= ile_dni[ktory_msc-1];

      DodajSwieto(ktory_msc, dz-dzien_buf);
    }


    CMiesiac(){pusty=true;}
    ~CMiesiac(){}
};







#endif
