#include "CPlugin.h"


void CPlugin::query ()
{
  static GimpParamDef args[] =
  {
    {
      GIMP_PDB_INT32,
      "run-mode",
      "Run mode"
    }
  };

  gimp_install_procedure (
    "CalendarGenerator v0.1",
    "Generuje kaledarz.",
    "Generuje kalendarz.",
    "Dominik Urbański",
    "Copyright Dominik Urbański",
    "2012",
    "_CalendarGenerator...",
    "",
    GIMP_PLUGIN,
    G_N_ELEMENTS (args),
    0,
    args,
    NULL);

  gimp_plugin_menu_register ("CalendarGenerator v0.1",
                             "<Image>/Filters/Render");
}


void CPlugin::run (const gchar *name, gint nparams, const GimpParam *param, gint *nreturn_vals, GimpParam **return_vals)
{
  static GimpParam  values[1];
  GimpPDBStatusType status = GIMP_PDB_SUCCESS;
  GimpRunMode       run_mode;
  CPlugin plugin;

  *nreturn_vals = 1;
  *return_vals  = values;

  values[0].type = GIMP_PDB_STATUS;
  values[0].data.d_status = status;

  //pobranie trybu pracy; ten plugin nie dziala w trybie nie-interaktywnym
  run_mode = (GimpRunMode)param[0].data.d_int32;

  //wczytanie poprzednich ustawien jezeli istnieja, w przeciwnym razie wczytanie domyslnych ustawien
  plugin.WczytajUstawienia();

  switch(run_mode)
  {
    case GIMP_RUN_INTERACTIVE:
    {
      CPluginGUI gui;
      std::string plik_okna(sciezka_wtyczki, 0, sciezka_wtyczki.size()-4);
      plik_okna += PLIK_OKNA;

      if(gui.Wczytaj(plik_okna.c_str()))
        if(gui.PokazOkno(plugin.ust))       //jezeli nacisnieto OK
        {
          plugin.Wykonaj();                 //wygeneruj kalendarz
          gimp_set_data(PLUGIN_NAZWA, &plugin.ust, sizeof(plugin.ust));   //i zapisz ustawienia
        }
      break;
    }
    case GIMP_RUN_NONINTERACTIVE:
    {
      gimp_message("Tylko tryb interaktywny.");
      break;
    }
    case GIMP_RUN_WITH_LAST_VALS:
    {
      plugin.Wykonaj();
      break;
    }
    default:
      break;
  }


  return;
}



/******Wykonaj********/
/**tworzy nowy obraz z warstwa bedaca kalendarzem**/
bool CPlugin::Wykonaj()
{
  unsigned int x, y;
  unsigned int sizeX, sizeY;

  GdkPixbuf* pixbuf;
  cairo_surface_t* surface;
  cairo_t* cr;

  switch(ust.ukladRoku)
  {
    case 0:
    case 1:
    case 2:
    case 3:
    {
      x = ust.ukladRoku+1;
      break;
    }
    case 4:
    {
      x = 6;
      break;
    }
    case 5:
    {
      x = 12;
      break;
    }
  }
  y = 12/x;

  sizeX = ust.tylko1msc?(ust.UOWymiarMscX * ust.skala):(ust.UOWymiarMscX * ust.skala * x);
  sizeY = ust.tylko1msc?(ust.UOWymiarMscY * ust.skala):(ust.UOWymiarMscY * ust.skala * y);

  pixbuf = gdk_pixbuf_new(GDK_COLORSPACE_RGB, true, 8, sizeX, sizeY);

  if(pixbuf)      //jezeli udalo sieutworzyc region
  {
    surface = cairo_image_surface_create_for_data(gdk_pixbuf_get_pixels(pixbuf),
                                                  CAIRO_FORMAT_ARGB32,
                                                  sizeX,
                                                  sizeY,
                                                  gdk_pixbuf_get_rowstride(pixbuf));
    cr = cairo_create(surface);

    if(cairo_status(cr)==CAIRO_STATUS_SUCCESS)    //jezeli utworzono powierzchnie cairo
    {
      CPluginGenerator generator(cr,
                                 gimp_progress_init("Generowanie kalendarza..."));

      cairo_set_source_rgba(cr, 0.0, 0.0, 0.0, 0.0);
      cairo_paint(cr);

      if(generator.Generuj(ust))                //jezeli wygenerowano kalendarz
      {
        RGB2BGR(pixbuf);

        gint32 image = gimp_image_new(sizeX, sizeY, GIMP_RGB);
        gint32 layer = gimp_layer_new_from_pixbuf(image, "Calendar", pixbuf, 100, GIMP_NORMAL_MODE, 0, 0);

        gimp_image_add_layer(image, layer, -1);
        gimp_display_new(image);
      }

      cairo_destroy(cr);
      cairo_surface_destroy(surface);
    }

    g_object_unref(pixbuf);
  }

  return true;
}


/******Wczytuje poprzednie ustawienia lub domyslna ustawienia*******/
/**tworzy nowy obraz z warstwa bedaca kalendarzem**/
void CPlugin::WczytajUstawienia()
{
  if(gimp_get_data_size(PLUGIN_NAZWA)==sizeof(ust))
    gimp_get_data(PLUGIN_NAZWA, &ust);
  else
  {
    std::string nazwa(sciezka_wtyczki, 0, sciezka_wtyczki.size()-4);
    nazwa+="\\STYL_default";

    std::ifstream plik;
    plik.open(nazwa.c_str());

    if(!plik.is_open())
      memset(&ust, 0, sizeof(ust));

    plik.read((char*)&ust, sizeof(ust));

    plik.close();
  }
}


/*****RGB2BGR******/
/**zamienia kanal red z kanalem blue**/
void CPlugin::RGB2BGR(GdkPixbuf* pixbuf)
{
  unsigned int wiersz = gdk_pixbuf_get_rowstride(pixbuf);
  unsigned int wys = gdk_pixbuf_get_height(pixbuf);
  unsigned int szer = gdk_pixbuf_get_width(pixbuf)*4;

  unsigned int bufr, bufg, bufb, bufa;

  unsigned char* data = gdk_pixbuf_get_pixels(pixbuf);

  for(unsigned int y=0; y<wys; y++)
    for(unsigned int x = 0; x<szer; x+=4)
    {
      if(bufa = data[wiersz*y+x+3])   //jezeli pixel nie jest calkowicie przezroczysty
      {
        bufr = data[wiersz*y+x+2] * 255;
        bufg = data[wiersz*y+x+1] * 255;
        bufb = data[wiersz*y+x] *255;

        bufr/=bufa;
        bufg/=bufa;
        bufb/=bufa;

        data[wiersz*y+x] = bufr;
        data[wiersz*y+x+1] = bufg;
        data[wiersz*y+x+2] = bufb;
      }
    }
}
