#include "CPluginGUI.h"

/*******************Wczytaj****************/
/**wczytuje z pliku glowne okno dialogowe**/
bool CPluginGUI::Wczytaj(const char* filename)
{
  GtkBuilder* builder;
  GtkFileFilter* filtr_imiona;

  builder = gtk_builder_new();
  if(!gtk_builder_add_from_file(builder, filename, NULL))
  {
    g_object_unref(builder);
    return false;
  }

  filtr_imiona = gtk_file_filter_new();
  gtk_file_filter_set_name(filtr_imiona, "Pliki imienin (*.txt)");
  gtk_file_filter_add_pattern(filtr_imiona, "*.txt");

  okna.OknoDialogowe = (GtkWidget*)gtk_builder_get_object(builder, "OKNO_DIALOGOWE");
  okna.NaPodglad = (GtkWidget*)gtk_builder_get_object(builder, "NA_PODGLAD");

  //Ustawienia ogolne
  okna.UOWczytajStyl = (GtkWidget*)gtk_builder_get_object(builder, "UO_WCZYTAJ_STYL");
  okna.UOZapiszStyl = (GtkWidget*)gtk_builder_get_object(builder, "UO_ZAPISZ_STYL");
  okna.UOSkala = (GtkWidget*)gtk_builder_get_object(builder, "UO_SKALA");
  okna.UODniTygodnia = (GtkWidget*)gtk_builder_get_object(builder, "UO_DNI_TYGODNIA");
    gtk_entry_set_max_length(GTK_ENTRY(okna.UODniTygodnia), MAX_NAME-1);
  okna.UONazwyMiesiecy = (GtkWidget*)gtk_builder_get_object(builder, "UO_NAZWY_MIESIECY");
    gtk_entry_set_max_length(GTK_ENTRY(okna.UONazwyMiesiecy), MAX_NAME-1);
  okna.UOListaSwiat = (GtkWidget*)gtk_builder_get_object(builder, "UO_LISTA_SWIAT");
    gtk_entry_set_max_length(GTK_ENTRY(okna.UOListaSwiat), MAX_NAME-1);
  okna.UOListaImion = (GtkWidget*)gtk_builder_get_object(builder, "UO_LISTA_IMION");
  okna.UOListaImionWybierz = (GtkWidget*)gtk_builder_get_object(builder, "UO_LISTA_IMION_WYBIERZ");

  okna.UOTylko1Miesiac = (GtkWidget*)gtk_builder_get_object(builder, "UO_GENERUJ_1_MIESIAC");
  okna.UOMiesiac = (GtkWidget*)gtk_builder_get_object(builder, "UO_MIESIAC");
  okna.UORok = (GtkWidget*)gtk_builder_get_object(builder, "UO_ROK");
  okna.UOUkladRokuH = (GtkWidget*)gtk_builder_get_object(builder, "UKLAD_ROKU_H");
  okna.UOUkladRoku = gtk_my_uklad_roku();
    gtk_fixed_put(GTK_FIXED(okna.UOUkladRokuH), okna.UOUkladRoku, 0, 0);
  okna.UOWybierzSwieta = (GtkWidget*)gtk_builder_get_object(builder, "UO_WYBIERZ_SWIETA");
  okna.UOWymiarMscX = (GtkWidget*)gtk_builder_get_object(builder, "UO_WYMIAR_MSC_X");
  okna.UOWymiarMscY = (GtkWidget*)gtk_builder_get_object(builder, "UO_WYMIAR_MSC_Y");
  okna.UOTloCalosci = (GtkWidget*)gtk_builder_get_object(builder, "UO_TLO_CALOSCI");
  okna.UOTloX = (GtkWidget*)gtk_builder_get_object(builder, "UO_TLO_X");
  okna.UOTloY = (GtkWidget*)gtk_builder_get_object(builder, "UO_TLO_Y");
  okna.UOTloW = (GtkWidget*)gtk_builder_get_object(builder, "UO_TLO_W");
  okna.UOTloH = (GtkWidget*)gtk_builder_get_object(builder, "UO_TLO_H");
  okna.UOTloPr = (GtkWidget*)gtk_builder_get_object(builder, "UO_TLO_PR");
  okna.UOTloGr = (GtkWidget*)gtk_builder_get_object(builder, "UO_TLO_GR");
  okna.UOTloLG = (GtkWidget*)gtk_builder_get_object(builder, "UO_TLO_LG");
  okna.UOTloPG = (GtkWidget*)gtk_builder_get_object(builder, "UO_TLO_PG");
  okna.UOTloLD = (GtkWidget*)gtk_builder_get_object(builder, "UO_TLO_LD");
  okna.UOTloPD = (GtkWidget*)gtk_builder_get_object(builder, "UO_TLO_PD");
  okna.UOTloKolor = (GtkWidget*)gtk_builder_get_object(builder, "UO_TLO_KOLOR");
  okna.UOTloRamkaKolor = (GtkWidget*)gtk_builder_get_object(builder, "UO_RAMKA_KOLOR");

  //Ustawienia dni
    //tlo
  okna.UDTlo = (GtkWidget*)gtk_builder_get_object(builder, "UD_GENERUJ_TLO");
  okna.UDDwieCyfry = (GtkWidget*)gtk_builder_get_object(builder, "UD_DWIE_CYFRY_DNI");
  okna.UDPokazInne = (GtkWidget*)gtk_builder_get_object(builder, "UD_POKAZ_INNE");
  okna.UDPokaz6Tygodni = (GtkWidget*)gtk_builder_get_object(builder, "UD_POKAZ_6_TYGODNI");
  okna.UDTloX = (GtkWidget*)gtk_builder_get_object(builder, "UD_X");
  okna.UDTloY = (GtkWidget*)gtk_builder_get_object(builder, "UD_Y");
  okna.UDTloW = (GtkWidget*)gtk_builder_get_object(builder, "UD_W");
  okna.UDTloH = (GtkWidget*)gtk_builder_get_object(builder, "UD_H");
  okna.UDTloPr = (GtkWidget*)gtk_builder_get_object(builder, "UD_PR");
  okna.UDTloGr = (GtkWidget*)gtk_builder_get_object(builder, "UD_GR");
  okna.UDTloLG = (GtkWidget*)gtk_builder_get_object(builder, "UD_LG");
  okna.UDTloPG = (GtkWidget*)gtk_builder_get_object(builder, "UD_PG");
  okna.UDTloLD = (GtkWidget*)gtk_builder_get_object(builder, "UD_LD");
  okna.UDTloPD = (GtkWidget*)gtk_builder_get_object(builder, "UD_PD");
  okna.UDTloOX = (GtkWidget*)gtk_builder_get_object(builder, "UD_OX");
  okna.UDTloOY = (GtkWidget*)gtk_builder_get_object(builder, "UD_OY");
  okna.UDTloCX = (GtkWidget*)gtk_builder_get_object(builder, "UD_CX");
  okna.UDTloCY = (GtkWidget*)gtk_builder_get_object(builder, "UD_CY");
    //text
  okna.UDTextX = (GtkWidget*)gtk_builder_get_object(builder, "UD_TEXT_X");
  okna.UDTextY = (GtkWidget*)gtk_builder_get_object(builder, "UD_TEXT_Y");
  okna.UDTextJH = (GtkWidget*)gtk_builder_get_object(builder, "UD_TEXT_J_H");
  okna.UDTextJ = gtk_my_justification();
    gtk_fixed_put(GTK_FIXED(okna.UDTextJH), okna.UDTextJ, 0, 0);
  okna.UDTextCzcionka = (GtkWidget*)gtk_builder_get_object(builder, "UD_TEXT_CZCIONKA");
    //imiona
  okna.UDImiona = (GtkWidget*)gtk_builder_get_object(builder, "UD_IMIONA");
  okna.UDImionaX = (GtkWidget*)gtk_builder_get_object(builder, "UD_IMIONA_X");
  okna.UDImionaY = (GtkWidget*)gtk_builder_get_object(builder, "UD_IMIONA_Y");
  okna.UDImionaJH = (GtkWidget*)gtk_builder_get_object(builder, "UD_IMIONA_J_H");
  okna.UDImionaJ = gtk_my_justification();
    gtk_fixed_put(GTK_FIXED(okna.UDImionaJH), okna.UDImionaJ, 0, 0);
  okna.UDImionaMax = (GtkWidget*)gtk_builder_get_object(builder, "UD_MAX");
  okna.UDImionaSzer = (GtkWidget*)gtk_builder_get_object(builder, "UD_MAX_SZER");
  okna.UDImionaCzcionka = (GtkWidget*)gtk_builder_get_object(builder, "UD_IMIONA_CZCIONKA");
    //kolory
  okna.UDDniRamka = (GtkWidget*)gtk_builder_get_object(builder, "UD_DNI_RAMKA");
  okna.UDDniLG = (GtkWidget*)gtk_builder_get_object(builder, "UD_DNI_LG");
  okna.UDDniPG = (GtkWidget*)gtk_builder_get_object(builder, "UD_DNI_PG");
  okna.UDDniLD = (GtkWidget*)gtk_builder_get_object(builder, "UD_DNI_LD");
  okna.UDDniPD = (GtkWidget*)gtk_builder_get_object(builder, "UD_DNI_PD");
  okna.UDDniDni = (GtkWidget*)gtk_builder_get_object(builder, "UD_DNI_DNI");
  okna.UDDniImiona = (GtkWidget*)gtk_builder_get_object(builder, "UD_DNI_IMIONA");
  okna.UDSobRamka = (GtkWidget*)gtk_builder_get_object(builder, "UD_SOB_RAMKA");
  okna.UDSobLG = (GtkWidget*)gtk_builder_get_object(builder, "UD_SOB_LG");
  okna.UDSobPG = (GtkWidget*)gtk_builder_get_object(builder, "UD_SOB_PG");
  okna.UDSobLD = (GtkWidget*)gtk_builder_get_object(builder, "UD_SOB_LD");
  okna.UDSobPD = (GtkWidget*)gtk_builder_get_object(builder, "UD_SOB_PD");
  okna.UDSobDni = (GtkWidget*)gtk_builder_get_object(builder, "UD_SOB_DNI");
  okna.UDSobImiona = (GtkWidget*)gtk_builder_get_object(builder, "UD_SOB_IMIONA");
  okna.UDNieRamka = (GtkWidget*)gtk_builder_get_object(builder, "UD_NIE_RAMKA");
  okna.UDNieLG = (GtkWidget*)gtk_builder_get_object(builder, "UD_NIE_LG");
  okna.UDNiePG = (GtkWidget*)gtk_builder_get_object(builder, "UD_NIE_PG");
  okna.UDNieLD = (GtkWidget*)gtk_builder_get_object(builder, "UD_NIE_LD");
  okna.UDNiePD = (GtkWidget*)gtk_builder_get_object(builder, "UD_NIE_PD");
  okna.UDNieDni = (GtkWidget*)gtk_builder_get_object(builder, "UD_NIE_DNI");
  okna.UDNieImiona = (GtkWidget*)gtk_builder_get_object(builder, "UD_NIE_IMIONA");
  okna.UDInneRamka = (GtkWidget*)gtk_builder_get_object(builder, "UD_INNE_RAMKA");
  okna.UDInneLG = (GtkWidget*)gtk_builder_get_object(builder, "UD_INNE_LG");
  okna.UDInnePG = (GtkWidget*)gtk_builder_get_object(builder, "UD_INNE_PG");
  okna.UDInneLD = (GtkWidget*)gtk_builder_get_object(builder, "UD_INNE_LD");
  okna.UDInnePD = (GtkWidget*)gtk_builder_get_object(builder, "UD_INNE_PD");
  okna.UDInneDni = (GtkWidget*)gtk_builder_get_object(builder, "UD_INNE_DNI");
  okna.UDInneImiona = (GtkWidget*)gtk_builder_get_object(builder, "UD_INNE_IMIONA");

  //Dni Tygodnia
    //tlo
  okna.DTTlo = (GtkWidget*)gtk_builder_get_object(builder, "DT_TLO");
  okna.DTTloX = (GtkWidget*)gtk_builder_get_object(builder, "DT_TLO_X");
  okna.DTTloY = (GtkWidget*)gtk_builder_get_object(builder, "DT_TLO_Y");
  okna.DTTloW = (GtkWidget*)gtk_builder_get_object(builder, "DT_TLO_W");
  okna.DTTloH = (GtkWidget*)gtk_builder_get_object(builder, "DT_TLO_H");
  okna.DTTloGr = (GtkWidget*)gtk_builder_get_object(builder, "DT_TLO_GR");
  okna.DTTloPr = (GtkWidget*)gtk_builder_get_object(builder, "DT_TLO_PR");
  okna.DTTloLG = (GtkWidget*)gtk_builder_get_object(builder, "DT_TLO_LG");
  okna.DTTloPG = (GtkWidget*)gtk_builder_get_object(builder, "DT_TLO_PG");
  okna.DTTloLD = (GtkWidget*)gtk_builder_get_object(builder, "DT_TLO_LD");
  okna.DTTloPD = (GtkWidget*)gtk_builder_get_object(builder, "DT_TLO_PD");
    //text
  okna.DTText = (GtkWidget*)gtk_builder_get_object(builder, "DT_TEXT");
  okna.DTTextX = (GtkWidget*)gtk_builder_get_object(builder, "DT_TEXT_X");
  okna.DTTextY = (GtkWidget*)gtk_builder_get_object(builder, "DT_TEXT_Y");
  okna.DTTextCzcionka = (GtkWidget*)gtk_builder_get_object(builder, "DT_TEXT_CZCIONKA");
  okna.DTTextJH = (GtkWidget*)gtk_builder_get_object(builder, "DT_TEXT_J_H");
  okna.DTTextJ = gtk_my_justification();
    gtk_fixed_put(GTK_FIXED(okna.DTTextJH), okna.DTTextJ, 0, 0);
    //TC
  okna.DTTC = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC");
  okna.DTTCX = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC_X");
  okna.DTTCY = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC_Y");
  okna.DTTCW = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC_W");
  okna.DTTCH = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC_H");
  okna.DTTCGr = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC_GR");
  okna.DTTCPr = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC_PR");
  okna.DTTCLG = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC_LG");
  okna.DTTCPG = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC_PG");
  okna.DTTCLD = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC_LD");
  okna.DTTCPD = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC_PD");
  okna.DTTCTlo = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC_TLO");
  okna.DTTCRamka = (GtkWidget*)gtk_builder_get_object(builder, "DT_TC_RAMKA");
    //kolory
  okna.DTDniRamka = (GtkWidget*)gtk_builder_get_object(builder, "DT_DNI_RAMKA");
  okna.DTDniTlo = (GtkWidget*)gtk_builder_get_object(builder, "DT_DNI_TLO");
  okna.DTDniText = (GtkWidget*)gtk_builder_get_object(builder, "DT_DNI_TEXT");
  okna.DTSobRamka = (GtkWidget*)gtk_builder_get_object(builder, "DT_SOB_RAMKA");
  okna.DTSobTlo = (GtkWidget*)gtk_builder_get_object(builder, "DT_SOB_TLO");
  okna.DTSobText = (GtkWidget*)gtk_builder_get_object(builder, "DT_SOB_TEXT");
  okna.DTNieRamka = (GtkWidget*)gtk_builder_get_object(builder, "DT_NIE_RAMKA");
  okna.DTNieTlo = (GtkWidget*)gtk_builder_get_object(builder, "DT_NIE_TLO");
  okna.DTNieText = (GtkWidget*)gtk_builder_get_object(builder, "DT_NIE_TEXT");

  //numerowanie tygodni
    //tlo
  okna.NTTlo = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO");
  okna.NTTloX = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO_X");
  okna.NTTloY = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO_Y");
  okna.NTTloW = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO_W");
  okna.NTTloH = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO_H");
  okna.NTTloGr = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO_GR");
  okna.NTTloPr = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO_PR");
  okna.NTTloLG = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO_LG");
  okna.NTTloPG = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO_PG");
  okna.NTTloLD = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO_LD");
  okna.NTTloPD = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO_PD");
  okna.NTTloTlo = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO_TLO");
  okna.NTTloRamka = (GtkWidget*)gtk_builder_get_object(builder, "NT_TLO_RAMKA");
    //text
  okna.NTText = (GtkWidget*)gtk_builder_get_object(builder, "NT_TEXT");
  okna.NTDwieCyfry = (GtkWidget*)gtk_builder_get_object(builder, "NT_DWIE_CYFRY");
  okna.NTTextX = (GtkWidget*)gtk_builder_get_object(builder, "NT_TEXT_X");
  okna.NTTextY = (GtkWidget*)gtk_builder_get_object(builder, "NT_TEXT_Y");
  okna.NTTextJH = (GtkWidget*)gtk_builder_get_object(builder, "NT_TEXT_J_H");
  okna.NTTextJ = gtk_my_justification();
    gtk_fixed_put(GTK_FIXED(okna.NTTextJH), okna.NTTextJ, 0, 0);
  okna.NTTextCzcionka = (GtkWidget*)gtk_builder_get_object(builder, "NT_TEXT_CZCIONKA");
  okna.NTTextKolor = (GtkWidget*)gtk_builder_get_object(builder, "NT_TEXT_KOLOR");
    //TC
  okna.NTTC = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC");
  okna.NTTCX = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC_X");
  okna.NTTCY = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC_Y");
  okna.NTTCW = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC_W");
  okna.NTTCH = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC_H");
  okna.NTTCGr = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC_GR");
  okna.NTTCPr = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC_PR");
  okna.NTTCLG = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC_LG");
  okna.NTTCPG = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC_PG");
  okna.NTTCLD = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC_LD");
  okna.NTTCPD = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC_PD");
  okna.NTTCTlo = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC_TLO");
  okna.NTTCRamka = (GtkWidget*)gtk_builder_get_object(builder, "NT_TC_RAMKA");

  //Nazwy miesiaca
    //text
  okna.NMText = (GtkWidget*)gtk_builder_get_object(builder, "NM_TEXT");
  okna.NMTextX = (GtkWidget*)gtk_builder_get_object(builder, "NM_TEXT_X");
  okna.NMTextY = (GtkWidget*)gtk_builder_get_object(builder, "NM_TEXT_Y");
  okna.NMTextJH = (GtkWidget*)gtk_builder_get_object(builder, "NM_TEXT_J_H");
  okna.NMTextJ = gtk_my_justification();
    gtk_fixed_put(GTK_FIXED(okna.NMTextJH), okna.NMTextJ, 0, 0);
  okna.NMTextCzcionka = (GtkWidget*)gtk_builder_get_object(builder, "NM_TEXT_CZCIONKA");
  okna.NMTextKolor = (GtkWidget*)gtk_builder_get_object(builder, "NM_TEXT_KOLOR");
    //tlo
  okna.NMTC = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC");
  okna.NMTCX = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC_X");
  okna.NMTCY = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC_Y");
  okna.NMTCW = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC_W");
  okna.NMTCH = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC_H");
  okna.NMTCGr = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC_GR");
  okna.NMTCPr = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC_PR");
  okna.NMTCLG = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC_LG");
  okna.NMTCPG = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC_PG");
  okna.NMTCLD = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC_LD");
  okna.NMTCPD = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC_PD");
  okna.NMTCTlo = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC_TLO");
  okna.NMTCRamka = (GtkWidget*)gtk_builder_get_object(builder, "NM_TC_RAMKA");

  g_object_unref(builder);

  //utworz okno podgladu
  okna.Podglad = gtk_drawing_area_new();
  gtk_fixed_put((GtkFixed*)okna.NaPodglad, okna.Podglad, 0, 0);
  gtk_widget_set_size_request(okna.Podglad, PODGLAD_X, PODGLAD_Y);
  gtk_widget_show(okna.Podglad);

  //do kazdej kontrolki dodaj sygnal odswiezajacy podglad
  PolaczSygnaly(&okna);
  //do zapisz i wczytaj styl podlacz funkcje zapisujaa i wczytujaca
  g_signal_connect(GTK_BUTTON(okna.UOZapiszStyl), "clicked", G_CALLBACK (CPluginGUI::ZapiszStyl), this);
  g_signal_connect(GTK_BUTTON(okna.UOWczytajStyl), "clicked", G_CALLBACK (CPluginGUI::OtworzStyl), this);
  //do wybierz liste imion dodaj funkcje wczytujaca
  g_signal_connect(GTK_BUTTON(okna.UOListaImionWybierz), "clicked", G_CALLBACK(CPluginGUI::WczytajListeImion), this);

  //przesuwanie podgladu
  przesuniecieX = 0;
  przesuniecieY = 0;
  gtk_widget_set_events(okna.Podglad, GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK);
  g_signal_connect(okna.Podglad, "event", G_CALLBACK(CPluginGUI::PrzesunPodglad), this);
  //odswiezanie podgladu
  g_signal_connect(okna.Podglad, "expose-event", G_CALLBACK (CPluginGUI::OdswiezPodglad), this);


  wczytano = true;
  return true;
}

/**********PokazOkno*************/
/**wyswietla glowne okno dialogowe**/
bool CPluginGUI::PokazOkno(SUstawienia& ust)
{
  bool czyOk = false;

  if(!wczytano)
    return false;

  UstawUstawienia(ust);

  if(gtk_dialog_run(GTK_DIALOG(okna.OknoDialogowe))==1)
  {
    czyOk = true;
  }

  PobierzUstawienia(ust);

  gtk_widget_destroy(okna.OknoDialogowe);

  wczytano=false;
  return czyOk;
}

/**********PolaczSygnaly*************/
/**podlacza sygnaly odswiezajace podglad***/
void CPluginGUI::PolaczSygnaly(SOkna* widgety)
{
  GtkWidget** okna = (GtkWidget**)widgety;

  for(unsigned int i=0; i<(sizeof(*widgety)/sizeof(widgety));i++)
  {
    GtkWidget* okno = *(okna+i);

    if(GTK_IS_SPIN_BUTTON(okno))
      g_signal_connect_swapped(okno, "value-changed", G_CALLBACK(gtk_widget_queue_draw), widgety->Podglad);
    else if(GTK_IS_TOGGLE_BUTTON(okno))
      g_signal_connect_swapped(okno, "toggled", G_CALLBACK(gtk_widget_queue_draw), widgety->Podglad);
    else if(GTK_IS_COLOR_BUTTON(okno))
      g_signal_connect_swapped(okno, "color-set", G_CALLBACK(gtk_widget_queue_draw), widgety->Podglad);
    else if(GTK_IS_COMBO_BOX(okno))
      g_signal_connect_swapped(okno, "changed", G_CALLBACK(gtk_widget_queue_draw), widgety->Podglad);
    else if(GTK_IS_FONT_BUTTON(okno))
      g_signal_connect_swapped(okno, "font-set", G_CALLBACK(gtk_widget_queue_draw), widgety->Podglad);
    else if(GTK_IS_FILE_CHOOSER_BUTTON(okno))
      g_signal_connect_swapped(okno, "file-set", G_CALLBACK(gtk_widget_queue_draw), widgety->Podglad);
  }
}

/**********OdswiezPodglad*************/
/**** odswieza okno z podgladem ******/
gboolean CPluginGUI::OdswiezPodglad(GtkWidget* widget, GdkEventExpose* event, CPluginGUI* gui)
{
  /* static int ile = 0;
  ile++;
  char buf[16];
  sprintf(buf, "%d", ile);
  gimp_message(buf);*/


  cairo_t* cr = gdk_cairo_create(widget->window);
  CPluginGenerator generator(cr, false);
  SUstawienia ust;

  cairo_set_source_rgba(cr, 1.0, 1.0, 1.0, 1.0);
  cairo_paint(cr);

  gui->PobierzUstawienia(ust);
  ust.tylko1msc = true; //w podgladzie pokazuj zawsze tylko 1 msc

  cairo_translate(cr, gui->przesuniecieX, gui->przesuniecieY);
  generator.Generuj(ust);

  cairo_destroy(cr);

  return FALSE;
}


/**********PrzesunPodglad*************/
/**** przesuwa okno z podgladem ******/
gboolean CPluginGUI::PrzesunPodglad(GtkWidget* widget, GdkEventButton* event, CPluginGUI* data)
{
  static bool przesuwany = false;
  static int staryX, staryY;

  if(event->type==GDK_BUTTON_PRESS && event->button==1) //jezeli wcisnieto lewy przycisk myszy
  {
    staryX = event->x;    //zapisz pozycje myszy
    staryY = event->y;
    przesuwany = true;
  }

  if(event->type==GDK_BUTTON_RELEASE && event->button==1 && przesuwany) //jezeli zwolniono przycisk
  {
    SUstawienia ust;
    data->PobierzUstawienia(ust);

    int miesiacX = ust.UOWymiarMscX * ust.skala;  //oblicz wymiar miesiaca z uwzglednieniem skali
    int miesiacY = ust.UOWymiarMscY * ust.skala;

    int nowyX = data->przesuniecieX - staryX + event->x;  //oblicz nowe przesuniecie
    int nowyY = data->przesuniecieY - staryY + event->y;

    if(miesiacX<=PODGLAD_X)   //jezeli miesiac X jest mniejszy od okna to przesuniecie = 0
      data->przesuniecieX=0;
    else     //jezeli wiekszy to oblicz przesuniecie
    {
      data->przesuniecieX = (miesiacX+nowyX)>PODGLAD_X?nowyX:(PODGLAD_X-miesiacX);
      if(data->przesuniecieX>0)data->przesuniecieX=0;
    }

    if(miesiacY<=PODGLAD_Y)   //jezeli miesiac Y jest mniejszy od okna to przesuniecie = 0
      data->przesuniecieY=0;
    else                      //jezeli wiekszy to oblicz przesuniecie
    {
      data->przesuniecieY = (miesiacY+nowyY)>PODGLAD_Y?nowyY:(PODGLAD_Y-miesiacY);
      if(data->przesuniecieY>0)data->przesuniecieY=0;
    }

    przesuwany = false;

    gtk_widget_queue_draw(data->okna.Podglad);  //odswiez podglad
  }



  return FALSE;
}

/*******get_color_from_color_button*********/
/**pobiera kolor z przycisku wyboru koloru**/
void get_color_from_color_button(GtkColorButton* button, SRGBA& color)
{
  GdkColor tmpcolor;

  color.a = gtk_color_button_get_alpha(button)/65536.0;

  gtk_color_button_get_color(button, &tmpcolor);
  color.r = tmpcolor.red/65536.0;
  color.b = tmpcolor.blue/65536.0;
  color.g = tmpcolor.green/65536.0;
}

/******set_color_to_color_button*********/
/**ustawia kolor na przycisku wyboru koloru**/
void set_color_to_color_button(GtkColorButton* button, const SRGBA& color)
{
  GdkColor tmpcolor;

  gtk_color_button_set_alpha(button, color.a*65536.0);

  tmpcolor.red = color.r*65536.0;
  tmpcolor.green = color.g*65536.0;
  tmpcolor.blue = color.b*65536.0;
  gtk_color_button_set_color(button, &tmpcolor);
}

/*********gtk_my_justification***********/
/**tworzy widget z wyborem justyfikacji**/
GtkWidget* gtk_my_justification()
{
  GtkComboBox* widget;
  widget = GTK_COMBO_BOX(gtk_combo_box_new_text());

  gtk_combo_box_append_text(widget, "L");
  gtk_combo_box_append_text(widget, "S");
  gtk_combo_box_append_text(widget, "P");

  gtk_combo_box_set_active(widget, 0);
  gtk_widget_show(GTK_WIDGET(widget));
  return GTK_WIDGET(widget);
}

/**********gtk_my_uklad_roku*************/
/**tworzy widget z wyborem ukladu roku **/
GtkWidget* gtk_my_uklad_roku()
{
  GtkComboBox* widget;
  widget = GTK_COMBO_BOX(gtk_combo_box_new_text());

  gtk_combo_box_append_text(widget, "1x12");
  gtk_combo_box_append_text(widget, "2x6");
  gtk_combo_box_append_text(widget, "3x4");
  gtk_combo_box_append_text(widget, "4x3");
  gtk_combo_box_append_text(widget, "6x2");
  gtk_combo_box_append_text(widget, "12x1");

  gtk_combo_box_set_active(widget, 2);
  gtk_widget_show(GTK_WIDGET(widget));
  return GTK_WIDGET(widget);
}

/************ZapiszStyl******************/
/**otwiera okno wyboru pliku do zapisu **/
/**zapisuje styl ust do wybranego pliku**/
void CPluginGUI::ZapiszStyl(GtkButton* button, CPluginGUI* gui)
{
  GtkWidget* fc = gtk_file_chooser_dialog_new("Zapisz styl...",
                                                        GTK_WINDOW(gui->okna.OknoDialogowe),
                                                        GTK_FILE_CHOOSER_ACTION_SAVE,
                                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                        GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
                                                        NULL);

  gtk_file_chooser_set_do_overwrite_confirmation(GTK_FILE_CHOOSER(fc), true);

  if(gtk_dialog_run(GTK_DIALOG(fc))==GTK_RESPONSE_ACCEPT)
  {
    char* nazwa = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(fc));

    if(nazwa!=NULL)
    {
      if(!gui->Zapisz(nazwa))
        gimp_message("Zapis stylu nie powiódł się!");
    }

    g_free(nazwa);
  }

  gtk_widget_destroy(fc);
}

/************ZapiszStyl******************/
/**zapisuje styl ust do wybranego pliku**/
bool CPluginGUI::Zapisz(const char* nazwa)
{
  SUstawienia ust;
  std::ofstream plik(nazwa, std::ofstream::trunc | std::ofstream::binary);

  PobierzUstawienia(ust);

  if(!plik.is_open())
    return false;

  plik.write((const char*)&ust, sizeof(ust));

  if(!plik.good())
  {
    plik.close();
    return false;
  }

  plik.close();
  return true;
}

/************OtworzStyl *****************/
/**otwiera okno wyboru pliku do otwarcia*/
/**wczytuje styl ust z wybranego pliku **/
void CPluginGUI::OtworzStyl(GtkButton* button, CPluginGUI* gui)
{
  GtkWidget* fc = gtk_file_chooser_dialog_new("Wczytaj styl...",
                                                        GTK_WINDOW(gui->okna.OknoDialogowe),
                                                        GTK_FILE_CHOOSER_ACTION_OPEN,
                                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                        GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                                                        NULL);

  if(gtk_dialog_run(GTK_DIALOG(fc))==GTK_RESPONSE_ACCEPT)
  {
    char* nazwa = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(fc));

    if(nazwa!=NULL)
    {
      if(!gui->Otworz(nazwa))
        gimp_message("Wczytanie stylu nie powiodło się!");
    }

    g_free(nazwa);
  }

  gtk_widget_destroy(fc);
}

/************ Otworz ********************/
/**wczytuje styl ust z wybranego pliku **/
bool CPluginGUI::Otworz(const char* nazwa)
{
  SUstawienia ust;
  std::ifstream plik(nazwa, std::ifstream::binary);

  if(!plik.is_open())
    return false;

  plik.read((char*)&ust, sizeof(ust));

  if(!plik.good())
  {
    plik.close();
    return false;
  }

  UstawUstawienia(ust);

  plik.close();
  return true;
}


/************OtworzStyl *****************/
/**otwiera okno wyboru pliku do otwarcia*/
/**wczytuje liste imion z wybranego pliku **/
void CPluginGUI::WczytajListeImion(GtkButton* button, CPluginGUI* gui)
{
  GtkWidget* fc = gtk_file_chooser_dialog_new("Wczytaj styl...",
                                                        GTK_WINDOW(gui->okna.OknoDialogowe),
                                                        GTK_FILE_CHOOSER_ACTION_OPEN,
                                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                                        GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                                                        NULL);

  if(gtk_dialog_run(GTK_DIALOG(fc))==GTK_RESPONSE_ACCEPT)
  {
    char* nazwa = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(fc));

    if(nazwa!=NULL)
    {
      gtk_entry_set_text(GTK_ENTRY(gui->okna.UOListaImion), nazwa);
    }

    g_free(nazwa);
  }

  gtk_widget_destroy(fc);
}

