#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include <cstring>
#include <fstream>

#include "SUstawienia.h"
#include "CPluginGenerator.h"

#ifndef _C_PLUGIN_GUI_
#define _C_PLUGIN_GUI_

#define PODGLAD_X 500
#define PODGLAD_Y 500

struct SOkna
{
  GtkWidget* OknoDialogowe;
  GtkWidget* NaPodglad;
  GtkWidget* Podglad;

  //Ustawienia ogolne
  GtkWidget* UOWczytajStyl;
  GtkWidget* UOZapiszStyl;
  GtkWidget* UOSkala;
  GtkWidget* UODniTygodnia;
  GtkWidget* UONazwyMiesiecy;
  GtkWidget* UOListaSwiat;
  GtkWidget* UOListaImion;
  GtkWidget* UOListaImionWybierz;
  GtkWidget* UOTylko1Miesiac;
  GtkWidget* UOMiesiac;
  GtkWidget* UORok;
  GtkWidget* UOUkladRokuH;
  GtkWidget* UOUkladRoku;
  GtkWidget* UOWybierzSwieta;
  GtkWidget* UOWymiarMscX;
  GtkWidget* UOWymiarMscY;
  GtkWidget* UOTloCalosci;
  GtkWidget* UOTloX;
  GtkWidget* UOTloY;
  GtkWidget* UOTloW;
  GtkWidget* UOTloH;
  GtkWidget* UOTloPr;
  GtkWidget* UOTloGr;
  GtkWidget* UOTloLG;
  GtkWidget* UOTloPG;
  GtkWidget* UOTloLD;
  GtkWidget* UOTloPD;
  GtkWidget* UOTloKolor;
  GtkWidget* UOTloRamkaKolor;

  //Ustawienia dni
    //tlo
  GtkWidget* UDTlo;
  GtkWidget* UDDwieCyfry;
  GtkWidget* UDPokazInne;
  GtkWidget* UDPokaz6Tygodni;
  GtkWidget* UDTloX;
  GtkWidget* UDTloY;
  GtkWidget* UDTloW;
  GtkWidget* UDTloH;
  GtkWidget* UDTloPr;
  GtkWidget* UDTloGr;
  GtkWidget* UDTloLG;
  GtkWidget* UDTloPG;
  GtkWidget* UDTloLD;
  GtkWidget* UDTloPD;
  GtkWidget* UDTloOX;
  GtkWidget* UDTloOY;
  GtkWidget* UDTloCX;
  GtkWidget* UDTloCY;
    //text
  GtkWidget* UDTextX;
  GtkWidget* UDTextY;
  GtkWidget* UDTextJH;
  GtkWidget* UDTextJ;
  GtkWidget* UDTextCzcionka;
    //imiona
  GtkWidget* UDImiona;
  GtkWidget* UDImionaX;
  GtkWidget* UDImionaY;
  GtkWidget* UDImionaJH;
  GtkWidget* UDImionaJ;
  GtkWidget* UDImionaMax;
  GtkWidget* UDImionaSzer;
  GtkWidget* UDImionaCzcionka;
    //kolory
  GtkWidget* UDDniRamka;
  GtkWidget* UDDniLG;
  GtkWidget* UDDniPG;
  GtkWidget* UDDniLD;
  GtkWidget* UDDniPD;
  GtkWidget* UDDniDni;
  GtkWidget* UDDniImiona;
  GtkWidget* UDSobRamka;
  GtkWidget* UDSobLG;
  GtkWidget* UDSobPG;
  GtkWidget* UDSobLD;
  GtkWidget* UDSobPD;
  GtkWidget* UDSobDni;
  GtkWidget* UDSobImiona;
  GtkWidget* UDNieRamka;
  GtkWidget* UDNieLG;
  GtkWidget* UDNiePG;
  GtkWidget* UDNieLD;
  GtkWidget* UDNiePD;
  GtkWidget* UDNieDni;
  GtkWidget* UDNieImiona;
  GtkWidget* UDInneRamka;
  GtkWidget* UDInneLG;
  GtkWidget* UDInnePG;
  GtkWidget* UDInneLD;
  GtkWidget* UDInnePD;
  GtkWidget* UDInneDni;
  GtkWidget* UDInneImiona;

  //Dni Tygodnia
    //tlo
  GtkWidget* DTTlo;
  GtkWidget* DTTloX;
  GtkWidget* DTTloY;
  GtkWidget* DTTloW;
  GtkWidget* DTTloH;
  GtkWidget* DTTloGr;
  GtkWidget* DTTloPr;
  GtkWidget* DTTloLG;
  GtkWidget* DTTloPG;
  GtkWidget* DTTloLD;
  GtkWidget* DTTloPD;
    //text
  GtkWidget* DTText;
  GtkWidget* DTTextX;
  GtkWidget* DTTextY;
  GtkWidget* DTTextCzcionka;
  GtkWidget* DTTextJH;
  GtkWidget* DTTextJ;
    //TC
  GtkWidget* DTTC;
  GtkWidget* DTTCX;
  GtkWidget* DTTCY;
  GtkWidget* DTTCW;
  GtkWidget* DTTCH;
  GtkWidget* DTTCGr;
  GtkWidget* DTTCPr;
  GtkWidget* DTTCLG;
  GtkWidget* DTTCPG;
  GtkWidget* DTTCLD;
  GtkWidget* DTTCPD;
  GtkWidget* DTTCTlo;
  GtkWidget* DTTCRamka;
    //kolory
  GtkWidget* DTDniRamka;
  GtkWidget* DTDniTlo;
  GtkWidget* DTDniText;
  GtkWidget* DTSobRamka;
  GtkWidget* DTSobTlo;
  GtkWidget* DTSobText;
  GtkWidget* DTNieRamka;
  GtkWidget* DTNieTlo;
  GtkWidget* DTNieText;

  //numerowanie tygodni
    //tlo
  GtkWidget* NTTlo;
  GtkWidget* NTTloX;
  GtkWidget* NTTloY;
  GtkWidget* NTTloW;
  GtkWidget* NTTloH;
  GtkWidget* NTTloGr;
  GtkWidget* NTTloPr;
  GtkWidget* NTTloLG;
  GtkWidget* NTTloPG;
  GtkWidget* NTTloLD;
  GtkWidget* NTTloPD;
  GtkWidget* NTTloTlo;
  GtkWidget* NTTloRamka;
    //text
  GtkWidget* NTText;
  GtkWidget* NTDwieCyfry;
  GtkWidget* NTTextX;
  GtkWidget* NTTextY;
  GtkWidget* NTTextJH;
  GtkWidget* NTTextJ;
  GtkWidget* NTTextCzcionka;
  GtkWidget* NTTextKolor;
    //TC
  GtkWidget* NTTC;
  GtkWidget* NTTCX;
  GtkWidget* NTTCY;
  GtkWidget* NTTCW;
  GtkWidget* NTTCH;
  GtkWidget* NTTCGr;
  GtkWidget* NTTCPr;
  GtkWidget* NTTCLG;
  GtkWidget* NTTCPG;
  GtkWidget* NTTCLD;
  GtkWidget* NTTCPD;
  GtkWidget* NTTCTlo;
  GtkWidget* NTTCRamka;

  //Nazwy miesiaca
    //text
  GtkWidget* NMText;
  GtkWidget* NMTextX;
  GtkWidget* NMTextY;
  GtkWidget* NMTextJH;
  GtkWidget* NMTextJ;
  GtkWidget* NMTextCzcionka;
  GtkWidget* NMTextKolor;
    //tlo
  GtkWidget* NMTC;
  GtkWidget* NMTCX;
  GtkWidget* NMTCY;
  GtkWidget* NMTCW;
  GtkWidget* NMTCH;
  GtkWidget* NMTCGr;
  GtkWidget* NMTCPr;
  GtkWidget* NMTCLG;
  GtkWidget* NMTCPG;
  GtkWidget* NMTCLD;
  GtkWidget* NMTCPD;
  GtkWidget* NMTCTlo;
  GtkWidget* NMTCRamka;
};


class CPluginGUI
{
  private:
    bool wczytano;
    SOkna okna;

    int przesuniecieX;
    int przesuniecieY;

    bool PobierzUstawienia(SUstawienia& ust);
    bool UstawUstawienia(const SUstawienia& ust);
    void PolaczSygnaly(SOkna* widgety);

    static gboolean OdswiezPodglad(GtkWidget* widget, GdkEventExpose* event, CPluginGUI* data);
    static gboolean PrzesunPodglad(GtkWidget* widget, GdkEventButton* event, CPluginGUI* data);
    static void ZapiszStyl(GtkButton* button, CPluginGUI* gui);
    static void OtworzStyl(GtkButton* button, CPluginGUI* gui);
    static void WczytajListeImion(GtkButton* button, CPluginGUI* gui);
    bool Zapisz(const char* nazwa);
    bool Otworz(const char* nazwa);

  public:
    CPluginGUI():wczytano(false){}
    ~CPluginGUI()
    {
      if(wczytano)
        gtk_widget_destroy(okna.OknoDialogowe);
    }

    bool Wczytaj(const char* filename);
    bool PokazOkno(SUstawienia& ust);

};



void get_color_from_color_button(GtkColorButton* button, SRGBA& color);
void set_color_to_color_button(GtkColorButton* button, const SRGBA& color);
GtkWidget* gtk_my_justification();
GtkWidget* gtk_my_uklad_roku();

#endif
