#include "CPluginGUI.h"

/************PobierzUstawienia*************/
/**pobiera ustawienia z kontrolek do ust **/
bool CPluginGUI::PobierzUstawienia(SUstawienia& ust)
{
  const char* buf;

  if(!wczytano)
    return false;

  //ustawienia ogolne
  ust.skala = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UOSkala));

  strcpy(ust.dniTygodnia, gtk_entry_get_text(GTK_ENTRY(okna.UODniTygodnia)));
  strcpy(ust.miesiace, gtk_entry_get_text(GTK_ENTRY(okna.UONazwyMiesiecy)));
  strcpy(ust.listaSwiat, gtk_entry_get_text(GTK_ENTRY(okna.UOListaSwiat)));
  strcpy(ust.listaImienin, gtk_entry_get_text(GTK_ENTRY(okna.UOListaImion)));

  ust.tylko1msc = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UOTylko1Miesiac));
  ust.msc = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(okna.UOMiesiac));
  ust.rok = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(okna.UORok));
  ust.ukladRoku = gtk_combo_box_get_active(GTK_COMBO_BOX(okna.UOUkladRoku));

  ust.UOWymiarMscX = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UOWymiarMscX));
  ust.UOWymiarMscY = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UOWymiarMscY));

  ust.UOPokazTlo = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UOTloCalosci));

  ust.UOTlo.x = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UOTloX));
  ust.UOTlo.y = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UOTloY));
  ust.UOTlo.w = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UOTloW));
  ust.UOTlo.h = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UOTloH));
  ust.UOTlo.gr = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UOTloGr));
  ust.UOTlo.pr = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UOTloPr));
  ust.UOTlo.LG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UOTloLG));
  ust.UOTlo.PG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UOTloPG));
  ust.UOTlo.LD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UOTloLD));
  ust.UOTlo.PD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UOTloPD));
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UOTloKolor), ust.UOTlo.tlo);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UOTloRamkaKolor), ust.UOTlo.ramka);

  //ustawienia dni
  ust.UDPokazTlo = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UDTlo));
  ust.UDDwieCyfry = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UDDwieCyfry));
  ust.UDPokazInne = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UDPokazInne));
  ust.UDPokaz6Tygodni = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UDPokaz6Tygodni));
  ust.ox = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDTloOX));
  ust.oy = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDTloOY));

  ust.UDDni.x  = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDTloX));
  ust.UDDni.y  = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDTloY));
  ust.UDDni.w  = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDTloW));
  ust.UDDni.h  = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDTloH));
  ust.UDDni.pr  = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDTloPr));
  ust.UDDni.gr  = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDTloGr));
  ust.UDDni.LG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UDTloLG));
  ust.UDDni.PG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UDTloPG));
  ust.UDDni.LD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UDTloLD));
  ust.UDDni.PD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UDTloPD));
  ust.UDDni.cx  = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDTloCX));
  ust.UDDni.cy  = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDTloCY));

  ust.UDInne = ust.UDNie = ust.UDSob = ust.UDDni;

  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDDniRamka), ust.UDDni.ramka);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDDniLG), ust.UDDni.tloLG);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDDniPG), ust.UDDni.tloPG);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDDniLD), ust.UDDni.tloLD);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDDniPD), ust.UDDni.tloPD);

  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDNieRamka), ust.UDNie.ramka);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDNieLG), ust.UDNie.tloLG);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDNiePG), ust.UDNie.tloPG);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDNieLD), ust.UDNie.tloLD);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDNiePD), ust.UDNie.tloPD);

  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDSobRamka), ust.UDSob.ramka);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDSobLG), ust.UDSob.tloLG);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDSobPG), ust.UDSob.tloPG);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDSobLD), ust.UDSob.tloLD);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDSobPD), ust.UDSob.tloPD);

  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDInneRamka), ust.UDInne.ramka);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDInneLG), ust.UDInne.tloLG);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDInnePG), ust.UDInne.tloPG);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDInneLD), ust.UDInne.tloLD);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDInnePD), ust.UDInne.tloPD);

  ust.UDTextDni.x = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDTextX));
  ust.UDTextDni.y = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDTextY));
  ust.UDTextDni.max = 0.0;
  ust.UDTextDni.just = (Just)gtk_combo_box_get_active(GTK_COMBO_BOX(okna.UDTextJ));
  buf = gtk_font_button_get_font_name(GTK_FONT_BUTTON(okna.UDTextCzcionka));
  strcpy(ust.UDTextDni.font, buf);

  ust.UDTextInne = ust.UDTextNie = ust.UDTextSob = ust.UDTextDni;
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDDniDni), ust.UDTextDni.kolor);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDSobDni), ust.UDTextSob.kolor);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDNieDni), ust.UDTextNie.kolor);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDInneDni), ust.UDTextInne.kolor);

  ust.UDPokazImieniny = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.UDImiona));
  ust.UDImieninyMax = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(okna.UDImionaMax));

  ust.UDImieninyDni.x = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDImionaX));
  ust.UDImieninyDni.y = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDImionaY));
  ust.UDImieninyDni.max = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.UDImionaSzer));
  ust.UDImieninyDni.just = (Just)gtk_combo_box_get_active(GTK_COMBO_BOX(okna.UDImionaJ));
  buf = gtk_font_button_get_font_name(GTK_FONT_BUTTON(okna.UDImionaCzcionka));
  strcpy(ust.UDImieninyDni.font, buf);

  ust.UDImieninyInne = ust.UDImieninyNie = ust.UDImieninySob = ust.UDImieninyDni;
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDDniImiona), ust.UDImieninyDni.kolor);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDSobImiona), ust.UDImieninySob.kolor);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDNieImiona), ust.UDImieninyNie.kolor);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.UDInneImiona), ust.UDImieninyInne.kolor);

  //dni tygodnia
    //tlo
  ust.DTPokazTlo = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.DTTlo));

  ust.DTDni.x = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTloX));
  ust.DTDni.y = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTloY));
  ust.DTDni.w = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTloW));
  ust.DTDni.h = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTloH));
  ust.DTDni.gr = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTloGr));
  ust.DTDni.pr = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTloPr));
  ust.DTDni.LG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.DTTloLG));
  ust.DTDni.PG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.DTTloPG));
  ust.DTDni.LD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.DTTloLD));
  ust.DTDni.PD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.DTTloPD));

  ust.DTNie = ust.DTSob = ust.DTDni;

  get_color_from_color_button(GTK_COLOR_BUTTON(okna.DTDniTlo), ust.DTDni.tlo);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.DTDniRamka), ust.DTDni.ramka);

  get_color_from_color_button(GTK_COLOR_BUTTON(okna.DTSobTlo), ust.DTSob.tlo);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.DTSobRamka), ust.DTSob.ramka);

  get_color_from_color_button(GTK_COLOR_BUTTON(okna.DTNieTlo), ust.DTNie.tlo);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.DTNieRamka), ust.DTNie.ramka);

    //text
  ust.DTPokazText = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.DTText));

  ust.DTTextDni.x = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTextX));
  ust.DTTextDni.y = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTextY));
  ust.DTTextDni.max = 0.0;
  ust.DTTextDni.just = (Just)gtk_combo_box_get_active(GTK_COMBO_BOX(okna.DTTextJ));
  buf = gtk_font_button_get_font_name(GTK_FONT_BUTTON(okna.DTTextCzcionka));
  strcpy(ust.DTTextDni.font, buf);

  ust.DTTextNie = ust.DTTextSob = ust.DTTextDni;

  get_color_from_color_button(GTK_COLOR_BUTTON(okna.DTDniText), ust.DTTextDni.kolor);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.DTSobText), ust.DTTextSob.kolor);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.DTNieText), ust.DTTextNie.kolor);

    //TC
  ust.DTPokazTC = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.DTTC));

  ust.DTTC.x = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTCX));
  ust.DTTC.y = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTCY));
  ust.DTTC.w = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTCW));
  ust.DTTC.h = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTCH));
  ust.DTTC.gr = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTCGr));
  ust.DTTC.pr = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.DTTCPr));
  ust.DTTC.LG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.DTTCLG));
  ust.DTTC.PG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.DTTCPG));
  ust.DTTC.LD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.DTTCLD));
  ust.DTTC.PD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.DTTCPD));
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.DTTCTlo), ust.DTTC.tlo);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.DTTCRamka), ust.DTTC.ramka);

  //numerowanie tygodni
  ust.NTDwieCyfry = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NTDwieCyfry));
    //Tlo
  ust.NTPokazTlo = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NTTlo));

  ust.NTTlo.x = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTloX));
  ust.NTTlo.y = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTloY));
  ust.NTTlo.w = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTloW));
  ust.NTTlo.h = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTloH));
  ust.NTTlo.gr = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTloGr));
  ust.NTTlo.pr = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTloPr));
  ust.NTTlo.LG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NTTloLG));
  ust.NTTlo.PG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NTTloPG));
  ust.NTTlo.LD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NTTloLD));
  ust.NTTlo.PD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NTTloPD));
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.NTTloTlo), ust.NTTlo.tlo);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.NTTloRamka), ust.NTTlo.ramka);

    //text
  ust.NTPokazText = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NTText));

  ust.NTText.x = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTextX));
  ust.NTText.y = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTextY));
  ust.NTText.max = 0.0;
  ust.NTText.just = (Just)gtk_combo_box_get_active(GTK_COMBO_BOX(okna.NTTextJ));
  buf = gtk_font_button_get_font_name(GTK_FONT_BUTTON(okna.NTTextCzcionka));
  strcpy(ust.NTText.font, buf);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.NTTextKolor), ust.NTText.kolor);

    //TC
  ust.NTPokazTC = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NTTC));

  ust.NTTC.x = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTCX));
  ust.NTTC.y = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTCY));
  ust.NTTC.w = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTCW));
  ust.NTTC.h = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTCH));
  ust.NTTC.gr = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTCGr));
  ust.NTTC.pr = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NTTCPr));
  ust.NTTC.LG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NTTCLG));
  ust.NTTC.PG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NTTCPG));
  ust.NTTC.LD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NTTCLD));
  ust.NTTC.PD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NTTCPD));
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.NTTCTlo), ust.NTTC.tlo);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.NTTCRamka), ust.NTTC.ramka);

  //nazwy miesiecy
  ust.NMPokazText = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NMText));

  ust.NMText.x = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NMTextX));
  ust.NMText.y = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NMTextY));
  ust.NMText.max = 0.0;
  ust.NMText.just = (Just)gtk_combo_box_get_active(GTK_COMBO_BOX(okna.NMTextJ));
  buf = gtk_font_button_get_font_name(GTK_FONT_BUTTON(okna.NMTextCzcionka));
  strcpy(ust.NMText.font, buf);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.NMTextKolor), ust.NMText.kolor);

  ust.NMPokazTC = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NMTC));

  ust.NMTC.x = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NMTCX));
  ust.NMTC.y = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NMTCY));
  ust.NMTC.w = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NMTCW));
  ust.NMTC.h = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NMTCH));
  ust.NMTC.gr = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NMTCGr));
  ust.NMTC.pr = gtk_spin_button_get_value(GTK_SPIN_BUTTON(okna.NMTCPr));
  ust.NMTC.LG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NMTCLG));
  ust.NMTC.PG = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NMTCPG));
  ust.NMTC.LD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NMTCLD));
  ust.NMTC.PD = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(okna.NMTCPD));
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.NMTCTlo), ust.NMTC.tlo);
  get_color_from_color_button(GTK_COLOR_BUTTON(okna.NMTCRamka), ust.NMTC.ramka);

  return true;
}

/****************UstawUstawienia*************/
/**ustawia ustawienia z ust na kontrolkach***/
bool CPluginGUI::UstawUstawienia(const SUstawienia& ust)
{
  if(!wczytano)
    return false;

  //ustawienia ogolne
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UOSkala), ust.skala);

  gtk_entry_set_text(GTK_ENTRY(okna.UODniTygodnia), ust.dniTygodnia);
  gtk_entry_set_text(GTK_ENTRY(okna.UONazwyMiesiecy), ust.miesiace);
  gtk_entry_set_text(GTK_ENTRY(okna.UOListaSwiat), ust.listaSwiat);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UOTylko1Miesiac), ust.tylko1msc);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UOMiesiac), ust.msc);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UORok), ust.rok);
  gtk_combo_box_set_active(GTK_COMBO_BOX(okna.UOUkladRoku), ust.ukladRoku);

  gtk_entry_set_text(GTK_ENTRY(okna.UOListaImion), ust.listaImienin);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UOWymiarMscX), ust.UOWymiarMscX);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UOWymiarMscY), ust.UOWymiarMscY);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UOTloCalosci), ust.UOPokazTlo);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UOTloX), ust.UOTlo.x);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UOTloY), ust.UOTlo.y);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UOTloW), ust.UOTlo.w);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UOTloH), ust.UOTlo.h);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UOTloGr), ust.UOTlo.gr);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UOTloPr), ust.UOTlo.pr);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UOTloLG), ust.UOTlo.LG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UOTloPG), ust.UOTlo.PG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UOTloLD), ust.UOTlo.LD);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UOTloPD), ust.UOTlo.PD);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UOTloKolor), ust.UOTlo.tlo);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UOTloRamkaKolor), ust.UOTlo.ramka);

  //ustawienia dni
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UDTlo), ust.UDPokazTlo);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UDDwieCyfry), ust.UDDwieCyfry);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UDPokazInne), ust.UDPokazInne);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UDPokaz6Tygodni), ust.UDPokaz6Tygodni);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDTloOX), ust.ox);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDTloOY), ust.oy);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDTloX), ust.UDDni.x);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDTloY), ust.UDDni.y);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDTloW), ust.UDDni.w);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDTloH), ust.UDDni.h);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDTloPr), ust.UDDni.pr);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDTloGr), ust.UDDni.gr);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UDTloLG), ust.UDDni.LG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UDTloPG), ust.UDDni.PG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UDTloLD), ust.UDDni.LD);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UDTloPD), ust.UDDni.PD);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDTloCX), ust.UDDni.cx);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDTloCY), ust.UDDni.cy);

  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDDniRamka), ust.UDDni.ramka);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDDniLG), ust.UDDni.tloLG);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDDniPG), ust.UDDni.tloPG);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDDniLD), ust.UDDni.tloLD);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDDniPD), ust.UDDni.tloPD);

  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDNieRamka), ust.UDNie.ramka);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDNieLG), ust.UDNie.tloLG);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDNiePG), ust.UDNie.tloPG);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDNieLD), ust.UDNie.tloLD);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDNiePD), ust.UDNie.tloPD);

  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDSobRamka), ust.UDSob.ramka);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDSobLG), ust.UDSob.tloLG);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDSobPG), ust.UDSob.tloPG);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDSobLD), ust.UDSob.tloLD);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDSobPD), ust.UDSob.tloPD);

  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDInneRamka), ust.UDInne.ramka);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDInneLG), ust.UDInne.tloLG);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDInnePG), ust.UDInne.tloPG);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDInneLD), ust.UDInne.tloLD);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDInnePD), ust.UDInne.tloPD);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDTextX), ust.UDTextDni.x);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDTextY), ust.UDTextDni.y);
  gtk_combo_box_set_active(GTK_COMBO_BOX(okna.UDTextJ), (gint)ust.UDTextDni.just);
  gtk_font_button_set_font_name(GTK_FONT_BUTTON(okna.UDTextCzcionka), ust.UDTextDni.font);

  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDDniDni), ust.UDTextDni.kolor);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDSobDni), ust.UDTextSob.kolor);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDNieDni), ust.UDTextNie.kolor);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDInneDni), ust.UDTextInne.kolor);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.UDImiona), ust.UDPokazImieniny);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDImionaMax), ust.UDImieninyMax);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDImionaX), ust.UDImieninyDni.x);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDImionaY), ust.UDImieninyDni.y);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.UDImionaSzer), ust.UDImieninyDni.max);
  gtk_combo_box_set_active(GTK_COMBO_BOX(okna.UDImionaJ), (gint)ust.UDImieninyDni.just);
  gtk_font_button_set_font_name(GTK_FONT_BUTTON(okna.UDImionaCzcionka), ust.UDImieninyDni.font);

  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDDniImiona), ust.UDImieninyDni.kolor);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDSobImiona), ust.UDImieninySob.kolor);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDNieImiona), ust.UDImieninyNie.kolor);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.UDInneImiona), ust.UDImieninyInne.kolor);

  //dni tygodnia
    //tlo
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.DTTlo), ust.DTPokazTlo);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTloX), ust.DTDni.x);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTloY), ust.DTDni.y);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTloW), ust.DTDni.w);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTloH), ust.DTDni.h);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTloGr), ust.DTDni.gr);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTloPr), ust.DTDni.pr);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.DTTloLG), ust.DTDni.LG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.DTTloPG), ust.DTDni.PG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.DTTloLD), ust.DTDni.LD);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.DTTloPD), ust.DTDni.PD);

  set_color_to_color_button(GTK_COLOR_BUTTON(okna.DTDniTlo), ust.DTDni.tlo);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.DTDniRamka), ust.DTDni.ramka);

  set_color_to_color_button(GTK_COLOR_BUTTON(okna.DTSobTlo), ust.DTSob.tlo);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.DTSobRamka), ust.DTSob.ramka);

  set_color_to_color_button(GTK_COLOR_BUTTON(okna.DTNieTlo), ust.DTNie.tlo);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.DTNieRamka), ust.DTNie.ramka);

    //text
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.DTText), ust.DTPokazText);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTextX), ust.DTTextDni.x);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTextY), ust.DTTextDni.y);
  gtk_combo_box_set_active(GTK_COMBO_BOX(okna.DTTextJ), (gint)ust.DTTextDni.just);
  gtk_font_button_set_font_name(GTK_FONT_BUTTON(okna.DTTextCzcionka), ust.DTTextDni.font);

  set_color_to_color_button(GTK_COLOR_BUTTON(okna.DTDniText), ust.DTTextDni.kolor);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.DTSobText), ust.DTTextSob.kolor);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.DTNieText), ust.DTTextNie.kolor);

    //TC
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.DTTC), ust.DTPokazTC);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTCX), ust.DTTC.x);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTCY), ust.DTTC.y);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTCW), ust.DTTC.w);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTCH), ust.DTTC.h);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTCGr), ust.DTTC.gr);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.DTTCPr), ust.DTTC.pr);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.DTTCLG), ust.DTTC.LG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.DTTCPG), ust.DTTC.PG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.DTTCLD), ust.DTTC.LD);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.DTTCPD), ust.DTTC.PD);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.DTTCTlo), ust.DTTC.tlo);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.DTTCRamka), ust.DTTC.ramka);

  //numerowanie tygodni
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NTDwieCyfry), ust.NTDwieCyfry);
    //Tlo
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NTTlo), ust.NTPokazTlo);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTloX), ust.NTTlo.x);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTloY), ust.NTTlo.y);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTloW), ust.NTTlo.w);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTloH), ust.NTTlo.h);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTloGr), ust.NTTlo.gr);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTloPr), ust.NTTlo.pr);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NTTloLG), ust.NTTlo.LG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NTTloPG), ust.NTTlo.PG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NTTloLD), ust.NTTlo.LD);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NTTloPD), ust.NTTlo.PD);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.NTTloTlo), ust.NTTlo.tlo);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.NTTloRamka), ust.NTTlo.ramka);

    //text
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NTText), ust.NTPokazText);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTextX), ust.NTText.x);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTextY), ust.NTText.y);
  gtk_combo_box_set_active(GTK_COMBO_BOX(okna.NTTextJ), (gint)ust.NTText.just);
  gtk_font_button_set_font_name(GTK_FONT_BUTTON(okna.NTTextCzcionka), ust.NTText.font);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.NTTextKolor), ust.NTText.kolor);

    //TC
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NTTC), ust.NTPokazTC);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTCX), ust.NTTC.x);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTCY), ust.NTTC.y);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTCW), ust.NTTC.w);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTCH), ust.NTTC.h);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTCGr), ust.NTTC.gr);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NTTCPr), ust.NTTC.pr);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NTTCLG), ust.NTTC.LG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NTTCPG), ust.NTTC.PG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NTTCLD), ust.NTTC.LD);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NTTCPD), ust.NTTC.PD);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.NTTCTlo), ust.NTTC.tlo);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.NTTCRamka), ust.NTTC.ramka);

  //nazwy miesiecy
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NMText), ust.NMPokazText);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NMTextX), ust.NMText.x);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NMTextY), ust.NMText.y);
  gtk_combo_box_set_active(GTK_COMBO_BOX(okna.NMTextJ), (gint)ust.NMText.just);
  gtk_font_button_set_font_name(GTK_FONT_BUTTON(okna.NMTextCzcionka), ust.NMText.font);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.NMTextKolor), ust.NMText.kolor);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NMTC), ust.NMPokazTC);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NMTCX), ust.NMTC.x);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NMTCY), ust.NMTC.y);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NMTCW), ust.NMTC.w);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NMTCH), ust.NMTC.h);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NMTCGr), ust.NMTC.gr);
  gtk_spin_button_set_value(GTK_SPIN_BUTTON(okna.NMTCPr), ust.NMTC.pr);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NMTCLG), ust.NMTC.LG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NMTCPG), ust.NMTC.PG);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NMTCLD), ust.NMTC.LD);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(okna.NMTCPD), ust.NMTC.PD);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.NMTCTlo), ust.NMTC.tlo);
  set_color_to_color_button(GTK_COLOR_BUTTON(okna.NMTCRamka), ust.NMTC.ramka);

  return true;
}
