#include "CPluginGenerator.h"

bool CPluginGenerator::Generuj(const SUstawienia& ust)
{
  /**
  Kolejosc generowaia:
  1.ustawieie skali obrazu
  2.jezeli 1 miesiac to go wygeneruj
  3.ustawienie pozycji miesiaca
  4.generuj miesiac
  5.powrot do pozycji (0,0) i przejdz do punktu 3
  **/

  /**1**/
  cairo_scale(cr, ust.skala, ust.skala);

  /**2**/
  if(ust.tylko1msc)
  {
    GenerujMiesiac(ust, ust.msc, ust.rok);

    if(odswiezajPasek)
      gimp_progress_update(1.0);
  }
  else
  {
    unsigned int ukladyX[] = {1,2,3,4,6,12};
    unsigned int ukladX = ukladyX[ust.ukladRoku];
    unsigned int ukladY = 12/ukladX;
    unsigned int ktoryMsc = 1;

    for(unsigned int y = 0; y<ukladY; y++)
        for(unsigned int x = 0; x<ukladX; x++)
        {
          /**3**/
          cairo_translate(cr, ust.UOWymiarMscX*x, ust.UOWymiarMscY*y);

          /**4**/
          GenerujMiesiac(ust, ktoryMsc, ust.rok);
          ktoryMsc++;


          /**5**/
          cairo_translate(cr, -(ust.UOWymiarMscX*x), -(ust.UOWymiarMscY*y));

          if(odswiezajPasek)
            gimp_progress_update(ktoryMsc/12.0);
        }
  }

  return true;
}

bool CPluginGenerator::GenerujMiesiac(const SUstawienia& ust, int msc, int rok)
{
  /**
  Kolejosc generowaia:
  0.ustaw swieta i wczytaj imiona
  1.tlo calosc (UOTlo)
  2.tlo nazwy miesiaca
  3.napis nazwy miesiaca
  4.tlo calosci numerowania tygodni
  5.tlo i napisy numerowania tygodni
  6.tlo calosci dni tygodnia
  7.tlo i napisy dni tygodni
  8.tlo i napisy (daty i imieniny) poszczegolnych dni
  **/

  static CPluginImiona imiona;
  CMiesiac miesiac;

  miesiac.Nowy(msc, rok);
  imiona.WczytajImiona(ust.listaImienin);

  /**0**/
  UstawSwieta(miesiac, ust.listaSwiat);

  /**1**/
  if(ust.UOPokazTlo)
  {
    prostokat = ust.UOTlo;
    RysujProstokat();
  }

  /**2**/
  if(ust.NMPokazTC)
  {
    prostokat = ust.NMTC;
    RysujProstokat();
  }

  /**3**/
  if(ust.NMPokazText)
  {
    napis = ust.NMText;
    napisText = PobierzNazwe(ust.miesiace, msc);
    RysujNapis();
  }

  /**4**/
  if(ust.NTPokazTC)
  {
    prostokat = ust.NTTC;
    RysujProstokat();
  }

  /**5**/
  for(unsigned int i = 0; i<6; i++)
  {
    if(miesiac.tygodnie[i].pusty && (!ust.UDPokaz6Tygodni))
      break;

    prostokat = ust.NTTlo;
    prostokat.y += i*ust.oy;

    if(ust.NTPokazTlo)
      RysujProstokat();

    if(ust.NTPokazText)
    {
      std::stringstream ss("");

      napis = ust.NTText;
      napis.y += prostokat.y;
      napis.x += prostokat.x;

      if(miesiac.tygodnie[i].ktory<=9 && ust.NTDwieCyfry)
        ss<<"0";

      ss<<miesiac.tygodnie[i].ktory;

      napisText = ss.str();
      RysujNapis();
    }
  }

  /**6**/
  if(ust.DTPokazTC)
  {
    prostokat = ust.DTTC;
    RysujProstokat();
  }

  /**7**/
  for(unsigned int i = 0; i<7; i++)
  {
    if(i<5) //dni tygodnia
    {
      prostokat = ust.DTDni;
      napis = ust.DTTextDni;
    }
    else if(i==5) //sobota
    {
      prostokat = ust.DTSob;
      napis = ust.DTTextSob;
    }
    else //niedziela
    {
      prostokat = ust.DTNie;
      napis = ust.DTTextNie;
    }

    prostokat.x += ust.ox*i;

    if(ust.DTPokazTlo)
      RysujProstokat();

    if(ust.DTPokazText)
    {
      napis.x += prostokat.x;
      napis.y += prostokat.y;
      napisText = PobierzNazwe(ust.dniTygodnia, i+1);

      RysujNapis();
    }
  }

  /**8**/
  for(unsigned int t = 0; t<6; t++)
  {
    if(miesiac.tygodnie[t].pusty && (!ust.UDPokaz6Tygodni))   //jezeli dany tydzien jest pusty przerwij
      break;

    for(unsigned int d = 0; d<7; d++)
    {
      SText napisImiona;
      std::stringstream ss("");

      if(miesiac.tygodnie[t].dni[d].miesiac != miesiac.ktory) //dzien z innego miesiaca
      {
        if(!ust.UDPokazInne)
          continue;       //jezlie nie wyswietlamy dni z innych miesiacy to przejdz do kolejnego dnia

        prostokat4kolory = ust.UDInne;
        napis = ust.UDTextInne;
        napisImiona = ust.UDImieninyInne;
      }
      else if(miesiac.tygodnie[t].dni[d].dzien_tygodnia==7 || miesiac.tygodnie[t].dni[d].swieto) //jezeli niedziela lub swieto
      {
        prostokat4kolory = ust.UDNie;
        napis = ust.UDTextNie;
        napisImiona = ust.UDImieninyNie;
      }
      else if(miesiac.tygodnie[t].dni[d].dzien_tygodnia == 6)  //jezeli sobota
      {
        prostokat4kolory = ust.UDSob;
        napis = ust.UDTextSob;
        napisImiona = ust.UDImieninySob;
      }
      else //zwykly dzien
      {
        prostokat4kolory = ust.UDDni;
        napis = ust.UDTextDni;
        napisImiona = ust.UDImieninyDni;
      }

      prostokat4kolory.x += d*ust.ox;
      prostokat4kolory.y += t*ust.oy;

      napis.x += prostokat4kolory.x;
      napis.y += prostokat4kolory.y;

      if(miesiac.tygodnie[t].dni[d].dzien<10 && ust.UDDwieCyfry)
        ss<<"0";

      ss<<miesiac.tygodnie[t].dni[d].dzien;
      napisText = ss.str();

      if(ust.UDPokazTlo)
        RysujProstokat4Kolory();

      RysujNapis();

      if(ust.UDPokazImieniny && ust.UDImieninyMax)
      {
        napis = napisImiona;
        napis.x += prostokat4kolory.x;
        napis.y += prostokat4kolory.y;

        napisText = imiona.PobierzImiona(miesiac.tygodnie[t].dni[d].dzien,
                                         miesiac.tygodnie[t].dni[d].miesiac,
                                         ust.UDImieninyMax);

        RysujNapis();
      }
    }
  }

  return true;
}

/**********UstawSwieta************/
/** ustawia swieta w miesiacu*****/
void CPluginGenerator::UstawSwieta(CMiesiac& msc, std::string swieta)
{
  char buf[8];
  unsigned int d, m;
  std::stringstream ss(swieta);

  if(swieta.size()==0)
    return;

  while(!ss.eof())
  {
    ss.getline(buf, 8, ':');
    d = atoi(buf);
    ss.getline(buf, 8, ';');
    m = atoi(buf);

    msc.DodajSwieto(m, d);
  }

}

/**********PobierzNazwe************/
/** zwraca napis n z ciagu napisow oddzielonych znakiem ';' ******/
/** i podmienia znak '|' na '\n' ***/
std::string CPluginGenerator::PobierzNazwe(const char* cstr, int n)
{
  std::stringstream ss(cstr);
  std::string buf;

  for(int i=0;i<n;i++)
    getline(ss, buf, ';');

  if(buf.size()==0)
    return buf;

  for(unsigned int i = 0; i<buf.size();i++)
  {
    if(buf[i]=='|')
      buf[i]='\n';
  }
  return buf;

}

/**********cairo_my_prostokat_4_kolory************/
/** generuje prostokat z 4 kolorami tla **********/
void CPluginGenerator::cairo_my_prostokat_4_kolory(double x, double y, double w, double h, double szer, double pr, bool LG, bool PG, bool LD, bool PD, SRGBA ramka,
                                                  SRGBA tloLG, SRGBA tloPG, SRGBA tloLD, SRGBA tloPD, double cx, double cy)
{
  double r = w>h?(h*pr/200.0):(w*pr/200.0);

  //jezeli prostokat jest szeroki lub wysoki na 0px
  if(w==0||h==0)
    return;

  cairo_save(cr);
  cairo_push_group(cr);

  //narysuj ramke jezeli jest widoczna
  if(szer>=1.0)
  {
    cairo_my_zaznacz_prostokat(x, y, w, h, r, LG, PG, LD, PD);
    cairo_set_source_rgba(cr, ramka.r, ramka.g, ramka.b, ramka.a);
    cairo_fill(cr);
  }

  //jezeli widoczne jest tlo to je narysuj
  if((w-2*szer)>=1.0&&(h-2*szer)>=1.0)
  {
    //zaznacz caly srodek prostokata i wypelnij go 4 kolorami
    r = r-szer<1?0.0:r-szer;
    cairo_my_zaznacz_prostokat(x+szer, y+szer, w-2*szer, h-2*szer, r, LG, PG, LD, PD);

    cairo_clip(cr);
    cairo_set_operator(cr, CAIRO_OPERATOR_SOURCE);

    //lewy gorny
    cairo_rectangle(cr, x, y, cx, cy);
    cairo_set_source_rgba(cr, tloLG.r, tloLG.g, tloLG.b, tloLG.a);
    cairo_fill(cr);

    //prawy gorny
    cairo_rectangle(cr, x+cx, y, w, cy);
    cairo_set_source_rgba(cr, tloPG.r, tloPG.g, tloPG.b, tloPG.a);
    cairo_fill(cr);

    //lewy dolny
    cairo_rectangle(cr, x, y+cy, cx, h);
    cairo_set_source_rgba(cr, tloLD.r, tloLD.g, tloLD.b, tloLD.a);
    cairo_fill(cr);

    //prawy dolny
    cairo_rectangle(cr, x+cx, y+cy, w, h);
    cairo_set_source_rgba(cr, tloPD.r, tloPD.g, tloPD.b, tloPD.a);
    cairo_fill(cr);
  }

  cairo_pop_group_to_source(cr);
  cairo_paint(cr);

  cairo_restore(cr);
}

/***** cairo_my_prostokat************/
/**Funkcja rysuje prostokat z zaokraglonymi kolorami i 1 kolorem tla**/
void CPluginGenerator::cairo_my_prostokat(double x, double y, double w, double h, double szer, double pr, bool LG, bool PG, bool LD, bool PD, SRGBA ramka, SRGBA tlo)
{
  double r = w>h?(h*pr/200.0):(w*pr/200.0);

  //jezeli prostokat jest szeroki lub wysoki na 0px
  if(w==0.0||h==0.0)
    return;

  cairo_save(cr);

  cairo_push_group(cr);

  //narysuj ramke jezeli jest widoczna
  if(szer>=1.0)
  {
    cairo_my_zaznacz_prostokat(x, y, w, h, r, LG, PG, LD, PD);
    cairo_set_source_rgba(cr, ramka.r, ramka.g, ramka.b, ramka.a);    //kolor ramki
    cairo_fill(cr);
  }

  //jezeli widoczny jest rowniez srodek to go wypelnij
  if((w-2*szer)>=1.0&&(h-2*szer)>=1.0)
  {
    //zaznacz caly srodek prostokata i wypelnij go kolorem tla
    r = r-szer<1?0.0:r-szer;
    cairo_my_zaznacz_prostokat(x+szer, y+szer, w-2*szer, h-2*szer, r, LG, PG, LD, PD);

    cairo_set_operator(cr, CAIRO_OPERATOR_SOURCE);
    cairo_set_source_rgba(cr, tlo.r, tlo.g, tlo.b, tlo.a);
    cairo_fill(cr);
  }

  cairo_pop_group_to_source(cr);
  cairo_paint(cr);

  cairo_restore(cr);
}

/***** cairo_my_zaznacz_prostokat************/
/**
Funkcja zaznacza prostokat z zaokraglonymi rogami
**/
void CPluginGenerator::cairo_my_zaznacz_prostokat(double x, double y, double w, double h, double pr, bool LG, bool PG, bool LD, bool PD)
{
  double r;

  r = LG?pr:0.0;
  cairo_move_to(cr, x+r, y);
  r = PG?pr:0.0;
  cairo_arc(cr, x+w-r, y+r, r, -90.0*M_PI/180, 0.0);
  r = PD?pr:0.0;
  cairo_arc(cr, x+w-r, y+h-r, r, 0.0, 90.0*M_PI/180.0);
  r = LD?pr:0.0;
  cairo_arc(cr, x+r, y+h-r, r, 90.0*M_PI/180.0, M_PI);
  r = LG?pr:0.0;
  cairo_arc(cr, x+r, y+r, r, M_PI, -90.0*M_PI/180);
  cairo_close_path(cr);

}


/**** RysujProstokat *******/
/***rysuje prostokat z zmiennej prostokat****/
void CPluginGenerator::RysujProstokat()
{
  cairo_my_prostokat(prostokat.x,
                    prostokat.y,
                    prostokat.w,
                    prostokat.h,
                    prostokat.gr,
                    prostokat.pr,
                    prostokat.LG,
                    prostokat.PG,
                    prostokat.LD,
                    prostokat.PD,
                    prostokat.ramka,
                    prostokat.tlo);
}

/**** RysujProstokat4Kolory *******/
/***rysuje prostokat z zmiennej prostokat4kolory****/
void CPluginGenerator::RysujProstokat4Kolory()
{
  cairo_my_prostokat_4_kolory(prostokat4kolory.x,
                              prostokat4kolory.y,
                              prostokat4kolory.w,
                              prostokat4kolory.h,
                              prostokat4kolory.gr,
                              prostokat4kolory.pr,
                              prostokat4kolory.LG,
                              prostokat4kolory.PG,
                              prostokat4kolory.LD,
                              prostokat4kolory.PD,
                              prostokat4kolory.ramka,
                              prostokat4kolory.tloLG,
                              prostokat4kolory.tloPG,
                              prostokat4kolory.tloLD,
                              prostokat4kolory.tloPD,
                              prostokat4kolory.cx,
                              prostokat4kolory.cy);
}

/**** RysujNapis *******/
/***rysuje napis ze zmiennych napis i napisText****/
void CPluginGenerator::RysujNapis()
{
  double x;
  int px, py;

  PangoLayout* layout = pango_cairo_create_layout(cr);

  PangoFontDescription* font = pango_font_description_from_string(napis.font);
  pango_layout_set_font_description(layout, font);
  pango_font_description_free(font);

  pango_layout_set_alignment(layout, (PangoAlignment)napis.just);

  if(napis.max!=0.0)
  {
    pango_layout_set_ellipsize(layout, PANGO_ELLIPSIZE_END);
    pango_layout_set_width(layout, napis.max*PANGO_SCALE);
  }

  pango_layout_set_text(layout, napisText.c_str(), napisText.length());

  pango_layout_get_pixel_size(layout, &px, &py);
  cairo_set_source_rgba(cr, napis.kolor.r, napis.kolor.g, napis.kolor.b, napis.kolor.a);

  x = napis.x;
  if(napis.just==Prawo)
    x-=px;
  else if(napis.just==Srodek)
    x-=px/2.0;

  cairo_move_to(cr, x, napis.y);
  pango_cairo_show_layout(cr, layout);

  g_object_unref(layout);
}
