#include <libgimp/gimp.h>
#include <cairo/cairo.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <string>
#include <sstream>

#include "SUstawienia.h"
#include "CMiesiac.h"
#include "CPluginImiona.h"

#ifndef _C_PLUGIN_GENERATOR_
#define _C_PLUGIN_GENERATOR_

class CPluginGenerator
{
  private:
    cairo_t* cr;
    bool odswiezajPasek;

    SProstokat prostokat;
    SProstokat4Kolory prostokat4kolory;
    SText napis;
    std::string napisText;


    void RysujProstokat();
    void RysujProstokat4Kolory();
    void RysujNapis();

    void UstawSwieta(CMiesiac& msc, std::string swieta);

    bool GenerujMiesiac(const SUstawienia& ust, int msc, int rok);
    std::string PobierzNazwe(const char* cstr, int n);

    void cairo_my_prostokat_4_kolory(double x, double y, double w, double h, double szer, double pr, bool LG, bool PG, bool LD, bool PD, SRGBA ramka,
                                    SRGBA tloLG, SRGBA tloPG, SRGBA tloLD, SRGBA tloPD, double cx, double cy);
    void cairo_my_prostokat(double x, double y, double w, double h, double szer, double pr, bool LG, bool PG, bool LD, bool PD, SRGBA ramka, SRGBA tlo);
    void cairo_my_zaznacz_prostokat(double x, double y, double w, double h, double pr, bool LG, bool PG, bool LD, bool PD);

  public:
    CPluginGenerator(cairo_t* cairo, bool pasekPostepu)
      :cr(cairo), odswiezajPasek(pasekPostepu){}

    bool Generuj(const SUstawienia& ust);



};



#endif

