#ifndef _S_USTAWIENIA_
#define _S_USTAWIENIA_

#include <string>

#define MAX_NAME 1024

#undef MAX_PATH
#define MAX_PATH 2048


extern std::string sciezka_wtyczki;

struct SRGBA
{
  double r;
  double g;
  double b;
  double a;

};

enum Just
{
  Lewo,
  Srodek,
  Prawo
};

struct SProstokat
{
  double x;
  double y;
  double w;
  double h;
  double gr;
  double pr;
  SRGBA tlo;
  SRGBA ramka;
  bool LG;
  bool PG;
  bool LD;
  bool PD;
};

struct SProstokat4Kolory
{
  double x;
  double y;
  double w;
  double h;
  double gr;
  double pr;
  double cx;
  double cy;
  SRGBA tloLG;
  SRGBA tloPG;
  SRGBA tloLD;
  SRGBA tloPD;
  SRGBA ramka;
  bool LG;
  bool PG;
  bool LD;
  bool PD;
};

struct SText
{
  double x;
  double y;
  Just just;
  char font[MAX_NAME];
  SRGBA kolor;
  double max;
};


struct SUstawienia
{
  //ustawienia ogolne
  double skala;

  char dniTygodnia[MAX_NAME];
  char miesiace[MAX_NAME];
  char listaSwiat[MAX_NAME];
  char listaImienin[MAX_PATH];

  double UOWymiarMscX;
  double UOWymiarMscY;

  bool tylko1msc;
  int msc;
  int rok;
  int ukladRoku;

  bool UOPokazTlo;
  SProstokat UOTlo;

  //ustawienia dni
  bool UDPokazTlo;
  bool UDDwieCyfry;
  bool UDPokazInne;
  bool UDPokaz6Tygodni;
  double ox;
  double oy;
  SProstokat4Kolory UDDni;
  SProstokat4Kolory UDSob;
  SProstokat4Kolory UDNie;
  SProstokat4Kolory UDInne;
  SText UDTextDni;
  SText UDTextSob;
  SText UDTextNie;
  SText UDTextInne;
  bool UDPokazImieniny;
  int UDImieninyMax;
  SText UDImieninyDni;
  SText UDImieninySob;
  SText UDImieninyNie;
  SText UDImieninyInne;

  //dni tygodnia
  bool DTPokazTlo;
  SProstokat DTDni;
  SProstokat DTSob;
  SProstokat DTNie;
  bool DTPokazText;
  SText DTTextDni;
  SText DTTextSob;
  SText DTTextNie;
  bool DTPokazTC;
  SProstokat DTTC;

  //numerowanie tygodni
  bool NTDwieCyfry;
  bool NTPokazTlo;
  SProstokat NTTlo;
  bool NTPokazText;
  SText NTText;
  bool NTPokazTC;
  SProstokat NTTC;

  //nazwy miesiecy
  bool NMPokazText;
  SText NMText;
  bool NMPokazTC;
  SProstokat NMTC;

};


#endif
