#include <iostream>
#include <conio.h>
#include <fstream>
#include <string>
#include <vector>
#include <math.h>

#define min(a,b) (a<b?a:b)
#define max(a,b) (a>b?a:b)

void ClearText(std::string &text){
	if(text.size()){
		while(text[0]==' ' && text.size()){
			text.erase(text.begin());
		}
	}
}

class val{
public:
	std::string name;
	std::string value;
	val(std::string vText);
};

val::val(std::string vText){
	if(vText.size()){
		std::string::size_type index = vText.find_first_of('=',0);
		if(index != std::string::npos){
			name.insert(0,vText,0,index);
			value.insert(0,vText,index + 2, vText.size() - index - 3);
		}
	}
};

class c_xml{
public:
	std::vector<c_xml> xmlT;
	std::string vName;
	std::vector<val> tVal;
	c_xml(std::vector<std::string> &t);

	void EraseRekordIfNameNotMatch(std::string name);
	void EraseRekordIfDontHaveChild();

	void WriteChildsValues();
	void WriteChildsValue(std::string name);

	int FindValueIndex(std::string valueName);
};

int c_xml::FindValueIndex(std::string valueName){
	for(std::vector<val>::iterator i = tVal.begin(); i < tVal.end(); i++){
		if(!valueName.compare(i->name)){
			return int(i - tVal.begin());
		}
	}
	return -1;
}

void c_xml::WriteChildsValues(){
	for(std::vector<c_xml>::iterator i = xmlT.begin(); i < xmlT.end(); i++){
		std::cout<<std::endl<<i->vName.c_str();
		for(std::vector<val>::iterator j = i->tVal.begin(); j < i->tVal.end(); j++){
			std::cout<<std::endl<<j->name.c_str()<<"="<<j->value.c_str();
		}
	}
}

void c_xml::WriteChildsValue(std::string name){
	for(std::vector<c_xml>::iterator i = xmlT.begin(); i < xmlT.end(); i++){
		//std::cout<<std::endl<<i->vName.c_str();
		for(std::vector<val>::iterator j = i->tVal.begin(); j < i->tVal.end(); j++){
			if(!name.compare(j->name))
				std::cout<<std::endl<<"Nazwa gradientu: "<<j->value.c_str();
		}
		std::cout<<std::endl<<"Liczba punktow: "<<i->xmlT.size();
	}
}

void c_xml::EraseRekordIfNameNotMatch(std::string name){
	for(int i = 0; i < xmlT.size(); i++){
		if(name.compare(xmlT[i].vName)){
			xmlT.erase(xmlT.begin() + i);
			i--;
		}
	}
}

void c_xml::EraseRekordIfDontHaveChild(){
	for(int i = 0; i < xmlT.size(); i++){
		if(!xmlT[i].xmlT.size()){
			xmlT.erase(xmlT.begin() + i);
			i--;
		}
	}
}

c_xml::c_xml(std::vector<std::string> &t){
	vName.insert(0,t[0],1,t[0].size()-1);
	t.erase(t.begin());
	if(t.size()){
		bool w = true;
		while(t.size() && w){
			if(t[0][t[0].size()-1] == '>'){
				w = false;
				t[0].erase(t[0].end()-1);
			}
			if(t[0][t[0].size()-1] == '/'){
				t[0].erase(t[0].end()-1);
				tVal.push_back(val(t[0]));
				t.erase(t.begin());
			}else{
				tVal.push_back(val(t[0]));
				t.erase(t.begin());
				if(!w){
					std::string s = "</";
					s += vName;
					s += ">";
					while(t.size() && s.compare(t[0])){
						xmlT.push_back(c_xml(t));
					}
					t.erase(t.begin());
				}

			}

		}
	}
}

int HexSingleValue(char c){
    switch(int(c)){
        case '0':
             return 0;
        case '1':
             return 1;
        case '2':
             return 2;
        case '3':
             return 3;
        case '4':
             return 4;
        case '5':
             return 5;
        case '6':
             return 6;
        case '7':
             return 7;
        case '8':
             return 8;
        case '9':
             return 9;
        case 'a':
        case 'A':
             return 10;
        case 'b':
        case 'B':
             return 11;
        case 'c':
        case 'C':
             return 12;
        case 'd':
        case 'D':
             return 13;
        case 'e':
        case 'E':
             return 14;
        case 'f':
             return 15;
        default:
             return -1;
    }
}

int CharHexToInt(std::string str){
    int dig = str.size();
    int value = 0;
    for(int i = 0; i < dig; i++){
        value += HexSingleValue(str[i])*pow(16.,double(dig -i-1));
    }
    return value;
}

struct pt{
	double red;
	double green;
	double blue;
	double alpha;
	double offset;

	pt::pt(c_xml stopPoint);
};

pt::pt(c_xml stopPoint){
	if(!stopPoint.vName.compare(std::string("stop")) && stopPoint.tVal.size() == 3){
		int iStyle = stopPoint.FindValueIndex(std::string("style"));
		int iOffset = stopPoint.FindValueIndex(std::string("offset"));
		std::string::size_type st = stopPoint.tVal[iStyle].value.find("rgb(",0);
		if(st == std::string::npos){
			std::string s;
			s.insert(0,stopPoint.tVal[iStyle].value,12,2);
			red = double(CharHexToInt(s.c_str())) / 255.;
			s.clear();
			s.insert(0,stopPoint.tVal[iStyle].value,14,2);
			green = double(CharHexToInt(s.c_str())) / 255.;
			s.clear();
			s.insert(0,stopPoint.tVal[iStyle].value,16,2);
			blue = double(CharHexToInt(s.c_str())) / 255.;
			s.clear();
			s.insert(0,stopPoint.tVal[iStyle].value,32,stopPoint.tVal[0].value.size() - 32);
			if(s[s.size()-1] == ';')
				s.erase(s.end() - 1);
			alpha = atof(s.c_str());
			offset = atof(stopPoint.tVal[iOffset].value.c_str());
		}else{
			std::string::size_type st2 = stopPoint.tVal[iStyle].value.find(')',0);
			st2;
			st += 4;
			std::string s;
			s.insert(0,stopPoint.tVal[iStyle].value,st, st2-st);
			int r = 0, g = 0, b = 0;
			sscanf(s.c_str(),"%i,%i,%i",&r,&g,&b);
			red = (double) r / 255;			
			green = (double) g / 255;
			blue = (double) b / 255;

			st = stopPoint.tVal[iStyle].value.find("stop-opacity:",0);
			if(st != std::string::npos){
				st += 13;
				s.clear();
				s.insert(0, stopPoint.tVal[iStyle].value, st,stopPoint.tVal[iStyle].value.size() - st);
				if(s[s.size() -1] == '%')
					s.erase(s.end() - 1);
				alpha = atof(s.c_str());
			}
			s.clear();
			s = stopPoint.tVal[iOffset].value;
			if(s[s.size() -1] == '%')
				s.erase(s.end() - 1);
			offset = (double) atol(s.c_str()) / 100.;
		}
	}
}

void CreateGGRFile(c_xml &xml,int index){
	std::vector<pt> tPt;

	if(index < 0 || index >= xml.xmlT.size())
		return;

	for(int i = 0; i < xml.xmlT[index].xmlT.size(); i++){
		tPt.push_back(pt(xml.xmlT[index].xmlT[i]));
	}

	std::string buffor("GIMP Gradient");
	buffor += char(10u);
	buffor += "Name: ";
	int iID = xml.xmlT[index].FindValueIndex("id");
	buffor += xml.xmlT[index].tVal[iID].value;
	buffor += char(10u);
	char buf[200];
	sprintf(buf, "%i",tPt.size() - 1);
	buffor += buf;
	buffor += char(10u);

	if(tPt.size() - 1 == 1){
		sprintf(buf,"%f %f %f %f %f %f %f %f %f %f %f 0 0%c",tPt[0].offset,(tPt[0].offset + tPt[1].offset) / 2.,tPt[1].offset,tPt[0].red,tPt[0].green,tPt[0].blue, tPt[0].alpha, tPt[1].red, tPt[1].green, tPt[1].blue, tPt[1].alpha, char(10));
		buffor += buf;
	}else{
		for(int i = 0; i < tPt.size() - 1; i++){
			sprintf(buf,"%f %f %f %f %f %f %f %f %f %f %f 0 0 0 0%c",tPt[i].offset,(tPt[i].offset + tPt[i + 1].offset) / 2.,tPt[i + 1].offset,tPt[i].red,tPt[i].green,tPt[i].blue, tPt[i].alpha, tPt[i+1].red, tPt[i+1].green, tPt[i+1].blue, tPt[i+1].alpha, char(10));
			buffor += buf;
		}
	}
	
	std::string location = xml.xmlT[index].tVal[iID].value;

	location += ".ggr";

	std::fstream file(location.c_str(),std::ios_base::out);

	file.write(buffor.c_str(),buffor.size());
	file.close();
	
	std::cout<<std::endl<<"Utworzono plik o nazwie (Create file with name): "<<xml.xmlT[index].tVal[iID].value.c_str();
}

void CreateGGRFile(c_xml &xml,int index,std::string loc){
	std::vector<pt> tPt;

	if(index < 0 || index >= xml.xmlT.size())
		return;

	for(int i = 0; i < xml.xmlT[index].xmlT.size(); i++){
		tPt.push_back(pt(xml.xmlT[index].xmlT[i]));
	}

	std::string buffor("GIMP Gradient");
	buffor += char(10u);
	buffor += "Name: ";
	int iID = xml.xmlT[index].FindValueIndex("id");
	buffor += xml.xmlT[index].tVal[iID].value;
	buffor += char(10u);
	char buf[200];
	sprintf(buf, "%i",tPt.size() - 1);
	buffor += buf;
	buffor += char(10u);

	if(tPt.size() - 1 == 1){
		sprintf(buf,"%f %f %f %f %f %f %f %f %f %f %f 0 0%c",tPt[0].offset,(tPt[0].offset + tPt[1].offset) / 2.,tPt[1].offset,tPt[0].red,tPt[0].green,tPt[0].blue, tPt[0].alpha, tPt[1].red, tPt[1].green, tPt[1].blue, tPt[1].alpha, char(10));
		buffor += buf;
	}else{
		for(int i = 0; i < tPt.size() - 1; i++){
			sprintf(buf,"%f %f %f %f %f %f %f %f %f %f %f 0 0 0 0%c",tPt[i].offset,(tPt[i].offset + tPt[i + 1].offset) / 2.,tPt[i + 1].offset,tPt[i].red,tPt[i].green,tPt[i].blue, tPt[i].alpha, tPt[i+1].red, tPt[i+1].green, tPt[i+1].blue, tPt[i+1].alpha, char(10));
			buffor += buf;
		}
	}
	
	std::string location = loc;
    
    location += xml.xmlT[index].tVal[iID].value;
	location += ".ggr";

	std::fstream file(location.c_str(),std::ios_base::out);

	file.write(buffor.c_str(),buffor.size());
	file.close();
	
	std::cout<<std::endl<<"Utworzono plik o nazwie (Create file with name): "<<xml.xmlT[index].tVal[iID].value.c_str();
}

int ExportGradient(char* location){
    std::fstream file(location,std::ios_base::in);

	std::string s;
	bool w = false;

	std::vector<std::string> tText;

	if(!file.fail()){
		do{
			std::getline(file,s);
			if(w){
				//std::cout<<s.c_str()<<std::endl;
				ClearText(s);
				tText.push_back(s);
			}else{
				ClearText(s);
				w = !s.compare("<defs");
				if(w)
					tText.push_back(s);
			}
		}while(!file.fail()?s.compare("</defs>"):0);
	}else{
          std::cout<<"ERROR nr. 1: Spowodowany przez czynnik ludzki: zla scieska do pliku svg";
          getch();
          return 0;
    }

	file.close();
	
	if(!tText.size()){
          std::cout<<"ERROR nr. 2: Cos nie tak z plikiem";
          getch();
          return 0;
    }

	c_xml x(tText);
	x.EraseRekordIfNameNotMatch(std::string("linearGradient"));
	x.EraseRekordIfDontHaveChild();
	
	if(!x.xmlT.size()){
          std::cout<<"ERROR nr. 3: Nie odnaleziono deklaracji gradientow";
          getch();
          return 0;
    }

	std::cout<<"===================================\n\n";

	std::cout<<"PL: Wykryto nastepujace deklaracje gradientow:\nEN:Following statements of gradients were detected:";

	x.WriteChildsValue(std::string("id"));

	std::cout<<"\n\n===================================\n\n";

	for(int i = 0; i < x.xmlT.size(); i++){
		CreateGGRFile(x,i);
	}
}

int ExportGradient(char* location, std::string loc){
    std::fstream file(location,std::ios_base::in);

	std::string s;
	bool w = false;

	std::vector<std::string> tText;

	if(!file.fail()){
		do{
			std::getline(file,s);
			if(w){
				//std::cout<<s.c_str()<<std::endl;
				ClearText(s);
				tText.push_back(s);
			}else{
				ClearText(s);
				w = !s.compare("<defs");
				if(w)
					tText.push_back(s);
			}
		}while(!file.fail()?s.compare("</defs>"):0);
	}else{
          std::cout<<"ERROR nr. 1: Spowodowany przez czynnik ludzki: zla scieska do pliku svg";
          getch();
          return 0;
    }

	file.close();
	
	if(!tText.size()){
          std::cout<<"ERROR nr. 2: Cos nie tak z plikiem";
          getch();
          return 0;
    }

	c_xml x(tText);
	x.EraseRekordIfNameNotMatch(std::string("linearGradient"));
	x.EraseRekordIfDontHaveChild();
	
	if(!x.xmlT.size()){
          std::cout<<"ERROR nr. 3: Nie odnaleziono deklaracji gradientow";
          getch();
          return 0;
    }

	std::cout<<"===================================\n\n";

	std::cout<<"PL: Wykryto nastepujace deklaracje gradientow:\nEN:Following statements of gradients were detected:";

	x.WriteChildsValue(std::string("id"));

	std::cout<<"\n\n===================================\n\n";

	for(int i = 0; i < x.xmlT.size(); i++){
		CreateGGRFile(x,i,loc);
	}
}

int main(int index,char* data[]){
    
    std::string appLocation = data[0];
    
    std::string::size_type k = appLocation.find_last_of( '\\', std::string::npos);
	if(std::string::npos != k)
		appLocation.erase( appLocation.begin() + k + 1, appLocation.end());
   
    
    for(int i = 1; i < index; i++){
        ExportGradient(data[i], appLocation);
    }

    if(index>1)
        return 0;

	std::cout<<"PL: Program ExportGradientFromSVGToGGR utworzony przez\n Krzysztofa Zajaczkowskiego przeznaczony do automatycznego eksportu\n gradientow zapisanych w pliku svg.\n "<<std::endl<<
		"Program dostepny do uzytku komercyjnego jak i niekomercyjnego,\n bez zadnych ograniczen."<<std::endl<<
		"Licencja: GPL\nKontakt: ProgrammingMalyszKZ@wp.pl"<<std::endl<<std::endl;
		
	std::cout<<"EN: Program ExportGradientFromSVGToGGR made by Krzysztof Zajaczkowski\n designed to automatically export gradient stored in the svg file.\n "<<std::endl<<
		"Program available for commercial use and not commercial\n without any restrictions."<<std::endl<<
		"License: GPL\nContact: ProgrammingMalyszKZ@wp.pl"<<std::endl<<std::endl;
		
	std::cout<<"===================================\n\n";
		
	std::cout<<"PL: Podaj, jesli laska lokalizacje i nazwe pliku svg, z ktorego program wyeksportuje gradienty do plikow zapisanych w folderze programu (nie uzywaj spacji): "<<std::endl<<
               "EN: Enter, if grace location and file name for svg, whose program will export the gradients in to the files stored in the program folder (do not use spaces)";
	char location[256];
	
	std::cin>>location;
	
	ExportGradient(location);

	getch();
	return 0;
}
