#!/usr/bin/env python
# -*- coding: UTF-8 -*-

# import logging
import os
import datetime
import fpformat
from math import floor, ceil
import gimp
from gimpfu import *
from operator import itemgetter, attrgetter
from Logging import *
from helperfunctions import *
import gtk

'''
Something about points and pixels:
A point is a typographic meassure, that means it is a physical meassure of
length, like miles, inches, meters or an astronomical unit. Historically,
the length of a point varied from different locales and cultures, but with
the rise of desktop publishing and internationalisation the following
convention has established:

    In the late 1980s to the 1990s, the traditional point was supplanted by
    the desktop publishing point (also called the PostScript point), which was
    defined as 72 points to the inch
    (1 point = 1⁄72 inches = 25.4⁄72 mm = 0.3527 mm).

A pixel is the smallest unit of digital image data. That is to say a pixel is
without actual physical size. Pixels are used to display an image on screen or
print it, converting the image information in pixels to physical representation.
Screens have their pixel density measured in ppi (pixels per inch), whereas
printed images are measured by dpi (dots per inch) - for both the same amount
of image pixels may result in hugely variable physical sizes, e.g.,
a 100X100 pixel image will be huge displayed on a outdoor advertising screen,
or tiny when printed on paper at 300 dpi.
'''

## global parameter point
point = 0.352778     ## a point has a size of 0,375 mm (25.4/72=0.352778mm)
##     a point pt=0.375 mm not 0.376mm(!) sinc 1973, see wikipedia on typographic
## ==> to do: everything in mm confirm ISO standardisation

#==============================================================================
#===================== which OS are we operating on?? =========================
#==============================================================================
## implement if necessary


#==============================================================================
#=================== save index print as a png file ===========================
#==============================================================================
def save_png(image, drawable, new_filelocation, use_comment):
    compression = 9
    interlace, bkgd = False, False
    gama, offs, phys = False, False, False
    time, svtrans = True, False
    pdb.file_png_save2(image, drawable, new_filelocation, new_filelocation,
                       interlace, compression, bkgd, gama, offs, phys, time,
                       use_comment, svtrans) 

#==============================================================================
#=================== save index print as a jpg file ===========================
#==============================================================================
def save_jpeg(image, name, quality_jpg_save, comment=""):
    jpeg_save_defaults = (0.85, 0.0, 1, 0, "", 1, 0, 0, 0)
    args = list(jpeg_save_defaults)
    args[4] = comment
    args[0] = quality_jpg_save/100
    #Log(str(args))
    pdb.file_jpeg_save(image, image.active_layer, name, name, *args)

#==============================================================================
#=============== Makes an overview of the images and directorys ===============
#==============================================================================
def LogFileName(text, contact_location, contact_name, FirstRun):
    """
    =============== Makes an overview of the images and directorys ============
     input: text:              text to save
            contact_location:  directory to save
            contact_name:      filename of the textfile is the same in the
                                registersection
            FirstRun:          bool, delete old file on first entry
     output: txt file with imagename and dirname where the image is located
    ===========================================================================
    """
    Filename = (contact_location + '/' + contact_name + '.txt')
    if (FirstRun == True):
        if (os.path.isfile(Filename) == True):
            os.remove(Filename)

    f=file(Filename, "a+")
    f.write(text + "\n")
    f.close()
    return

#==============================================================================
#================= get images from eventually all dirs ========================
#==============================================================================
def get_images(FileType, original_location, include_subdirs,\
               DirFileList, select_on_part_of_filename,\
               images_sort_alphanumeric, exif_sort, exif_sort_datetime,\
               exif_sort_someexif):
    '''
    ================== get images from eventually all dirs =====================
    input: FileType:          array contains one or more extensions
           original_location: directory to start
           include_subdirs:   bool to include subdirectory's too
           DirFileList:       bool to give a txt list of images with their dir
           select_on_part_of_filename:  text string to make file selections
           images_sort_alphanumeric: sort on filename
           exif_sort:           bool: exif sorting enabled
           exif_sort_datetime:  bool: sort on exif date and time
           exif_sort_someexif:  bool: not implemented
    output: images:           (sorted) array with images
    ============================================================================

    wijzigen --> Onder Linux en Mac dienen de hoofdletters te blijven bestaan !!
    '''
    images = []
    if (include_subdirs == True):                   #include all subdirectory's
        for dirpath, dirnames, filenames in os.walk(original_location.decode(),\
                                                    topdown=True):
            #for dirpath,\
            #dirnames,\
            #filenames in os.walk(original_location.decode('idna'), topdown=True):
            # Log(dirpath)
            for filename in filenames:
                if select_on_part_of_filename.lower() in filename.lower():
                    basename, ext = os.path.splitext(filename)
                    if ((len(ext)>2) and (ext.lower() in FileType)):
                        #15/11: case insensitive now
                        imagefile = os.path.join(dirpath, filename)
                        exif_row1, exif_row2,\
                                   DT,\
                                   iso,\
                                   FN,\
                                   speed,\
                                   FL = get_exif_info(imagefile)
                        original_image = {'extension_low':ext.lower(),\
                                          'base_name_low':basename.lower(),\
                                          'image_file_low':imagefile.lower(),\
                                          'extension':ext,\
                                          'base_name':basename,\
                                          'image_file':imagefile,\
                                          'dirpath':dirpath,\
                                          'DT':DT,\
                                          'iso':iso,\
                                          'FN':FN,\
                                          'speed':speed,\
                                          'FL':FL}
                        if os.path.isfile(imagefile):
                            images.append(original_image)
                            #Log(str(original_image))
                else:
                    continue
    else:                                           #only the choosen directory
        for filename in os.listdir(original_location.decode()):
            #for filename in os.listdir(original_location.decode('idna')):
            #Log(original_location)
            if select_on_part_of_filename.lower() in filename.lower():
                basename, ext = os.path.splitext(filename)
                if ((len(ext)>2) and (ext.lower() in FileType)):
                    imagefile = os.path.join(original_location, filename)
                    exif_row1, exif_row2,\
                                   DT,\
                                   iso,\
                                   FN,\
                                   speed,\
                                   FL = get_exif_info(imagefile)
                    original_image = {'extension_low':ext.lower(),\
                                      'base_name_low':basename.lower(),\
                                      'image_file_low':imagefile.lower(),\
                                      'extension':ext,\
                                      'base_name':basename,\
                                      'image_file':imagefile,\
                                      'dirpath':'',\
                                      'DT':DT,\
                                      'iso':iso,\
                                      'FN':FN,\
                                      'speed':speed,\
                                      'FL':FL}
                    if os.path.isfile(imagefile):
                        images.append(original_image)
                        #Log(str(original_image))
            else:
                continue

    #DT, iso, FN, speed, FL
    # sorted(images, key=itemgetter('image_file'))

    #Log('original images')
    #Log(str(images))
    sortcriteria = ''
    Sort = False

    if (exif_sort_someexif == True) and (exif_sort == True):
        #Log('sorting on iso')
        #sortcriteria = sortcriteria + 'iso' + ','
        imagessort = sort_images(images, 'iso')
        images = imagessort
        Sort = True

    if (exif_sort_datetime == True) and (exif_sort == True):
        #Log('sorting on date and time')
        #sortcriteria = sortcriteria + 'DT' +','
        imagessort = sort_images(images, 'DT')
        images = imagessort
        Sort = True

    if images_sort_alphanumeric == True:
        #Log('sorting on filename')
        imagessort = sort_images(images, 'image_file_low')
        images = imagessort
        Sort = True

##    if (exif_sort_someexif == True) and (exif_sort == True):
##        Log('sorting on FN')
##        sortcriteria = sortcriteria + "'FN',"
##
##    if (exif_sort_someexif == True) and (exif_sort == True):
##        Log('sorting on speed')
##        sortcriteria = sortcriteria + "'speed',"
##
##    if (exif_sort_someexif == True) and (exif_sort == True):
##        Log('sorting on FL')
##        sortcriteria = sortcriteria + "'FL',"


    #if not sorted
    #images are sorted as listed in a directory, can be different from
    #windows or Linux systems
##    if Sort:
##        sortcriteria = sortcriteria[0: len(sortcriteria)-1]
##        imagessorted = sort_images(images, sortcriteria)
##    else:
    imagessorted = images

    #Log('\n' + 'perhaps sorted images')
    #Log(str(imagessorted))

    return imagessorted
   


#sorted(images, key=itemgetter('image_file',<item2>,.....)) sorteren op
#    meerdere items

# indien sorteren aan dan geen dir indeling/scheiding
# niet gesorteerd dan dir scheiding/indeling per dir
# dir met rare tekens wordt niet herkend als dit de eerste is, wel als het dieper
#   in de boom zit


# decode('idna') is working on windows
# on linux decode('mbcs') is unknown on windows it is a known :-( searching
# for an other solution
## for dirpath, dirnames, filenames in os.walk(original_location.decode('mbcs'),
#                                                           topdown=True):
## for filename in os.listdir(original_location.decode('mbcs')):

## for filename in os.listdir(original_location.decode('unicode_escape')):
## for filename in os.listdir(original_location.decode('mbcs')): #win only


#==============================================================================
#=================== sort images on several indexes ===========================
#==============================================================================
def sort_images(images, sortcriteria):
    '''
    ================ sort images on several given indexes =====================
    input: images:          array with images
           sortcriteria:    dictonary
    output: images:         array with sorted images
    ===========================================================================
    sorting on some exif like date-time; on filename + extension;
    DT, iso, FN, speed, FL
    '''
    #sortcriteria='image_file'
    #Log('sortcriteria: ' + sortcriteria + str(len(sortcriteria)))
    imagesiso = sorted(images, key=itemgetter(sortcriteria))
    #Log(str(imagesiso))
    return imagesiso

#==============================================================================
#================= create a text list with file and dirnames ==================
#==============================================================================
def Make_DirFile_List(images, save_to_location, filename):
    '''
    input: images:             array contains the images etc.
           save_to_location:   directory to save
           filename:           name of the txt file
    output: txt file with imagename and dirname were the image is located
    '''
    files = images[0:len(images)]
    FirstRun = True
    for file in files:
        if FirstRun == True:
            directory_path = file['dirpath']
            text = file['dirpath']
            # Log(text)
            LogFileName(text, save_to_location, filename, FirstRun)
            FirstRun = False
            
        if directory_path == file['dirpath']:
            pass
        else:
            text = '' #linespace
            LogFileName(text, save_to_location, filename, FirstRun)
            text = file['dirpath']
            LogFileName(text, save_to_location, filename, FirstRun)
            directory_path = text #save dirpath
            
        text = file['base_name'] + file['extension']
        LogFileName(text, save_to_location, filename, FirstRun)


#==============================================================================
#======================== calculate papersize in mm ===========================
#==============================================================================
def CalcPaperSize(ContactSize, orient, paper_height, paper_width):
    '''
    input: Contactsize     papersize text (given in mm)
           orient          text of paperorientation
           paper_height    height of paper in mm in case custom, float
           paper_width     width of paper in mm in case custom, float
    output:width           width in mm of the papersize, float
           height          height in mm of the papersize, float
    '''
    if (ContactSize == "Jumbo"):          #Jumbo
        width,height = (102,152)
    elif (ContactSize == "6x8"):          #6x8
        width,height = (152,203)
    elif (ContactSize == "8x10"):         #8x10
        width,height = (203,254)
    elif (ContactSize == "A5"):           #A5
        width,height = (148,210)    
    elif (ContactSize == "A4"):           #A4
        width,height = (210,297)
    elif (ContactSize == "A3"):           #A3
        width,height = (297,420)
    elif (ContactSize == "A2"):           #A2
        width,height = (420,594)
    elif (ContactSize == "A1"):           #A1
        width,height = (594,841)
    elif (ContactSize == "A0"):           #A0
        width,height = (841,1189)        
    elif (ContactSize == "Letter"):       #Letter
        width,height = (216,279)
    elif (ContactSize == "Legal"):        #Legal
        width,height = (216,356)
    elif (ContactSize == "Tabloid"):      #Tabloid
        width,height = (279,432)
    elif (ContactSize == "banner1"):      #banner A4 width
        width,height = (210,1000)
    elif (ContactSize == "banner2"):      #banner A3 width
        width,height = (297,1000)
    elif (ContactSize == "custom"):       #free sizes
        width,height = (paper_width, paper_height)
    else:
        width,height = (210,297)          #use default if in error
        Log("error in pagesize, pagesize doesnot exist: " + ContactSize)

    if (orient == "land"):
        Height = width
        Width = height
    else:
        Width = width
        Height = height

    return Width, Height                    #size in mm (float)


#==============================================================================
#===================== calculate thumb fixed size in mm =======================
#==============================================================================
def CalcThumbFixedSize(image_aspectratio, caption_height,\
                       Canvas_width, Canvas_height,\
                       thumbspacinghorizontal, thumbspacingvertical):
    '''
    input:     image_aspectratio
               caption_height
               Canvas_width            Canvas width in mm
               Canvas_height           Canvas height in mm
               thumbspacinghorizontal  Horizontal Thumb spacing in mm
               thumbspacingvertical    Vertical Thumb spacing in mm
    output:    thumbwidth
               thumbheight
               maxnumberofcolumns
               maxnumberofrows
    ===========================================================================
    The case the image aspect ratio is fixed. Width and height are well
    defined. Calculate how many rows/columns are possible but not more
    then given. Of course papersize should be big enough :)
    Other option is the vertical/horizontal space rubberbanded or not and
    alignment of the thumbplace
    Everything in mm except the fixed sizes are in cm
    '''

    if image_aspectratio == '7x10':     ## sizes not correct ??
        thumbwidth = 100
        thumbheight = 100
    elif image_aspectratio == '9x13':
        thumbwidth = 130
        thumbheight = 130
    elif image_aspectratio == '10x15':
        thumbwidth = 152
        thumbheight = 152
    elif image_aspectratio == '13x18':
        thumbwidth = 180
        thumbheight = 180
    elif image_aspectratio == '18x24':
        thumbwidth = 240
        thumbheight = 240
    else:
        Log('error in CalcThumbFixedSize: predefined thumbsizes')
        
    thumbcaptionheight = caption_height + thumbheight
    if (Canvas_width < thumbwidth) or (Canvas_height < thumbcaptionheight):
        Log('thumb doesnot fit on the canvas, increase your paper size')
    else:
        maxcolumns = floor(Canvas_width/thumbwidth)
        maxrows = floor(Canvas_height/thumbcaptionheight)
        ## we didnot know the number of max columns/rows and therefore
        ## the total extra vertical/horizontal space was unknown.
        ## Now we can test with these spaces and correct
        if (thumbwidth * maxcolumns +\
            thumbspacinghorizontal * (maxcolumns-1)) > Canvas_width:
            maxnumberofcolumns = maxcolumns - 1
        else:
            maxnumberofcolumns = maxcolumns

        if (thumbcaptionheight * maxrows +\
            thumbspacingvertical * (maxrows-1)) > Canvas_height:
            maxnumberofrows = maxrows - 1
        else:
            maxnumberofrows = maxrows


        ## to do: recalculate the new spacing horizontal/vertical if necessary
        ## to do: test on fixednumbercolumns

    return thumbwidth, thumbheight, maxnumberofcolumns, maxnumberofrows


#==============================================================================
#===================== calculate thumbsize in mm ==============================
#==============================================================================
def CalcThumbSize(thumbareawidth, thumbareaheight, NumOfRows, NumOfCols,\
                  image_aspectratio, thumbspacinghorizontal,\
                  thumbspacingvertical, captiontopmargin, captionbottommargin,\
                  captionspace, caption_fontsize, include_imagename,\
                  include_exif, include_exif_datetime, include_exif_ISO,\
                  fixednumbercolumnsrows, fixedcolumn, autospacing):
    '''
    input: thumbareawidth          thumbarea width in mm
           thumbareaheight         thumbarea height in mm
           NumOfRows               int: max number of rows
           NumOfCols               int: max number of columns
           image_aspectratio       text: aspect ratio of the thumb
           thumbspacinghorizontal  float: horizontal distance between thumbs in mm
           thumbspacingvertical    float: vertical distance between thumbs in mm
           captiontopmargin        float: topmargin caption area in mm
           captionbottommargin     float: bottommargin caption area in mm
           captionspace            float: inter caption space
           caption_fontsize        float: fontsize in mm
           include_imagename       bool: include imagename, 1 row
           include_exif            bool: include exif, max. two rows
           include_exif_datetime   bool: include date and time, 1 row
           include_exif_ISO        bool: include ISO speed and diafragm, 1 row
    output:thumbcaptionheight      height of thumb including caption in mm
           thumbheight             height of thumb in mm
           thumbwidth              width of thumb in mm
           thumbspacinghorizontal  horizontal spacing between thumbs in mm
           thumbspacingvertical    vertical spacing between thumbs in mm
           maxnumberofrows         max number of possible rows on a page
           maxnumberofcolumns      max number of possible rows on a page
    ===========================================================================
    Now we can calculate the thumbsize including the caption area. It depends
    on the number of rows and columns; caption size; spacing between thumbs;
    canvas size;
    If combination of number of rows/columns doesn't fit the space between the
    thumbs should be rubberbanded so the number will fit else we keep the
    number of columns but modify the number of rows so it fits on one page
    (max or less rows).
    '''

    maxnumberofrows = 0             #initialise
    maxnumberofcolumns = 0          #initialise
    thumbwidth = 0
    thumbheight = 0
    maxnumberofcolumns = 0
    maxnumberofrows = 0

    ## first we calculate the height of the caption. It depends on the information
    ## like filename and how much exif
    
    caption_height = CalcCaptionHeight(captiontopmargin, captionbottommargin,\
                                       caption_fontsize, captionspace,\
                                       include_imagename, include_exif,\
                                       include_exif_datetime, include_exif_ISO)

    #Log('caption_height in clathumbsize: ' + str(caption_height))

## docase
## case image_aspectratio = fixed
    if image_aspectratio == '7x10' or image_aspectratio == '9x13' or\
       image_aspectratio == '10x15' or image_aspectratio == '13x18' or\
       image_aspectratio == '18x24':       ## predefined thumbsizes
        thumbwidth, thumbheight,\
        maxnumberofcolumns,\
        maxnumberofrows = CalcThumbFixedSize(image_aspectratio, caption_height,\
                                             thumbareawidth, thumbareaheight,\
                                             thumbspacinghorizontal,\
                                             thumbspacingvertical)
        thumbcaptionheight = thumbheight + caption_height

## next case the number of rows and columns are arbitrary, means on each
## index sheet there are only the given number of rows and columns. Other option
## is the vertical/horizontal space rubberbanded (autospacing) or not.
## case number of rows and columns are arbitrary means fixed
    elif fixednumbercolumnsrows:
        #Log('fixednumber of columns and rows')
        thumbwidth = floor(thumbareawidth  -\
                           thumbspacinghorizontal*(NumOfCols-1))/NumOfCols
        thumbcaptionheight = floor(thumbareaheight  -\
                                   thumbspacingvertical*(NumOfRows-1))/NumOfRows
        thumbheight = thumbcaptionheight - caption_height
        if thumbwidth < thumbheight:    ## width overrules height, height too big
            thumbheight = thumbwidth
            thumbcaptionheight = thumbheight + caption_height   #recalculate
        else:
            thumbwidth = thumbheight    ## height overrules width, width too big

        maxnumberofrows = NumOfRows
        maxnumberofcolumns = NumOfCols

## Case the number of rows and columns are floating, means on each
## index sheet there are only the given number of rows and floating columns
## or given numbers of rows and floating columns. The floating numbers are corrected
## to the max number if they are set to high but not altered if they are too low.
## Other option is the vertical/horizontal space rubberbanded or not or the entire
## sheet is centered
    elif (not fixednumbercolumnsrows) and fixedcolumn:
        #Log('fixed number of columns')
        thumbwidth = floor(thumbareawidth\
                           - thumbspacinghorizontal*(NumOfCols-1))/NumOfCols
        thumbheight = thumbwidth
        thumbcaptionheight = thumbheight + caption_height
        maxnumberofrows = floor((thumbareaheight\
                                - thumbspacingvertical*(NumOfRows-1))\
                                /thumbcaptionheight) #forgotten space vertical
        if maxnumberofrows > NumOfRows:
            maxnumberofrows = NumOfRows
        
        maxnumberofcolumns = NumOfCols

    else:                       ## fixed number of rows, floating columns
        #Log('fixed number of rows')
        thumbcaptionheight = floor(thumbareaheight -\
                                   thumbspacingvertical*(NumOfRows-1))/NumOfRows
        thumbheight = thumbcaptionheight - caption_height
        thumbwidth = thumbheight

        maxnumberofcolumns = floor(thumbareawidth/thumbwidth)
        if maxnumberofcolumns > NumOfCols:
            maxnumberofcolumns = NumOfCols
        if maxnumberofcolumns*thumbwidth +\
               (maxnumberofcolumns-1)*thumbspacinghorizontal > thumbareawidth:
            maxnumberofcolumns = maxnumberofcolumns - 1
        
        maxnumberofrows = NumOfRows

## endcase

    if autospacing == True:
        #Log('recalculate thumbspace')
        # horizontal space
        totalspaceover = thumbareawidth - maxnumberofcolumns * thumbwidth
        if maxnumberofcolumns == 1:
            thumbspacinghorizontal = totalspaceover
        else:
            thumbspacinghorizontal =  totalspaceover/(maxnumberofcolumns-1)
        # vertical space
        totalspaceover = thumbareaheight - maxnumberofrows * thumbcaptionheight
        if maxnumberofrows == 1:
            thumbspacingvertical =  totalspaceover
        else:
            thumbspacingvertical =  totalspaceover/(maxnumberofrows-1)
        
    #Log('thumbcaptionheight in CalcThumbSize: ' + str(thumbcaptionheight))
    
    return thumbcaptionheight, thumbheight, thumbwidth, thumbspacinghorizontal,\
           thumbspacingvertical, maxnumberofrows, maxnumberofcolumns


#==============================================================================
#===================== calculate captionheight in mm ==========================
#==============================================================================

def CalcCaptionHeight(captiontopmargin,  captionbottommargin, caption_fontsize,\
                      captionspace, include_imagename,\
                      include_exif, include_exif_datetime, include_exif_ISO):
    '''
    input: captiontopmargin        Caption topmargin in mm
           captionbottommargin     Caption bottommargin in mm
           caption_fontsize        font size in mm
           captionspace            distance between caption lines in mm
           include_imagename       bool: include image name
           include_exif            bool: include exif, max. two rows
           include_exif_datetime   bool: include exif date and time, 1 row
           include_exif_ISO        bool: include exif iso, speed and diafragm
    output:caption_height          height in mm
    ===========================================================================
    fontsize seems to be different from the real fontsize!! use font_extents
    Space reserved for exif is always two rows !!


    exif sectie variable maken nu heeft de caption nog een vaste hoogte
    '''

    if (not include_imagename) and (not include_exif):
        caption_height = 0                          #there is no caption
        #Log('no caption')
    elif include_imagename and (not include_exif):     #only imagename
        #Log('only image name')
        caption_height = caption_fontsize +\
                         captiontopmargin + captionbottommargin
    elif (not include_imagename) and include_exif:     #only exif, two rows
        #Log('only exif, two rows')
        caption_height = 2*caption_fontsize + captionspace +\
                         captiontopmargin + captionbottommargin
    else:                                       #imagename and exif, 3 rows
        #Log('imagename and exif, 3 rows')
        caption_height = 3*caption_fontsize + 2*captionspace +\
                         captiontopmargin + captionbottommargin

    return caption_height


#==============================================================================
#========= resize and eventually rotate and crop photo to allowed size ========
#==============================================================================
def generate_foto(filename, MP_width, MP_height,\
                  image_rotate, aspect_ratio, dpi):
    '''
    deze procedure ingeval indexprint: other then none
    ------------------------------------
    input: filename:          photo to resize
           MP_width:          int, max size of minipage width in pixels
           MP_height:         int, max size of minipage height in pixels
           image_rotate       bool, image rotate yes or no
           aspect_ratio       int, photo has a fixed size or not
           dpi:               for rendering eps/ps
    output: img:              resized photo
            new[0]            int, x-size of the photo in px
            new[1]            int, y-size of the photo in px
    ===========================================================================

    ==> seperate loading ps/eps with dpi resolution due to a problem that
        ps/eps always be rendered with default 100dpi. Use gimp_epsload,
        see reference

    ==> to do: everything in mm ??
    '''

    # Try to read the image. eps/ps will be rendered with at least 200 dpi
    valid_image = True
    try:
        if ('.ps' in filename )or ('.eps' in filename):
            if dpi <= 200:
                dpi = 200   #a render less then 200 is very bad.
            
            pdb.file_ps_load_setargs(MP_width,MP_height,dpi,True,"1",7,1,1)
            #img = pdb.gimp_file_load(filename,filename)
            img = pdb.file_ps_load(filename,filename)
        else:
            #Log('andere file extensie')
            img = pdb.gimp_file_load(filename,filename)
    except RuntimeError:
        Log('Not a valid image: ' + filename)
        valid_image = False
        img=[]
        return img, 0, 0, valid_image

    #Log('aspect_ratio: ' + str(aspect_ratio))

    minimum_scale = False
    maximum_scale = False
    MakeSMP = False
    if (image_rotate == True):      #rotate 90' if the longest side is vertical
        # not square
        if (img.height > img.width):
            pdb.gimp_image_rotate(img, 0)    #rotate 90' to the right
            
        if (aspect_ratio == 6):             #none
            minimum_scale = True
        else:                               #ratio and fixed
            MakeSMP = True                  #nodig ??????
            maximum_scale = True
    else:
        # square
        if (aspect_ratio == 6):             #none
            minimum_scale = True
        else:                               #ratio and fixed
            MakeSMP = True
            maximum_scale = True

    if (MakeSMP == True):
        img_ratio = img.width/float(img.height)
        # img_ratio >=1 landscape else portrait
        AR, fixed_size, ImageSize_x, ImageSize_y = CalcAspect(aspect_ratio)
        if (img_ratio < 1):     # portrait
            AR = 1/AR
        #create subminipage with the desired dimensions;
        #is independend from image properties
        SMP_x,\
        SMP_y,\
        offset_x,\
        offset_y = CalcSubminipage(AR, MP_width, MP_height)
        #now we have created a subminipage within a minipage with the correct
        #aspect ratio and dimensions SMP_x and SMP_y including the subminipage
        #offset
    else:
        SMP_x = MP_width
        SMP_y = MP_height
        offset_x = 0
        offset_y = 0

    crop_y = False
    crop_x = False
    #define new scalefactors now from image
    scale_y = SMP_y/float(img.height)
    scale_x = SMP_x/float(img.width)
    if (minimum_scale == True):
        #lineair scale the image; just fit
        if (scale_x < scale_y):         #landscape; scale min in x
            new_x = int(img.width * scale_x)
            new_y = int(img.height * scale_x)
        else:                           #portrait; scale min in y
            new_y = int(img.height * scale_y)
            new_x = int(img.width * scale_y)
    else:                               # (maximum_scale == True):
        #now we have the image scaled in either the correct width or height
        #of the subminipage. The other side is larger and should therefor
        #be cropped in x or y
        if (scale_x < scale_y):         #scale max in y and crop in x
            new_x = int(img.width * scale_y)
            new_y = SMP_y
            crop_x = True
        else:
            new_y = int(img.height * scale_x)
            new_x = SMP_x
            crop_y = True

    #scale image (or is gimp_image_resize better ??????)
    pdb.gimp_image_scale(img, new_x, new_y)
        
    if (crop_x == True):
        offy = 0
        offx = int((new_x - SMP_x)/float(2))
        new_x = SMP_x
        pdb.gimp_image_crop(img, new_x, new_y, offx , offy)

    if (crop_y == True):
        offx = 0
        offy = int((new_y - SMP_y)/float(2))
        new_y = SMP_y
        pdb.gimp_image_crop(img, new_x, new_y, offx, offy) 
        
    return img, new_x, new_y, valid_image


#==============================================================================
#================== calculate aspectratio, size, etc  =========================
#==============================================================================
def CalcAspect(AspectRatio):
    '''
    input: AspectRatio         int number (from input, choice)
    output:AR                  float, aspect ratio
           ImageSize_x         int, maximum width in mm for fixed_sizes only
           ImageSize_y         int, maximum height in mm for fixed_sizes only
           fixed_size          bool, 
    ===========================================================================
    most common aspect ratio's (bxh = width x height)
      4:3 -> TV
      16:9 -> movie
      3:2 -> SLR digital camera
      5:4
      6:7
      1:1
      none -> maximum size depends on paper, #rows and #columns

    otherwise predefined papersizes (bxh)
     7x10 cm  ->
     9x12 cm  ->
     10x15 cm  ->
     13x18 cm  ->
     18x24 cm  ->
    else??
    '''
    fixed_size = False
    #---  The tallest size should be noted first (=width)!!
    #--- this section contains the non-fixed formats
    if (AspectRatio == 0):                      #1:1 (bxh)
        ImageSize_x,ImageSize_y = (1,1)         #float, desired ratio
    elif (AspectRatio == 1):                    #3:2
        ImageSize_x,ImageSize_y = (3,2)
    elif (AspectRatio == 2):                    #4:3
        ImageSize_x,ImageSize_y = (4,3)
    elif (AspectRatio == 3):                    #5:4
        ImageSize_x,ImageSize_y = (5,4)
    elif (AspectRatio == 4):                    #6:7
        ImageSize_x,ImageSize_y = (6,7)
    elif (AspectRatio == 5):                    #16:9
        ImageSize_x,ImageSize_y = (16,9)
    elif (AspectRatio == 6):                    #none, default to 4:3
        ImageSize_x,ImageSize_y = (4,3)
# --- this section contains the fixed formats in mm (bxh)
    elif (AspectRatio == 7):                    #7x10 cm predefined section
        fixed_size = True
        ImageSize_x,ImageSize_y = (100,70)
    elif (AspectRatio == 8):                    #9x13 cm
        fixed_size = True
        ImageSize_x,ImageSize_y = (127,89)        
    elif (AspectRatio == 9):                    #10x15 cm
        fixed_size = True
        ImageSize_x,ImageSize_y = (152,102)
    elif (AspectRatio == 10):                   #13x18 cm
        fixed_size = True
        ImageSize_x,ImageSize_y = (178,127)        
    elif (AspectRatio == 11):                   #18x24 cm
        fixed_size = True
        ImageSize_x,ImageSize_y = (240,180)
    else:
        fixed_size = False
        ImageSize_x,ImageSize_y = (4,3)         #none is the default
        Log("Error in routine CalcAspect, size doesn't exist.")

    AR =  ImageSize_x/float(ImageSize_y)        #float AR

    return AR, fixed_size, ImageSize_x, ImageSize_y

#==============================================================================
#========== calculate the size of a subminipage within a minipage =============
#==============================================================================
def CalcSubminipage(AR, MiniPage_x, MiniPage_y):
    '''
    input   AR              float, aspect ratio
            MiniPage_x      int, size in pixels
            MiniPage_y      int, size in pixels
    output  SMPx            int, new size in px
            SMPy            int, new size in px
            offset_x        int, x offset subminipage
            offset_y        int, y offset subminipage
    '''
    if (AR >= 1):               #landscape
        SMPx = MiniPage_x
        SMPy = int(MiniPage_x/float(AR))
    else:                       #portrait
        SMPx = int(MiniPage_y*AR)
        SMPy = MiniPage_y

    offset_x = int((MiniPage_x - SMPx)/2)
    offset_y = int((MiniPage_y - SMPy)/2)

    return SMPx, SMPy, offset_x, offset_y


#==============================================================================
#================= modify fontsize so it fits thumbwidth ======================
#==============================================================================
def CalcFontSize(text, Font, Size, max_width):
    '''
    this procedure calculates the text size to fit within the
    width param, the text is reduced until the width is small enough
    
    input   text            text, text to scale
            Font            text, fontname
            Size            int, asked height text size in pixels
            CalcTextHeight  not used
            max_width       int pixels, max. width of the thumb
    output  Size            int, new text height size in pixels
            txtw            int, new width size in pixels
    '''
    txtw,\
    txtH,\
    txte,\
    txtd = pdb.gimp_text_get_extents_fontname(text, Size, PIXELS, Font)
    
    if (txtw <= max_width):
        return Size, txtw
    
    while ((txtw > max_width) and (Size > 0)):
        Size = Size -1
        txtw,\
        txtH,\
        txte,\
        txtd = pdb.gimp_text_get_extents_fontname(text, Size, PIXELS, Font)
        
    return Size, txtw

#==============================================================================
#===================== get exif information for caption =======================
#==============================================================================
def get_exif_info(image):
    '''
    input:  image:      thumb with exif information
    output: exif_row1
            exif_row2   string of choosen exif information, if not available
                        'no exif data' will be returned.
    '''
#    def get_selected_exif_info(image, exif_info)
#       '''
#       exif_info is a string with selected exif information
#       '''
#       if exif is_in_string exif_info add to exif_data string

    NDT     = datetime.datetime(1,1,1,0,0,0)
    Niso    = None
    NFN     = None
    Nspeed  = None
    NFL     = None

    import pyexiv2
    metadata = pyexiv2.ImageMetadata(image)
    try:
        metadata.read()
# ---select on exif data
        #-- read date and time photo is taken
        try:
            tagDT = metadata['Exif.Image.DateTime'].value
            NDT = tagDT
            DT = str(tagDT)
        except:
            DT = '?'
            NDT = datetime(1,1,1,0,0,0)

        #-- read shutterspeed
        try:
            tagExposureTime = metadata['Exif.Photo.ExposureTime']
            nspeed = tagExposureTime.value.numerator
            dspeed = tagExposureTime.value.denominator
            if nspeed > dspeed: #exposuretime > 1 sec
                speed = str(dspeed / float(nspeed))
                Nspeed = nspeed / float(dspeed)
            else:
                nspeed = nspeed /nspeed
                dspeed = dspeed / nspeed
                speed = str(nspeed) + '/' + str(dspeed)
                Nspeed = nspeed + dspeed        #is fout andere formule
        except:
            speed = '?'
            Nspeed = None

        #-- read diafragma
        try:
            tagFNumber = metadata['Exif.Photo.FNumber']
            ndia = tagFNumber.value.numerator
            ddia = tagFNumber.value.denominator
            FN = str(ndia / float(ddia))
            NFN = ndia/float(ddia)
        except:
            FN = '?'
            NFN = None

        #-- read focal length
        try:
            tagFLnumber = metadata['Exif.Photo.FocalLength']
            nFL = tagFLnumber.value.numerator
            dFL = tagFLnumber.value.denominator
            #FL = str(nFL / float(dFL))
            NFL = nFL / float(dFL)
            FL = str(fpformat.fix(NFL,1))
        except:
            FL = '?'
            NFL = None
            
        #-- read ISO setting
        try:
            tagISOSpeedratings = metadata['Exif.Photo.ISOSpeedRatings']
            iso = str(tagISOSpeedratings.value)
            Niso = tagISOSpeedratings.value
        except:
            iso = '?'
            Niso = None

##        try:
##            tagModel  = metadata['Exif.Image.Model'].value
##            Log(tagModel)
##        except:
##            tagModel = 'No Model'
##            Log(tagModel)
##
##        try:
##            tagMake = metadata['Exif.Image.Make'].value
##            Log(tagMake)
##        except:
##            tagMake = 'No Manufacturer'
##            Log(tagMake)
##
##        try:
##            tagFlash = metadata['Exif.Photo.Flash'].value
##            Log(tagFlash)
##        except:
##            tagFlash = 'No Flash'
##            Log(tagFlash)



        exif_row1 = ('DT:' + DT )
        exif_row2 = ('ISO' + iso + '; F' + FN + '; ' + speed + 's' + '; FL' + FL)

    except:
        exif_row1 = 'no exif data'
        exif_row2 = ' '
    
    return exif_row1, exif_row2, NDT, Niso, NFN, Nspeed, NFL

           


#==============================================================================
#======================= place thumbsoutline on sheet =========================
#==============================================================================
def place_outlines(sheetimg, start_x, start_y,\
                   thumbwidth_pixels, thumbheight_pixels,\
                   thumbareawidth_pixels, thumbareaheight_pixels,
                   maxnumberofrows, maxnumberofcolumns,\
                   thumbspacinghorizontal_pixels, thumbspacingvertical_pixels,\
                   thumbcaptionheight_pixels):
    '''
    input:     sheetimg,
               start_x,
               start_y,\
               thumbwidth_pixels
               thumbheight_pixels,\
               thumbareawidth_pixels
               thumbareaheight_pixels,
               maxnumberofrows,
               maxnumberofcolumns,\
               thumbspacinghorizontal_pixels,
               thumbspacingvertical_pixels,\
               thumbcaptionheight_pixels
    output:    image with thumb outlines
    '''
##----- next code is for testing only. Draw a single reactangle with the size
##      of a thumb
    pdb.gimp_context_set_default_colors()       ## reset colors to B/W
    # Log(pdb.gimp_context_get_brush())
    # Log(pdb.gimp_context_get_paint_method())
    ##pdb.gimp_context_set_foreground (BLACK)
    ##pdb.gimp_palette_set_foreground(0,0,0,0) ## depricated
    pdb.gimp_context_set_paint_method ('gimp-pencil')
    pdb.gimp_context_set_brush('Pixel (1x1 square)')
    #pdb.gimp_context_set_brush('G_Sparks')
    #pdb.gimp_context_set_brush('2. Hardness 025')

    ## draw thumbarea
    pdb.gimp_rect_select (sheetimg, start_x, start_y, thumbareawidth_pixels,\
                         thumbareaheight_pixels,0,0,0)
    pdb.gimp_edit_stroke (sheetimg.active_layer)
    pdb.gimp_selection_none (sheetimg)

    #Log('thumbcaptionheight_pixels in outline: ' + str(thumbcaptionheight_pixels))


    ## draw the thumbs outline including everything
    rcount = 0      # row counter
    ccount = 0      # column counter
    for rcount in range(0,int(maxnumberofrows)): ## for x in range(0, 3):
        for ccount in range(0, int(maxnumberofcolumns)):
            # draw thumbplace
            pdb.gimp_rect_select (sheetimg,\
                    start_x + ccount*(thumbwidth_pixels\
                                      + thumbspacinghorizontal_pixels),\
                    start_y + rcount*(thumbspacingvertical_pixels\
                                      + thumbcaptionheight_pixels),\
                    thumbwidth_pixels, thumbheight_pixels,\
                    0,0,0)
            pdb.gimp_edit_stroke (sheetimg.active_layer)
            # draw captionarea
            pdb.gimp_rect_select (sheetimg,\
                    start_x + ccount*(thumbwidth_pixels\
                                      + thumbspacinghorizontal_pixels),\
                    start_y + rcount*(thumbspacingvertical_pixels\
                                      + thumbcaptionheight_pixels),\
                    thumbwidth_pixels, thumbcaptionheight_pixels,\
                    0,0,0)
            pdb.gimp_edit_stroke (sheetimg.active_layer)

        ccount = 0
    return sheetimg


#==============================================================================
#==================== place pagenumber or title on sheet ======================
#==============================================================================
def add_pagenumber(sheetimg, start_x, start_y,\
                   thumbwidth_pixels, thumbheight_pixels,\
                   thumbareawidth_pixels, thumbareaheight_pixels,
                   maxnumberofrows, maxnumberofcolumns,\
                   thumbspacinghorizontal_pixels, thumbspacingvertical_pixels,\
                   thumbcaptionheight_pixels):
    '''
    input:      sheetimg
                start_x
                start_y
                thumbwidth_pixels
                thumbheight_pixels
                thumbareawidth_pixels
                thumbareaheight_pixels
                maxnumberofrows
                maxnumberofcolumns
                thumbspacinghorizontal_pixels
                thumbspacingvertical_pixels
                thumbcaptionheight_pixels
    output:     image with pagenumber or title
    '''
    if d['total_pages'] == True:
        total_pages_text = _("Sheet %03d of %03d")
        
        ## calculate the upper left corner of the text bounding box
        x_text = mid_pixels - pagenumberwidth_pixels/2
        y_text = paperheight_pixels\
                 - (mm2pixels(d['bottommargin'], d['page_resolution'])\
                 + pagenumberbottommargin_pixels + pagenumberfontheight_pixels)

        #--- page number with total pages if checked
        #text_layer = gimp_text_fontname (image,drawable,x,y,text,border,
        #                               antialias,size,size_type,fontname)
        pdb.gimp_palette_set_foreground(d['pagenumber_color'])
        txtfloat = pdb.gimp_text_fontname(sheetimg, sheetimg.active_layer,\
                            x_text, y_text,\
                            total_pages_text % (sheetcount+1,\
                            int(ceil(num_images/float(ThumbsPerSheet)))),\
                            -1, False, FS_pagenumber,\
                            PIXELS, d['pagenumber_font'])
        pdb.gimp_floating_sel_anchor(txtfloat)
    else:
        total_pages_text = _("Sheet %d")
        
        ## calculate the upper left corner of the text bounding box
        x_text = mid_pixels - pagenumberwidth_pixels/2
        y_text = paperheight_pixels\
                        - ( mm2pixels(d['bottommargin'],\
                        d['page_resolution']) + pagenumberbottommargin_pixels\
                        + pagenumberfontheight_pixels)

        pdb.gimp_palette_set_foreground(d['pagenumber_color'])
        txtfloat = pdb.gimp_text_fontname(sheetimg, sheetimg.active_layer,\
                        x_text, y_text,\
                        total_pages_text % (sheetcount+ d['pagenumber']),\
                        -1, False, FS_pagenumber, PIXELS,\
                        d['pagenumber_font'])
        pdb.gimp_floating_sel_anchor(txtfloat)
        
    return sheetimg


#==============================================================================
#============================== add background ================================
#==============================================================================
def add_background(sheetimg, bklayer, page_rb_bg_solidcolor,\
                   page_background_color, page_background_image_opacity,\
                   paperwidth_pixels, paperheight_pixels):
    '''
    input:      sheetimg
                bklayer
                page_rb_bg_solidcolor
                page_background_color
                page_background_image_opacity
                paperwidth_pixels
                paperheight_pixels
    output:     image with background
    '''
    if page_rb_bg_solidcolor:  ## fill background with a solid color
        gimp.set_background(str(page_background_color))
        bklayer.fill(BACKGROUND_FILL)
        bklayer.flush()
    else:                           ## fill background with an image
        bklayer.fill(WHITE_FILL)
        bklayer.flush()
        # Load an image as a new layer
        BGLayer = pdb.gimp_file_load_layer(sheetimg, page_background_image)
        # BGLayer = pdb.gimp_file_load_layer(sheetimg,\
        #                   page_background_image.decode('unicode_escape'))
        pdb.gimp_image_add_layer(sheetimg, BGLayer, -1)
        # scale BGLayer to sheetimg size
        pdb.gimp_layer_scale(BGLayer, paperwidth_pixels,\
                             paperheight_pixels, 0)
        pdb.gimp_layer_set_opacity(BGLayer,\
                                   d['page_background_image_opacity'])
        pdb.gimp_image_flatten(sheetimg)

    return sheetimg


#==============================================================================
#========================= add caption filename ===============================
#==============================================================================
def add_caption(sheetimg, imagename_with_extension, base_name, extension,\
                xpos, ypos, caption_row1_y, caption_row2_y, caption_row3_y,\
                caption_font, FS_caption,\
                thumbwidth_pixels, thumbheight_pixels,\
                image_file, include_imagename,\
                include_exif, include_exif_datetime, include_exif_ISO):
    '''
    input:      sheetimg
                imagename_with_extension
                base_name
                extension
                xpos
                ypos
                caption_row1_y
                caption_row2_y
                caption_row3_y
                caption_font
                FS_caption
                thumbwidth_pixels
                thumbheight_pixels
                image_file
                include_imagename       bool include filename
                include_exif            bool include exif one or more rows
                include_exif_datetime   bool include date and time
                include_exif_ISO        bool include iso, speed and diafragm
    output:     image with caption
    '''
# start_x
# start_y
# caption_row_x
# caption_row1_y

    if include_imagename == True:
        if (imagename_with_extension == True):
            ThumbName = base_name + extension
        else:
            ThumbName = base_name

        # check if thumbname fits thumbwidth, downsize if necessary
        newsize,\
        txtwidth = CalcFontSize(ThumbName, caption_font,\
                                FS_caption, thumbwidth_pixels)
        
        #--calculate text position, round the center of the image
        txt_xpos = xpos + (thumbwidth_pixels - txtwidth)/2
        txt_ypos = ypos + caption_row1_y

        #Log('txt_xpos:' + str(txt_xpos))
        #Log('txt_ypos:' + str(txt_ypos))
        
        #place now at x,y position
        txtfloat = pdb.gimp_text_fontname(sheetimg, sheetimg.active_layer,
                          txt_xpos, txt_ypos, ThumbName, -1,
                          False, newsize, PIXELS, caption_font) 
        pdb.gimp_floating_sel_anchor(txtfloat) #merge with background

## include_exif_shutterspeed
## include_exif_ISO
## include_exif_datetime
## include_exif_focal
## include_exif_lightsource
## include_exif_diafragm

## volgende uitbreiden met iso en datetime
    if include_exif == True:
        exif_row1, exif_row2, DT, iso, FN, speed, FL = get_exif_info(image_file)

        #--- exif row 1 ----
        newsize,\
        txtwidth = CalcFontSize(exif_row1, caption_font,\
                                FS_caption, thumbwidth_pixels)
        
        #calculate text position, round the center of the image
        txt_xpos = xpos + (thumbwidth_pixels - txtwidth)/2
        if include_imagename == True:
            txt_ypos = ypos + caption_row2_y
        else:
            txt_ypos = ypos + caption_row1_y    #no imagename
        
        #place at now x,y position    
        txtfloat = pdb.gimp_text_fontname(sheetimg, sheetimg.active_layer,\
                          txt_xpos, txt_ypos, exif_row1, -1,\
                          False, newsize, PIXELS, caption_font) 
        pdb.gimp_floating_sel_anchor(txtfloat) #merge with background

        #--- exif row 2 ----
        if exif_row2 != ' ':
            #Log('exif_row2 is not empty')
            newsize,\
            txtwidth = CalcFontSize(exif_row2, caption_font,\
                                    FS_caption, thumbwidth_pixels)

            #calculate text position, round the center of the image
            txt_xpos = xpos + (thumbwidth_pixels - txtwidth)/2
            if include_imagename == True:
                txt_ypos = ypos + caption_row3_y
            else:
                txt_ypos = ypos + caption_row2_y    #no imagename
            
            #place now at x,y position    
            txtfloat = pdb.gimp_text_fontname(sheetimg, sheetimg.active_layer,\
                              txt_xpos, txt_ypos, exif_row2, -1,\
                              False, newsize, PIXELS, caption_font)

            pdb.gimp_floating_sel_anchor(txtfloat) #merge with background
        else:
            pass
            #Log('exif_row2 is empty skipping')

    return sheetimg

#==============================================================================
#================= main routine generate index print ==========================
#==============================================================================
#class GenerateIndexprint(ContactsheetApp):
def indexprint(d,f):
    '''
    Contents dict d
    d = {\
    'filetype':                filetype,
    'select_part_of_filename': select_part_of_filename,
    'open_from_location':      open_from_location,
    'include_subdirs':         include_subdirs,
    'save_to_location':        save_to_location,
    'filename'     :           filename,
    'contact_type':            contact_type,
    'paper_size':              paper_size,
    'CS':                      CS,
    'paper_height':            paper_height,           ## height in mm (float)
    'paper_width':             paper_width,            ## width in mm (float)
    'paper_units':             paper_units,
    'orient':                  orient,
    'page_resolution':         page_resolution,        ## dpi (int)
    'page_with_background':    page_with_background,
    'page_rb_bg_solidcolor':   page_rb_bg_solidcolor,
    'page_rb_bg_image':        page_rb_bg_image,
    'page_background_color':   page_background_color,
    'page_background_image':   page_background_image,
    'page_background_image_opacity': page_background_image_opacity,
    'page_with_header':        page_with_header,    ## type:(bool); header yes/no
    'page_header':             page_header,         ## type:(text); header text
    'page_header_font':        page_header_font,
    'page_header_fontsize':    page_header_fontsize,   ## type: (float) in mm
    'page_header_color':       page_header_color,
    'with_pagenumber':         with_pagenumber,        ## type: (bool);
    'pagenumber':              pagenumber,             ## type: (int)
    'total_pages':             total_pages,            ## type: (int)
    'pagenumber_font':         pagenumber_font,
    # print(pagenumber_font) #-->output is: sans 12
    'pagenumber_fontsize':     pagenumber_fontsize     ## type (float) in mm
    'pagenumber_color':        pagenumber_color,
    #print(pagenumber_color) # output is: #000
    'topmargin':               topmargin,              ## type: (float) in mm
    'bottommargin':            bottommargin,           ## type: (float) in mm
    'leftmargin':              leftmargin,             ## type: (float) in mm
    'rightmargin':             rightmargin,            ## type: (float) in mm
    'pagemargin_units':        pagemargin_units,
    'NumOfRows':               NumOfRows,              ## type: (int)
    'NumOfCols':               NumOfCols,              ## type: (int)
    'image_horizontal_space'   image_horizontal_space, ## type: (float) in mm
    'image_vertical_space'     image_vertical_space,   ## type: (float) in mm
    'image_space_units'        image_space_units,
    'image_whiteborder_units': image_whiteborder_units,
    'image_aspectratio':       image_aspectratio,
    'AR':                      AR,
    'image_rotate':            image_rotate,
    'include_imagename':       include_imagename,
    'imagename_with_extension': imagename_with_extension,
    'caption_fontsize':        caption_fontsize,       ## type: (float) in mm
    'caption_font':            caption_font,
    'caption_font_color':      caption_font_color,
    'include_exif':            include_exif,
    'include_exif_ISO':        include_exif_ISO,
    'include_exif_datetime':   include_exif_datetime,
    'include_list_imagenames': include_list_imagenames,
    'direct_printing':         direct_printing,
    'images_sort_alphanumeric': images_sort_alphanumeric,
    'exif_sort':               exif_sort,
    'exif_sort_datetime':      exif_sort_datetime,
    'exif_sort_someexif':      exif_sort_someexif
    'fixednumbercolumnsrows':  fixednumbercolumnsrows,
    'fixedcolumn':             fixedcolumn,
    'autospacing':             autospacing,
    'thumbaligned':            autospacing,
    'autocenter':              autocenter,
    'draw_outline':            draw_outline,
    'captionspace':            captionspace,
    'captiontopmargin':        captiontopmargin,
    'captionbottommargin':     captionbottommargin,
    'titletopmargin':          titletopmargin,
    'titlebottommargin':       titlebottommargin,
    'pagenumbertopmargin':     pagenumbertopmargin,
    'pagenumberbottommargin':  pagenumberbottommargin,
    'quality_jpg_save':        quality_jpg_save
    '''

## optie include exif niet goed. Deze eruit en alleen DT en/of ISO,...etc.
## als include. Nu DT yes dan ISO ook yes ook al staat deze op no.

    f.set_text('Generating indexprints')
    while gtk.events_pending():
        gtk.main_iteration()
    count_len_images = 1
## ------ some hidden options

    thumbspacinghorizontal = d['image_horizontal_space']
    thumbspacingvertical = d['image_vertical_space']
    
    fixednumbercolumnsrows = d['fixednumbercolumnsrows']  # if True, number of
                                    # columns/rows can not be altered by the program
    fixedcolumn = d['fixedcolumn']  # if True columns are fixed, rows are 
                                    # floating else rows are fixed and columns 
                                    # floating overruled by
                                    # fixednumbercolumnsrows if True
    autospacing = d['autospacing']  # if True spacing between thumbs are rubberbanded
                                    # else fixed; overrules thumbspacinghorizontal
                                    # or thumbspacingvertical but space is always
                                    # at least the thumbspacinghorizontal and
                                    # thumbspacingvertical spacing
    thumbaligned = d['thumbaligned']# if True thumb aligned to the bottom;
                                    # thumb always centered horizontal
    autocenter = d['autocenter']    # if True thumbpage will be centered
    draw_outline = d['draw_outline'] # draw outline of canvas and thumbs
    captionspace = d['captionspace'] # space in mm between captiontext rows,
                                     # to be implemented
    titletopmargin = d['titletopmargin']                # in mm
    titlebottommargin = d['titlebottommargin']          # in mm
    pagenumbertopmargin = d['pagenumbertopmargin']      # in mm
    pagenumberbottommargin = d['pagenumberbottommargin']    # in mm
    captiontopmargin = d['captiontopmargin']            # in mm
    captionbottommargin = d['captionbottommargin']      # in mm
    jpegsave = d['quality_jpg_save']                    # quality of jpg save
## ------ end some hidden options

## ------ converting some variables/invariants to pixels
    titletopmargin_pixels = mm2pixels(titletopmargin, d['page_resolution'])
    titlebottommargin_pixels = mm2pixels(titlebottommargin,\
                                         d['page_resolution'])

    pagenumbertopmargin_pixels = mm2pixels(pagenumbertopmargin,\
                                           d['page_resolution'])
    pagenumberbottommargin_pixels = mm2pixels(pagenumberbottommargin,\
                                              d['page_resolution'])

    captiontopmargin_pixels = mm2pixels(captiontopmargin,\
                                        d['page_resolution'])
    captionbottommargin_pixels = mm2pixels(captionbottommargin,\
                                            d['page_resolution'])
##------ end converting some variables/invariants to pixels

##----- collect all registered images in the choosen directory and subdirs
##      eventualy sorted
    images = get_images(d['filetype'], d['open_from_location'],\
                        d['include_subdirs'], d['include_list_imagenames'],\
                        d['select_part_of_filename'],\
                        d['images_sort_alphanumeric'], d['exif_sort'],\
                        d['exif_sort_datetime'], d['exif_sort_someexif'])
    num_images = len(images)                    #calculate number of images


##----- if necessary make a txt overwiew file with image names and image
##      directories
    if (d['include_list_imagenames'] == True):
        Make_DirFile_List(images, d['save_to_location'], d['filename'])


## ----- calculate titleareaheight and titleareawidth in mm
    titleareaheight = 0
    titlefontheight_mm = 0
    titleareahight_pixels = 0
    if d['page_with_header'] == True:
        # calculate x corps fontsize in pixels
        FS_header = mm2pixels(d['page_header_fontsize'], d['page_resolution'])
        titlewidth_pixels,\
        titlefontheight_pixels,\
        txte,txtd = pdb.gimp_text_get_extents_fontname(d['page_header'],\
                                                       FS_header, PIXELS,\
                                                       d['page_header_font'])
        # titlefontheight_pixels = FS_header + ascent + descent
        titlefontheight_mm = pixels2mm(titlefontheight_pixels,\
                                       d['page_resolution'])
        titleareaheight = titletopmargin\
                          + titlefontheight_mm\
                          + titlebottommargin
        titleareahight_pixels = mm2pixels(titleareaheight, d['page_resolution'])
## ----- end calculate titleareaheight and titleareawidth in mm/pixels


## ----- calculate pagenumberareaheight and pagenumberwidth in mm/pixels
    pagenumberareaheight = 0        # initialise
    pagenumberfontheight_mm = 0
    pagenumberareaheight_pixels = 0
    if d['with_pagenumber'] == True:
        # calculate x corps fontsize in pixels
        FS_pagenumber = mm2pixels(d['pagenumber_fontsize'], d['page_resolution'])
        if d['total_pages'] == True:
            total_pages_text = _("Sheet 001 of 001")
        else:
            total_pages_text = _("Sheet 8")
            
        pagenumberwidth_pixels,\
        pagenumberfontheight_pixels,\
        txte,txtd = pdb.gimp_text_get_extents_fontname(total_pages_text,\
                                                       FS_pagenumber, PIXELS,\
                                                       d['pagenumber_font'])
        # pagenumberfontheight_pixels = FS_pagenumber + ascent + descent
        pagenumberfontheight_mm = pixels2mm(pagenumberfontheight_pixels,\
                                            d['page_resolution'])
        pagenumberareaheight = pagenumbertopmargin\
                               + pagenumberfontheight_mm\
                               + pagenumberbottommargin
        pagenumberareaheight_pixels = mm2pixels(pagenumberareaheight,\
                                                d['page_resolution'])
##----- end calculate pagenumberareaheight and pagenumberwidth in mm/pixels


##----- calculate Canvas size and thumbareawidth and height in mm
    paper_width,\
    paper_height = CalcPaperSize(d['paper_size'], d['orient'],\
                                d['paper_height'], d['paper_width'])

    Canvas_width = paper_width - d['leftmargin'] - d['rightmargin']
    Canvas_height = paper_height - d['topmargin'] - d['bottommargin']

    thumbareawidth = Canvas_width
    thumbareaheight = Canvas_height - titleareaheight - pagenumberareaheight
##----- end calculate Canvas size and thumbareawidth and height in mm

##----- calculate thumb and thumbcaption size, maximum number of rows/columns
##      and new thumb spacing if necessary in mm
    thumbcaptionheight,\
    thumbheight, thumbwidth,\
    thumbspacinghorizontal, thumbspacingvertical,\
    maxnumberofrows,\
    maxnumberofcolumns = CalcThumbSize(thumbareawidth, thumbareaheight,\
                                    d['NumOfRows'], d['NumOfCols'],\
                                    d['image_aspectratio'],\
                                    thumbspacinghorizontal, thumbspacingvertical,\
                                    captiontopmargin, captionbottommargin,\
                                    captionspace, d['caption_fontsize'],\
                                    d['include_imagename'], d['include_exif'],\
                                    d['include_exif_datetime'],\
                                    d['include_exif_ISO'],\
                                    fixednumbercolumnsrows, fixedcolumn,\
                                    autospacing)
##----- end calculate thumb and thumbcaption size etc.


##----- Converting some variables, creating an image cannot be in float
##      only in int(pixels)
    paperwidth_pixels = mm2pixels(paper_width, d['page_resolution'])
    paperheight_pixels = mm2pixels(paper_height, d['page_resolution'])

    thumbareawidth_pixels = mm2pixels(thumbareawidth, d['page_resolution'])
    thumbareaheight_pixels = mm2pixels(thumbareaheight, d['page_resolution'])

    Canvas_width_pixels = mm2pixels(Canvas_width, d['page_resolution'])
    Canvas_height_pixels = mm2pixels(Canvas_height, d['page_resolution'])

    thumbheight_pixels = mm2pixels(thumbheight, d['page_resolution'])
    thumbwidth_pixels = mm2pixels(thumbwidth, d['page_resolution'])

    thumbcaptionheight_pixels = mm2pixels(thumbcaptionheight,\
                                          d['page_resolution'])

    #Log('thumbcaptionheight_pixels in main: ' + str(thumbcaptionheight_pixels))
    #Log('thumbheight_pixels in main: ' + str(thumbheight_pixels))
    
    thumbspacinghorizontal_pixels = mm2pixels(thumbspacinghorizontal,\
                                              d['page_resolution'])
    thumbspacingvertical_pixels = mm2pixels(thumbspacingvertical,\
                                            d['page_resolution'])

    mid_pixels = mm2pixels(paper_width/2, d['page_resolution'])
    FS_caption = mm2pixels(d['caption_fontsize'], d['page_resolution'])
    captionspace_pixels =  mm2pixels(captionspace, d['page_resolution'])

##----- Calculate upperleft corner of the thumbarea and captionarea is the
##      startingpoint for the thumbs/caption and offset but starting point
##      for the thumbs can be different it depends on autocenter
    start_x = mm2pixels(d['leftmargin'], d['page_resolution'])
    start_y = mm2pixels(d['topmargin'], d['page_resolution'])\
                    + titleareahight_pixels
    ## correct for autocenter
##    if autocenter:
##        start_x = mm2pixels(d['leftmargin'], d['page_resolution'])
##        start_y = mm2pixels(d['topmargin'], d['page_resolution'])\
##                    + titleareahight_pixels

    # calculating thumbs x and y offset in pixels
    x_offset_pixels = thumbwidth_pixels + thumbspacinghorizontal_pixels
    y_offset_pixels = thumbcaptionheight_pixels + thumbspacingvertical_pixels

    # caption rows relative coordinates
    caption_row_x = start_x

    caption_row1_y = thumbheight_pixels + captiontopmargin_pixels
    caption_row2_y = caption_row1_y + FS_caption + captionspace_pixels
    caption_row3_y = caption_row2_y + FS_caption + captionspace_pixels
##----- end Calculate upperleft corner of the thumbarea and captionarea etc.
    
##    Log('FS_caption:' + str(FS_caption))
##    Log('captionspace_pixels:' + str(captionspace_pixels))
##
##    Log('start_x:' + str(start_x))
##    Log('start_y:' + str(start_y))
##
##    Log('x_offset_pixels:' + str(x_offset_pixels))
##    Log('y_offset_pixels:' + str(y_offset_pixels))
##
##    Log('caption_row1_y:' + str(caption_row1_y))
##    Log('caption_row2_y:' + str(caption_row2_y))
##    Log('caption_row3_y:' + str(caption_row3_y))


    ThumbsPerSheet = int(maxnumberofrows * maxnumberofcolumns)
#------ initialise progressbar
    fraction = 1 / num_images
    #f.set_pulse_step(fraction)
    f.set_fraction(0.33)
    f.update(fraction)
    while gtk.events_pending():
        gtk.main_iteration()

#The step size of the activity indicator is set using the following function
#where fraction is between 0.0 and 1.0.
    # progressbar.set_pulse_step(fraction)

    for sheetcount in range(int(ceil(num_images/float(ThumbsPerSheet)))):
        sheetimg = pdb.gimp_image_new (paperwidth_pixels, paperheight_pixels, RGB)
        bklayer = gimp.Layer(sheetimg, "Background", paperwidth_pixels,\
                             paperheight_pixels, RGB_IMAGE, 100, NORMAL_MODE)
        sheetimg.disable_undo()
        sheetimg.add_layer(bklayer,0)
        sheetimg.resolution = (float(d['page_resolution']),\
                               float(d['page_resolution']))  #set resolution

#------ set background
        if d['page_with_background']:
            if d['page_rb_bg_solidcolor']:  ## fill background with a solid color
                gimp.set_background(str(d['page_background_color']))
                bklayer.fill(BACKGROUND_FILL)
                bklayer.flush()
            else:                           ## fill background with an image
                bklayer.fill(WHITE_FILL)
                bklayer.flush()
                # Load an image as a new layer
                BGLayer = pdb.gimp_file_load_layer(sheetimg,\
                                                   d['page_background_image'])
                # BGLayer = pdb.gimp_file_load_layer(sheetimg,\
                #                   page_background_image.decode('unicode_escape'))
                pdb.gimp_image_add_layer(sheetimg, BGLayer, -1)
                # scale BGLayer to sheetimg size
                pdb.gimp_layer_scale(BGLayer, paperwidth_pixels,\
                                     paperheight_pixels, 0)
                pdb.gimp_layer_set_opacity(BGLayer,\
                                           d['page_background_image_opacity'])
                pdb.gimp_image_flatten(sheetimg)
        else:                       ## no background, make background white
            bklayer.fill(WHITE_FILL)
            bklayer.flush()
#------ end set background        

        sheetdsp = gimp.Display(sheetimg)
        gimp.displays_flush()
  
#------ next put the heading on the sheet if necessary
        if d['page_with_header'] == True:      ## header/title
            ## calculate the upper left corner of the text bounding box
            x_text = mid_pixels - titlewidth_pixels/2
            y_text = mm2pixels(d['topmargin'], d['page_resolution'])\
                     + titletopmargin_pixels

            # place header text centered if checked
            pdb.gimp_palette_set_foreground(d['page_header_color'])
            txtfloat = pdb.gimp_text_fontname(sheetimg, sheetimg.active_layer,\
                                              x_text, y_text, d['page_header'],\
                                              -1, False, FS_header, PIXELS,\
                                              d['page_header_font'])
            pdb.gimp_floating_sel_anchor(txtfloat)
#------ end next put the heading on the sheet if necessary

            
#----- next put the pagenumber on the sheet if necessary
        if d['with_pagenumber'] == True:
            x_text = mid_pixels - pagenumberwidth_pixels/2
            pdb.gimp_palette_set_foreground(d['pagenumber_color'])
            if d['total_pages'] == True:
                total_pages_text = _("Sheet %03d of %03d")
                ## calculate the upper left corner of the text bounding box
                y_text = paperheight_pixels - ( mm2pixels(d['bottommargin'],\
                         d['page_resolution']) + pagenumberbottommargin_pixels\
                            + pagenumberfontheight_pixels)

                #--- page number with total pages if checked
                #text_layer = gimp_text_fontname (image,drawable,x,y,text,border,
                #                               antialias,size,size_type,fontname)
                
                txtfloat = pdb.gimp_text_fontname(sheetimg,\
                                    sheetimg.active_layer,\
                                    x_text, y_text,\
                                    total_pages_text % (sheetcount+1,\
                                    int(ceil(num_images/float(ThumbsPerSheet)))),\
                                    -1, False, FS_pagenumber, PIXELS,\
                                    d['pagenumber_font'])
            else:
                total_pages_text = _("Sheet %d")
                ## calculate the upper left corner of the text bounding box
                y_text = paperheight_pixels\
                            - ( mm2pixels(d['bottommargin'], d['page_resolution'])\
                            + pagenumberbottommargin_pixels\
                            + pagenumberfontheight_pixels)

                txtfloat = pdb.gimp_text_fontname(sheetimg, sheetimg.active_layer,\
                                x_text, y_text,\
                                total_pages_text % (sheetcount+ d['pagenumber']),\
                                -1, False, FS_pagenumber, PIXELS,\
                                d['pagenumber_font'])
                
            pdb.gimp_floating_sel_anchor(txtfloat)
#----- end next put the pagenumber on the sheet


##----- next place the thumbs outline on the sheet, testing only
        if draw_outline == True:
            sheetimg = place_outlines(sheetimg, start_x, start_y,\
                                thumbwidth_pixels, thumbheight_pixels,\
                                thumbareawidth_pixels, thumbareaheight_pixels,
                                maxnumberofrows, maxnumberofcolumns,\
                                thumbspacinghorizontal_pixels,\
                                thumbspacingvertical_pixels,\
                                thumbcaptionheight_pixels)
##----- end place the thumbs outline on the sheet, testing only


#-------This is the real routine placing thumbs and eventually caption
        #-- caption_fontsize, caption_font, caption_font_color,

        files = images[sheetcount*ThumbsPerSheet:(sheetcount+1)*ThumbsPerSheet]

        rcount = 0      # row counter
        ccount = 0      # column counter
        pdb.gimp_palette_set_foreground(d['caption_font_color'])
        for file in files:
            f.set_text('Processing image ' + str(count_len_images) + ' of '\
                       + str(num_images) + ' images')
            count_len_images = count_len_images + 1
            f.pulse()
            while gtk.events_pending():
                gtk.main_iteration()
            # x-size and y-size are the new dimensions of the thumb, it depends
            # on the aspect ratio
            thumbimg,\
            x_size, y_size,\
            valid_image = generate_foto(file['image_file'], thumbwidth_pixels,\
                                        thumbheight_pixels,\
                                        d['image_rotate'], d['AR'],\
                                        d['page_resolution'])
            if valid_image == False:
                continue                            #next image, image not valid

            cpy = pdb.gimp_edit_copy(thumbimg.active_layer)
            # center image within its minipage
            x_offset = 0
            y_offset = 0
            if (x_size >= y_size):
                if thumbaligned:
                    y_offset = int(thumbheight_pixels - y_size)
                else:       # landscape image or square, center vertical
                    y_offset = int((thumbheight_pixels - y_size)/2)
            else:
                # portrait image, center horizontal
                x_offset = int((thumbwidth_pixels - x_size)/2)

            gimp.delete(thumbimg)
            #now paste the new thumb into contact sheet
            newselect = pdb.gimp_edit_paste(sheetimg.active_layer, True)

            #positition in top left corner 
            newselect.translate(-newselect.offsets[0],-newselect.offsets[1])
            #now place in correct position, modified with x- and y-offset
            xpos = start_x + ccount * x_offset_pixels + x_offset
            ypos = start_y + rcount * y_offset_pixels + y_offset
            xpos = int(xpos)
        #05/12/2011 changed to int: on ubuntu type error integer expected got float.
            ypos = int(ypos) 
            newselect.translate(xpos,ypos)
            pdb.gimp_floating_sel_anchor(newselect)

            #--place filename if asked for to extend with exif info, xpos and
            #  ypos are the upperleft corner of the thumb
            xpos = start_x + ccount * x_offset_pixels
            ypos = start_y + rcount * y_offset_pixels
            if (d['include_imagename'] == True) or (d['include_exif'] == True):
                add_caption(sheetimg, d['imagename_with_extension'],\
                            file['base_name'], file['extension'],\
                            xpos, ypos, caption_row1_y, caption_row2_y,\
                            caption_row3_y, d['caption_font'], FS_caption,\
                            thumbwidth_pixels,thumbheight_pixels,
                            file['image_file'], d['include_imagename'],\
                            d['include_exif'], d['include_exif_datetime'],\
                            d['include_exif_ISO'])
 
            ccount = ccount + 1
            if (ccount >= maxnumberofcolumns):
                ccount = 0
                rcount = rcount + 1
            gimp.displays_flush()

#-------end This is the real routine placing thumbs


##----- save index sheet
        contact_filename = d['filename'] + "_%03d" % (sheetcount+1)\
                           + d['contact_type']
        contact_full_filename = os.path.join(d['save_to_location'],\
                                             contact_filename)

        if (d['contact_type'] == ".jpg"):
            save_jpeg(sheetimg,contact_full_filename,d['quality_jpg_save'],"")
        else:
            save_png(sheetimg,pdb.gimp_image_get_active_drawable(sheetimg),
                     contact_full_filename,False)
##----- end save index sheet


##----- print index sheet
        if (d['direct_printing'] == True):
            pdb.file_print_gtk(sheetimg)
##----- end print index sheet


##----- clear display and prepare for the next sheet
        gimp.delete(sheetimg)
        pdb.gimp_display_delete(sheetdsp)



##===================================================================================
##This tool creates a rectangular selection over the specified image. The rectangular
##region can be either added to, subtracted from, or replace the contents of the
##previous selection mask. If the feather option is enabled, the resulting selection
##is blurred before combining. The blur is a gaussian blur with the specified feather
##radius. 
##INPUT ARGUMENTS
##    TYPE	NAME	        DESCRIPTION
##    IMAGE	image	        The image
##    FLOAT	x	        x coordinate of upper-left corner of rectangle
##    FLOAT	y	        y coordinate of upper-left corner of rectangle
##    FLOAT	width	        The width of the rectangle: 0 < width
##    FLOAT	height	        The height of the rectangle: 0 < height
##    INT32	operation	The selection operation: { ADD (0), SUB (1),\
##                                                      REPLACE (2), INTERSECT (3) }
##    INT32	feather	        Feather option for selections
##    FLOAT	feather_radius	Radius for feather operation
        
## gimp_rect_select (image,x,y,width,height,operation,feather,feather_radius)


##===================================================================================
## This procedure strokes the current selection, painting along the selection
## boundary with the active brush and foreground color. The paint is applied
## to the specified drawable regardless of the active selection.
        
## pdb.gimp_edit_stroke (drawable)


##===================================================================================
##Paint in the current brush without sub-pixel sampling. This tool is the standard
##pencil. It draws linearly interpolated lines through the specified stroke
##coordinates. It operates on the specified drawable in the foreground color with
##the active brush. The brush mask is treated as though it contains only black and
##white values. Any value below half is treated as black; any above half, as white.
##        pdb.gimp_pencil((gint32 drawable_ID,\
##                         gint num_strokes,\
##                         const gdouble *strokes);)
## pdb.gimp_pencil(sheetimg.active_layer, 4,(100,100,500,500))


##===================================================================================
## (width,height,ascent,descent) =
##          gimp_text_get_extents_fontname (text,size,size_type,fontname) 
## DESCRIPTION
## This tool returns the width and height of a bounding box for the
## specified text string with the specified font information. Ascent
## and descent for the specified font are returned as well.
