#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import os
import sys
try:
    import pygtk
    pygtk.require("2.0")
except ImportError, e :
    print(_("The pygtk library not found.\nCheck your installation please!\n") + str(e))
    sys.exit(1)

try:
    import gtk
    import gtk.glade
except ImportError, e :
    print(_("The gtk/gtk.glade library not found.\nCheck your installation please!\n") + str(e))
    sys.exit(1)

# *****************************************************************************
# ********************** initialize internationalisation **********************
# *****************************************************************************
APP = "indexprint"  #name of the translation file, in this case indexprint.mo
PO_DIR = os.path.join(os.path.join(os.path.dirname(os.path.abspath(__file__))),'locale')

#***********************************************
## In order to get strings inside glade files translated, I still have to add
## gtk.glade.bindtextdomain and gtk.textdomain, like the following code:

import locale
import gettext

# FOR STRINGS INSIDE SOURCE FILES (.py)
gettext.bindtextdomain(APP, PO_DIR)
locale.setlocale(locale.LC_ALL, '')
gettext.textdomain(APP)
#gettext.install(APP, localedir=None, unicode=1)
gettext.install(APP, PO_DIR, unicode=1)
gettext.bindtextdomain(APP, PO_DIR)

# FOR STRINGS INSIDE XML FILES (.glade)
##import gtk, gtk.glade
gtk.glade.bindtextdomain(APP, PO_DIR)
gtk.glade.textdomain(APP)
#***********************************************

##Funny thing is I even tried the ctypes hint without success first....
##import ctypes
##libintl = ctypes.cdll.LoadLibrary("/usr/lib/preloadable_libintl.so")
##libintl.bindtextdomain(localedomain, localedir)
##
##Well, at least all works....not
#***********************************************


import math
import gobject              #nodig???
import glib
import ConfigParser
from gimpfu import *

import re

from Logging import *
from helperfunctions import *
from IndexprintDevelopment import GenerateIndexprint
# import time             # timer to automatic update progressbar


# Make fully qualified path so pygtk finds glade file.
# Get the glade file from same directory as this file (must be together)
GUI_FILENAME = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'IndexPrint.glade')


point = 0.352778     ## a point has a size of 0,375 mm (25.4/72=0.352778mm)
                    ## look at wikipedia for more information


# *****************************************************************************
# *************************** build the window ********************************
# *****************************************************************************
class ContactsheetApp():   # new-style class

    def __init__(self):
        if not os.path.exists(GUI_FILENAME):
            self.on_error(_("IndexPrint.glade not found.\n") +\
                          _("Check your installation please!\n") + GUI_FILENAME)
            sys.exit(1)
            ##return

        # Note: use self for all variables accessed across class methods,
        # but not passed into a method, eg in a callback.
        # gtk.glade.textdomain(GUI_FILENAME)
        builder = gtk.Builder()
        builder.set_translation_domain(APP)
        builder.add_from_file(GUI_FILENAME)

        # Connect some signals defined in the glade file.
        # See callbacks below, named same as in glade file.
        builder.connect_signals(self)
        
        #Log('werkt de import wel?')
        self.pbar = builder.get_object('progressbar')
        self.pbar.set_text('Initialising indexprints')
        #self.pbar.set_fraction(0.1)
##        fraction=0.1
##        self.pbar.set_pulse_step(fraction)
##        #self.pbar.set_fraction(0.5)
        # self.pbar.pulse()
##        #Log('pbar init: ' + str(self.pbar))
        #self.timeout_handler_id = gtk.timeout_add(100, self.update_progress_bar)
##        #self.pbar.set_text('Generating indexprints')
##        self.percentage = 0.1
##        self.pbar.update(self.percentage)
        
        self.dialog         = builder.get_object("dialog1")
        self.helpMessage    = builder.get_object("messagedialog1")
        self.aboutDialog    = builder.get_object("aboutdialog1")
        self.buttonOK       = builder.get_object("button_ok")
        self.notebook       = builder.get_object("notebook")
        self.extended_options   = builder.get_object("alignment-extended-options")

        # --------------- read&save tab -----------------------
        # images to read section
        self.jpg = builder.get_object("checkbutton_jpg")
        self.png = builder.get_object("checkbutton_png")
        self.tif = builder.get_object("checkbutton_tif")
        self.xcf = builder.get_object("checkbutton_xcf")
        self.pcx = builder.get_object("checkbutton_pcx")
        self.bmp = builder.get_object("checkbutton_bmp")
        self.gif = builder.get_object("checkbutton_gif")
        self.eps = builder.get_object("checkbutton_eps")
        self.raw = builder.get_object("checkbutton_raw")
        self.wdp = builder.get_object("checkbutton_wdp")
        self.svg = builder.get_object("checkbutton_svg")
        self.psd = builder.get_object("checkbutton_psd")
        #self.orf = builder.get_object("checkbutton_orf")
        self.select_part_of_filename =  builder.get_object("entry_select_part_of_filename")
        self.open_from_location     = builder.get_object("filechooserbutton_open_from_location")
        self.include_subdirs        = builder.get_object("checkbutton_include_subdirs")
        
        # images to save section
        self.save_to_location = builder.get_object("filechooserbutton_save_to_location")
        self.filename       = builder.get_object("entry_filename")
        self.extension_jpg  = builder.get_object("radiobutton_jpg")
        self.extension_png  = builder.get_object("radiobutton_png")
        
        # --------------- page options tab ---------------
        self.paper_size     = builder.get_object("combobox_sheet_size")
        self.paper_height   = builder.get_object("spinbutton_height")
        self.paper_width    = builder.get_object("spinbutton_width")
        self.paper_units    = builder.get_object("combobox_units_customsize")
        
        self.page_orientation_portrait = builder.get_object("radiobutton_portrait")
        self.page_orientation_landscape = builder.get_object("radiobutton_landscape")
        self.page_resolution        = builder.get_object("spinbutton_resolution")
        #--background
        self.page_with_background = builder.get_object("checkbutton_with_background")
        self.page_rb_bg_solidcolor = builder.get_object("radiobutton_background_solidcolor")
        self.page_rb_bg_image       = builder.get_object("radiobutton_background_image")
        self.page_background_color = builder.get_object("colorbutton_background_color")
        self.page_background_image = builder.get_object("filechooserbutton_background_image")
        self.page_background_image_opacity = builder.get_object("spinbutton_opacity_background_image")
        #--header
        self.page_with_header   = builder.get_object("checkbutton_include_header") 
        self.page_header        = builder.get_object("entry_page_header") #text
        self.page_header_font   = builder.get_object("fontbutton_header") #font and size
        self.page_header_color  = builder.get_object("colorbutton_header") #color
        # ---pagenumber
        self.with_pagenumber    = builder.get_object("checkbutton_include_pagenumber") #nummer
        self.pagenumber         = builder.get_object("spinbutton_pagenumber") #nummer
        self.pagenumber_font    = builder.get_object("fontbutton_pagenumber") #font and size
        self.pagenumber_color   = builder.get_object("colorbutton_pagenumber") #color
        self.total_pages        = builder.get_object("checkbutton_total_pages") #y/n
        # ---pagemargins
        self.pagemargin_top     = builder.get_object("spinbutton_pagemargin_top")
        self.pagemargin_bottom  = builder.get_object("spinbutton_pagemargin_bottom")
        self.pagemargin_left    = builder.get_object("spinbutton_pagemargin_left")
        self.pagemargin_right   = builder.get_object("spinbutton_pagemargin_right")
        self.pagemargin_units   = builder.get_object("combobox_units_pagemargin")
        self.temppage           = builder.get_object("combobox_units_pagemargin")
        self.pagemargin_old_units = self.temppage.get_active_text()

        # --------------------- image options tab -----------------------------
        self.numofrows          = builder.get_object("spinbutton_number_of_rows")
        self.numofcols          = builder.get_object("spinbutton_number_of_columns")
        self.image_horizontal_space  = builder.get_object("spinbutton_image_horizontal_space")
        self.image_vertical_space  = builder.get_object("spinbutton_image_vertical_space")
        self.image_space_units  = builder.get_object("combobox_image_space_units")
        self.tempimage          = builder.get_object("combobox_image_space_units")
        self.image_space_old_units = self.tempimage.get_active_text()

        self.include_imagename  = builder.get_object("checkbutton_include_imagename")
        self.imagename_with_extension = builder.get_object("checkbutton_with_extension")
        self.image_aspectratio  = builder.get_object("combobox_image_size_or_ratio")
        self.image_rotate       = builder.get_object("checkbutton_rotate_images")

        self.caption_font       = builder.get_object("fontbutton_font_caption")
        self.caption_font_color = builder.get_object("colorbutton_font_caption_color")
        
        # exif information
        self.include_exif           = builder.get_object("checkbutton_include_exif")
        self.include_exif_datetime  = builder.get_object("checkbutton_exif_datetime")
        self.include_exif_ISO       = builder.get_object("checkbutton_exif_ISO")
        self.include_exif_cameramodel = builder.get_object("checkbutton_exif_cameramodel")
        self.include_exif_cameramodel.set_sensitive(False)
        
        # ------------------------ other tab ----------------------------------
        self.include_list_imagenames = builder.get_object("checkbutton_include_list_imagenames")
        self.direct_printing        = builder.get_object("checkbutton_direct_printing")

        self.images_sort_alphanumeric = builder.get_object("checkbutton_sort_on_filename")
        self.exif_sort              = builder.get_object("checkbutton_sorting_exif")
        self.exif_sort_datetime     = builder.get_object("checkbutton_exif_sort_datetime")
        self.exif_sort_someexif     = builder.get_object("checkbutton_exif_sort_someexif")
        self.hide_extended_options  = builder.get_object("checkbutton_hide_extended_options")

        # ------------------- extended options tab ----------------------------
        self.fixednumbercolumnsrows = builder.get_object("checkbutton_fixednumbercolumnsrows")
        self.fixedcolumn        = builder.get_object("checkbutton_fixedcolumn")

        self.autospacing        = builder.get_object("checkbutton_autospacing")
        self.thumbaligned       = builder.get_object("checkbutton_thumbaligned")
        self.autocenter         = builder.get_object("checkbutton_autocenter")
        self.draw_outline       = builder.get_object("checkbutton_draw_outline")

        self.captionspace       = builder.get_object("spinbutton_captionspace")
        self.captiontopmargin   = builder.get_object("spinbutton_captiontopmargin")
        self.captionbottommargin = builder.get_object("spinbutton_captionbottommargin")
        self.units_captionspace = builder.get_object("combobox_units_captionspace")
        self.tempcaption          = builder.get_object("combobox_units_captionspace")
        self.units_captionspace_old = self.tempcaption.get_active_text()

        self.titletopmargin     = builder.get_object("spinbutton_titletopmargin")
        self.titlebottommargin  = builder.get_object("spinbutton_titlebottommargin")
        self.units_titlemargin = builder.get_object("combobox_units_titlemargin")
        self.temptitlemargin   = builder.get_object("combobox_units_titlemargin")
        self.units_titlemargin_old = self.temptitlemargin.get_active_text()

        self.pagenumbertopmargin    = builder.get_object("spinbutton_pagenumbertopmargin")
        self.pagenumberbottommargin = builder.get_object("spinbutton_pagenumberbottommargin")
        self.units_pagenumbermargin = builder.get_object("combobox_units_pagenumbermargin")
        self.temppagenumbermargin   = builder.get_object("combobox_units_pagenumbermargin")
        self.units_pagenumbermargin_old = self.temppagenumbermargin.get_active_text()
            
        self.quality_jpg_save       = builder.get_object("spinbutton_quality_jpg_save")
        
   
        try:
            import pyexiv2
            self.pyexiv2_loaded = True
        except ImportError, e :
            Log(_("PyExiv2 not installed!") + str(e))
            self.on_error(_("PyExiv2 not installed!"), _("Disabling exif functions.\n"+str(e)))
            self.pyexiv2_loaded = False

        # ---- if pyexiv2 not installed disable exif options ------------
        if self.pyexiv2_loaded == False:
            self.include_exif.set_sensitive(False)
            self.include_exif_datetime.set_sensitive(False)
            self.include_exif_ISO.set_sensitive(False)
            self.exif_sort.set_sensitive(False)
            self.exif_sort_datetime.set_sensitive(False)
            self.exif_sort_someexif.set_sensitive(False)
        else:
            self.include_exif.set_sensitive(True)
            self.include_exif_datetime.set_sensitive(True)
            self.include_exif_ISO.set_sensitive(True)
            self.exif_sort.set_sensitive(True)
            self.exif_sort_datetime.set_sensitive(True)
            self.exif_sort_someexif.set_sensitive(True)

        # -- to do: also when ghostscript is not installed
##        try:
##            import ghostscript
##            self.ghostscript_loaded = True
##        except ImportError, e :
##            Log(_("Ghostscript not installed!"))
##            self.on_error(_("Ghostscript not installed!"), _("Disabling ps/eps functions.\n"+str(e)))
##            self.ghostscript_loaded = False
##
##        # ---- if pyexiv2 not installed disable exif options ------------
##        if self.ghostscript_loaded == False:
##            self.eps.set_sensitive(False)
##         else:
##            self.eps.set_sensitive(True)


        self.initcycle = True


        # -------------- Load config file if exist ---------------------
        #self.config_dir = gimp.directory
        self.config_file = os.path.join(os.path.dirname(os.path.abspath(__file__)),
                                        "config/indexprint.cfg")
        self.load_config('DEFAULT')
        self.dialog.show()

        #gtk.timeout_remove(self.timeout_handler_id)

# *****************************************************************************
    def main(self):
        gtk.main()  # event loop


    def update_progress_bar(self):
        #pass
        self.pbar.pulse()
        while gtk.events_pending():
            gtk.main_iteration()
        return gtk.TRUE


# *****************************************************************************
# ****************************** Callback's ***********************************
# *****************************************************************************
    '''
    ************** Callback functions, signals emitted by Glade *********
    ** Callbacks are as far as possible grouped per notebook tab
    '''
# --------------- on the read&save tab -----------------------

    def on_checkbutton_jpg_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())
        
    def on_checkbutton_png_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())
        
    def on_checkbutton_tif_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())
        
    def on_checkbutton_pcx_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())
        
    def on_checkbutton_xcf_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())
        
    def on_checkbutton_bmp_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())
        
    def on_checkbutton_wdp_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())
        
    def on_checkbutton_svg_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs,\
                                        self.select_part_of_filename.get_text())
        
    def on_checkbutton_psd_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())
        
    def on_checkbutton_eps_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())
        
    def on_checkbutton_raw_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())
        
    def on_checkbutton_gif_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())

    def on_entry_select_part_of_filename_activate(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())

    def on_filechooserbutton_open_from_location_file_set(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())

    def on_checkbutton_include_subdirs_toggled(self, widget):
        filetype = ""
        filetype = self.makefiletype(filetype)
        number_of_images = self.count_images(filetype,\
                                        self.open_from_location.get_filename(),\
                                        self.include_subdirs.get_active(),\
                                        self.select_part_of_filename.get_text())



# --------------- on the page options tab --------------------
# *****************************************************************************
    def on_combobox_sheet_size_changed(self, widget):
        '''
        gray out custom size and units when custom not selected
        not working correct, should grey out directly if not custom
        '''

        if self.paper_size.get_active_text() == "custom":
            self.paper_height.set_sensitive(True)
            self.paper_width.set_sensitive(True)
            self.paper_units.set_sensitive(True)
            self.page_orientation_portrait.set_sensitive(False)
            self.page_orientation_landscape.set_sensitive(False)
        else:
            self.paper_height.set_sensitive(False)
            self.paper_width.set_sensitive(False)
            self.paper_units.set_sensitive(False)
            self.page_orientation_portrait.set_sensitive(True)
            self.page_orientation_landscape.set_sensitive(True)


# *****************************************************************************
    def on_combobox_units_customsize_changed(self, widget):
        '''
        change dynamicly adjustment of height and width.
        mm: min 100 max 1000 step 0,1
        inch: min 4 max 25 step 0,01
        '''
        
        # save value
        height = self.paper_height.get_value()
        width  = self.paper_width.get_value()
        if self.paper_units.get_active_text() == "mm":      # mm
            # set range
            self.paper_height.set_range(100,1000)
            self.paper_width.set_range(100,1000)
            # restore converted value from inches to mm
            self.paper_height.set_value(inch2mm(height))
            self.paper_width.set_value(inch2mm(width))
        else:                                               # inch
            # set range
            self.paper_height.set_range(4,25)
            self.paper_width.set_range(4,25)
            # restore converted value from mm to inches
            self.paper_height.set_value(mm2inch(height))
            self.paper_width.set_value(mm2inch(width))

# *****************************************************************************
    def on_checkbutton_with_background_toggled(self, widget):
        '''
        gray out frame background when 'background' not selected
        '''
        if self.page_with_background.get_active() == True:
            if self.page_rb_bg_solidcolor.get_active() == True:
                self.page_background_color.set_sensitive(True)
                self.page_background_image.set_sensitive(False)
                self.page_background_image_opacity.set_sensitive(False)
            else:
                self.page_background_color.set_sensitive(False)
                self.page_background_image.set_sensitive(True)
                self.page_background_image_opacity.set_sensitive(True)
            self.page_rb_bg_solidcolor.set_sensitive(True)
            self.page_rb_bg_image.set_sensitive(True)
        else:
            self.page_rb_bg_solidcolor.set_sensitive(False)
            self.page_rb_bg_image.set_sensitive(False)
            self.page_background_image.set_sensitive(False)
            self.page_background_image_opacity.set_sensitive(False)
            self.page_background_color.set_sensitive(False)

# *****************************************************************************
    def on_radiobutton_background_solidcolor_toggled(self,widget):
        if self.page_rb_bg_solidcolor.get_active() == True:
            self.page_background_image.set_sensitive(False)
            self.page_background_image_opacity.set_sensitive(False)
            self.page_background_color.set_sensitive(True)
        else:
            self.page_background_image.set_sensitive(True)
            self.page_background_image_opacity.set_sensitive(True)
            self.page_background_color.set_sensitive(False)

# *****************************************************************************
    def on_checkbutton_include_header_toggled(self, widget):
        '''
        gray out frame header when 'header' not selected
        '''
        #self.percentage = self.percentage +0.1
        if self.page_with_header.get_active() == True:
            self.page_header.set_sensitive(True)
            self.page_header_font.set_sensitive(True)
            self.page_header_color.set_sensitive(True)
        else:
            self.page_header.set_sensitive(False)
            self.page_header_font.set_sensitive(False)
            self.page_header_color.set_sensitive(False)

        #self.pbar.set_text('include_header_toggled')
        #self.pbar.update(self.percentage)

# *****************************************************************************
    def on_checkbutton_include_pagenumber_toggled(self, widget):
        '''
        gray out frame pagenumber when 'pagenumber' not selected
        '''
        if self.with_pagenumber.get_active() == True:
            self.pagenumber.set_sensitive(True)
            self.pagenumber_font.set_sensitive(True)
            self.pagenumber_color.set_sensitive(True)
            self.total_pages.set_sensitive(True)
            
        else:
            self.pagenumber.set_sensitive(False)
            self.pagenumber_font.set_sensitive(False)
            self.pagenumber_color.set_sensitive(False)
            self.total_pages.set_sensitive(False)

        #self.pbar.set_text('include_pagenumber_toggled')
        
# *****************************************************************************
    def on_combobox_units_pagemargin_changed(self, widget):
        '''
        change dynamicly adjustment of pagemargins.
        mm: min 0 max 50 step 0,1
        inch: min 0 max 2 step 0,01
        pt: min 0 max 150 step 1
        %: min 0 max 10 step 0,1     (% of the width of the papersize)
        '''
        # Save values for converting
        top     = self.pagemargin_top.get_value()
        bottom  = self.pagemargin_bottom.get_value()
        left    = self.pagemargin_left.get_value()
        right   = self.pagemargin_right.get_value()
        new_units = self.pagemargin_units.get_active_text()
        old_units = self.pagemargin_old_units

        # ---- define ranges ------
        if self.pagemargin_units.get_active_text() == "mm":
            range_min = 0
            range_max = 50
            digits = 1
            step = 0.1
            pagestep = 10
        elif self.pagemargin_units.get_active_text() == "inch":
            range_min = 0
            range_max = 2
            digits = 2
            step = 0.01
            pagestep = 0.05
        elif self.pagemargin_units.get_active_text() == "pt":
            range_min = 0
            range_max = 150
            digits = 0
            step = 1
            pagestep = 50
        else:
            range_min = 0               # % 
            range_max = 10
            digits = 1
            step = 0.1
            pagestep = 1

        # ----- apply ranges ------
        self.pagemargin_top.set_range(range_min, range_max)
        self.pagemargin_top.set_digits(digits)
        self.pagemargin_top.set_increments(step,pagestep)

        self.pagemargin_bottom.set_range(range_min, range_max)
        self.pagemargin_bottom.set_digits(digits)
        self.pagemargin_bottom.set_increments(step,pagestep)

        self.pagemargin_left.set_range(range_min, range_max)
        self.pagemargin_left.set_digits(digits)
        self.pagemargin_left.set_increments(step,pagestep)

        self.pagemargin_right.set_range(range_min, range_max)
        self.pagemargin_right.set_digits(digits)
        self.pagemargin_right.set_increments(step,pagestep)

        # restore converted value
        if self.pagemargin_units.get_active_text() == old_units:
            # do nothing
            pass
        elif ((old_units == "mm") and (new_units == "inch")):
            self.pagemargin_top.set_value(mm2inch(top))
            self.pagemargin_bottom.set_value(mm2inch(bottom))
            self.pagemargin_left.set_value(mm2inch(left))
            self.pagemargin_right.set_value(mm2inch(right))
            
        elif ((old_units == "mm") and (new_units == "pt")):
            self.pagemargin_top.set_value(mm2pt(top))
            self.pagemargin_bottom.set_value(mm2pt(bottom))
            self.pagemargin_left.set_value(mm2pt(left))
            self.pagemargin_right.set_value(mm2pt(right))
            
        elif ((old_units == "mm") and (new_units == "%")):
            self.pagemargin_top.set_value(self.unit2procent(top,old_units,True))
            self.pagemargin_bottom.set_value(self.unit2procent(bottom,old_units,True))
            self.pagemargin_left.set_value(self.unit2procent(left,old_units,False))
            self.pagemargin_right.set_value(self.unit2procent(right,old_units,False))

        elif (old_units == "inch" and new_units == "mm"):
            self.pagemargin_top.set_value(inch2mm(top))
            self.pagemargin_bottom.set_value(inch2mm(bottom))
            self.pagemargin_left.set_value(inch2mm(left))
            self.pagemargin_right.set_value(inch2mm(right))

        elif (old_units == "inch" and new_units == "pt"):
            self.pagemargin_top.set_value(inch2pt(top))
            self.pagemargin_bottom.set_value(inch2pt(bottom))
            self.pagemargin_left.set_value(inch2pt(left))
            self.pagemargin_right.set_value(inch2pt(right))
            
        elif (old_units == "inch" and new_units == "%"):
            self.pagemargin_top.set_value(self.unit2procent(top,old_units,True))
            self.pagemargin_bottom.set_value(self.unit2procent(bottom,old_units,True))
            self.pagemargin_left.set_value(self.unit2procent(left,old_units,False))
            self.pagemargin_right.set_value(self.unit2procent(right,old_units,False))

        elif (old_units == "pt" and new_units == "mm"):
            self.pagemargin_top.set_value(pt2mm(top))
            self.pagemargin_bottom.set_value(pt2mm(bottom))
            self.pagemargin_left.set_value(pt2mm(left))
            self.pagemargin_right.set_value(pt2mm(right))

        elif (old_units == "pt" and new_units == "inch"):
            self.pagemargin_top.set_value(pt2inch(top))
            self.pagemargin_bottom.set_value(pt2inch(bottom))
            self.pagemargin_left.set_value(pt2inch(left))
            self.pagemargin_right.set_value(pt2inch(right))

        elif (old_units == "pt" and new_units == "%"):
            self.pagemargin_top.set_value(self.unit2procent(top,old_units,True))
            self.pagemargin_bottom.set_value(self.unit2procent(bottom,old_units,True))
            self.pagemargin_left.set_value(self.unit2procent(right,old_units,False))
            self.pagemargin_right.set_value(self.unit2procent(left,old_units,False))

        elif (old_units == "%"):
            self.pagemargin_top.set_value(self.procent2unit(top,new_units,True))
            self.pagemargin_bottom.set_value(self.procent2unit(bottom,new_units,True))
            self.pagemargin_left.set_value(self.procent2unit(left,new_units,False))
            self.pagemargin_right.set_value(self.procent2unit(right,new_units,False))

        else:
            Log('error in on_combobox_units_pagemargin_changed')

        old_units = new_units
        self.pagemargin_old_units = old_units


# ------------------- on the image options tab -------------------------

# ------------------- on the other tab ---------------------------------

# *****************************************************************************
    def on_checkbutton_include_imagename_toggled(self, widget):
        '''
        gray out extension when 'include imagename' not selected
        '''
        if self.include_imagename.get_active() == True:
            self.imagename_with_extension.set_sensitive(True)
        else:
            self.imagename_with_extension.set_sensitive(False)
            
# *****************************************************************************
    def on_combobox_image_space_units_changed(self, widget):
        '''
        change dynamicly adjustment of space units of vertical/horizontal space
        between thumbs
        mm: min 0 max 25 step 0,1
        inch: min 0 max 1 step 0,01 (1" = 25,4 mm)
        pt: min 0 max 70 step 1 (1pt=0,375mm/0,35277mm: 70pt ~ 25mm)
        %: min 0 max 10 step 0,1
        '''
        # Save values for converting
        hor         = self.image_horizontal_space.get_value()
        ver         = self.image_vertical_space.get_value()
        new_units   = self.image_space_units.get_active_text()
        old_units   = self.image_space_old_units

        # ---- define ranges ------
        if self.image_space_units.get_active_text() == "mm":
            range_min = 0
            range_max = 25
            digits = 1
            step = 0.1
            pagestep = 2.5
        elif self.image_space_units.get_active_text() == "inch":
            range_min = 0
            range_max = 1
            digits = 2
            step = 0.01
            pagestep = 0.1
        elif self.image_space_units.get_active_text() == "pt":
            range_min = 0
            range_max = 70
            digits = 0
            step = 1
            pagestep = 10
        else:
            range_min = 0               # % of the width of the image
            range_max = 10
            digits = 1
            step = 0.1
            pagestep = 1

        # ----- apply ranges ------
        self.image_horizontal_space.set_range(range_min, range_max)
        self.image_horizontal_space.set_digits(digits)
        self.image_horizontal_space.set_increments(step, pagestep)
        self.image_vertical_space.set_range(range_min, range_max)
        self.image_vertical_space.set_digits(digits)
        self.image_vertical_space.set_increments(step, pagestep)

        # restore converted value
        if new_units == old_units:
            # do nothing
            pass
        elif ((old_units == "mm") and (new_units == "inch")):
            self.image_horizontal_space.set_value(mm2inch(hor))
            self.image_vertical_space.set_value(mm2inch(ver))
        elif ((old_units == "mm") and (new_units == "pt")):
            self.image_horizontal_space.set_value(mm2pt(hor))
            self.image_vertical_space.set_value(mm2pt(ver))
        elif ((old_units == "mm") and (new_units == "%")):
            self.image_horizontal_space.set_value(self.unit2procent(hor,old_units,True))
            self.image_vertical_space.set_value(self.unit2procent(ver,old_units,True))
        elif (old_units == "inch") and (new_units == "mm"):
            self.image_horizontal_space.set_value(inch2mm(hor))
            self.image_vertical_space.set_value(inch2mm(ver))
        elif (old_units == "inch") and (new_units == "pt"):
            self.image_horizontal_space.set_value(inch2pt(hor))
            self.image_vertical_space.set_value(inch2pt(ver))
        elif (old_units == "inch") and (new_units == "%"):
            self.image_horizontal_space.set_value(self.unit2procent(hor,old_units,True))
            self.image_vertical_space.set_value(self.unit2procent(ver,old_units,True))
        elif (old_units == "pt") and (new_units == "mm"):
            self.image_horizontal_space.set_value(pt2mm(hor))
            self.image_vertical_space.set_value(pt2mm(ver))
        elif (old_units == "pt") and (new_units == "inch"):
            self.image_horizontal_space.set_value(pt2inch(hor))
            self.image_vertical_space.set_value(pt2inch(ver))
        elif (old_units == "pt") and (new_units == "%"):
            self.image_horizontal_space.set_value(self.unit2procent(hor,old_units,True))
            self.image_vertical_space.set_value(self.unit2procent(ver,old_units,True))
        elif (old_units == "%"):
            self.image_horizontal_space.set_value(self.procent2unit(hor,new_units,True))
            self.image_vertical_space.set_value(self.procent2unit(ver,new_units,True))
        else:
            Log('error in on_combobox_image_space_units_changed')

        old_units = new_units
        self.image_space_old_units = old_units


# *****************************************************************************
    def on_checkbutton_include_exif_toggled(self, widget):
        if self.include_exif.get_active() == True :
            self.include_exif_datetime.set_sensitive(True)
            self.include_exif_ISO.set_sensitive(True)
        else:
            self.include_exif_datetime.set_sensitive(False)
            self.include_exif_ISO.set_sensitive(False)


# *****************************************************************************
    def on_checkbutton_sorting_exif_toggled(self, widget):
        if self.exif_sort.get_active() == True :
            self.exif_sort_datetime.set_sensitive(True)
            self.exif_sort_someexif.set_sensitive(True)
        else:
            self.exif_sort_datetime.set_sensitive(False)
            self.exif_sort_someexif.set_sensitive(False)

# *****************************************************************************
    def on_checkbutton_hide_extended_options_toggled(self, widget):
        if self.hide_extended_options.get_active() == True:
            self.extended_options.hide()
        else:
            self.extended_options.show()


# ------------------- on the extended options tab -----------------------------

# *****************************************************************************
    def on_checkbutton_fixednumbercolumnsrows_toggled(self, widget):
        '''
        gray out fixed column when fixed number of rows/cols is selected
        '''
        if self.fixednumbercolumnsrows.get_active() == False:
            self.fixedcolumn.set_sensitive(True)
        else:
            self.fixedcolumn.set_sensitive(False)


# ************************** Caption space/margin ******************************
    def on_combobox_units_captionspace_changed(self, widget):
        '''
        -->change dynamicly adjustment of captionspacelines.
        mm: min 0 max 5 step 0,01 (initial 1)
        inch: min 0 max 0.2 step 0,01
        pt: min 0 max 14 step 1  (1pt=0,352778mm: 70pt ~ 25mm)
                
        -->change dynamicly adjustment of caption bottom/top margin.
        mm: min 0 max 5 step 0,01 (initial 0,5)
        inch: min 0 max 0.2 step 0,01
        pt: min 0 max 14 step 1

        -->self variables
        self.captionspace
        self.captiontopmargin
        self.captionbottommargin
        self.units_captionspace 
        '''
      
        # Save values for converting
        top         = self.captiontopmargin.get_value()
        bottom      = self.captionbottommargin.get_value()
        linespace   = self.captionspace.get_value()

        new_units = self.units_captionspace.get_active_text()
        old_units = self.units_captionspace_old

        #************************ define ranges *****************************
        if self.units_captionspace.get_active_text() == "mm":
            range_min = 0
            captionspacelines_range_max = 5
            bottom_top_range_max = 5
            digits = 2
            step = 0.01
            pagestep = 0.1
        elif self.units_captionspace.get_active_text() == "inch":
            range_min = 0
            captionspacelines_range_max = 0.2
            bottom_top_range_max = 0.2
            digits = 2
            step = 0.01
            pagestep = 0.05
        elif self.units_captionspace.get_active_text() == "pt":
            range_min = 0
            captionspacelines_range_max = 14
            bottom_top_range_max = 14
            digits = 0
            step = 1
            pagestep = 1

        # ----- apply ranges ------
        self.captiontopmargin.set_range(range_min, bottom_top_range_max)
        self.captiontopmargin.set_digits(digits)
        self.captiontopmargin.set_increments(step,pagestep)

        self.captionbottommargin.set_range(range_min, bottom_top_range_max)
        self.captionbottommargin.set_digits(digits)
        self.captionbottommargin.set_increments(step,pagestep)

        self.captionspace.set_range(range_min, captionspacelines_range_max)
        self.captionspace.set_digits(digits)
        self.captionspace.set_increments(step,pagestep)

        # restore converted value
        if self.units_captionspace.get_active_text() == old_units:
            # do nothing
            pass
        elif ((old_units == "mm") and (new_units == "inch")):
            self.captiontopmargin.set_value(mm2inch(top))
            self.captionbottommargin.set_value(mm2inch(bottom))
            self.captionspace.set_value(mm2inch(linespace))
        elif ((old_units == "mm") and (new_units == "pt")):
            self.captiontopmargin.set_value(mm2pt(top))
            self.captionbottommargin.set_value(mm2pt(bottom))
            self.captionspace.set_value(mm2pt(linespace))
        elif (old_units == "inch" and new_units == "mm"):
            self.captiontopmargin.set_value(inch2mm(top))
            self.captionbottommargin.set_value(inch2mm(bottom))
            self.captionspace.set_value(inch2mm(linespace))
        elif (old_units == "inch" and new_units == "pt"):
            self.captiontopmargin.set_value(inch2pt(top))
            self.captionbottommargin.set_value(inch2pt(bottom))
            self.captionspace.set_value(inch2pt(linespace))
        elif (old_units == "pt" and new_units == "mm"):
            self.captiontopmargin.set_value(pt2mm(top))
            self.captionbottommargin.set_value(pt2mm(bottom))
            self.captionspace.set_value(pt2mm(linespace))
        elif (old_units == "pt" and new_units == "inch"):
            self.captiontopmargin.set_value(pt2inch(top))
            self.captionbottommargin.set_value(pt2inch(bottom))
            self.captionspace.set_value(pt2inch(linespace))
        else:
            Log('error in on_combobox_units_captionspace_changed')

        old_units = new_units
        self.units_captionspace_old = old_units


# ************************ Title top/bottom margin ******************************
    def on_combobox_units_titlemargin_changed(self, widget):
        '''
        change dynamicly adjustment of title top/bottom margin.
        mm: min 0 max 10 step 0,01 (initial top=0; bottom=5)
        inch: min 0 max 0.4 step 0,01
        pt: min 0 max 28 step 1  (1pt=0,352778mm: 70pt ~ 25mm)

        self.titletopmargin
        self.titlebottommargin
        self.units_titlemargin
        self.units_titlemargin_old
        '''
        # Save values for converting
        top         = self.titletopmargin.get_value()
        bottom      = self.titlebottommargin.get_value()

        new_units = self.units_titlemargin.get_active_text()
        old_units = self.units_titlemargin_old

        # ---- define ranges 
        #*********************************************************************!!!!!
        if self.units_titlemargin.get_active_text() == "mm":
            range_min = 0
            range_max = 10
            digits = 2
            step = 0.01
            pagestep = 0.1
        elif self.units_titlemargin.get_active_text() == "inch":
            range_min = 0
            range_max = 0.4
            digits = 2
            step = 0.01
            pagestep = 0.05
        elif self.units_titlemargin.get_active_text() == "pt":
            range_min = 0
            range_max = 28
            digits = 0
            step = 1
            pagestep = 1

        # ----- apply ranges ------
        self.titletopmargin.set_range(range_min, range_max)
        self.titletopmargin.set_digits(digits)
        self.titletopmargin.set_increments(step,pagestep)

        self.titlebottommargin.set_range(range_min, range_max)
        self.titlebottommargin.set_digits(digits)
        self.titlebottommargin.set_increments(step,pagestep)

        # restore converted value
        if self.units_titlemargin.get_active_text() == old_units:
            # do nothing
            pass
        elif ((old_units == "mm") and (new_units == "inch")):
            self.titletopmargin.set_value(mm2inch(top))
            self.titlebottommargin.set_value(mm2inch(bottom))
        elif ((old_units == "mm") and (new_units == "pt")):
            self.titletopmargin.set_value(mm2pt(top))
            self.titlebottommargin.set_value(mm2pt(bottom))
        elif (old_units == "inch" and new_units == "mm"):
            self.titletopmargin.set_value(inch2mm(top))
            self.titlebottommargin.set_value(inch2mm(bottom))
        elif (old_units == "inch" and new_units == "pt"):
            self.titletopmargin.set_value(inch2pt(top))
            self.titlebottommargin.set_value(inch2pt(bottom))
        elif (old_units == "pt" and new_units == "mm"):
            self.titletopmargin.set_value(pt2mm(top))
            self.titlebottommargin.set_value(pt2mm(bottom))
        elif (old_units == "pt" and new_units == "inch"):
            self.titletopmargin.set_value(pt2inch(top))
            self.titlebottommargin.set_value(pt2inch(bottom))
        else:
            Log('error in on_combobox_units_captionspace_changed')

        old_units = new_units
        self.units_titlemargin_old = old_units


# *********************** pagenumber top/bottom margin *************************
    def on_combobox_units_pagenumbermargin_changed(self, widget):
        '''
        change dynamicly adjustment of pagenumber top/bottom margin.
        mm: min 0 max 10 step 0,01 (initial top=5; bottom=0)
        inch: min 0 max .. step 0,01
        pt: min 0 max .. step 1

        self.pagenumbertopmargin
        self.pagenumberbottommargin
        self.units_pagenumbermargin
        self.units_pagenumbermargin_old
        '''
        # Save values for converting
        top         = self.pagenumbertopmargin.get_value()
        bottom      = self.pagenumberbottommargin.get_value()

        new_units = self.units_pagenumbermargin.get_active_text()
        old_units = self.units_pagenumbermargin_old

        # ---- define ranges ------ 
        #*********************************************************************!!!!!
        if self.units_pagenumbermargin.get_active_text() == "mm":
            range_min = 0
            range_max = 10
            digits = 2
            step = 0.01
            pagestep = 0.1
        elif self.units_pagenumbermargin.get_active_text() == "inch":
            range_min = 0
            range_max = 0.4
            digits = 2
            step = 0.01
            pagestep = 0.05
        elif self.units_pagenumbermargin.get_active_text() == "pt":
            range_min = 0
            range_max = 28
            digits = 0
            step = 1
            pagestep = 1

        # ----- apply ranges ------
        self.pagenumbertopmargin.set_range(range_min, range_max)
        self.pagenumbertopmargin.set_digits(digits)
        self.pagenumbertopmargin.set_increments(step,pagestep)

        self.pagenumberbottommargin.set_range(range_min, range_max)
        self.pagenumberbottommargin.set_digits(digits)
        self.pagenumberbottommargin.set_increments(step,pagestep)

        # restore converted value
        if self.units_pagenumbermargin.get_active_text() == old_units:
            # do nothing
            pass
        elif ((old_units == "mm") and (new_units == "inch")):
            self.pagenumbertopmargin.set_value(mm2inch(top))
            self.pagenumberbottommargin.set_value(mm2inch(bottom))
        elif ((old_units == "mm") and (new_units == "pt")):
            self.pagenumbertopmargin.set_value(mm2pt(top))
            self.pagenumberbottommargin.set_value(mm2pt(bottom))
        elif (old_units == "inch" and new_units == "mm"):
            self.pagenumbertopmargin.set_value(inch2mm(top))
            self.pagenumberbottommargin.set_value(inch2mm(bottom))
        elif (old_units == "inch" and new_units == "pt"):
            self.pagenumbertopmargin.set_value(inch2pt(top))
            self.pagenumberbottommargin.set_value(inch2pt(bottom))
        elif (old_units == "pt" and new_units == "mm"):
            self.pagenumbertopmargin.set_value(pt2mm(top))
            self.pagenumberbottommargin.set_value(pt2mm(bottom))
        elif (old_units == "pt" and new_units == "inch"):
            self.pagenumbertopmargin.set_value(pt2inch(top))
            self.pagenumberbottommargin.set_value(pt2inch(bottom))
        else:
            Log('error in on_combobox_units_pagenumbermargin_changed')

        old_units = new_units
        self.units_pagenumbermargin_old = old_units


# ------------------------------- main page -----------------------------------

# *****************************************************************************
    def on_dialog1_destroy( self, widget ):
        gtk.main_quit()   

# *****************************************************************************
    def on_dialog1_response(self, widget, responseID):
        '''
        Callback when user clicks on any button in "internal action_area" of dialog.
        In Glade: Add toplevel DialogBox.  
          Set dialog1>Signals>response to "on_dialog1_response" (one of the choices
          and this callback method should be named the same.)
          Add buttons to internal_action area.
          For each button, set General>Response ID property to correspond, eg. 1.
          No need to set button Signals properties.
        This is a dispatcher.
        '''
        if responseID == 1: # same as responseID property set in Glade on Cancel button
            gtk.main_quit()
        elif responseID == 2: # OK button
            # Crux
##            self.pbar.set_text('Generating indexprints')
##            self.pbar.set_fraction(0.5)
            self.update_progress_bar()
            self.doindexprint()
            gtk.main_quit()
        elif responseID == 3: # Help button
            self.helpMessage.show()
        elif responseID == 4: # About button
            self.aboutDialog.show()
        elif responseID == -4:  # on destroy, not set in Glade but sent by pygtk
            pass
        else :
            Log(_("Unhandled response ID for dialog:") + responseID)
            print _("Unhandled response ID for dialog:"), responseID

# *****************************************************************************
    def on_aboutdialog1_close(self, widget, responseID):
        pass    #added to supress runtimewarnings

# *****************************************************************************
    def on_aboutdialog1_destroy(self, widget, responseID):
        pass    #added to supress runtimewarnings

# *****************************************************************************
    def on_messagedialog1_response(self, widget, responseID):
        if responseID == 1:
            widget.hide()

# *****************************************************************************
    def on_aboutdialog1_response(self, widget, responseID = None):
        widget.hide()


#==============================================================================
#=============================== utilitys =====================================
#==============================================================================

#==============================================================================
# ******************** if error log it to the log file ************************
#==============================================================================
    def on_error(self, s):
        Log(s)
        return

#==============================================================================
# ************* return the integer value of a hexadecimal string s ************
#==============================================================================
    def hex2dec(self, s):
        return int(s, 16)

#==============================================================================
# ***************** extract font name from the FontButton *********************
#==============================================================================
    def extract_font_name (self, inFont):
        delim = " "
        delim_idx = inFont.rfind(delim)
        if delim_idx >= 0 :
            return inFont[0: delim_idx]
        else :
            return ""

#==============================================================================
# ***************** extract font size from the FontButton *********************
#==============================================================================
    def extract_font_size (self, inFont):
        delim = " "
        delim_idx = inFont.rfind(delim)
        if delim_idx >= 0 :
            return inFont[delim_idx + 1: len(inFont)]
        else :
            return ""

#==============================================================================
# ****************** extract color definition (r,g,b) *************************
#==============================================================================
    def extract_color (self, inColor):
        red_hexa = inColor.to_string()[1:3]
        green_hexa = inColor.to_string()[5:7]
        blue_hexa = inColor.to_string()[9:11]
        return (self.hex2dec(red_hexa),
                self.hex2dec(green_hexa),
                self.hex2dec(blue_hexa))


#==============================================================================
#============================ convert unit to %  ==============================
#==============================================================================
    def unit2procent(self, margin, unit, Bheight):
        '''
        margin contains the value of mm, inch or pt size
        unit contains one of these words: mm, inch or pt
        height is a boolean to decide using width or hight papersize
        sizes noted here are in mm
        '''
        width,\
        height = getpapersize_mm(self.paper_size.get_active_text(),\
                                 self.paper_width.get_value(),\
                                 self.paper_height.get_value())

        #--convert unit inch or pt to mm if neccessary
        if unit == "inch":
            width = 25,4 * width
            height = 25,4 * height
        elif unit == "pt":
            width = width/point
            height = height/point
        #else:
            # unit is mm

        #--for top and bottom us height; for left/right use width
        if Bheight == True:
            procent = float(100*margin/height)
        else:
            procent = float(100*margin/width)

        return procent

#==============================================================================
#=========================== convert unit to % ================================
#==============================================================================
    def procent2unit(self, procent, unit, Bheight):
        '''
        procent contains the percentage of the height or width from papersize
        unit contains one of these words: mm, inch or pt
        height is a boolean to decide using width or hight papersize
        sizes noted here are in mm
        '''
        width,\
        height = getpapersize_mm(self.paper_size.get_active_text(),\
                                 self.paper_width.get_value(),\
                                 self.paper_height.get_value())

        #-- calculate the margin in mm
        if Bheight == True:
            margin = float(procent * height/100)
        else:
            margin = float(procent * width/100)
        
        #-- if neccessary convert to inch or pt
        if unit == "inch":
            margin = float(margin/25.4)
        elif unit == "pt":
            margin = float(margin/point)
        #else:
            # unit is mm

        return margin


# ******************************* main caller *********************************
    def doindexprint(self):
        '''
        This procedure converts the input and put it into a dict.
        '''
        self.pbar.set_text('Generating indexprint(s)')
        # --------------- read&save tab ---------------------
        # ---read
        filetype                = ""
        filetype                = self.makefiletype(filetype)   #make string of filetypes
        select_part_of_filename = self.select_part_of_filename.get_text()
        open_from_location      = self.open_from_location.get_filename()
        include_subdirs         = self.include_subdirs.get_active()
        # ---save
        save_to_location        = self.save_to_location.get_filename()
        filename                = self.filename.get_text()
        if self.extension_jpg.get_active() == True:
            contact_type = ".jpg"
        else:
            contact_type = ".png"

        
        # --------------- page options tab ----------------------
        # ---sheetsize
        paper_size      = self.paper_size.get_active_text()
        CS              = self.paper_size.get_active()  #pointer paper_size
        paper_height    = self.paper_height.get_value()
        paper_width     = self.paper_width.get_value()
        paper_units     = self.paper_units.get_active()  #pointer paper_units

        if self.page_orientation_portrait.get_active() == True:
            orient = "port"
        else:
            orient = "land"

        page_resolution         = self.page_resolution.get_value()
        # ---background
        page_with_background    = self.page_with_background.get_active()
        page_rb_bg_solidcolor   = self.page_rb_bg_solidcolor.get_active()    #radiobutton
        page_rb_bg_image        = self.page_rb_bg_image.get_active()         #radiobutton
        page_background_color   = self.page_background_color.get_color()
        page_background_image   = self.page_background_image.get_filename()
        page_background_image_opacity = self.page_background_image_opacity.get_value() 


        page_with_header  = self.page_with_header.get_active()
        page_header       = self.page_header.get_text()
        page_header_font  = self.page_header_font.get_font_name() #-->output is: sans 12
        page_header_color = self.page_header_color.get_color()

        with_pagenumber     = self.with_pagenumber.get_active()
        pagenumber          = self.pagenumber.get_value()
        total_pages         = self.total_pages.get_active()
        pagenumber_font     = self.pagenumber_font.get_font_name()
        # print(pagenumber_font) #-->output is: sans 12
        pagenumber_color    = self.pagenumber_color.get_color()
        #print(pagenumber_color) # output is: #000

        # --- pagemargins
        topmargin       = self.pagemargin_top.get_value()
        bottommargin    = self.pagemargin_bottom.get_value()
        leftmargin      = self.pagemargin_left.get_value()
        rightmargin     = self.pagemargin_right.get_value()
        pagemargin_units = self.pagemargin_units.get_active()
        
        # ------- image options tab ----------------------
        NumOfRows               = self.numofrows.get_value()
        NumOfCols               = self.numofcols.get_value()

        image_horizontal_space = self.image_horizontal_space.get_value()
        image_vertical_space = self.image_vertical_space.get_value()
        image_space_units = self.image_space_units.get_active()    #pointer image_space_units

        image_aspectratio = self.image_aspectratio.get_active_text()
        AR              = self.image_aspectratio.get_active()  #pointer aspectratio
        image_rotate    = self.image_rotate.get_active()

        # ---caption
        include_imagename       = self.include_imagename.get_active()
        imagename_with_extension = self.imagename_with_extension.get_active()
        caption_fontsize        = 3 #self.caption_fontsize.get_value()
        caption_font            = self.caption_font.get_font_name()
        caption_font_color      = self.caption_font_color.get_color()
        
        if self.pyexiv2_loaded == True:
            include_exif = self.include_exif.get_active()
        else:
            include_exif = False

        include_exif_ISO            = self.include_exif_ISO.get_active()
        include_exif_datetime       = self.include_exif_datetime.get_active()
 
        # ------------- other tab --------------------------
        include_list_imagenames = self.include_list_imagenames.get_active()
        direct_printing         = self.direct_printing.get_active()

        images_sort_alphanumeric = self.images_sort_alphanumeric.get_active()
        # ===> to do: sorting on several objects i.e. filename or exifdata
        exif_sort           = self.exif_sort.get_active()
        exif_sort_datetime  = self.exif_sort_datetime.get_active()
        exif_sort_someexif  = self.exif_sort_someexif.get_active()
        hide_extended_options = self.hide_extended_options.get_active()

        # ------------------- extended options tab ----------------------------
        fixednumbercolumnsrows  = self.fixednumbercolumnsrows.get_active()
        fixedcolumn             = self.fixedcolumn.get_active()

        autospacing             = self.autospacing.get_active()
        thumbaligned            = self.thumbaligned.get_active()
        autocenter              = self.autocenter.get_active()
        draw_outline            = self.draw_outline.get_active()
        
        captionspace            = self.captionspace.get_value()
        captiontopmargin        = self.captiontopmargin.get_value()
        captionbottommargin     = self.captionbottommargin.get_value()
        units_captionspace      = self.units_captionspace.get_active()  #pointer units_captionspace
        
        titletopmargin          = self.titletopmargin.get_value()
        titlebottommargin       = self.titlebottommargin.get_value()
        units_titlemargin       = self.units_titlemargin.get_active()  #pointer units_titlemargin
        
        pagenumbertopmargin     = self.pagenumbertopmargin.get_value()
        pagenumberbottommargin  = self.pagenumberbottommargin.get_value()
        units_pagenumbermargin  = self.units_pagenumbermargin.get_active()  #pointer units_pagenumbermargin

        quality_jpg_save        = self.quality_jpg_save.get_value()
           

        # --------- saving configuration for next time ---------
        self.save_config( 'DEFAULT',
            filetype, open_from_location, include_subdirs,
            save_to_location, filename, contact_type,
            paper_size, CS, paper_height, paper_width, paper_units,
            orient, page_resolution,
            page_with_background, page_rb_bg_solidcolor, page_rb_bg_image,
            page_background_color,
            page_background_image, page_background_image_opacity,
            page_with_header, page_header, page_header_font, page_header_color,
            with_pagenumber,pagenumber, pagenumber_font, pagenumber_color, total_pages,
            topmargin, bottommargin, leftmargin, rightmargin, pagemargin_units,
            NumOfCols, NumOfRows,
            image_horizontal_space, image_vertical_space, image_space_units,
            AR, image_rotate,
            caption_fontsize, caption_font, caption_font_color,
            include_imagename, imagename_with_extension,
            include_exif, include_exif_datetime, include_exif_ISO,
            include_list_imagenames, direct_printing,
            images_sort_alphanumeric,
            exif_sort, exif_sort_datetime, exif_sort_someexif,
            hide_extended_options,
            fixednumbercolumnsrows, fixedcolumn,
            autospacing, thumbaligned, autocenter, draw_outline,
            captionspace, captiontopmargin, captionbottommargin, units_captionspace,
            titletopmargin, titlebottommargin, units_titlemargin,
            pagenumbertopmargin, pagenumberbottommargin, units_pagenumbermargin,
            quality_jpg_save)


        # ********** now we have first to convert some variables ************
        # ********** before entering the main routine ***********************

#        page_background_color    = self.extract_color(self.page_background_color.get_color())

        # extract fontname (str), size float) and colorinformation; size will be converted to mm (float)
        pagenumber_font     = self.extract_font_name(self.pagenumber_font.get_font_name())
        pagenumber_fontsize = pt2mm(int(self.extract_font_size(self.pagenumber_font.get_font_name())))
        pagenumber_color    = self.extract_color(self.pagenumber_color.get_color())

        page_header_font    = self.extract_font_name(self.page_header_font.get_font_name())
        page_header_fontsize  = pt2mm(int(self.extract_font_size(self.page_header_font.get_font_name())))
        page_header_color   = self.extract_color(self.page_header_color.get_color())

        caption_font        = self.extract_font_name(self.caption_font.get_font_name())
        caption_fontsize    = pt2mm(int(self.extract_font_size(self.caption_font.get_font_name())))
        caption_font_color  = self.extract_color(self.caption_font_color.get_color())
        
        # --- if paper_units is in inches convert it to mm before calling
        if self.paper_units.get_active_text() == "inch":
            paper_height    = inch2mm(paper_height)
            paper_width     = inch2mm(paper_width)

        # --- convert paper_margin_units to mm (float) before calling
        if self.pagemargin_units.get_active_text() == 'mm':
            pass
        elif self.pagemargin_units.get_active_text() == 'inch':
            topmargin       = inch2mm(topmargin)
            bottommargin    = inch2mm(bottommargin)
            leftmargin      = inch2mm(leftmargin)
            rightmargin     = inch2mm(rightmargin)
        elif self.pagemargin_units.get_active_text() == 'pt':
            topmargin       = pt2mm(topmargin)
            bottommargin    = pt2mm(bottommargin)
            leftmargin      = pt2mm(leftmargin)
            rightmargin     = pt2mm(rightmargin)
        elif self.pagemargin_units.get_active_text() == '%':
            topmargin       = procent2unit(topmargin, 'mm', True)
            bottommargin    = procent2unit(bottommargin, 'mm', True)
            leftmargin      = procent2unit(leftmargin, 'mm', True)
            rightmargin     = procent2unit(rightmargin, 'mm', True)
        else:
            Log('something wrong with paper_margin_units')


        # --- convert image_spacing_units to mm (float) before calling
        if self.image_space_units.get_active_text() == 'mm':
            pass
        elif self.image_space_units.get_active_text() == 'inch':
            image_horizontal_space  = inch2mm(image_horizontal_space)
            image_vertical_space    = inch2mm(image_vertical_space)
        elif self.image_space_units.get_active_text() == 'pt':
            image_horizontal_space  = pt2mm(image_horizontal_space)
            image_vertical_space    = pt2mm(image_vertical_space)
        elif self.image_space_units.get_active_text() == '%':
            image_horizontal_space  = procent2unit(image_horizontal_space, 'mm', True)
            image_vertical_space    = procent2unit(image_vertical_space, 'mm', True)
        else:
            Log('something wrong image_spacing_units')


        # --- convert units_titlemargin to mm (float) before calling
        if self.units_titlemargin.get_active_text() == 'mm':
            pass
        elif self.units_titlemargin.get_active_text() == 'inch':
            titletopmargin      = inch2mm(titletopmargin)
            titlebottommargin   = inch2mm(titlebottommargin)
        elif self.units_titlemargin.get_active_text() == 'pt':
            titletopmargin      = pt2mm(titletopmargin)
            titlebottommargin   = pt2mm(titlebottommargin)
        else:
            Log('something wrong with units_titlemargin')


        # --- convert units_pagenumbermargin to mm (float) before calling
        if self.units_pagenumbermargin.get_active_text() == 'mm':
            pass
        elif self.units_pagenumbermargin.get_active_text() == 'inch':
            pagenumbertopmargin      = inch2mm(pagenumbertopmargin)
            pagenumberbottommargin   = inch2mm(pagenumberbottommargin)
        elif self.units_pagenumbermargin.get_active_text() == 'pt':
            pagenumbertopmargin      = pt2mm(pagenumbertopmargin)
            pagenumberbottommargin   = pt2mm(pagenumberbottommargin)
        else:
            Log('something wrong with units_pagenumbermargin')
        

        # ----------------- create dict -------------------
        d = {'filetype': filetype,
             'select_part_of_filename': select_part_of_filename,
             'open_from_location':      open_from_location,
             'include_subdirs':         include_subdirs,
             'save_to_location':        save_to_location,
             'filename'     :           filename,
             'contact_type':            contact_type,
             'paper_size':              paper_size,
             'CS': CS,
             'paper_height':            paper_height,           ## height in mm (float)
             'paper_width':             paper_width,            ## width in mm (float)
             'paper_units':             paper_units,
             'orient':                  orient,
             'page_resolution':         page_resolution,        ## dpi (int)
             'page_with_background':    page_with_background,
             'page_rb_bg_solidcolor':   page_rb_bg_solidcolor,
             'page_rb_bg_image':        page_rb_bg_image,
             'page_background_color':   page_background_color,
             'page_background_image':   page_background_image,
             'page_background_image_opacity': page_background_image_opacity,
             'page_with_header':        page_with_header,       ## type: (bool); header yes/no
             'page_header':             page_header,            ## type: (text); header text
             'page_header_font':        page_header_font,
             'page_header_fontsize':    page_header_fontsize,   ## type: (float) in mm
             'page_header_color':       page_header_color,
             'with_pagenumber':         with_pagenumber,        ## type: (bool);
             'pagenumber':              pagenumber,             ## type: (int)
             'total_pages':             total_pages,            ## type: (int)
             'pagenumber_font':         pagenumber_font,
             # print(pagenumber_font) #-->output is: sans 12
             'pagenumber_fontsize':     pagenumber_fontsize,    ## type (float) in mm
             'pagenumber_color':        pagenumber_color,
             #print(pagenumber_color) # output is: #000
             'topmargin':               topmargin,              ## type: (float) in mm
             'bottommargin':            bottommargin,           ## type: (float) in mm
             'leftmargin':              leftmargin,             ## type: (float) in mm
             'rightmargin':             rightmargin,            ## type: (float) in mm
             'pagemargin_units':        pagemargin_units,
             'NumOfRows':               NumOfRows,              ## type: (int)
             'NumOfCols':               NumOfCols,              ## type: (int)
             'image_horizontal_space':  image_horizontal_space, ## type: (float) in mm
             'image_vertical_space':    image_vertical_space,
             'image_space_units':       image_space_units,
             'image_aspectratio':       image_aspectratio,
             'AR':                      AR,
             'image_rotate':            image_rotate,
             'include_imagename':       include_imagename,
             'imagename_with_extension': imagename_with_extension,
             'caption_fontsize':        caption_fontsize,       ## type: (float) in mm
             'caption_font':            caption_font,
             'caption_font_color':      caption_font_color,
             'include_exif':            include_exif,
             'include_exif_ISO':        include_exif_ISO,
             'include_exif_datetime':   include_exif_datetime,
             'include_list_imagenames': include_list_imagenames,
             'direct_printing':         direct_printing,
             'images_sort_alphanumeric': images_sort_alphanumeric,
             'exif_sort':               exif_sort,
             'exif_sort_datetime':      exif_sort_datetime,
             'exif_sort_someexif':      exif_sort_someexif,
             'fixednumbercolumnsrows':  fixednumbercolumnsrows,
             'fixedcolumn':             fixedcolumn,
             'autospacing':             autospacing,
             'thumbaligned':            thumbaligned,
             'autocenter':              autocenter,
             'draw_outline':            draw_outline,
             'captionspace':            captionspace,
             'captiontopmargin':        captiontopmargin,
             'captionbottommargin':     captionbottommargin,
             'titletopmargin':          titletopmargin,
             'titlebottommargin':       titlebottommargin,
             'pagenumbertopmargin':     pagenumbertopmargin,
             'pagenumberbottommargin':  pagenumberbottommargin,
             'quality_jpg_save':        quality_jpg_save
              }
        
        # ----------------- do the job -------------------
        
        self.pbar.set_text('Generating indexprints')    #raar wil niet werken
        self.update_progress_bar()
        
        #Log('pbar before: ' + str(self.pbar))
        #GenerateIndexprint.indexprint(d, self.pbar)
        #f = ContactsheetApp()
        GenerateIndexprint.indexprint(d, self.pbar)


# *****************************************************************************
# ====> to do make case insensitive
    def makefiletype(self, filetype):
        '''
        make from all selected filetypes one extended string and return it.
        Input: filetypes
        Output: string of filetypes
        '''
        if self.jpg.get_active() == True:
            filetype = filetype + " .jpg .jpeg"
        if self.png.get_active() == True:
            filetype = filetype + " .png"
        if self.xcf.get_active() == True:
            filetype = filetype + " .xcf"
        if self.tif.get_active() == True:
            filetype = filetype + " .tiff .tif"
        if self.pcx.get_active() == True:
            filetype = filetype + " .pcx"
        if self.bmp.get_active() == True:
            filetype = filetype + " .bmp"
        if self.gif.get_active() == True:
            filetype = filetype + " .gif"
        if self.eps.get_active() == True:
            filetype = filetype + " .ps .eps"
        if self.raw.get_active() == True:
            filetype = filetype + " .rw2 .crw .cr2 .nef .pef .sr2 .raw .raf .pef .dng .orf"
        if self.wdp.get_active() == True:
            filetype = filetype + " .wdp .hdp .jxr"
        if self.svg.get_active() == True:
            filetype = filetype + " .svg"
        if self.psd.get_active() == True:
            filetype = filetype + " .psd"

        return filetype

# *****************************************************************************
    def profile_sections(self, profile):
        '''
        define the profile sections
        '''
        sec_readsave = profile +':' + 'retrieve'
        sec_page = profile +':' + 'page'
        sec_image = profile +':' + 'margins'
        sec_other = profile +':' + 'general'
        sec_extended = profile +':' + 'extended'
        return sec_readsave, sec_page, sec_image, sec_other, sec_extended

# *****************************************************************************
    # --------- Save plugin options for nex time -------
    def save_config(self, profile,
            filetype, open_from_location, include_subdirs,
            save_to_location, filename, contact_type,
            paper_size, CS, paper_height, paper_width, paper_units,
            orient, page_resolution,
            page_with_background, page_rb_bg_solidcolor, page_rb_bg_image,
            page_background_color,
            page_background_image, page_background_image_opacity,
            page_with_header, page_header, page_header_font, page_header_color,
            with_pagenumber, pagenumber, pagenumber_font, pagenumber_color, total_pages,
            topmargin, bottommargin, leftmargin, rightmargin, pagemargin_units,
            NumOfCols, NumOfRows,
            image_horizontal_space, image_vertical_space, image_space_units,
            AR, image_rotate,
            caption_fontsize, caption_font, caption_font_color,
            include_imagename, imagename_with_extension,
            include_exif, include_exif_datetime, include_exif_ISO,
            include_list_imagenames, direct_printing, images_sort_alphanumeric,
            exif_sort, exif_sort_datetime, exif_sort_someexif,
            hide_extended_options,
            fixednumbercolumnsrows, fixedcolumn,
            autospacing, thumbaligned, autocenter, draw_outline,
            captionspace, captiontopmargin, captionbottommargin, units_captionspace,
            titletopmargin, titlebottommargin, units_titlemargin,
            pagenumbertopmargin, pagenumberbottommargin, units_pagenumbermargin,
            quality_jpg_save
            ):

        sec_readsave, sec_page,\
                      sec_image,\
                      sec_other,\
                      sec_extended = self.profile_sections(profile)
    
        cfg = ConfigParser.RawConfigParser()
        
        # ------------- options to remembered per tab ------------
        # ------------- read&save section ------------------
        cfg.add_section(sec_readsave)
        cfg.set (sec_readsave, 'filetype', filetype)
        # (part of) filename not to be remembered
        cfg.set (sec_readsave, 'open_from_location', open_from_location)
        cfg.set (sec_readsave, 'include_subdirs', include_subdirs)
        cfg.set (sec_readsave, 'save_to_location', save_to_location)
        cfg.set (sec_readsave, 'filename', filename)
        cfg.set (sec_readsave, 'contact_type', contact_type)
        
        # ------------- page options section ---------------
        cfg.add_section(sec_page)
        cfg.set (sec_page, 'paper_size', paper_size)
        cfg.set (sec_page, 'CS', CS)
        cfg.set (sec_page, 'paper_height', paper_height)
        cfg.set (sec_page, 'paper_width', paper_width)
        cfg.set (sec_page, 'paper_units', paper_units)
        cfg.set (sec_page, 'orient', orient)
        cfg.set (sec_page, 'page_resolution', page_resolution)

        cfg.set (sec_page, 'page_with_background', page_with_background)
        cfg.set (sec_page, 'page_rb_bg_solidcolor', page_rb_bg_solidcolor) #radiobutton
        cfg.set (sec_page, 'page_rb_bg_image', page_rb_bg_image) #radiobutton
        cfg.set (sec_page, 'page_background_color', page_background_color)
        cfg.set (sec_page, 'page_background_image', page_background_image) #to be remembered??
        cfg.set (sec_page, 'page_background_image_opacity', page_background_image_opacity)

        cfg.set (sec_page, 'page_with_header', page_with_header)
        cfg.set (sec_page, 'page_header', page_header)
        cfg.set (sec_page, 'page_header_font', page_header_font)
        cfg.set (sec_page, 'page_header_color', page_header_color)

        cfg.set (sec_page, 'with_pagenumber', with_pagenumber)
        cfg.set (sec_page, 'pagenumber', pagenumber)
        cfg.set (sec_page, 'total_pages', total_pages)
        cfg.set (sec_page, 'pagenumber_font', pagenumber_font)
        cfg.set (sec_page, 'pagenumber_color', pagenumber_color)
        
        cfg.set (sec_page, 'topmargin', topmargin)
        cfg.set (sec_page, 'bottommargin', bottommargin)
        cfg.set (sec_page, 'leftmargin', leftmargin)
        cfg.set (sec_page, 'rightmargin', rightmargin)
        cfg.set (sec_page, 'pagemargin_units', pagemargin_units)

        # ------------- image options section --------------
        cfg.add_section(sec_image)
        cfg.set (sec_image, 'NumOfCols', NumOfCols)
        cfg.set (sec_image, 'NumOfRows', NumOfRows)

        cfg.set (sec_image, 'image_horizontal_space', image_horizontal_space)
        cfg.set (sec_image, 'image_vertical_space', image_vertical_space)
        cfg.set (sec_image, 'image_space_units', image_space_units)

        cfg.set (sec_image, 'AR', AR)
        cfg.set (sec_image, 'image_rotate', image_rotate)
        cfg.set (sec_image, 'caption_fontsize', caption_fontsize)

        cfg.set (sec_image, 'caption_font', caption_font)
        cfg.set (sec_image, 'caption_font_color', caption_font_color)

        cfg.set (sec_image, 'include_imagename', include_imagename)
        cfg.set (sec_image, 'imagename_with_extension', imagename_with_extension)
        cfg.set (sec_image, 'include_exif', include_exif)
        cfg.set (sec_image, 'include_exif_datetime', include_exif_datetime)
        cfg.set (sec_image, 'include_exif_ISO', include_exif_ISO)
        
        # ------------- other section ----------------------
        cfg.add_section(sec_other)
        cfg.set (sec_other, 'include_list_imagenames', include_list_imagenames)
        cfg.set (sec_other, 'direct_printing', direct_printing)
        cfg.set (sec_other, 'images_sort_alphanumeric', images_sort_alphanumeric)
        cfg.set (sec_other, 'exif_sort', exif_sort)
        cfg.set (sec_other, 'exif_sort_datetime', exif_sort_datetime)
        cfg.set (sec_other, 'exif_sort_someexif', exif_sort_someexif)
        cfg.set (sec_other, 'hide_extended_options', hide_extended_options)

        # ------------- extended options section ----------------------
        cfg.add_section(sec_extended)
        cfg.set (sec_extended, 'fixednumbercolumnsrows', fixednumbercolumnsrows)
        cfg.set (sec_extended, 'fixedcolumn', fixedcolumn)
        cfg.set (sec_extended, 'autospacing', autospacing)
        cfg.set (sec_extended, 'thumbaligned', thumbaligned)
        cfg.set (sec_extended, 'autocenter', autocenter)
        cfg.set (sec_extended, 'draw_outline', draw_outline)

        cfg.set (sec_extended, 'captionspace', captionspace)
        cfg.set (sec_extended, 'captiontopmargin', captiontopmargin)
        cfg.set (sec_extended, 'captionbottommargin', captionbottommargin)
        cfg.set (sec_extended, 'units_captionspace', units_captionspace)

        cfg.set (sec_extended, 'titletopmargin', titletopmargin)
        cfg.set (sec_extended, 'titlebottommargin', titlebottommargin)
        cfg.set (sec_extended, 'units_titlemargin', units_titlemargin)

        cfg.set (sec_extended, 'pagenumbertopmargin', pagenumbertopmargin)
        cfg.set (sec_extended, 'pagenumberbottommargin', pagenumberbottommargin)
        cfg.set (sec_extended, 'units_pagenumbermargin', units_pagenumbermargin)

        cfg.set (sec_extended, 'quality_jpg_save', quality_jpg_save)

        with open(self.config_file, 'wb') as configfile:
          cfg.write(configfile)

        return True


# *****************************************************************************
# ******************** load stored configuration ******************************
# *****************************************************************************
    def load_config(self, profile):
        '''
        load stored configuration from configuration file
        else load default values
        '''
        self.initcycle = True
        if not os.path.exists(self.config_file):
            Log(_("config file doesnot exist"))
            open_from_location = 'c:/'
            self.open_from_location.set_current_folder(open_from_location)
            save_to_location = 'c:/'
            self.save_to_location.set_current_folder(save_to_location)
            return False
        else:
            try:
                sec_readsave, sec_page,\
                              sec_image,\
                              sec_other,\
                              sec_extended = self.profile_sections(profile)
                cfg = ConfigParser.RawConfigParser()
                cfg.read(self.config_file)

                # ------------- read&save section ------------------
                try:
                    try:
                        filetype = cfg.get(sec_readsave, 'filetype')
                        if re.search('jpg', filetype):
                            self.jpg.set_active(True)
                        if re.search('png', filetype):
                            self.png.set_active(True)
                        if re.search('tif', filetype):
                            self.tif.set_active(True)
                        if re.search('xcf', filetype):
                            self.xcf.set_active(True)
                        if re.search('pcx', filetype):
                            self.pcx.set_active(True)
                        if re.search('bmp', filetype):
                            self.bmp.set_active(True)
                        if re.search('gif', filetype):
                            self.gif.set_active(True)
                        if re.search('eps', filetype):
                            self.eps.set_active(True)
                        if re.search('rw2', filetype):
                            self.raw.set_active(True)
                        if re.search('wdp', filetype):
                            self.wdp.set_active(True)
                        if re.search('svg', filetype):
                            self.svg.set_active(True)
                        if re.search('psd', filetype):
                            self.psd.set_active(True)
                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass

                # ----(part of) filename not to be remembered

                    try:
                        open_from_location = cfg.get(sec_readsave, 'open_from_location')
                        self.open_from_location.set_current_folder(open_from_location)
                        include_subdirs = cfg.getboolean(sec_readsave, 'include_subdirs')
                        self.include_subdirs.set_active(include_subdirs)

                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass

                    try:
                        save_to_location = cfg.get(sec_readsave, 'save_to_location')
                        self.save_to_location.set_current_folder(save_to_location)
                        
                        filename = cfg.get(sec_readsave, 'filename')
                        self.filename.set_text(filename)

                        contact_type = cfg.get(sec_readsave, 'contact_type')
                        if contact_type == '.jpg':
                            self.extension_jpg.set_active(True)
                        else:
                            self.extension_png.set_active(True)
                            
                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass

                except ConfigParser.NoSectionError, err:
                    Log(_("Missing section in config file. %s") + err)
                    print _("Missing section in config file. %s") %err

                # ------------- page options section ---------------

                try:
                    try:
                        paper_units  = cfg.getint(sec_page, 'paper_units')
                        self.paper_units.set_active(paper_units)
                        
                        paper_height = cfg.getfloat(sec_page, 'paper_height')
                        paper_width  = cfg.getfloat(sec_page, 'paper_width')
                        self.paper_height.set_value(paper_height)
                        self.paper_width.set_value(paper_width)
                        
                        paper_size = cfg.get(sec_page, 'paper_size')
                        if  paper_size == "custom":
                            self.paper_height.set_sensitive(True)
                            self.paper_width.set_sensitive(True)
                            self.paper_units.set_sensitive(True)
                        else:
                            self.paper_height.set_sensitive(False)
                            self.paper_width.set_sensitive(False)
                            self.paper_units.set_sensitive(False)
                            
                        CS = cfg.getint(sec_page, 'CS')
                        self.paper_size.set_active(CS)

                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass

                    try:
                        orient = cfg.get(sec_page, 'orient')
                        if orient == 'port':
                            self.page_orientation_portrait.set_active(True)
                        else:
                            self.page_orientation_landscape.set_active(True)

                        page_resolution = cfg.getfloat(sec_page, 'page_resolution')
                        self.page_resolution.set_value(page_resolution)
                            
                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass
                   
                    try:
                        page_with_background  = cfg.getboolean(sec_page, 'page_with_background')
                        page_rb_bg_solidcolor = cfg.get(sec_page, 'page_rb_bg_solidcolor') #radiobutton
                        
                        page_background_color = cfg.get(sec_page, 'page_background_color')
                        page_background_image = cfg.get(sec_page, 'page_background_image')
                        page_background_image_opacity = cfg.getfloat(sec_page, 'page_background_image_opacity')

                        self.page_with_background.set_active(page_with_background)
                        self.page_background_color.set_color(gtk.gdk.Color(page_background_color))
                        # set_color() : color should be a GdkColor
                        
                        #-- remember background image????           
                        #self.page_background_image.set_current_folder(page_background_image)
                        self.page_background_image_opacity.set_value(page_background_image_opacity)

                        if page_with_background:
                            if page_rb_bg_solidcolor:
                                self.page_rb_bg_solidcolor.set_active(True)
                                self.page_background_image.set_sensitive(False)
                                self.page_background_image_opacity.set_sensitive(False)
                                self.page_background_color.set_sensitive(True)
                            else:
                                self.page_rb_bg_image.set_active(True)
                                self.page_background_image.set_sensitive(True)
                                self.page_background_image_opacity.set_sensitive(True)
                                self.page_background_color.set_sensitive(False)
                        else:
                            if page_rb_bg_solidcolor:
                                self.page_rb_bg_solidcolor.set_active(True)
                            else:
                                self.page_rb_bg_image.set_active(True)

                            self.page_rb_bg_solidcolor.set_sensitive(False)
                            self.page_rb_bg_image.set_sensitive(False)
                            self.page_background_image.set_sensitive(False)
                            self.page_background_image_opacity.set_sensitive(False)
                            self.page_background_color.set_sensitive(False)
                        
                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass


                    try:
                        page_with_header    = cfg.getboolean(sec_page, 'page_with_header')
                        page_header         = cfg.get(sec_page, 'page_header')
                        page_header_font    = cfg.get(sec_page, 'page_header_font')
                        page_header_color   = cfg.get(sec_page, 'page_header_color')

                        self.page_with_header.set_active(page_with_header)
                        self.page_header.set_text(page_header)
                        self.page_header_font.set_font_name(page_header_font)
                        self.page_header_color.set_color(gtk.gdk.Color(page_header_color))

                        with_pagenumber = cfg.getboolean(sec_page, 'with_pagenumber')
                        pagenumber      = cfg.getfloat(sec_page, 'pagenumber')
                        total_pages     = cfg.getboolean(sec_page, 'total_pages')
                        pagenumber_font = cfg.get(sec_page, 'pagenumber_font')
                        pagenumber_color = cfg.get(sec_page, 'pagenumber_color')

                        self.with_pagenumber.set_active(with_pagenumber)
                        self.pagenumber.set_value(pagenumber)
                        self.total_pages.set_active(total_pages)
                        self.pagenumber_font.set_font_name(pagenumber_font)
                        self.pagenumber_color.set_color(gtk.gdk.Color(pagenumber_color))
                        
                        if self.page_with_header.get_active() == True:
                            self.page_header.set_sensitive(True)
                            self.page_header_font.set_sensitive(True)
                            self.page_header_color.set_sensitive(True)
                        else:
                            self.page_header.set_sensitive(False)
                            self.page_header_font.set_sensitive(False)
                            self.page_header_color.set_sensitive(False)


                        if self.with_pagenumber.get_active() == True:
                            self.pagenumber.set_sensitive(True)
                            self.pagenumber_font.set_sensitive(True)
                            self.pagenumber_color.set_sensitive(True)
                            self.total_pages.set_sensitive(True)
                            
                        else:
                            self.pagenumber.set_sensitive(False)
                            self.pagenumber_font.set_sensitive(False)
                            self.pagenumber_color.set_sensitive(False)
                            self.total_pages.set_sensitive(False)

                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass

                    try:    
                        # pagemargin_units is a pointer not text !
                        pagemargin_units = cfg.getint(sec_page, 'pagemargin_units')
                        #self.pagemargin_old_units.set_active(pagemargin_old_units)
                        self.pagemargin_units.set_active(pagemargin_units)
                        
                        topmargin       = cfg.getfloat(sec_page, 'topmargin')
                        bottommargin    = cfg.getfloat(sec_page, 'bottommargin')
                        leftmargin      = cfg.getfloat(sec_page, 'leftmargin')
                        rightmargin     = cfg.getfloat(sec_page, 'rightmargin')
                        
                        self.pagemargin_top.set_value(topmargin)
                        self.pagemargin_bottom.set_value(bottommargin)
                        self.pagemargin_left.set_value(leftmargin)
                        self.pagemargin_right.set_value(rightmargin)

                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass
                    
                except ConfigParser.NoSectionError, err:
                    Log(_("Missing section in config file. %s") + err)
                    print _("Missing section in config file. %s") %err

                # ------------- image options section --------------    
                try:
                    try:
                        NumOfCols  = cfg.getfloat(sec_image, 'NumOfCols')
                        NumOfRows  = cfg.getfloat(sec_image, 'NumOfRows')
                        self.numofrows.set_value(NumOfRows)
                        self.numofcols.set_value(NumOfCols)
                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass

                    try:
                        image_space_units = cfg.getint(sec_image, 'image_space_units')
                        #self.image_space_old_units.set_active(image_space_units)
                        self.image_space_units.set_active(image_space_units)

                        image_horizontal_space = cfg.getfloat(sec_image, 'image_horizontal_space')
                        image_vertical_space = cfg.getfloat(sec_image, 'image_vertical_space')
                        
                        self.image_horizontal_space.set_value(image_horizontal_space)
                        self.image_vertical_space.set_value(image_vertical_space)
                        
                        AR = cfg.getint(sec_image, 'AR')
                        self.image_aspectratio.set_active(AR)
                        image_rotate = cfg.getboolean(sec_image, 'image_rotate')
                        self.image_rotate.set_active(image_rotate)
                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass

                    try:
                        include_exif            = cfg.getboolean(sec_image, 'include_exif')
                        include_exif_datetime   = cfg.getboolean(sec_image, 'include_exif_datetime')
                        include_exif_ISO        = cfg.getboolean(sec_image, 'include_exif_ISO')
                                                
                        self.include_exif.set_active(include_exif)
                        self.include_exif_datetime.set_active(include_exif_datetime)
                        self.include_exif_ISO.set_active(include_exif_ISO)
                        
                        if include_exif and self.pyexiv2_loaded :
                            self.include_exif_datetime.set_sensitive(True)
                            self.include_exif_ISO.set_sensitive(True)
                        else:
                            self.include_exif_datetime.set_sensitive(False)
                            self.include_exif_ISO.set_sensitive(False)

                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass

                    try:
                        caption_fontsize = cfg.getfloat(sec_image, 'caption_fontsize')
                        #self.caption_fontsize.set_value(caption_fontsize)

                        caption_font = cfg.get(sec_image, 'caption_font')
                        self.caption_font.set_font_name(caption_font)

                        caption_font_color = cfg.get(sec_image, 'caption_font_color')
                        self.caption_font_color.set_color(gtk.gdk.Color(caption_font_color))
                        
                        include_imagename       = cfg.getboolean(sec_image, 'include_imagename')
                        imagename_with_extension = cfg.getboolean(sec_image, 'imagename_with_extension')
                        self.include_imagename.set_active(include_imagename)
                        self.imagename_with_extension.set_active(imagename_with_extension)

                        if include_imagename :
                            self.imagename_with_extension.set_sensitive(True)
                        else:
                            self.imagename_with_extension.set_sensitive(False)
                        
                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass

                except ConfigParser.NoSectionError, err:
                    Log(_("Missing section in config file. %s") + err)
                    print _("Missing section in config file. %s") %err

                # ------------- other section ----------------------
                try:
                    try:
                        include_list_imagenames = cfg.getboolean(sec_other, 'include_list_imagenames')
                        images_sort_alphanumeric = cfg.getboolean(sec_other, 'images_sort_alphanumeric')
                        direct_printing         = cfg.getboolean(sec_other, 'direct_printing')

                        self.include_list_imagenames.set_active(include_list_imagenames)
                        self.images_sort_alphanumeric.set_active(images_sort_alphanumeric)
                        self.direct_printing.set_active(direct_printing)

                        exif_sort           = cfg.getboolean(sec_other, 'exif_sort')
                        exif_sort_datetime  = cfg.getboolean(sec_other, 'exif_sort_datetime')
                        exif_sort_someexif  = cfg.getboolean(sec_other, 'exif_sort_someexif')

                        self.exif_sort.set_active(exif_sort)
                        self.exif_sort_datetime.set_active(exif_sort_datetime)
                        self.exif_sort_someexif.set_active(exif_sort_someexif)

                        if exif_sort and self.pyexiv2_loaded:
                            self.exif_sort_datetime.set_sensitive(True)
                            self.exif_sort_someexif.set_sensitive(True)
                        else:
                            self.exif_sort_datetime.set_sensitive(False)
                            self.exif_sort_someexif.set_sensitive(False)

                        hide_extended_options   = cfg.getboolean(sec_other, 'hide_extended_options')
                        self.hide_extended_options.set_active(hide_extended_options)
                        
                        if hide_extended_options:
                            self.extended_options.hide()
                        else:
                            self.extended_options.show()
                                                
                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass

                except ConfigParser.NoSectionError, err:
                    Log(_("Missing section in config file. %s") + err)
                    print _("Missing section in config file. %s") %err


                # ------------- extended option section ----------------------
                try:
                    try:
                        fixednumbercolumnsrows = cfg.getboolean(sec_extended, 'fixednumbercolumnsrows')
                        fixedcolumn     = cfg.getboolean (sec_extended, 'fixedcolumn')
                        autospacing     = cfg.getboolean (sec_extended, 'autospacing')
                        thumbaligned    = cfg.getboolean (sec_extended, 'thumbaligned')
                        autocenter      = cfg.getboolean (sec_extended, 'autocenter')
                        draw_outline    = cfg.getboolean (sec_extended, 'draw_outline')

                        self.fixednumbercolumnsrows.set_active(fixednumbercolumnsrows)
                        self.fixedcolumn.set_active(fixedcolumn)
                        self.autospacing.set_active(autospacing)
                        self.thumbaligned.set_active(thumbaligned)
                        self.autocenter.set_active(autocenter)
                        self.draw_outline.set_active(draw_outline)

                        units_captionspace  = cfg.getint(sec_extended, 'units_captionspace')
                        captionspace        = cfg.getfloat(sec_extended, 'captionspace')
                        captiontopmargin    = cfg.getfloat(sec_extended, 'captiontopmargin')
                        captionbottommargin = cfg.getfloat(sec_extended, 'captionbottommargin')
                        
                        self.units_captionspace.set_active(units_captionspace)
                        self.captionspace.set_value(captionspace)
                        self.captiontopmargin.set_value(captiontopmargin)
                        self.captionbottommargin.set_value(captionbottommargin)

                        units_titlemargin   = cfg.getint(sec_extended, 'units_titlemargin')
                        titletopmargin      = cfg.getfloat(sec_extended, 'titletopmargin')
                        titlebottommargin   = cfg.getfloat(sec_extended, 'titlebottommargin')

                        units_pagenumbermargin   = cfg.getint(sec_extended, 'units_pagenumbermargin')
                        pagenumbertopmargin = cfg.getfloat(sec_extended, 'pagenumbertopmargin')
                        pagenumberbottommargin = cfg.getfloat(sec_extended, 'pagenumberbottommargin')

                        quality_jpg_save    = cfg.getfloat(sec_extended, 'quality_jpg_save')

                        self.units_titlemargin.set_active(units_titlemargin)
                        self.titletopmargin.set_value(titletopmargin)
                        self.titlebottommargin.set_value(titlebottommargin)
                        
                        self.units_pagenumbermargin.set_active(units_pagenumbermargin)
                        self.pagenumbertopmargin.set_value(pagenumbertopmargin)
                        self.pagenumberbottommargin.set_value(pagenumberbottommargin)

                        self.quality_jpg_save.set_value(quality_jpg_save)
                                                
                    except ConfigParser.NoOptionError, err:
                        pass
                    except ValueError, err:
                        pass

                except ConfigParser.NoSectionError, err:
                    Log(_("Missing section in config file. %s") + err)
                    print _("Missing section in config file. %s") %err

                filetype = ""
                filetype = self.makefiletype(filetype)
                
                number_of_images = self.count_images(filetype,\
                                            open_from_location,\
                                            include_subdirs,\
                                            "")

            except ConfigParser.Error, err:
                Log(_("Cannot parse configuration file. %s") + err)
                print _("Cannot parse configuration file. %s") %err
                self.on_error(_("Configuration file error"),
                              _("Cannot parse configuration file. ") + str(err))
            except IOError, err:
                Log(_("Problem opening configuration file. %s") + err)
                print _("Problem opening configuration file. %s") %err
                self.on_error(_("Configuration file loading error"),
                              _("Problem opening configuration file.") + str(err))

        self.initcycle = False
        return


#==============================================================================
#================= get images from eventually all dirs ========================
#==============================================================================
    def count_images(self, FileType, original_location, include_subdirs,\
                     select_on_part_of_filename):
        '''
        ================== count number of images in given dir(s) ==================
        input: FileType:          array contains one or more extensions
               original_location: directory to start
               include_subdirs:   bool to include subdirectory's too
               select_on_part_of_filename:  text string to make file selections
        output: count:           (sorted) array with images
        ============================================================================

        filetype mag natuurlijk niet leeg zijn !!!

        foutmelding:
        File "C:\Documents and Settings\...\IndexprintDevelopment\gui.py", line 2406,
        in count_images for filename in os.listdir(original_location.decode()):
        AttributeError: 'NoneType' object has no attribute 'decode'
        of
        File "C:\Documents and Settings\...\IndexprintDevelopment\gui.py", line 2412,
        in count_images for filename in os.listdir(original_location):
        TypeError: coercing to Unicode: need string or buffer, NoneType found

        '''
        count = 0
        if (include_subdirs == True):                   #include all subdirectory's
##            for dirpath, dirnames, filenames in os.walk(original_location.decode(),\
##                                                        topdown=True):
            for dirpath, dirnames, filenames in os.walk(original_location,\
                                                        topdown=True):
                for filename in filenames:
                    if select_on_part_of_filename.lower() in filename.lower():
                        basename, ext = os.path.splitext(filename)
                        if ((len(ext)>2) and (ext.lower() in FileType)):
                            count = count + 1
                    else:
                        continue
        else:                                           #only the choosen directory
            ##for filename in os.listdir(original_location.decode()):
            for filename in os.listdir(original_location):
                if select_on_part_of_filename.lower() in filename.lower():
                    basename, ext = os.path.splitext(filename)
                    if ((len(ext)>2) and (ext.lower() in FileType)):
                        count = count + 1
                else:
                    continue
        
        self.pbar.set_text('Number of images: ' + str(count))

        return count
