#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import re

#--global constant
point = 0.352778

#==============================================================================
#======================== calculate mm to pixels ==============================
#==============================================================================
def mm2pixels(mm,dpi):
    '''
    input mm:       float
          dpi:      int resolution
    output pixels:  integer and correct rounded number of pixels
    '''
    pixels = int(round(mm/25.4 * dpi))
    return pixels

#==============================================================================
#======================== calculate pixels to mm ==============================
#==============================================================================
def pixels2mm(pixels,dpi):
    '''
    input pixels:   int
          dpi:      int resolution
    output mm:      float
    '''
    mm = pixels * 25.4 / dpi
    return mm

#==============================================================================
# ************* return the integer value of a hexadecimal string s ************
#==============================================================================
def hex2dec(s):
    return int(s, 16)

#==============================================================================
# ***************** extract font name from the FontButton *********************
#==============================================================================
def extract_font_name (inFont):
    delim = " "
    delim_idx = inFont.rfind(delim)
    if delim_idx >= 0 :
        return inFont[0: delim_idx]
    else :
        return ""

#==============================================================================
# ***************** extract font size from the FontButton *********************
#==============================================================================
def extract_font_size (inFont):
    delim = " "
    delim_idx = inFont.rfind(delim)
    if delim_idx >= 0 :
        return inFont[delim_idx + 1: len(inFont)]
    else :
        return ""

#==============================================================================
# ****************** extract color definition (r,g,b) *************************
#==============================================================================
def extract_color (inColor):
    red_hexa = inColor.to_string()[1:3]
    green_hexa = inColor.to_string()[5:7]
    blue_hexa = inColor.to_string()[9:11]
    return (self.hex2dec(red_hexa),
            self.hex2dec(green_hexa),
            self.hex2dec(blue_hexa))

#==============================================================================
# ************************** convert inches to mm  ****************************
#==============================================================================
def inch2mm(s):
    return float(s*25.4)

#==============================================================================
# ************************** convert mm to inches  ****************************
#==============================================================================
def mm2inch(s):
    return float(s/25.4)

#==============================================================================
# ************************** convert points to mm  ****************************
#==============================================================================
def pt2mm(s):
    return float(s*point)

#==============================================================================
# ************************** convert mm to points  ****************************
#==============================================================================
def mm2pt(s):
    return float(s/point)

#==============================================================================
# ************************** convert points to inches  ************************
#==============================================================================
def pt2inch(s):
    return float(s*point/25.4)

#==============================================================================
# ************************** convert inches to points  ************************
#==============================================================================
def inch2pt(s):
    return float(s*25.4/point)


#==============================================================================
#=========================== get the papersize ================================
#==============================================================================
def getpapersize_mm(papername, givenwidth, givenheight):
    '''
    input   papername   text: name of the choosen paper
    output  givenwidth  float: paper width in case custom
            givenheight float: paper height in case custom
    sizes noted here are in mm
    '''
    #--get the papersize
    if (papername == "Jumbo"):          #Jumbo
        width,height = (102,152)
    elif (papername == "6x8"):          #6x8
        width,height = (152,203)
    elif (papername == "8x10"):         #8x10
        width,height = (203,254)
    elif (papername == "A5"):           #A5
        width,height = (148,210)    
    elif (papername == "A4"):           #A4
        width,height = (210,297)
    elif (papername == "A3"):           #A3
        width,height = (297,420)
    elif (papername == "A2"):           #A2
        width,height = (420,594)
    elif (papername == "A1"):           #A1
        width,height = (594,841)
    elif (papername == "A0"):           #A0
        width,height = (841,1189)        
    elif (papername == "Letter"):       #Letter
        width,height = (216,279)
    elif (papername == "Legal"):        #Legal
        width,height = (216,356)
    elif (papername == "Tabloid"):      #Tabloid
        width,height = (279,432)
    elif (papername == "banner1"):      #banner A4 width
        width,height = (210,1000)
    elif (papername == "banner2"):      #banner A3 width
        width,height = (297,1000)
    elif (papername == "custom"):       #free sizes
        width,height = (givenwidth, givenheight)
    else:
        width,height = (210,297)          #use default if in error
        Log("error in pagesize, pagesize doesnot exist.")

    return width, height
