# -*- coding: utf-8 -*-

#MD Modeller ver. 0.09
#(C) 2010-2011 Ivan Makarov. Yevheniia Holovchanska
#Email: ivmakarov@yahoo.com

# ---------------------------------------------------------------------

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import os,sys
import math
import random

from gimpfu import *



# Import Qt modules
from PyQt4 import QtCore,QtGui

# Import the compiled UI module
#from windowUI8 import Ui_MainWindow


try:
    _fromUtf8 = QtCore.QString.fromUtf8
except AttributeError:
    _fromUtf8 = lambda s: s

class detail(object):
     def __init__(self, name=None, level=None, position=None, pict=None, ctype=None, connects=None, area=None, btw=None):
         self.name = name
         self.level = level
         self.position = position
         self.pict = pict
         self.ctype = ctype
         self.connects = connects
         self.area = area
         self.btw = btw



level1list = []

level1list.append(detail("p1", 1, 1, "p1.xcf", "front", "r1 r2 r3 r7 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5", 0, 0))
level1list.append(detail("p2",1,2,"p2.xcf","front","r1 r2 r3 r7 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5",0,0))
level1list.append(detail("p3",1,3,"p3.xcf","front","r1 r2 r3 r7 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5",0,0))
level1list.append(detail("p4",1,4,"p4.xcf","front","r1 r2 r3 r7 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5",0,0))
level1list.append(detail("p5",1,5,"p5.xcf","front","r7 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5",0,0))
level1list.append(detail("p6",1,6,"p6.xcf","front","r4 r5 r6 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5",0,0))
level1list.append(detail("p7",1,7,"p7.xcf","front","r4 r5 r6 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5",0,0))

level2list = []

level2list.append(detail("r1",2,1,"r1.xcf","sleeve","p1 p2 p3 p4",0,0))
level2list.append(detail("r2",2,2,"r2.xcf","sleeve","p1 p2 p3 p4",0,0))
level2list.append(detail("r3",2,3,"r3.xcf","sleeve","p1 p2 p3 p4",0,0))
level2list.append(detail("r4",2,4,"r4.xcf","sleeve","p6 p7",0,0))
level2list.append(detail("r5",2,5,"r4.xcf","sleeve","p6 p7",0,0))
level2list.append(detail("r6",2,6,"r6.xcf","sleeve","p6 p7",0,0))
level2list.append(detail("r7",2,7,"r7.xcf","sleeve","p1 p2 p3 p4 p5 p6 p7",0,0))

level3list = []

level3list.append(detail("k1",3,1,"k1.xcf","collar","p1 p2 p3 p4 p5 p6 p7",0,0))
level3list.append(detail("k2",3,2,"k2.xcf","collar","p1 p2 p3 p4 p5 p6 p7",0,0))
level3list.append(detail("k3",3,3,"k3.xcf","collar","p1 p2 p3 p4 p5 p6 p7",0,0))
level3list.append(detail("k3",3,4,"k4.xcf","collar","p1 p2 p3 p4 p5 p6 p7",0,0))
level3list.append(detail("k5",3,5,"k5.xcf","collar","p5",0,0))

level4list = []

level4list.append(detail("d1",4,1,"d1.xcf","decoration","p1 p2 p3 p4 p5 p6 p7",0,0))
level4list.append(detail("d2",4,2,"d2.xcf","decoration","p1 p2 p3 p4 p5 p6 p7",0,0))
level4list.append(detail("d3",4,3,"d3.xcf","decoration","p1 p2 p3 p4 p5 p6 p7",0,0))
level4list.append(detail("d4",4,4,"d4.xcf","decoration","p1 p2 p3 p4 p5 p6 p7",0,0))
level4list.append(detail("d5",4,5,"d5.xcf","decoration","p1 p2 p3 p4 p5 p6 p7",0,0))

Model = []


def check_model(model):
    L1name=level1list[model[0]-1].name
    L2name=level2list[model[1]-1].name
    L3name=level3list[model[2]-1].name
    L4name=level4list[model[3]-1].name
    c1=level1list[model[0]-1].connects
    n3 = c1.count(L2name) + c1.count(L3name) +c1.count(L4name)
    if n3 == 3:
        return True
    else:
        return False
    
def draw_model(model, dpath, filename):
    img1 = gimp.Image(562,717,RGB)

    layer = pdb.gimp_file_load_layer(img1, dpath+"B.xcf")
    pdb.gimp_image_add_layer(img1, layer, 0)
    pdb.gimp_edit_fill(layer, BACKGROUND_FILL)

    layer = pdb.gimp_file_load_layer(img1, dpath+"girl.xcf")
    pdb.gimp_image_add_layer(img1, layer, 0)


    l1fname=level1list[model[0]-1].pict
    lfpath=dpath+l1fname
    print lfpath    
    filename=filename+level1list[model[0]-1].name
    layer = pdb.gimp_file_load_layer(img1, lfpath)
    pdb.gimp_image_add_layer(img1, layer, 0)

    l2fname=level2list[model[1]-1].pict
    lfpath=dpath+l2fname
    print lfpath    
    filename=filename+level2list[model[1]-1].name
    layer = pdb.gimp_file_load_layer(img1, lfpath)
    pdb.gimp_image_add_layer(img1, layer, 0)

    l3fname=level3list[model[2]-1].pict
    lfpath=dpath+l3fname
    print lfpath    
    filename=filename+level3list[model[2]-1].name
    layer = pdb.gimp_file_load_layer(img1, lfpath)
    pdb.gimp_image_add_layer(img1, layer, 0)

    l4fname=level4list[model[3]-1].pict
    lfpath=dpath+l4fname
    print lfpath    
    filename=filename+level4list[model[3]-1].name
    layer = pdb.gimp_file_load_layer(img1, lfpath)
    pdb.gimp_image_add_layer(img1, layer, 0)

    gimp.Display(img1)

    drawable = pdb.gimp_image_get_active_drawable(img1)
    ffilename=dpath+filename+".xcf"
    print ffilename
    pdb.gimp_file_save(img1, drawable, ffilename, filename)
    return ffilename

def random_model():
    n = random.randint(1,7)
    print n
    Model.append(n)
    n = random.randint(1,6)
    print n
    Model.append(n)
    n = random.randint(1,4)
    print n
    Model.append(n)
    n = random.randint(1,4)
    print n
    Model.append(n)
    
    


class Ui_MainWindow(object):
    def setupUi(self, MainWindow):
        MainWindow.setObjectName(_fromUtf8("MainWindow"))
        MainWindow.resize(568, 541)
        self.centralwidget = QtGui.QWidget(MainWindow)
        self.centralwidget.setObjectName(_fromUtf8("centralwidget"))
        self.label = QtGui.QLabel(self.centralwidget)
        self.label.setGeometry(QtCore.QRect(40, 20, 61, 121))
        self.label.setText(_fromUtf8(""))
        self.label.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/p1.jpg")))
        self.label.setObjectName(_fromUtf8("label"))
        self.label_2 = QtGui.QLabel(self.centralwidget)
        self.label_2.setGeometry(QtCore.QRect(480, 20, 71, 121))
        self.label_2.setText(_fromUtf8(""))
        self.label_2.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/p7.jpg")))
        self.label_2.setObjectName(_fromUtf8("label_2"))
        self.label_3 = QtGui.QLabel(self.centralwidget)
        self.label_3.setGeometry(QtCore.QRect(410, 20, 61, 121))
        self.label_3.setText(_fromUtf8(""))
        self.label_3.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/p6.jpg")))
        self.label_3.setObjectName(_fromUtf8("label_3"))
        self.label_4 = QtGui.QLabel(self.centralwidget)
        self.label_4.setGeometry(QtCore.QRect(330, 20, 71, 121))
        self.label_4.setText(_fromUtf8(""))
        self.label_4.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/p5.jpg")))
        self.label_4.setObjectName(_fromUtf8("label_4"))
        self.label_5 = QtGui.QLabel(self.centralwidget)
        self.label_5.setGeometry(QtCore.QRect(260, 20, 61, 121))
        self.label_5.setText(_fromUtf8(""))
        self.label_5.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/p4.jpg")))
        self.label_5.setObjectName(_fromUtf8("label_5"))
        self.label_6 = QtGui.QLabel(self.centralwidget)
        self.label_6.setGeometry(QtCore.QRect(180, 20, 71, 121))
        self.label_6.setText(_fromUtf8(""))
        self.label_6.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/p3.jpg")))
        self.label_6.setObjectName(_fromUtf8("label_6"))
        self.label_7 = QtGui.QLabel(self.centralwidget)
        self.label_7.setGeometry(QtCore.QRect(110, 20, 61, 121))
        self.label_7.setText(_fromUtf8(""))
        self.label_7.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/p2.jpg")))
        self.label_7.setObjectName(_fromUtf8("label_7"))
        self.label_8 = QtGui.QLabel(self.centralwidget)
        self.label_8.setGeometry(QtCore.QRect(110, 170, 61, 71))
        self.label_8.setText(_fromUtf8(""))
        self.label_8.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/r2.jpg")))
        self.label_8.setObjectName(_fromUtf8("label_8"))
        self.label_9 = QtGui.QLabel(self.centralwidget)
        self.label_9.setGeometry(QtCore.QRect(250, 170, 61, 71))
        self.label_9.setText(_fromUtf8(""))
        self.label_9.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/r4.jpg")))
        self.label_9.setObjectName(_fromUtf8("label_9"))
        self.label_10 = QtGui.QLabel(self.centralwidget)
        self.label_10.setGeometry(QtCore.QRect(390, 170, 61, 81))
        self.label_10.setText(_fromUtf8(""))
        self.label_10.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/r6.jpg")))
        self.label_10.setObjectName(_fromUtf8("label_10"))
        self.label_11 = QtGui.QLabel(self.centralwidget)
        self.label_11.setGeometry(QtCore.QRect(40, 170, 61, 81))
        self.label_11.setText(_fromUtf8(""))
        self.label_11.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/r1.jpg")))
        self.label_11.setObjectName(_fromUtf8("label_11"))
        self.label_12 = QtGui.QLabel(self.centralwidget)
        self.label_12.setGeometry(QtCore.QRect(320, 170, 61, 81))
        self.label_12.setText(_fromUtf8(""))
        self.label_12.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/r5.jpg")))
        self.label_12.setObjectName(_fromUtf8("label_12"))
        self.label_14 = QtGui.QLabel(self.centralwidget)
        self.label_14.setGeometry(QtCore.QRect(180, 170, 61, 71))
        self.label_14.setText(_fromUtf8(""))
        self.label_14.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/r3.jpg")))
        self.label_14.setObjectName(_fromUtf8("label_14"))
        self.label_15 = QtGui.QLabel(self.centralwidget)
        self.label_15.setGeometry(QtCore.QRect(120, 300, 61, 41))
        self.label_15.setText(_fromUtf8(""))
        self.label_15.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/k2.jpg")))
        self.label_15.setObjectName(_fromUtf8("label_15"))
        self.label_16 = QtGui.QLabel(self.centralwidget)
        self.label_16.setGeometry(QtCore.QRect(250, 300, 61, 41))
        self.label_16.setText(_fromUtf8(""))
        self.label_16.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/k4.jpg")))
        self.label_16.setObjectName(_fromUtf8("label_16"))
        self.label_18 = QtGui.QLabel(self.centralwidget)
        self.label_18.setGeometry(QtCore.QRect(50, 300, 61, 41))
        self.label_18.setText(_fromUtf8(""))
        self.label_18.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/k1.jpg")))
        self.label_18.setObjectName(_fromUtf8("label_18"))
        self.label_21 = QtGui.QLabel(self.centralwidget)
        self.label_21.setGeometry(QtCore.QRect(180, 300, 61, 41))
        self.label_21.setText(_fromUtf8(""))
        self.label_21.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/k3.jpg")))
        self.label_21.setObjectName(_fromUtf8("label_21"))
        self.label_22 = QtGui.QLabel(self.centralwidget)
        self.label_22.setGeometry(QtCore.QRect(120, 390, 61, 41))
        self.label_22.setText(_fromUtf8(""))
        self.label_22.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/d1 3.jpg")))
        self.label_22.setObjectName(_fromUtf8("label_22"))
        self.label_23 = QtGui.QLabel(self.centralwidget)
        self.label_23.setGeometry(QtCore.QRect(260, 390, 61, 41))
        self.label_23.setText(_fromUtf8(""))
        self.label_23.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/d2 3.jpg")))
        self.label_23.setObjectName(_fromUtf8("label_23"))
        self.label_25 = QtGui.QLabel(self.centralwidget)
        self.label_25.setGeometry(QtCore.QRect(50, 390, 61, 41))
        self.label_25.setText(_fromUtf8(""))
        self.label_25.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/d1.jpg")))
        self.label_25.setObjectName(_fromUtf8("label_25"))
        self.label_28 = QtGui.QLabel(self.centralwidget)
        self.label_28.setGeometry(QtCore.QRect(190, 390, 61, 41))
        self.label_28.setText(_fromUtf8(""))
        self.label_28.setPixmap(QtGui.QPixmap(_fromUtf8("../pics/50p/d2.jpg")))
        self.label_28.setObjectName(_fromUtf8("label_28"))
        self.pushButton = QtGui.QPushButton(self.centralwidget)
        self.pushButton.setGeometry(QtCore.QRect(420, 360, 99, 25))
        self.pushButton.setObjectName(_fromUtf8("pushButton"))
        self.groupBox = QtGui.QGroupBox(self.centralwidget)
        self.groupBox.setGeometry(QtCore.QRect(40, 140, 511, 51))
        self.groupBox.setTitle(_fromUtf8(""))
        self.groupBox.setObjectName(_fromUtf8("groupBox"))
        self.radioButton = QtGui.QRadioButton(self.groupBox)
        self.radioButton.setGeometry(QtCore.QRect(0, 0, 51, 21))
        self.radioButton.setObjectName(_fromUtf8("radioButton"))
        self.radioButton_2 = QtGui.QRadioButton(self.groupBox)
        self.radioButton_2.setGeometry(QtCore.QRect(70, 0, 51, 21))
        self.radioButton_2.setObjectName(_fromUtf8("radioButton_2"))
        self.radioButton_3 = QtGui.QRadioButton(self.groupBox)
        self.radioButton_3.setGeometry(QtCore.QRect(140, 0, 51, 21))
        self.radioButton_3.setObjectName(_fromUtf8("radioButton_3"))
        self.radioButton_4 = QtGui.QRadioButton(self.groupBox)
        self.radioButton_4.setGeometry(QtCore.QRect(220, 0, 51, 21))
        self.radioButton_4.setObjectName(_fromUtf8("radioButton_4"))
        self.radioButton_5 = QtGui.QRadioButton(self.groupBox)
        self.radioButton_5.setGeometry(QtCore.QRect(290, 0, 51, 21))
        self.radioButton_5.setObjectName(_fromUtf8("radioButton_5"))
        self.radioButton_6 = QtGui.QRadioButton(self.groupBox)
        self.radioButton_6.setGeometry(QtCore.QRect(370, 0, 51, 21))
        self.radioButton_6.setObjectName(_fromUtf8("radioButton_6"))
        self.radioButton_7 = QtGui.QRadioButton(self.groupBox)
        self.radioButton_7.setGeometry(QtCore.QRect(440, 0, 51, 21))
        self.radioButton_7.setObjectName(_fromUtf8("radioButton_7"))
        self.groupBox_2 = QtGui.QGroupBox(self.centralwidget)
        self.groupBox_2.setGeometry(QtCore.QRect(40, 240, 481, 51))
        self.groupBox_2.setTitle(_fromUtf8(""))
        self.groupBox_2.setObjectName(_fromUtf8("groupBox_2"))
        self.radioButton_8 = QtGui.QRadioButton(self.groupBox_2)
        self.radioButton_8.setGeometry(QtCore.QRect(0, 0, 51, 21))
        self.radioButton_8.setObjectName(_fromUtf8("radioButton_8"))
        self.radioButton_9 = QtGui.QRadioButton(self.groupBox_2)
        self.radioButton_9.setGeometry(QtCore.QRect(70, 0, 51, 21))
        self.radioButton_9.setObjectName(_fromUtf8("radioButton_9"))
        self.radioButton_10 = QtGui.QRadioButton(self.groupBox_2)
        self.radioButton_10.setGeometry(QtCore.QRect(140, 0, 51, 21))
        self.radioButton_10.setObjectName(_fromUtf8("radioButton_10"))
        self.radioButton_11 = QtGui.QRadioButton(self.groupBox_2)
        self.radioButton_11.setGeometry(QtCore.QRect(210, 0, 51, 21))
        self.radioButton_11.setObjectName(_fromUtf8("radioButton_11"))
        self.radioButton_12 = QtGui.QRadioButton(self.groupBox_2)
        self.radioButton_12.setGeometry(QtCore.QRect(270, 0, 51, 21))
        self.radioButton_12.setObjectName(_fromUtf8("radioButton_12"))
        self.radioButton_13 = QtGui.QRadioButton(self.groupBox_2)
        self.radioButton_13.setGeometry(QtCore.QRect(350, 0, 51, 21))
        self.radioButton_13.setObjectName(_fromUtf8("radioButton_13"))
        self.radioButton_14 = QtGui.QRadioButton(self.groupBox_2)
        self.radioButton_14.setGeometry(QtCore.QRect(410, 0, 81, 21))
        self.radioButton_14.setObjectName(_fromUtf8("radioButton_14"))
        self.groupBox_3 = QtGui.QGroupBox(self.centralwidget)
        self.groupBox_3.setGeometry(QtCore.QRect(40, 340, 341, 51))
        self.groupBox_3.setTitle(_fromUtf8(""))
        self.groupBox_3.setObjectName(_fromUtf8("groupBox_3"))
        self.radioButton_15 = QtGui.QRadioButton(self.groupBox_3)
        self.radioButton_15.setGeometry(QtCore.QRect(0, 0, 51, 21))
        self.radioButton_15.setObjectName(_fromUtf8("radioButton_15"))
        self.radioButton_16 = QtGui.QRadioButton(self.groupBox_3)
        self.radioButton_16.setGeometry(QtCore.QRect(70, 0, 51, 21))
        self.radioButton_16.setObjectName(_fromUtf8("radioButton_16"))
        self.radioButton_17 = QtGui.QRadioButton(self.groupBox_3)
        self.radioButton_17.setGeometry(QtCore.QRect(140, 0, 51, 21))
        self.radioButton_17.setObjectName(_fromUtf8("radioButton_17"))
        self.radioButton_18 = QtGui.QRadioButton(self.groupBox_3)
        self.radioButton_18.setGeometry(QtCore.QRect(210, 0, 51, 21))
        self.radioButton_18.setObjectName(_fromUtf8("radioButton_18"))
        self.radioButton_19 = QtGui.QRadioButton(self.groupBox_3)
        self.radioButton_19.setGeometry(QtCore.QRect(270, 0, 71, 21))
        self.radioButton_19.setObjectName(_fromUtf8("radioButton_19"))
        self.groupBox_4 = QtGui.QGroupBox(self.centralwidget)
        self.groupBox_4.setGeometry(QtCore.QRect(40, 430, 341, 61))
        self.groupBox_4.setTitle(_fromUtf8(""))
        self.groupBox_4.setObjectName(_fromUtf8("groupBox_4"))
        self.radioButton_20 = QtGui.QRadioButton(self.groupBox_4)
        self.radioButton_20.setGeometry(QtCore.QRect(0, 0, 61, 21))
        self.radioButton_20.setObjectName(_fromUtf8("radioButton_20"))
        self.radioButton_21 = QtGui.QRadioButton(self.groupBox_4)
        self.radioButton_21.setGeometry(QtCore.QRect(70, 0, 61, 21))
        self.radioButton_21.setObjectName(_fromUtf8("radioButton_21"))
        self.radioButton_22 = QtGui.QRadioButton(self.groupBox_4)
        self.radioButton_22.setGeometry(QtCore.QRect(140, 0, 61, 21))
        self.radioButton_22.setObjectName(_fromUtf8("radioButton_22"))
        self.radioButton_23 = QtGui.QRadioButton(self.groupBox_4)
        self.radioButton_23.setGeometry(QtCore.QRect(210, 0, 61, 21))
        self.radioButton_23.setObjectName(_fromUtf8("radioButton_23"))
        self.radioButton_24 = QtGui.QRadioButton(self.groupBox_4)
        self.radioButton_24.setGeometry(QtCore.QRect(270, 0, 61, 21))
        self.radioButton_24.setObjectName(_fromUtf8("radioButton_24"))
        self.pushButton_2 = QtGui.QPushButton(self.centralwidget)
        self.pushButton_2.setGeometry(QtCore.QRect(420, 440, 99, 25))
        self.pushButton_2.setObjectName(_fromUtf8("pushButton_2"))
        MainWindow.setCentralWidget(self.centralwidget)
        self.menubar = QtGui.QMenuBar(MainWindow)
        self.menubar.setGeometry(QtCore.QRect(0, 0, 568, 22))
        self.menubar.setObjectName(_fromUtf8("menubar"))
        MainWindow.setMenuBar(self.menubar)
        self.statusbar = QtGui.QStatusBar(MainWindow)
        self.statusbar.setObjectName(_fromUtf8("statusbar"))
        MainWindow.setStatusBar(self.statusbar)





        self.retranslateUi(MainWindow)
        QtCore.QObject.connect(self.radioButton, QtCore.SIGNAL(_fromUtf8("pressed()")), self.p1slot)
        QtCore.QObject.connect(self.radioButton_2, QtCore.SIGNAL(_fromUtf8("pressed()")), self.p2slot)
        QtCore.QObject.connect(self.radioButton_3, QtCore.SIGNAL(_fromUtf8("pressed()")), self.p3slot)
        QtCore.QObject.connect(self.radioButton_4, QtCore.SIGNAL(_fromUtf8("pressed()")), self.p4slot)
        QtCore.QObject.connect(self.radioButton_5, QtCore.SIGNAL(_fromUtf8("pressed()")), self.p5slot)
        QtCore.QObject.connect(self.radioButton_6, QtCore.SIGNAL(_fromUtf8("pressed()")), self.p6slot)
        QtCore.QObject.connect(self.radioButton_7, QtCore.SIGNAL(_fromUtf8("pressed()")), self.p7slot)
        QtCore.QObject.connect(self.radioButton_8, QtCore.SIGNAL(_fromUtf8("pressed()")), self.r1slot)
        QtCore.QObject.connect(self.radioButton_9, QtCore.SIGNAL(_fromUtf8("pressed()")), self.r2slot)
        QtCore.QObject.connect(self.radioButton_10, QtCore.SIGNAL(_fromUtf8("pressed()")), self.r3slot)
        QtCore.QObject.connect(self.radioButton_11, QtCore.SIGNAL(_fromUtf8("pressed()")), self.r4slot)
        QtCore.QObject.connect(self.radioButton_12, QtCore.SIGNAL(_fromUtf8("pressed()")), self.r5slot)
        QtCore.QObject.connect(self.radioButton_13, QtCore.SIGNAL(_fromUtf8("pressed()")), self.r6slot)
        QtCore.QObject.connect(self.radioButton_14, QtCore.SIGNAL(_fromUtf8("pressed()")), self.r7slot)
        QtCore.QObject.connect(self.radioButton_15, QtCore.SIGNAL(_fromUtf8("pressed()")), self.k1slot)
        QtCore.QObject.connect(self.radioButton_16, QtCore.SIGNAL(_fromUtf8("pressed()")), self.k2slot)
        QtCore.QObject.connect(self.radioButton_17, QtCore.SIGNAL(_fromUtf8("pressed()")), self.k3slot)
        QtCore.QObject.connect(self.radioButton_18, QtCore.SIGNAL(_fromUtf8("pressed()")), self.k4slot)
        QtCore.QObject.connect(self.radioButton_19, QtCore.SIGNAL(_fromUtf8("pressed()")), self.k5slot)
        QtCore.QObject.connect(self.radioButton_20, QtCore.SIGNAL(_fromUtf8("pressed()")), self.d1slot)
        QtCore.QObject.connect(self.radioButton_21, QtCore.SIGNAL(_fromUtf8("pressed()")), self.d2slot)
        QtCore.QObject.connect(self.radioButton_22, QtCore.SIGNAL(_fromUtf8("pressed()")), self.d3slot)
        QtCore.QObject.connect(self.radioButton_23, QtCore.SIGNAL(_fromUtf8("pressed()")), self.d4slot)
        QtCore.QObject.connect(self.radioButton_24, QtCore.SIGNAL(_fromUtf8("pressed()")), self.d5slot)
        QtCore.QObject.connect(self.pushButton, QtCore.SIGNAL(_fromUtf8("clicked()")), self.b1DMslot)
        QtCore.QObject.connect(self.pushButton_2, QtCore.SIGNAL(_fromUtf8("clicked()")), self.b2Ranslot)
        QtCore.QMetaObject.connectSlotsByName(MainWindow)

    def p1slot(self):
      p = 1
      in_number = 1
      Model.append(in_number)
      print "p1"
      
    def p2slot(self):
      p = 2
      in_number = 2
      Model.append(in_number)
      print "p2"
      
    def p3slot(self):
      p = 3
      in_number = 3
      Model.append(in_number)
      print "p3"    
   
    def p4slot(self):
      p = 4
      in_number = 4
      Model.append(in_number)
      print "p4"
      
    def p5slot(self):
      p = 5
      in_number = 5
      Model.append(in_number)
      print "p5"
      
    def p6slot(self):
      p = 6
      in_number = 6
      Model.append(in_number)
      print "p6"
      
    def p7slot(self):
      p = 7
      in_number = 7
      Model.append(in_number)
      print "p7"  
      
    def r1slot(self):
      r = 1
      in_number = 1
      Model.append(in_number)
      print "r1"
      
    def r2slot(self):
      r = 2
      in_number = 2
      Model.append(in_number)
      print "r2"  
      
    def r3slot(self):
      r = 3
      in_number = 3
      Model.append(in_number)
      print "r3"
      
    def r4slot(self):
      r = 4
      in_number = 4
      Model.append(in_number)
      print "r4"
      
    def r5slot(self):
      r = 5
      in_number = 5
      Model.append(in_number)
      print "r5"
      
    def r6slot(self):
      r = 6
      in_number = 6
      Model.append(in_number)
      print "r6"
      
    def r7slot(self):
      r = 7
      in_number = 7
      Model.append(in_number)
      print "r7"
      
    def k1slot(self):
      k = 1
      in_number = 1
      Model.append(in_number)
      print "k1"
      
    def k2slot(self):
      k = 2
      in_number = 2
      Model.append(in_number)
      print "k2"
        
    def k3slot(self):
      k = 3
      in_number = 3
      Model.append(in_number)
      print "k3"
      
    def k4slot(self):
      k = 4
      in_number = 4
      Model.append(in_number)
      print "k4"
      
    def k5slot(self):
      k = 5
      in_number = 5
      Model.append(in_number)
      print "k5"
      
    def d1slot(self):
      d = 1
      in_number = 1
      Model.append(in_number)
      print "d1"
      
    def d2slot(self):
      d = 2
      in_number = 2
      Model.append(in_number)
      print "d2"
      
    def d3slot(self):
      d = 3
      in_number = 3
      Model.append(in_number)
      print "d3"
      
    def d4slot(self):
      d = 4
      in_number = 4
      Model.append(in_number)
      print "d4"
      
    def d5slot(self):
      d = 5
      in_number = 5
      Model.append(in_number)
      print "d5"
      
    def b1DMslot(self):
      print "drawing model"
      dpath=os.getcwd()+"/";
      filename="model_"
      if check_model(Model):
	  draw_model(Model,dpath,filename)
      else:
	  print "details are not compatible"
      del Model[0:4]
      
    def b2Ranslot(self):
      print "drawing model"
      random_model()
      dpath=os.getcwd()+"/";
      filename="model_"
      if check_model(Model):
	  draw_model(Model,dpath,filename)
      else:
	  print "details are not compatible"  
      del Model[0:4]




    def retranslateUi(self, MainWindow):
        MainWindow.setWindowTitle(QtGui.QApplication.translate("MainWindow", "MD modeller", None, QtGui.QApplication.UnicodeUTF8))
        self.pushButton.setText(QtGui.QApplication.translate("MainWindow", "Draw", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton.setText(QtGui.QApplication.translate("MainWindow", "p1", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_2.setText(QtGui.QApplication.translate("MainWindow", "p2", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_3.setText(QtGui.QApplication.translate("MainWindow", "p3", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_4.setText(QtGui.QApplication.translate("MainWindow", "p4", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_5.setText(QtGui.QApplication.translate("MainWindow", "p5", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_6.setText(QtGui.QApplication.translate("MainWindow", "p6", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_7.setText(QtGui.QApplication.translate("MainWindow", "p7", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_8.setText(QtGui.QApplication.translate("MainWindow", "r1", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_9.setText(QtGui.QApplication.translate("MainWindow", "r2", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_10.setText(QtGui.QApplication.translate("MainWindow", "r3", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_11.setText(QtGui.QApplication.translate("MainWindow", "r4", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_12.setText(QtGui.QApplication.translate("MainWindow", "r5", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_13.setText(QtGui.QApplication.translate("MainWindow", "r6", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_14.setText(QtGui.QApplication.translate("MainWindow", "no r", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_15.setText(QtGui.QApplication.translate("MainWindow", "k1", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_16.setText(QtGui.QApplication.translate("MainWindow", "k2", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_17.setText(QtGui.QApplication.translate("MainWindow", "k3", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_18.setText(QtGui.QApplication.translate("MainWindow", "k4", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_19.setText(QtGui.QApplication.translate("MainWindow", "no k", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_20.setText(QtGui.QApplication.translate("MainWindow", "d1", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_21.setText(QtGui.QApplication.translate("MainWindow", "d2", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_22.setText(QtGui.QApplication.translate("MainWindow", "d3", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_23.setText(QtGui.QApplication.translate("MainWindow", "d4", None, QtGui.QApplication.UnicodeUTF8))
        self.radioButton_24.setText(QtGui.QApplication.translate("MainWindow", "no d", None, QtGui.QApplication.UnicodeUTF8))
        self.pushButton_2.setText(QtGui.QApplication.translate("MainWindow", "Random", None, QtGui.QApplication.UnicodeUTF8))
        






# Create a class for our main window
class Main(QtGui.QMainWindow):
    def __init__(self):
        QtGui.QMainWindow.__init__(self)
        
        # This is always the same
        self.ui=Ui_MainWindow()
        self.ui.setupUi(self)
        
      

def main():
    # Again, this is boilerplate, it's going to be the same on
    # almost every app you write
    app = QtGui.QApplication(sys.argv)
    window=Main()
    window.show()
    # It's exec_ because exec is a reserved word in Python
    sys.exit(app.exec_())
    

if __name__ == "__main__":
    main()