#!/usr/bin/env python

# Script counting all possible detail combinations in this set ( part of MD Modeller ver. 0.09 )
#(C) 2010-2011 Ivan Makarov. Yevheniia Holovchanska
#Email: ivmakarov@yahoo.com

# ---------------------------------------------------------------------

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import os,sys
import math
import random
import time


from gimpfu import *

class detail(object):
     def __init__(self, name=None, level=None, position=None, pict=None, ctype=None, connects=None, area=None, btw=None):
         self.name = name
         self.level = level
         self.position = position
         self.pict = pict
         self.ctype = ctype
         self.connects = connects
         self.area = area
         self.btw = btw
 
Glist = "cc "
         
level1list = []

level1list.append(detail("p1", 1, 1, "p1.xcf", "front", "r1 r2 r3 r7 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5", 0, 0))
level1list.append(detail("p2",1,2,"p2.xcf","front","r1 r2 r3 r7 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5",0,0))
level1list.append(detail("p3",1,3,"p3.xcf","front","r1 r2 r3 r7 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5",0,0))
level1list.append(detail("p4",1,4,"p4.xcf","front","r1 r2 r3 r7 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5",0,0))
level1list.append(detail("p5",1,5,"p5.xcf","front","r7 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5",0,0))
level1list.append(detail("p6",1,6,"p6.xcf","front","r4 r5 r6 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5",0,0))
level1list.append(detail("p7",1,7,"p7.xcf","front","r4 r5 r6 k1 k2 k3 k4 k5 d1 d2 d3 d4 d5",0,0))

level2list = []

level2list.append(detail("r1",2,1,"r1.xcf","sleeve","p1 p2 p3 p4",0,0))
level2list.append(detail("r2",2,2,"r2.xcf","sleeve","p1 p2 p3 p4",0,0))
level2list.append(detail("r3",2,3,"r3.xcf","sleeve","p1 p2 p3 p4",0,0))
level2list.append(detail("r4",2,4,"r4.xcf","sleeve","p6 p7",0,0))
level2list.append(detail("r5",2,5,"r4.xcf","sleeve","p6 p7",0,0))
level2list.append(detail("r6",2,6,"r6.xcf","sleeve","p6 p7",0,0))
level2list.append(detail("r7",2,7,"r7.xcf","sleeve","p1 p2 p3 p4 p5 p6 p7",0,0))

level3list = []

level3list.append(detail("k1",3,1,"k1.xcf","collar","p1 p2 p3 p4 p5 p6 p7",0,0))
level3list.append(detail("k2",3,2,"k2.xcf","collar","p1 p2 p3 p4 p5 p6 p7",0,0))
level3list.append(detail("k3",3,3,"k3.xcf","collar","p1 p2 p3 p4 p5 p6 p7",0,0))
level3list.append(detail("k3",3,4,"k4.xcf","collar","p1 p2 p3 p4 p5 p6 p7",0,0))
level3list.append(detail("k5",3,5,"k5.xcf","collar","p5",0,0))

level4list = []

level4list.append(detail("d1",4,1,"d1.xcf","decoration","p1 p2 p3 p4 p5 p6 p7",0,0))
level4list.append(detail("d2",4,2,"d2.xcf","decoration","p1 p2 p3 p4 p5 p6 p7",0,0))
level4list.append(detail("d3",4,3,"d3.xcf","decoration","p1 p2 p3 p4 p5 p6 p7",0,0))
level4list.append(detail("d4",4,4,"d4.xcf","decoration","p1 p2 p3 p4 p5 p6 p7",0,0))
level4list.append(detail("d5",4,5,"d5.xcf","decoration","p1 p2 p3 p4 p5 p6 p7",0,0))


def check_model(model):
    L1name=level1list[model[0]-1].name
    L2name=level2list[model[1]-1].name
    L3name=level3list[model[2]-1].name
    L4name=level4list[model[3]-1].name
    c1=level1list[model[0]-1].connects
    n3 = c1.count(L2name) + c1.count(L3name) +c1.count(L4name)
    if n3 == 3:
	L =  L1name + " " + L2name + " " + L3name + " " + L4name
	print L
        return True
    else:
        print "details are not compatible"
        L =  L1name + " " + L2name + " " + L3name + " " + L4name
	print L
        return False
    
def draw_model(model, dpath, filename):
    img1 = gimp.Image(562,717,RGB)

    layer = pdb.gimp_file_load_layer(img1, dpath+"B.xcf")
    pdb.gimp_image_add_layer(img1, layer, 0)
    pdb.gimp_edit_fill(layer, BACKGROUND_FILL)

    layer = pdb.gimp_file_load_layer(img1, dpath+"girl.xcf")
    pdb.gimp_image_add_layer(img1, layer, 0)
    

    l1fname=level1list[model[0]-1].pict
    lfpath=dpath+l1fname
    print lfpath    
    filename=filename+level1list[model[0]-1].name
    layer = pdb.gimp_file_load_layer(img1, lfpath)
    pdb.gimp_image_add_layer(img1, layer, 0)

    l2fname=level2list[model[1]-1].pict
    lfpath=dpath+l2fname
    print lfpath    
    filename=filename+level2list[model[1]-1].name
    layer = pdb.gimp_file_load_layer(img1, lfpath)
    pdb.gimp_image_add_layer(img1, layer, 0)

    l3fname=level3list[model[2]-1].pict
    lfpath=dpath+l3fname
    print lfpath    
    filename=filename+level3list[model[2]-1].name
    layer = pdb.gimp_file_load_layer(img1, lfpath)
    pdb.gimp_image_add_layer(img1, layer, 0)

    l4fname=level4list[model[3]-1].pict
    lfpath=dpath+l4fname
    print lfpath    
    filename=filename+level4list[model[3]-1].name
    layer = pdb.gimp_file_load_layer(img1, lfpath)
    pdb.gimp_image_add_layer(img1, layer, 0)

    gimp.Display(img1)

    drawable = pdb.gimp_image_get_active_drawable(img1)
    ffilename=dpath+filename+".xcf"
    print ffilename
    pdb.gimp_file_save(img1, drawable, ffilename, filename)
    return ffilename

def random_model():
    model = []
    n = random.randint(1,7)
    model.append(n)
    n = random.randint(1,6)
    model.append(n)
    n = random.randint(1,4)
    model.append(n)
    n = random.randint(1,4)
    model.append(n)
    return model

# check the presence of given detail
def check_detail(model, Glist):
    L1name=level1list[model[0]-1].name
    L2name=level2list[model[1]-1].name
    L3name=level3list[model[2]-1].name
    L4name=level4list[model[3]-1].name
    print Glist
    ck = Glist.count(L1name) + Glist.count(L2name) + Glist.count(L3name) + Glist.count(L4name)
    if ck == 0:
        Glist = Glist +" "+ L1name+" " +L2name+" " +L3name+" " +L4name
        print Glist
        return True
    else:
        print "details already used"
        return False

#check the presence of given combination of details
def check_cmb(model, Glist):
    L1name=level1list[model[0]-1].name
    L2name=level2list[model[1]-1].name
    L3name=level3list[model[2]-1].name
    L4name=level4list[model[3]-1].name
    print Glist
    ck = Glist.count( L1name+" " +L2name+" " +L3name)
    if ck == 0:
        Glist = Glist +" "+ L1name+" " +L2name+" " +L3name+" " +L4name
        print Glist
        return True
    else:
        print "this combination of the details is already used"
        return False 

if __name__ == '__main__':
    dpath = os.getcwd()+"/";
    filename="model_"
    print Glist
#    tlist = " "
    ncount = 0
    for fr in range(1, 8):
        for sl in range(1, 8):
            for cl in range(1, 6):
                for dc in range(1, 6):
                    Model=[fr,sl,cl,dc]
                    if check_model(Model) :
                        #draw_model(Model,dpath,filename)
                        ncount = ncount +1
                        #time.sleep(1)
    print "Number of all possible combinations : "
    print ncount
    
                        
                        
                        
 
