// ----------------------------------------------------
// RAWTEX
// Gimp 2.2.x & 2.3.x plugin to create raw textures & pictures.
//
// Copyright (C) 2006-2008 Franck Charlet
// All Rights Reserved.
//
// hitchhikr@australia.edu
// http://perso.wanadoo.fr/franck.charlet/
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and / or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ----------------------------------------------------

// ----------------------------------------------------
// Includes
#include <gtk/gtk.h>
#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "rawtex.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"

// ----------------------------------------------------
// Constants
#define COLOR_NAME "COLOR"

// ----------------------------------------------------
// Functions
#ifdef G_OS_WIN32
extern void (*gimp_ui_init)(const gchar *prog_name, gboolean preview);
extern GtkWidget *(*gimp_dialog_new)(const gchar *title, const gchar *role, GtkWidget *parent, GtkDialogFlags flags, GimpHelpFunc help_func, const gchar *help_id, ...);
extern gint (*gimp_dialog_run)(GimpDialog *dialog);
extern GType (*gimp_dialog_get_type)(void) G_GNUC_CONST;
#endif

// ----------------------------------------------------
// Variables
extern GtkWidget *vbox2;
extern GtkWidget *ImgLogo;
extern GtkWidget *LblCredits;
extern GtkWidget *table1;
extern GtkWidget *CbTex;
extern GtkWidget *LblTex;
extern GtkWidget *CbPal;
extern GtkWidget *LblPal;
extern GtkWidget *CbMipmap;
extern GtkWidget *LblMipmap;
extern GtkWidget *CbDxt;
extern GtkWidget *LblDxt;
extern GtkWidget *ChkKey;
extern GtkWidget *ChkSwizzle;
extern GtkWidget *ChkSrcPicture;
extern GtkWidget *ChkSrcPalette;
extern GtkWidget *hbox1;
extern GtkWidget *BtnColor;
extern GtkWidget *LblColor;
extern char string[128];

void on_CbTex_changed(GtkComboBox *combobox, gpointer user_data) {
    int cb_value;

    cb_value = gtk_combo_box_get_active(GTK_COMBO_BOX(combobox));
    switch(cb_value) {
        case 0:
            values_defaults.Dest_Format = GU_PSM_5650;
            gtk_widget_set_sensitive(GTK_WIDGET(CbPal), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSwizzle), TRUE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSrcPalette), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(CbDxt), FALSE);
            values_defaults.Use_Swizzle_Texture = TRUE;
            break;
        case 1:
            values_defaults.Dest_Format = GU_PSM_5551;
            gtk_widget_set_sensitive(GTK_WIDGET(CbPal), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSwizzle), TRUE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSrcPalette), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(CbDxt), FALSE);
            values_defaults.Use_Swizzle_Texture = TRUE;
            break;
        case 2:
            values_defaults.Dest_Format = GU_PSM_4444;
            gtk_widget_set_sensitive(GTK_WIDGET(CbPal), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSwizzle), TRUE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSrcPalette), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(CbDxt), FALSE);
            values_defaults.Use_Swizzle_Texture = TRUE;
            break;
        case 3:
            values_defaults.Dest_Format = GU_PSM_8888;
            gtk_widget_set_sensitive(GTK_WIDGET(CbPal), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSwizzle), TRUE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSrcPalette), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(CbDxt), FALSE);
            values_defaults.Use_Swizzle_Texture = TRUE;
            break;
        case 4:
            values_defaults.Dest_Format = GU_PSM_T4;
            gtk_widget_set_sensitive(GTK_WIDGET(CbPal), TRUE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSwizzle), TRUE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSrcPalette), TRUE);
            gtk_widget_set_sensitive(GTK_WIDGET(CbDxt), FALSE);
            values_defaults.Use_Swizzle_Texture = TRUE;
            break;
        case 5:
            values_defaults.Dest_Format = GU_PSM_T8;
            gtk_widget_set_sensitive(GTK_WIDGET(CbPal), TRUE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSwizzle), TRUE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSrcPalette), TRUE);
            gtk_widget_set_sensitive(GTK_WIDGET(CbDxt), FALSE);
            values_defaults.Use_Swizzle_Texture = TRUE;
            break;
        case 6:
            values_defaults.Dest_Format = GU_PSM_DXT1;
            gtk_widget_set_sensitive(GTK_WIDGET(CbPal), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSwizzle), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSrcPalette), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(CbDxt), TRUE);
            values_defaults.Use_Swizzle_Texture = FALSE;
            break;
        case 7:
            values_defaults.Dest_Format = GU_PSM_DXT3;
            gtk_widget_set_sensitive(GTK_WIDGET(CbPal), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSwizzle), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSrcPalette), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(CbDxt), TRUE);
            values_defaults.Use_Swizzle_Texture = FALSE;
            break;
        case 8:
            values_defaults.Dest_Format = GU_PSM_DXT5;
            gtk_widget_set_sensitive(GTK_WIDGET(CbPal), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSwizzle), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(ChkSrcPalette), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(CbDxt), TRUE);
            values_defaults.Use_Swizzle_Texture = FALSE;
            break;
    }       
}

void on_CbPal_changed(GtkComboBox *combobox, gpointer user_data) {
     values_defaults.Dest_Palette_Format = gtk_combo_box_get_active(GTK_COMBO_BOX(combobox));
}

void on_CbMipmap_changed(GtkComboBox *combobox, gpointer user_data) {
     values_defaults.Nbr_MipMaps = gtk_combo_box_get_active(GTK_COMBO_BOX(combobox));
}

void on_CbDxt_changed(GtkComboBox *combobox, gpointer user_data) {
     values_defaults.Dxt_Type = gtk_combo_box_get_active(GTK_COMBO_BOX(combobox));
}

void on_ChkKey_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    int chk_value;

    chk_value = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));
    values_defaults.Use_Alpha_Color = chk_value;
    gtk_widget_set_sensitive(GTK_WIDGET(BtnColor), chk_value);
}

void on_ChkSwizzle_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    int chk_value;

    chk_value = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));
    values_defaults.Swizzle_Texture = chk_value;

    switch(values_defaults.Dest_Format) {
        case GU_PSM_DXT1:
        case GU_PSM_DXT3:
        case GU_PSM_DXT5:
            values_defaults.Use_Swizzle_Texture = FALSE;
            break;
        default:
            values_defaults.Use_Swizzle_Texture = chk_value;
            break;
    }       
}

void on_ChkSrcPicture_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    int chk_value;

    chk_value = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));
    values_defaults.Save_Picture_Source = chk_value;
}

void on_ChkSrcPalette_toggled(GtkToggleButton *togglebutton, gpointer user_data) {
    int chk_value;

    chk_value = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(togglebutton));
    values_defaults.Save_Palette_Source = chk_value;
}

void on_BtnColor_clicked(GtkButton *button, gpointer user_data) {
    GtkWidget *dlg;
    gint run;
    gboolean ok;
    guint old_color;

    old_color = values_defaults.Alpha_Color;

    gimp_ui_init(COLOR_NAME, TRUE);
    dlg = gimp_dialog_new("Choose the color key", COLOR_NAME,
                          NULL, (GtkDialogFlags) 0,
                          NULL, NULL,
                          GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                          GTK_STOCK_OK, GTK_RESPONSE_OK,
                          NULL);
    create_winColor (dlg);

    gtk_widget_show_all(dlg);

    ok = FALSE;
    do {
        run = gimp_dialog_run(GIMP_DIALOG(dlg));
        switch (run) {
            default:
                ok = TRUE;
                break;
        }
    } while(!ok);

    gtk_widget_destroy(dlg);
    if(run != GTK_RESPONSE_OK) {
        values_defaults.Alpha_Color = old_color;
        sprintf(string, "#%.6X",  old_color);
        gtk_label_set_text(GTK_LABEL(LblColor), string);
    }
}

void on_Color_Changed(GtkColorSelection *ColorSelection, gpointer user_data) {
    GdkColor color_value;
    double val_red;
    double val_green;
    double val_blue;
    int ired;
    int igreen;
    int iblue;

    gtk_color_selection_get_current_color(GTK_COLOR_SELECTION(ColorSelection), &color_value);
    val_red = ((color_value.red * 256.0) / 65536.0);
    val_green = (((color_value.green * 256.0) / 65536.0));
    val_blue = ((color_value.blue * 256.0) / 65536.0);
    ired = (int) val_red << 16;
    igreen = (int) val_green << 8;
    iblue = (int) val_blue;
    values_defaults.Alpha_Color = ired;
    values_defaults.Alpha_Color |= igreen;
    values_defaults.Alpha_Color |= iblue;
    sprintf(string, "#%.6X", (guint) values_defaults.Alpha_Color);
    gtk_label_set_text(GTK_LABEL(LblColor), string);
}
