// ----------------------------------------------------
// RAWTEX
// Gimp 2.2.x & 2.3.x plugin to create raw textures & pictures.
//
// Copyright (C) 2006-2008 Franck Charlet
// All Rights Reserved.
//
// hitchhikr@australia.edu
// http://perso.wanadoo.fr/franck.charlet/
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and / or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ----------------------------------------------------

// ----------------------------------------------------
// Includes
#include "rawtex.h"

// ----------------------------------------------------
// Fucntions
extern const gchar *(*gimp_plug_in_directory_)(void);

// ----------------------------------------------------
// Variables
char *Config_Keys[] = {
    "Dest_Format",
    "Dest_Palette_Format",
    "Nbr_MipMaps",
    "Use_Alpha_Color",
    "Alpha_Color",
    "Swizzle_Texture",
    "Use_Swizzle_Texture",
    "Save_Picture_Source",
    "Save_Palette_Source",
    "Dxt_Type"
};
char Config_FileName[512];

// ----------------------------------------------------
// Check the validity of a key
int Get_Config_Key(char *KeyName) {
    int i;
    for(i = 0; i < sizeof(Config_Keys) / 4; i++) {
        if(!strcmp(KeyName, Config_Keys[i])) return(i);
    }
    return(-1);
}

// ----------------------------------------------------
// Fill the default values structure from the config file
void Load_Config(LPPluginValues Values) {
    FILE *Config_File;
    char Config_Key[64];
    int Config_Value;
    int i;
    int Config_Idx;
    int phony;
#ifdef G_OS_WIN32
    sprintf(Config_FileName, "%s\\rawtex.config", gimp_plug_in_directory_());
#else
    sprintf(Config_FileName, "%s\\rawtex.config", gimp_plug_in_directory());
#endif
    Config_File = fopen(Config_FileName, "r");
    if(Config_File) {
        phony = fscanf(Config_File, "%s", (char *) &Config_Key);
        if(!strcmp(Config_Key, "RAWTEX")) {
            for(i = 0; i < sizeof(Config_Keys) / 4; i++) {
                phony = fscanf(Config_File, "%s %d", (char *) &Config_Key, &Config_Value);
                Config_Idx = Get_Config_Key(Config_Key);
                if(Config_Idx == -1) break;
                switch(Config_Idx) {
                    case 0:
                        Values->Dest_Format = Config_Value;
                        break;
                    case 1:
                        Values->Dest_Palette_Format = Config_Value;
                        break;
                    case 2:
                        Values->Nbr_MipMaps = Config_Value;
                        break;
                    case 3:
                        Values->Use_Alpha_Color = Config_Value;
                        break;
                    case 4:
                        Values->Alpha_Color = Config_Value;
                        break;
                    case 5:
                        Values->Swizzle_Texture = Config_Value;
                        break;
                    case 6:
                        Values->Use_Swizzle_Texture = Config_Value;
                        break;
                    case 7:
                        Values->Save_Picture_Source = Config_Value;
                        break;
                    case 8:
                        Values->Save_Palette_Source = Config_Value;
                        break;
                    case 9:
                        Values->Dxt_Type = Config_Value;
                        break;
                }
            }
            switch(Values->Dest_Format) {
                case GU_PSM_DXT1:
                case GU_PSM_DXT3:
                case GU_PSM_DXT5:
                    Values->Use_Swizzle_Texture = FALSE;
                    break;
            }
        }
        fclose(Config_File);
    }
}

// ----------------------------------------------------
// Save the config file
void Save_Config(LPPluginValues Values) {
    FILE *Config_File;
#ifdef G_OS_WIN32
    sprintf(Config_FileName, "%s\\rawtex.config", gimp_plug_in_directory_());
#else
    sprintf(Config_FileName, "%s\\rawtex.config", gimp_plug_in_directory());
#endif
    Config_File = fopen(Config_FileName, "w");
    if(Config_File) {
        fprintf(Config_File, "RAWTEX\n");
        fprintf(Config_File, "%s %d\n", Config_Keys[0], Values->Dest_Format);
        fprintf(Config_File, "%s %d\n", Config_Keys[1], Values->Dest_Palette_Format);
        fprintf(Config_File, "%s %d\n", Config_Keys[2], Values->Nbr_MipMaps);
        fprintf(Config_File, "%s %d\n", Config_Keys[3], Values->Use_Alpha_Color);
        fprintf(Config_File, "%s %d\n", Config_Keys[4], Values->Alpha_Color);
        fprintf(Config_File, "%s %d\n", Config_Keys[5], Values->Swizzle_Texture);
        fprintf(Config_File, "%s %d\n", Config_Keys[6], Values->Use_Swizzle_Texture);
        fprintf(Config_File, "%s %d\n", Config_Keys[7], Values->Save_Picture_Source);
        fprintf(Config_File, "%s %d\n", Config_Keys[8], Values->Save_Palette_Source);
        fprintf(Config_File, "%s %d\n", Config_Keys[9], Values->Dxt_Type);
        fclose(Config_File);
    }
}
