// ----------------------------------------------------
// RAWTEX
// Gimp 2.2.x & 2.3.x plugin to create raw textures & pictures.
//
// Copyright (C) 2006-2008 Franck Charlet
// All Rights Reserved.
//
// hitchhikr@australia.edu
// http://perso.wanadoo.fr/franck.charlet/
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and / or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ----------------------------------------------------

#ifndef _RAW_H_
#define _RAW_H_

// ----------------------------------------------------
// Includes
#include <gtk/gtk.h>

// ----------------------------------------------------
// Constants
#define PLUGIN_VERSION "1.06"
#define PROCEDURE_NAME "RAWTEX"

#define GU_PSM_5650 0
#define GU_PSM_5551 1
#define GU_PSM_4444 2
#define GU_PSM_8888 3
#define GU_PSM_T4 4
#define GU_PSM_T8 5
#define GU_PSM_T16 6
#define GU_PSM_T32 7
#define GU_PSM_DXT1 8
#define GU_PSM_DXT3 9
#define GU_PSM_DXT5 10

#define DXT_TYPE_PSP 0
#define DXT_TYPE_OGL 1

// ----------------------------------------------------
// Structures
typedef struct {
    gint Dest_Format;
    gint Dest_Palette_Format;
    gint Nbr_MipMaps;
    gint Use_Alpha_Color;
    gint Alpha_Color;
    gint Swizzle_Texture;
    gint Use_Swizzle_Texture;
    gint Save_Picture_Source;
    gint Save_Palette_Source;
    gint Dxt_Type;
} PluginValues, *LPPluginValues;

// ----------------------------------------------------
// Variables
extern PluginValues values_defaults;

#endif
