// ----------------------------------------------------
// RAWTEX
// Gimp 2.2.x & 2.3.x plugin to create raw textures & pictures.
//
// Copyright (C) 2006-2008 Franck Charlet
// All Rights Reserved.
//
// hitchhikr@australia.edu
// http://perso.wanadoo.fr/franck.charlet/
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and / or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ----------------------------------------------------

// ----------------------------------------------------
// Includes
#include <sys/types.h>
#include <sys/stat.h>
#ifndef G_OS_WIN32
#include <unistd.h>
#endif
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include "support.h"

GtkWidget* lookup_widget(GtkWidget *widget, const gchar *widget_name) {
    GtkWidget *parent;
    GtkWidget *found_widget;

    for(;;) {
        if(GTK_IS_MENU (widget)) parent = gtk_menu_get_attach_widget(GTK_MENU(widget));
        else parent = widget->parent;
        if(!parent) parent = (GtkWidget *) g_object_get_data(G_OBJECT (widget), "GladeParentKey");
        if(parent == NULL) break;
        widget = parent;
    }

    found_widget = (GtkWidget*) g_object_get_data (G_OBJECT (widget), widget_name);
    if(!found_widget) g_warning("Widget not found: %s", widget_name);
    return(found_widget);
}

/* This is used to set ATK action descriptions. */
void glade_set_atk_action_description(AtkAction *action, const gchar *action_name, const gchar *description) {
    gint n_actions;
    gint i;

    n_actions = atk_action_get_n_actions(action);
    for(i = 0; i < n_actions; i++) {
        if(!strcmp (atk_action_get_name(action, i), action_name)) atk_action_set_description(action, i, description);
    }
}
