// ----------------------------------------------------
// RAWTEX
// Gimp 2.2.x & 2.3.x plugin to create raw textures & pictures.
//
// Copyright (C) 2006-2008 Franck Charlet
// All Rights Reserved.
//
// hitchhikr@australia.edu
// http://perso.wanadoo.fr/franck.charlet/
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and / or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
// ----------------------------------------------------

// Dirty hack to make it to work under windows as creating plugins under that system is a pain in the ass
// (Not to speak about compiling the libgimp.a itself).

HMODULE GimpLibBase;
HMODULE GimpBaseLibBase;
HMODULE GimpUiLibBase;
HMODULE GimpWidgetsLibBase;

void (*gimp_ui_init)(const gchar *prog_name, gboolean preview);
void (*gimp_install_procedure)(const gchar *name,
                               const gchar *blurb,
                               const gchar *help,
                               const gchar *author,
                               const gchar *copyright,
                               const gchar *date,
                               const gchar *menu_label,
                               const gchar *image_types,
                               GimpPDBProcType type,
                               gint n_params,
                               gint n_return_vals,
                               const GimpParamDef *params,
                               const GimpParamDef *return_vals);
GimpImageType (*gimp_drawable_type)(gint32 drawable_ID);
GimpDrawable *(*gimp_drawable_get)(gint32 drawable_ID);
gboolean (*gimp_progress_init)(const gchar *message);
gboolean (*gimp_progress_update)(gdouble percentage);
void (*gimp_pixel_rgn_init)(GimpPixelRgn *pr,
                            GimpDrawable *drawable,
                            gint x,
                            gint y,
                            gint width,
                            gint height,
                            gint dirty,
                            gint shadow);
void (*gimp_pixel_rgn_get_rect) (GimpPixelRgn *pr,
                            guchar *buf,
                            gint x,
                            gint y,
                            gint width,
                            gint height);
gboolean (*gimp_register_save_handler)(const gchar *procedure_name,
                                       const gchar *extensions,
                                       const gchar *prefixes);
guchar *(*gimp_image_get_colormap)(gint32 image_ID, gint *num_colors);
gint (*gimp_main)(const GimpPlugInInfo *info, gint argc, gchar *argv[]);
GtkWidget *(*gimp_dialog_new)(const gchar *title,
                              const gchar *role,
                              GtkWidget *parent,
                              GtkDialogFlags flags,
                              GimpHelpFunc help_func,
                              const gchar *help_id, ...) G_GNUC_NULL_TERMINATED;
gint (*gimp_dialog_run)(GimpDialog *dialog);
GType (*gimp_dialog_get_type)(void) G_GNUC_CONST;
const gchar *(*gimp_plug_in_directory_)(void);

int Load_GimpLib(void) {
    int Result = TRUE;
    if(!GimpLibBase) {
        GimpLibBase = LoadLibrary("libgimp-2.0-0.dll");
        if(GimpLibBase) {
            gimp_install_procedure = (void *) GetProcAddress(GimpLibBase, "gimp_install_procedure");
            gimp_drawable_type = (void *) GetProcAddress(GimpLibBase, "gimp_drawable_type");
            gimp_drawable_get = (void *) GetProcAddress(GimpLibBase, "gimp_drawable_get");
            gimp_progress_init = (void *) GetProcAddress(GimpLibBase, "gimp_progress_init");
            gimp_progress_update = (void *) GetProcAddress(GimpLibBase, "gimp_progress_update");
            gimp_pixel_rgn_init = (void *) GetProcAddress(GimpLibBase, "gimp_pixel_rgn_init");
            gimp_pixel_rgn_get_rect = (void *) GetProcAddress(GimpLibBase, "gimp_pixel_rgn_get_rect");
            gimp_register_save_handler = (void *) GetProcAddress(GimpLibBase, "gimp_register_save_handler");
            gimp_image_get_colormap = (void *) GetProcAddress(GimpLibBase, "gimp_image_get_colormap");
            gimp_main = (void *) GetProcAddress(GimpLibBase, "gimp_main");      
        } else {
            Result = FALSE;
        }
    }
    if(!GimpBaseLibBase) {
        GimpBaseLibBase = LoadLibrary("libgimpbase-2.0-0.dll");
        if(GimpBaseLibBase) {
            gimp_plug_in_directory_ = (void *) GetProcAddress(GimpBaseLibBase, "gimp_plug_in_directory");
        } else {
            Result = FALSE;
        }
    }
    if(!GimpUiLibBase) {
        GimpUiLibBase = LoadLibrary("libgimpui-2.0-0.dll");
        if(GimpUiLibBase) {
            gimp_ui_init = (void *) GetProcAddress(GimpUiLibBase, "gimp_ui_init");
        } else {
            Result = FALSE;
        }
    }
    if(!GimpWidgetsLibBase) {
        GimpWidgetsLibBase = LoadLibrary("libgimpwidgets-2.0-0.dll");
        if(GimpWidgetsLibBase) {
            gimp_dialog_new = (void *) GetProcAddress(GimpWidgetsLibBase, "gimp_dialog_new");
            gimp_dialog_run = (void *) GetProcAddress(GimpWidgetsLibBase, "gimp_dialog_run");
            gimp_dialog_get_type = (void *) GetProcAddress(GimpWidgetsLibBase, "gimp_dialog_get_type");
        } else {
            Result = FALSE;
        }
    }
    return(Result);
}
