#!/bin/bash
# bashufraw.sh

for file in `ls *.CR2`
do
	ufraw-batch $file --output=b${file%.CR2}n1.tif --exposure=auto --out-type=tif --noexif  --base-curve=linear --curve=linear --clip=film --restore=lch --saturation=1.30
	ufraw-batch $file --output=t${file%.CR2}n1_-1.tif --exposure=-1 --out-type=tif --noexif  --base-curve=linear --curve=linear --clip=digital --saturation=1.10
	ufraw-batch $file --output=t${file%.CR2}n1_0.tif --exposure=0 --out-type=tif --noexif  --base-curve=linear --curve=linear --clip=digital --saturation=1.10
	ufraw-batch $file --output=t${file%.CR2}n1_2.tif --exposure=2 --out-type=tif --noexif  --base-curve=linear --curve=linear --clip=digital --saturation=1.10

	enfuse -o en${file%.CR2}n1.tif t${file%.CR2}n1_-1.tif t${file%.CR2}n1_0.tif t${file%.CR2}n1_2.tif

	rm t${file%.CR2}n1_-1.tif
	rm t${file%.CR2}n1_0.tif
	rm t${file%.CR2}n1_2.tif
done

gimp -i -b "(manual-lens-mf \"en*.tif\")" -b "(gimp-quit 0)"
gimp -i -b "(manual-lens-mf \"b*.tif\")" -b "(gimp-quit 0)"

echo "Done!"

# ${file%.CR2} = the $file variable without the ".CR2" part!

