(define (manual-lens-mf pattern)
(let*
	(
		(filelist (cadr (file-glob pattern 1)))
	)
	(while (not (null? filelist))
		(let*
			(
			(filename (car filelist))
			(image (car (gimp-file-load RUN-NONINTERACTIVE filename filename)))
			(drawable (car (gimp-image-get-active-layer image)))
			)
		(gimp-levels drawable 1 15 233 1 0 255)
		(gimp-levels drawable 2 0 239 1 0 255)
		(gimp-levels drawable 3 6 255 1 0 255)
		(gimp-hue-saturation drawable 0 0 0 +17)
		(gimp-levels drawable 0 0 255 1.20 14 255)
		(plug-in-unsharp-mask 1 image drawable 0.7 0.5 0)
		(gimp-file-save 1 image drawable (string-append "g" filename) (string-append "g" filename))
		(gimp-image-delete image)
		(set! filelist (cdr filelist))
		)
	)
)
)
