#!/usr/bin/env python
# -*- coding: utf-8 -*-

'''
Copyright: Remigio Conti 2010
Licence: GPL

Based on the plugin batchwork.py Version 1.04 by Alexander Hadjiivanov 2010

Difference:

- Reported only the Bump Map portion of the code by Alexander
- The watermark is bumped with font size specified by the user (result is a text box more small)
- Position is specified as corner of the image
- Added offset (horizontal and vertical) for the watermark,from the border of the image
- Added choice for orizontal or vertical position

Installation: copy the "batchwork.py" file into your $HOME/.gimp-2.x/plug-ins directory.
On Linux and Mac OSX the file must be executable.
The scripts appear under the <Image>/Tools/Batchwork/ menu entry

Version 1.0
  - Initial release based on Version 1.04 of batchwork.py by Alexander Hadjiivanov 2010

Version 1.01
  - Changed help text to show author info

Version 1.02
  - M$ Windows Bug fix: changed way to build output file path (see line 155 in source code)

'''

from gimpfu import *
import os, glob, re
# i18n
import gettext

'''
Batch watermarking with a bump map
Based on the iccii "Texturizer" script (ported from script-fu to python-fu and added a batch mode)
          WARNING
Please double-check whether you have selected the correct output directory. If the
input directory and the output directory are the same, the script will replace the
original files.
'''

locale_directory = gimp.locale_directory
gettext.install( "gimp20-batchtools", locale_directory, unicode=True )

Watermark_help = _("Watermarking of multiple images with a bump map.\nV.1.02 ©2011 Remigio Conti - based on Version 1.04 of batchwork.py by Alexander Hadjiivanov")
Watermark_description = Watermark_help

def python_fu_batchtools_watermark(
  indirectory,
  outdirectory,
  ext,
  angle,
  elevation,
  depth,
  waterlevel,
  ambient,
  position,
  horiz_offs,
  vert_offs,
  fontname,
  font_p,
  orientation,
  copyright):

  if os.path.exists( u''+indirectory ):
    if ext == 0:
      inglobpattern = u''+indirectory + os.sep + '*.' + "[Jj][Pp][Ee][Gg]"
      infilepathnames = glob.glob( inglobpattern )
      inglobpattern = u''+indirectory + os.sep + '*.' + "[Jj][Pp][Gg]"
      infilepathnames.extend(glob.glob( inglobpattern ))
    elif ext==1:
      inglobpattern = u''+indirectory + os.sep + '*.' + "[Gg][Ii][Ff]"
      infilepathnames = glob.glob( inglobpattern )
    elif ext==2:
      inglobpattern = u''+indirectory + os.sep + '*.' + "[Pp][Nn][Gg]"
      infilepathnames = glob.glob( inglobpattern )

    if os.path.exists( u''+outdirectory ):
      if infilepathnames:
        messagebox = pdb.gimp_message_get_handler( )
        pdb.gimp_message_set_handler( 2 ) # send messages in error console
        # Start the process
        num_images=0

        for infilepathname in infilepathnames:
          img = pdb.gimp_file_load( infilepathname, infilepathname )
          imglayer= img.layers[0]
          imgwidth = pdb.gimp_image_width(img)
          imgheight = pdb.gimp_image_height(img)

          # Process the files
          # Perform some initialisation procedures
          texture_layer = gimp.Layer(img, _("Texture"), imgwidth,imgheight,RGBA_IMAGE,100,NORMAL_MODE)
          pdb.gimp_image_undo_disable(img)
          pdb.gimp_image_add_layer(img,texture_layer, 0)
          pdb.gimp_drawable_fill(texture_layer, 3)
          
	  if imgwidth>imgheight:
	      font_size=round(imgwidth*font_p/1000)
	  else:
	      font_size=round(imgheight*font_p/1000)

          # Create the texture layer from the string containing the copyright text
          textBoxWidth,textBoxHeight,fontAscent,fontDescent = pdb.gimp_text_get_extents_fontname(copyright, font_size, PIXELS, fontname)
          
	  if orientation==0:
              if position==0:
                  x_cord = horiz_offs
                  y_cord = vert_offs
                  texture_layer=pdb.gimp_text_fontname( img,texture_layer,x_cord,y_cord,copyright,0,True,font_size,PIXELS,fontname)
              elif position==1:
                  x_cord = imgwidth-textBoxWidth-horiz_offs
                  y_cord = vert_offs
                  texture_layer=pdb.gimp_text_fontname( img,texture_layer,x_cord,y_cord,copyright,0,True,font_size,PIXELS,fontname)
              elif position==2:
                  x_cord = horiz_offs
                  y_cord = imgheight-textBoxHeight-vert_offs
                  texture_layer=pdb.gimp_text_fontname( img,texture_layer,x_cord,y_cord,copyright,0,True,font_size,PIXELS,fontname)
              elif position==3:
                  x_cord = imgwidth-textBoxWidth-horiz_offs
                  y_cord = imgheight-textBoxHeight-vert_offs
                  texture_layer=pdb.gimp_text_fontname( img,texture_layer,x_cord,y_cord,copyright,0,True,font_size,PIXELS,fontname)
          else:
	      if position==0:
                  x_cord = horiz_offs
                  y_cord = textBoxWidth+vert_offs
                  texture_layer=pdb.gimp_text_fontname( img,texture_layer,x_cord,y_cord,copyright,0,True,font_size,PIXELS,fontname)
                  texture_layer_id = pdb.gimp_drawable_transform_rotate_simple(texture_layer,2,False,x_cord,y_cord,False)
              elif position==1:
                  x_cord = imgwidth-horiz_offs
                  y_cord = textBoxWidth+vert_offs-textBoxHeight
                  texture_layer=pdb.gimp_text_fontname( img,texture_layer,x_cord,y_cord,copyright,0,True,font_size,PIXELS,fontname)
                  texture_layer_id = pdb.gimp_drawable_transform_rotate_simple(texture_layer,2,False,x_cord,y_cord+textBoxHeight,False)
              elif position==2:
                  x_cord = horiz_offs
                  y_cord = imgheight-vert_offs
                  texture_layer=pdb.gimp_text_fontname( img,texture_layer,x_cord,y_cord,copyright,0,True,font_size,PIXELS,fontname)
                  texture_layer_id = pdb.gimp_drawable_transform_rotate_simple(texture_layer,2,False,x_cord,y_cord,False)
              elif position==3:
                  x_cord = imgwidth-horiz_offs
                  y_cord = imgheight-textBoxHeight-vert_offs
                  texture_layer=pdb.gimp_text_fontname( img,texture_layer,x_cord,y_cord,copyright,0,True,font_size,PIXELS,fontname)
                  texture_layer_id = pdb.gimp_drawable_transform_rotate_simple(texture_layer,2,False,x_cord,y_cord+textBoxHeight,False)
          
	  pdb.gimp_drawable_set_visible(imglayer,False)
          texture_layer=pdb.gimp_image_merge_visible_layers(img,CLIP_TO_IMAGE)
          pdb.gimp_drawable_set_visible(imglayer,True)
          pdb.plug_in_bump_map(img,imglayer,texture_layer,angle,elevation,depth, 0, 0, waterlevel, ambient, True, False, 0)
          pdb.gimp_image_remove_layer(img,texture_layer)
          #outfilepathname=re.sub(u''+indirectory,u''+outdirectory,infilepathname)
	  outfilepathname=outdirectory+os.sep+os.path.basename(infilepathname)
          pdb.gimp_file_save(img,imglayer,outfilepathname,outfilepathname)
          pdb.gimp_image_delete(img)
	  num_images=num_images + 1

        # Give some feedback
        pdb.gimp_message("Watermarking completed successfully! Processed " + str(num_images) + " images.")
        pdb.gimp_message_set_handler( messagebox )
      else:
        pdb.gimp_message( _("There are no files in %s") %(indirectory ) )
    else:
      pdb.gimp_message( _("%s doesn't exist") %(outdirectory) )
  else:
    pdb.gimp_message( _("%s doesn't exist") %(indirectory) )


# Register plugin

register(
   "python-fu-batchtools-watermark",
   Watermark_description,
   Watermark_help,
   "Remigio Conti",
   "GPL License",
   "2010",
   _("Watermark"),
   "",
   [
      (PF_DIRNAME, "indirectory", _("Input Directory"), os.getcwd() ),
      (PF_DIRNAME, "outdirectory", _("Output Directory"), os.getcwd() ),
      (PF_OPTION, "ext", _("Extension"), 0, ["JPEG", "GIF", "PNG"]),
      (PF_SPINNER, "angle", _("Angle"), 135, (0,360,1)),
      (PF_SPINNER, "elevation", _("Elevation"), 40.0, (0.5,90,0.5)),
      (PF_SPINNER, "depth", _("Depth"), 25, (1,65,1)),
      (PF_SPINNER, "waterlevel", _("Waterlevel"), 7, (0,255,1)),
      (PF_SPINNER, "ambient", _("Ambient"), 30, (0,255,1)),
      (PF_OPTION, "position", _("Position (corner)"), 3, ["Up-Left","Up-Right","Down-Left","Down-Right"]),
      (PF_SPINNER, "horiz_offs", _("Horizontal Offset (Px)"), 20, (1,100,1)),
      (PF_SPINNER, "vert_offs", _("Vertical Offset (Px)"), 20, (1,100,1)),
      (PF_FONT, "fontname", _("Font"), "FreeMono Bold"),
      (PF_SPINNER, "font_p", _("Font Size (0.1% of the longest side)"), 20, (1,100,1)),
      (PF_OPTION, "orientation", _("Orientation"), 0, ["Horizontal", "Vertical"]),
      (PF_STRING, "copyright", _("Watermark Text"), "© Your Watermark Text Here"),
   ],
   [],
   python_fu_batchtools_watermark,
   menu="<Image>/Tools/BatchTools",
   domain=( "gimp20-batchtools", locale_directory)
   )

main()
