from gimpfu import *
import gtk
import os
import collections
import ctypes

def divide_layer(img, drawable, width, height) :
        """****f* divide-layer/divide_layer
        *       DESCRIPTION
        *               Python-fu function, creates new layers holding copied regions from the active layer of an image
        *       ARGUMENTS
        *               img             -- python-fu image
        *               drawable        -- python-fu drawable
        *               width           -- width (in pixels) of regions to copy
        *               height          -- height (in pixels) of regions to copy
        *       SIDE EFFECTS
        *               Appends copy layers to image layer list
        *       RESULT
        *               None.
        *****"""
        MessageBox = ctypes.windll.user32.MessageBoxA

        hslices = img.width / width
        if 0 != (img.width % width) :
                hslices += 1

        vslices = img.height / height
        if 0 != (img.height % height) :
                vslices += 1

        layer_to_slice = img.active_layer

        for i in range(vslices) :
                for j in range(hslices) :
                        layer = layer_to_slice.copy()
                        layer.name = '(' + str(j) + ',' + str(i) + ')'
                        img.add_layer(layer, len(img.layers))
                        layer.resize(width, height, -1 * (j * width), -1 * (i * height))


        return None

"""****h* divide-layer/divide-layer
*       DESCRIPTION
*               Python-fu plug-in to divide a layer into smaller sections
*       ARGUMENTS
*               None.
*       SIDE EFFECTS
*               Adds to GIMP menu "Layer", submenu "Transform", item "Divide"
*       RESULT
*               None.
*       NOTE
*               Function is only available when an active image is open in GIMP.
*               Active layer is the layer that is divided.
*       SOURCE
*"""
register(
        #name
        "divide_layer",
        #blurb
        "Divide active layer into sections",
        #help
        "Select the layer you want to divide from an image",
        #author
        "Code Fox",
        #copyright
        "http://en.wikipedia.org/wiki/MIT_License",
        #date
        "March 4th, 2013",
        #menu path
        "<Image>/Layer/Transform/Divide",
        #image types
        "*",
        #params
        [
            (PF_INT, "width", "px width", None),
            (PF_INT, "height", "pc height", None),
        ],
        #results
        [],
        #function
        divide_layer
)

main()
"""*******"""