import os

from gimpfu import *

def plugin_main(image, drawable, size, crop):
    """main function for the plugin"""
    if size > 1024 or size < 1:
        raise Exception("Invalid output size!")
    w, h = image.width, image.height
    if w < 1 or h < 1:
        raise Exception("Invalid image size!")
    print "width: %d height: %d"%(w, h)
    outname = os.path.splitext(os.path.basename(image.name))[0] + "-casefied"
    image = pdb.gimp_image_duplicate(image)
    #drawable = pdb.gimp_image_get_active_drawable(image)
    layer = pdb.gimp_image_flatten(image)
    drawable = layer
    pdb.gimp_layer_add_alpha(layer)
    if crop:
        # select and remove borders -- works fine with CDs scans
        pdb.gimp_fuzzy_select(drawable, 0, 0, 50, 0, 1, 0, 0, 0)
        pdb.gimp_fuzzy_select(drawable, w-1, 0, 50, 0, 1, 0, 0, 0)
        pdb.gimp_fuzzy_select(drawable, 0, h-1, 50, 0, 1, 0, 0, 0)
        pdb.gimp_fuzzy_select(drawable, w-1, h-1, 50, 0, 1, 0, 0, 0)
        pdb.gimp_edit_clear(drawable)
        # crop image to the CD circumference
        pdb.gimp_selection_invert(image)
        non_empty, x1, y1, x2, y2 = pdb.gimp_selection_bounds(image)
        pdb.gimp_image_crop(image, x2 - x1, y2 - y1, x1, y1)
        print "after crop width: %d height: %d"%(w, h)
        w, h = image.width, image.height
        if w < 1 or h < 1:
            raise Exception("Invalid image size after crop!")
    pdb.gimp_ellipse_select(image, 0, 0, w, h, 2, 1, 0, 0)
    pdb.gimp_selection_invert(image)
    pdb.gimp_edit_clear(drawable)
    # remove middle circle
    # about 20% of the image size
    if w < h:
        d = w * 0.2
    else:
        d = h * 0.2
    pdb.gimp_ellipse_select(image, (w/2)-(d/2), (h/2)-(d/2), d, d, 2, 1, 0, 0)
    #pdb.gimp_fuzzy_select(drawable, w/2, h/2, 50, 2, 1, 0, 0, 0)
    pdb.gimp_edit_clear(drawable)
    # resize
    x1 = (206 * size) / 1024
    x2 = (875 * size) / 1024
    y1 = (79 * size) / 1024
    y2 = (670 * size) / 1024
    x, y, width, height = (x1, y1, x2-x1, y2-y1)
    print "x1: %d, y1: %d, x2: %d, y2: %d, width: %d, height: %d"%(x1, y1, x2, y2, width, height)
    pdb.gimp_image_scale(image, width, height)
    pdb.gimp_selection_all(image)
    pdb.gimp_edit_copy_visible(image)
    # load bottom
    raw_filename = "rhythmbox-missing-artwork-bottom.svg"
    casebottom = pdb.file_svg_load("%s/plug-ins/cdcasefier/%s"%(gimp.directory, raw_filename), outname, 90, size, size, 0)
    pdb.gimp_image_set_filename(casebottom, outname)
    drawablebottom = pdb.gimp_image_get_active_drawable(casebottom)
    pdb.gimp_drawable_set_name(drawablebottom, "CD Case")
    pdb.gimp_rect_select(casebottom, x, y, width, height, 2, 0, 0)
    pdb.gimp_edit_paste(drawablebottom, 1)
    # load top
    raw_filename = "rhythmbox-missing-artwork-top.svg"
    casetop = pdb.file_svg_load("%s/plug-ins/cdcasefier/%s"%(gimp.directory, raw_filename), raw_filename, 90, size, size, 0)
    pdb.gimp_selection_all(casetop)
    pdb.gimp_edit_copy(pdb.gimp_image_get_active_drawable(casetop))
    floating_sel = pdb.gimp_edit_paste(drawablebottom, 1)
    pdb.gimp_selection_all(casebottom)
    pdb.gimp_floating_sel_anchor(floating_sel)
    pdb.gimp_selection_none(casebottom)
    print "%s - %s"%(casebottom.name, casebottom.filename)
    display = pdb.gimp_display_new(casebottom)

register(
    "python-fu-cdcasefier",
    N_("GIMP plug-in to put a CD image into a case"),
    """This plugin will put a CD image into a case.""",
    "Fernando Vicente",
    "Fernando Vicente",
    "2011",
    N_("_CD Casefier..."),
    "*",
    [
        (PF_IMAGE, "image", "Input image", None),
        (PF_DRAWABLE, "drawable", "Input drawable" , None),
        (PF_INT, "size", "Output size (maximum 1024)" , 256),
        (PF_BOOL, "crop", "Try to crop corners" , True),
    ],
    [],
    plugin_main,
    menu="<Image>/Filters/Artistic",
    domain=("gimp20 - python", gimp.locale_directory)
)

main()
