#!/usr/bin/env python
# -*- coding: utf-8 -*-

from gimpfu import *

terms_of_use = """
  This program is free software; you can redistribute it
  and/or modify it under the terms of the GNU General
  Public License as published by the Free Software Foun-
  dation; either version 2 of the License
  
  This program is distributed in the hope that it will be 
  useful, but WITHOUT ANY WARRANTY; without even the 
  implied warranty of MERCHANTABILITY or FITNESS FOR A 
  PARTICULAR PURPOSE.  See the GNU General Public 
  License for more details.
"""

nutzungsbedingung = """
  Dieses Programm ist freie Software. Sie dürfen es weiter-
  verteilen und / oder modifizieren. Es gelten die Bedin-
  gungen der GNU General Public License,Version 2, wie sie 
  von der Free Software Foundation veröffentlicht wurden. 
  
  Dieses Programm wird in Umlauf gebracht in der Hoffnung 
  das Sie einen Nutzen davon haben.Trotz aller Bemühun-
  gen können Fehler nicht ausgeschlossen werde. Es kann
  deshalb keine Garantie für Schäden an Hard und Soft-
  ware übernummen werden, welche durch die Ausführung 
  dieses Skriptes entsteht.
"""

#### DEFAULTS ###########

DefBlur = {
  'horizontal'  : 10, 
  'vertical'    : 10,
  'method'      : 1
}

DefBump = {
  'azimuth'     : 55, 
  'elevation'   : 7,
  'depth'       : 17, 
  'xofs'        : 0, 
  'yofs'        : 0, 
  'waterlevel'  : 56, 
  'ambient'     : 32, 
  'compensate'  : True, 
  'invert'      : False, 
  'type'        : 0
}

DefDiamond = { #coordinates (x,y)
  'top_x'       : 0,
  'top_y'       : 0,
  'left_x'      : 0,
  'left_y'      : 0,
  'bottom_x'    : 0,
  'bottom_y'    : 0,
  'right_x'     : 0,
  'right_y'     : 0
}

PaintBrush = {
  'fade_out'       : 0, 
  'num_strokes'    : 0, 
  'strokes'        : [], 
  'method'         : 0, 
  'gradient_length': 0
}

FuzzySelect = {
  'x'                 : 0,
  'y'                 : 0, 
  'threshold'         : 10, 
  'operation'         : CHANNEL_OP_REPLACE, 
  'antialias'         : True, 
  'feather'           : False, 
  'feather_radius_x'  : 0, 
  'feather_radius_y'  : 0, 
  'sample_merged'     : False,
  'select_transparent': True, 
  'select_criterion'  : SELECT_CRITERION_COMPOSITE
}

def getDiamond(fx1, fy1, fx2, fy2):
  d               = DefDiamond
  d['top_x']      = int(fx1 + (fx2 - fx1)/2)
  d['top_y']      = fy1
  d['left_x']     = fx1
  d['left_y']     = int(fy1 + (fy2 - fy1)/2)
  d['bottom_x']   = int(fx1 + (fx2 - fx1)/2)
  d['bottom_y']   = fy2
  d['right_x']    = fx2
  d['right_y']    = int(fy1 + (fy2 - fy1)/2)
  return d


def darkframe(img, draw, NoOfFrames, FrameColor, FrameType, FrameBump, FrameBlur, FrameBlurType, 
             BmpAzimuth, BmpElevation, BmpDepth, BmpWaterlevel, BmpAmbient, BmpCompensate, BmpInvert, BmpType):

  debug        = False
  BmpXofs      = 0
  BmpYofs      = 0
  currentBrush = pdb.gimp_context_get_brush()
  pdb.gimp_context_set_brush('Circle (01)')
  
  if debug:
    print 'Frame type = ', FrameType

  try :
    if not debug:
      pdb.gimp_image_undo_group_start(img)
  
    if pdb.gimp_selection_is_empty(img):
      fail("Es ist keine Auswahl vorhanden")
    
#### SET DEFAULTS ################################
    if FrameBump:
      DefBlur['horizontal']   = FrameBlur
      DefBlur['vertical']     = FrameBlur
      DefBlur['method']       = FrameBlurType
  
      DefBump['azimuth']      = BmpAzimuth
      DefBump['elevation']    = BmpElevation
      DefBump['depth']        = BmpDepth
      DefBump['xofs']         = BmpXofs
      DefBump['yofs']         = BmpYofs
      DefBump['waterlevel']   = BmpWaterlevel
      DefBump['ambient']      = BmpAmbient
      DefBump['compensate']   = BmpCompensate
      DefBump['invert']       = BmpInvert
      DefBump['type']         = BmpType



    pdb.gimp_context_set_foreground(FrameColor)
    pdb.gimp_image_get_selection(img)
    non_empty, sx1, sy1, sx2, sy2 = pdb.gimp_selection_bounds(img)

    if debug:
      print 'sx1 = ', sx1
      print 'sy1 = ', sy1
      print 'sx2 = ', sx2
      print 'sy2 = ', sy2

    i = 1
    while i <= NoOfFrames:
      pdb.gimp_selection_none(img)
      sw    = img.width - sx2
      sh    = img.height - sy2
      fx1   = sx1 - int(sx1 / (NoOfFrames + 1) * i)
      fy1   = sy1 - int(sy1 / (NoOfFrames + 1) * i)
      fx2   = int(sw  / (NoOfFrames + 1) * (i)) + sx2
      fy2   = int(sh  / (NoOfFrames + 1) * (i)) + sy2
      op    = int(100 / (NoOfFrames + 1)) * i
      lname = 'DarkFrame' + str(i)

      if debug:
        print
        print 'LName = ', lname
        print 'fx1   = ', fx1
        print 'fy1   = ', fy1
        print 'fx2   = ', fx2
        print 'fy2   = ', fy2
        print 'op    = ', op
    

      lay = gimp.Layer(img, lname, img.width, img.height, draw.type, 100, NORMAL_MODE)
      lay.add_alpha

      pdb.gimp_image_add_layer(img, lay, -1)
      pdb.gimp_edit_clear(lay)

      if   FrameType == 0:  #ellipse
        pdb.gimp_ellipse_select(img, fx1, fy1, fx2-fx1, fy2-fy1, CHANNEL_OP_REPLACE, True, False, 100)
      elif  FrameType == 1: #rectangel
        pdb.gimp_rect_select( img, fx1, fy1, fx2-fx1, fy2-fy1, CHANNEL_OP_REPLACE, False, 100)
      else:                 #diamond
        d   = getDiamond(fx1, fy1, fx2, fy2)
        p   = PaintBrush
        p['strokes'] = []
        p['strokes'].append(d['top_x'])
        p['strokes'].append(d['top_y'])
        p['strokes'].append(d['right_x'])
        p['strokes'].append(d['right_y'])
        p['strokes'].append(d['bottom_x'])
        p['strokes'].append(d['bottom_y'])
        p['strokes'].append(d['left_x'])
        p['strokes'].append(d['left_y'])
        p['strokes'].append(d['top_x'])
        p['strokes'].append(d['top_y'])

        if debug:
          print 'strokes = ', p['strokes']
          print 'p       = ', p

        #p = PaintBrush
        pdb.gimp_paintbrush(lay, p['fade_out'], len(p['strokes']), p['strokes'], p['method'], p['gradient_length'])

        p = FuzzySelect
        p['x']    = d['top_x']
        p['y']    = d['left_y']
        pdb.gimp_fuzzy_select_full(lay,  
                                   p['x'],
                                   p['y'], 
                                   p['threshold'], 
                                   p['operation'], 
                                   p['antialias'], 
                                   p['feather'], 
                                   p['feather_radius_x'], 
                                   p['feather_radius_y'], 
                                   p['sample_merged'],
                                   p['select_transparent'],
                                   p['select_criterion'])
        #end selection diamond

      pdb.gimp_selection_invert(img)
      pdb.gimp_edit_fill( lay, FOREGROUND_FILL)
      pdb.gimp_layer_set_opacity(lay, op)  
      if FrameBump:
        FrameBumpMap(img, draw, lay)
        pdb.gimp_context_set_foreground(FrameColor)

      i = i + 1

  finally :
    pdb.gimp_selection_none(img)
    pdb.gimp_context_set_brush(currentBrush)
    if not debug:
      pdb.gimp_image_undo_group_end(img)


#### F U N C T I O N S ##################################################
def FrameBumpMap(img, draw, l1):
  horizontal = 25
  vertical = 25

  pdb.gimp_selection_none(img)
  l2 = pdb.gimp_layer_copy(l1, True)
  pdb.gimp_image_add_layer(img, l2, -1)
  pdb.gimp_image_set_active_layer(img, l2)
  pdb.gimp_selection_layer_alpha(l2)
  pdb.gimp_selection_invert(img)
  pdb.gimp_layer_set_opacity(l2, 100)
  pdb.gimp_context_set_foreground((0,0,0))
  pdb.gimp_edit_fill(l2, FOREGROUND_FILL)
  pdb.gimp_selection_none(img)
  pdb.plug_in_gauss(img, l2, DefBlur['horizontal'], DefBlur['vertical'], DefBlur['method'])
  pdb.plug_in_bump_map(img, l1, l2, DefBump['azimuth'], DefBump['elevation'], DefBump['depth'], 
                        DefBump['xofs'], DefBump['yofs'], DefBump['waterlevel'], DefBump['ambient'], 
                        DefBump['compensate'], DefBump['invert'], DefBump['type'])
  pdb.gimp_image_remove_layer(img, l2)
  pdb.gimp_image_set_active_layer(img, l1)
  

def lic_en(_a, _b):
  pdb.gimp_message(terms_of_use)

def lic_de(_a, _b):
  pdb.gimp_message(nutzungsbedingung)

def fail(msg):
  '''Error: Display'''
  raise error, msg




# Register with The Gimp,
register( "hans_darkfarmewin",
  "erzeugt sich abdunkelnde Rahmen",
  "erzeugt sich abdunkelnde Rahmen um eine Auswahl",
  "Hans-G. Normann, Chris Barharn",
  "(©) 2010 Hans-G. Normann, Chris Barharn",
  "2010-11-09",
  "<Image>/Filters/Gimp-Atelier/Abdunkelnde Rahmen",
  'RGB*',
  [ 
    (PF_SLIDER,   'NoOfFrames',    "Anzahl der Rahmen",                 1,          ( 1,20,1)),
    (PF_COLOR,    'FrameColor',    "Farbe der Rahmen",                  (0,0,0)),
    (PF_OPTION,   "FrameType",     "Art des Rahmens",                   0,          ["ELLIPSE","RECHTECK","RAUTE"]),
    (PF_BOOL,     'FrameBump',     "Rahmen Bumpmappen",                 True),
    (PF_SLIDER,   'FrameBlur',     "Stärke Weichzeichner",              10,         (1,100,1)),
    (PF_OPTION,   "FrameBlurType", "Weichzeichner Methode",             0,          ["IIR","RLE"]),
    (PF_SLIDER,   'BmpAzimuth',    "Bump Map Azimuth",                  140,        (1, 360, 1)),
    (PF_SLIDER,   'BmpElevation',  "Bump Map Höhenwinkel",              45,         (1,90,1)),
    (PF_SLIDER,   'BmpDepth',      "Bump Map Tiefe"   ,                 25,         (1,65,1)),
    (PF_SLIDER,   'BmpWaterlevel', "Bump Map Wasserhöhe",               90,         (0, 255, 1)),
    (PF_SLIDER,   'BmpAmbient',    "Bump Map Ambient",                  10,         (0, 255, 1)),
    (PF_BOOL,     'BmpCompensate', "Bump Map Verdunklung Kompensieren", True),
    (PF_BOOL,     'BmpInvert',     "Bump Map Invertieren",              False),
    (PF_OPTION,   "BmpType",       "Bump Map Methode",                  0,          ["LINEAR","SPHÄRISCH","SINUS"])
  ],
  '',
  darkframe)

main()
