;;; Studio Tecnico Arch. Giuseppe Conte  
;;; via Roma, 28
;;; 72026 - San Pancrazio Salentino (BR) - Italy
;;;
;;; Plugin  : draw-arch.scm
;;; Author  : Arch. Giuseppe Conte 
;;; Date    : 08 maggio 2002 -  Florence - Italy
;;; Revision: 19 giugno 2004
;;; 					13 dicembre 2007 update to TinyScheme
;;; Version : 2.4.1
;;; Last version at: http://xoomer.alice.it/lwcon/gimp/script-fu/draw-arch.htm
;;; Help guide at  : http://xoomer.alice.it/lwcon/gimp/script-fu/draw-arch.htm
;;; Required : Gimp 2.4.1 or last
;;;
;;; Description: 
;;; Draw a precise arch at point specified with the brush and color active.
;;; -----------------------------------------------------------------------------
;;;
;;; License:
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Define the function:

(define (script-fu-draw-arch inImage inLayer dx dy Radius From To Lati)

	(let* (	(segment)
					(stepx)
					(stepy)
					(raggio)
					(nlati)
					(lung)
					(angolo)
					(arco)
					(aRotaz)
					(beta)
					(gamma)
					(gcount)
					(npoint)
					(segment (make-vector 4))   
					(stepx dx)
					(stepy dy)
					(raggio Radius)
					(nlati Lati)
	      )

		(set! lung (- From To))
		(set! angolo (/ lung Lati))
		(set! arco (* angolo (/ 3.14 180)))
		(set! aRotaz (* To (/ 3.14 180)))
		(set! beta aRotaz)
		(set! gamma 0)
		(set! gcount 1)
		(set! npoint 4)

  (while (<= gcount nlati) 
  	
  		(set! beta (+ beta arco))
  		(set! gamma (- beta arco))
  		(vector-set! segment 0 (+ (* raggio (cos gamma)) stepx))
  		(vector-set! segment 1 (+ (- (* raggio (sin gamma))) stepy))
  		(vector-set! segment 2 (+ (* raggio (cos beta)) stepx))
  		(vector-set! segment 3 (+ (- (* raggio (sin beta))) stepy))
  
		(gimp-pencil inLayer npoint segment )
  		(set! gcount (+ gcount 1))
   	
   );end while

	  (gimp-displays-flush)
  
  );;let
) ;;def

(script-fu-register
 "script-fu-draw-arch"
 _"<Image>/_ATG 2003/_Draw/Draw _Arch"
 "Draw circle or an arch from initial angle to final angle."
 "Arch. Giuseppe Conte <http://xoomer.alice.it/lwcon/>"
 "2007, Giuseppe Conte"
 "10 dicembre 2007 - 72026 San Pancrazio Salentino (BR) - Italy"
 "RGB* GRAY* INDEXED*"
 SF-IMAGE "The Image" 0
 SF-DRAWABLE "The Layer" 0
 SF-ADJUSTMENT "X center" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Y center" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Radius" '(10 0 9999 1 10 0 1)
 SF-ADJUSTMENT "From angle" '(0 -9999 9999 1 10 0 1)
 SF-ADJUSTMENT "To angle" '(360 -9999 9999 1 10 0 1)
 SF-ADJUSTMENT "Number Segment" '(36 0 9999 1 10 0 1)
)
