;;; Studio Tecnico Arch. Giuseppe Conte  
;;; via Roma, 28
;;; 72026 - San Pancrazio Salentino (BR) - Italy
;;;
;;; Plugin  : draw-ellipse.scm
;;; Author  : Arch. Giuseppe Conte 
;;; Date    : 27 settembre 2002 - San Pancrazio
;;; Revision: 11 giugno 2006
;;; 					10 dicembre 2007 update to TinyScheme
;;; Version : 2.4.1
;;; Last version at: http://xoomer.alice.it/lwcon/gimp/script-fu/draw-circle-triangle.htm
;;; Help guide at  : http://xoomer.alice.it/lwcon/gimp/script-fu/draw-circle-triangle.htm
;;; Required : Gimp 2.4.1 or last
;;;
;;; Description: 
;;; Draw ellipse in parametric mode.
;;; -----------------------------------------------------------------------------
;;;
;;; License:
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Define the function:

(define (script-fu-draw-ellipse inImage inLayer dx dy Ra Rb Lati Rotaz)

	(let* (	(segment)
					(segment (make-vector 4))   
					(stepx dx)
					(stepy dy)
					(nlati Lati)
					(angolo)
					(arco)
					(delta)
					(alfa)
					(xa)
					(ya)
					(xb)
					(yb)
					(gcount)
					(npoint)
	      )

		(set! angolo (/ 360 Lati))
		(set! arco (* angolo (/ 3.141592654 180)))
		(set! delta (* Rotaz (/ 3.141592654 180)))

		(set! alfa 0)
		(set! xa 0)
		(set! ya 0)
		(set! xb 0)
		(set! yb 0)
		(set! gcount 1)
		(set! npoint 4)

	      
;inizio delle operazioni che potranno essere annullate con un solo undo
	(gimp-undo-push-group-start inImage)
	  
  (while (<= gcount nlati) 
  	
  		(set! xa  (* Ra (cos alfa)) )  
  		(set! ya  (- (* Rb (sin alfa))) ) 

		(vector-set! segment 0 (+ (- (* (cos delta) xa) (* (sin delta) ya)) stepx) )
		(vector-set! segment 1 (+ (+ (* (sin delta) xa) (* (cos delta) ya)) stepy) )
		
 		(set! alfa (+ alfa arco))

 		(set! xb  (* Ra (cos alfa)) )
 		(set! yb  (- (* Rb (sin alfa))) )		

		(vector-set! segment 2 (+ (- (* (cos delta) xb) (* (sin delta) yb)) stepx)   )
		(vector-set! segment 3 (+ (+ (* (sin delta) xb) (* (cos delta) yb)) stepy) )
  
		(gimp-pencil inLayer npoint segment )
  		(set! gcount (+ gcount 1))
   	
   );end while
   
;fine delle operazioni che potranno essere annullate con un solo undo
	(gimp-undo-push-group-end inImage) 
	
	  (gimp-displays-flush)
  
  );;let
) ;;def

(script-fu-register
 "script-fu-draw-ellipse"
 _"<Image>/_ATG/_Draw/Draw _Ellipse"
 "Draw an ellipse."
 "Arch. Giuseppe Conte <http://xoomer.alice.it/lwcon/>"
 "2007, Giuseppe Conte"
 "10 dicembre 2007 - San Pancrazio Salentino (BR) - Italy"
 "RGB* GRAY* INDEXED*"
 SF-IMAGE "The Image" 0
 SF-DRAWABLE "The Layer" 0
 SF-ADJUSTMENT "X center" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Y center" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Semi-axis a" '(10 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Semi-axis b" '(10 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Number segments" '(36 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Inclination" '(0 -9999 9999 1 10 0 1)
)
