;;; Studio Tecnico Arch. Giuseppe Conte  
;;; via Roma, 28
;;; 72026 - San Pancrazio Salentino (BR) - Italy
;;;
;;; Plugin  : draw-offset-segment.scm
;;; Author  : Arch. Giuseppe Conte 
;;; Date    : 30 agosto 2003 -  Florence - Italy
;;; Revision: 20 marzo 2008 update to TinyScheme
;;;						18 ottobre 2008 update to GIMP 2.6
;;;
;;; Version : 2.4.1
;;; Last version at: http://xoomer.alice.it/lwcon/gimp/script-fu/draw-offset-segment.htm
;;; Help guide at  : http://xoomer.alice.it/lwcon/gimp/script-fu/draw-offset-segment.htm
;;; Required : Gimp 2.4.1 or last
;;;
;;; Description: 
;;; Draw a precise arch at point specified with the brush and color active.
;;; -----------------------------------------------------------------------------
;;;
;;; License:
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Define the function:

(define (script-fu-draw-offset-segment inImage inLayer xa ya xb yb offset number )

	(let* (	(segment (cons-array 4 'double))
					(npoint 4)
					(alfa (atan (/ (- yb ya) (- xb xa))))
					(kx (* offset ( sin alfa)))
					(ky (* offset ( cos alfa)))
					(count 0)
				)
;inizio delle operazioni che potranno essere annullate con un solo undo
	(gimp-undo-push-group-start inImage)
		     
	     	(while (<= count number)
	     			
  			(vector-set! segment 0 (- xa (* count kx)) )
  			(vector-set! segment 1 (+ ya (* count ky)) )
  			
  			(vector-set! segment 2 (- xb (* count kx)) )
  			(vector-set! segment 3 (+ yb (* count ky)) )
   
		(gimp-pencil inLayer npoint segment )

		(set! count (+ count 1))

		); end while

	(gimp-undo-push-group-end inImage) 
;fine delle operazioni che potranno essere annullate con un solo undo
   			
  	  (gimp-displays-flush)
     
	);let	
) ;;def


(script-fu-register
 "script-fu-draw-offset-segment"
 _"<Image>/_ATG/_Offset/Draw offset _Segment"
 "Draw segment at offset distance."
 "Arch. Giuseppe Conte <http://space.tin.it/edicola/lwcon/>"
 "2008, Giuseppe Conte"
 "18 ottobre 2008 - 72026 San Pancrazio Salentino (BR) - Italy"
 "RGB* GRAY* INDEXED*"
 SF-IMAGE "The Image" 0
 SF-DRAWABLE "The Layer" 0
 SF-ADJUSTMENT "Xa" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Ya" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Xb" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Yb" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Offset" '(0 -9999 9999 1 10 0 1)
 SF-ADJUSTMENT "Number segments" '(1 0 9999 1 10 0 1)
)
