;;; Studio Tecnico Arch. Giuseppe Conte  
;;; via Roma, 28
;;; 72026 - San Pancrazio Salentino (BR) - Italy
;;;
;;; Plugin  : draw-spiral.scm
;;; Author  : Arch. Giuseppe Conte 
;;; Date    : 08 maggio 2002 -  Florence - Italy
;;; Revision: 19 giugno 2004
;;; 					13 dicembre 2007 update to TinyScheme's
;;;						18 ottobre 2008 update to GIMP 2.6
;;; Version : 3.1
;;; Last version at: http://xoomer.alice.it/lwcon/gimp/script-fu/draw-spiral.htm
;;; Help guide at  : http://xoomer.alice.it/lwcon/gimp/script-fu/draw-spiral.htm
;;;
;;; Description: 
;;; Draw the spiral with the brush and color active.
;;; 
;;; -----------------------------------------------------------------------------
;;;
;;; License:
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2 of the License, or
;;; (at your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;; -----------------------------------------------------------------------------
;;;
;;; Define the function:

(define (script-fu-draw-spiral inImage inLayer dx dy Spire Passo)

	(let* (	(segment (make-vector 4 ))   
					(stepx dx)
					(stepy dy)
					(lunghezza (* 2 3.141592654 Spire))
					(angolo (/ 360 Passo))
					(arco (* angolo (/ 3.141592654 180)))
					(beta 0)
					(gamma 0)
					(gcount arco)
					(npoint 4)
					(raggio 0)
	      )

;inizio delle operazioni che potranno essere annullate con un solo undo
	(gimp-undo-push-group-start inImage)
	
  (while (<= gcount lunghezza) 
			(set! raggio gcount)  	
  		(set! beta (+ beta arco))
  		(set! gamma (- beta arco))
  		(vector-set! segment 0 (+ (* raggio (cos gamma)) stepx))
  		(vector-set! segment 1 (+ (- (* raggio (sin gamma))) stepy))
  		(vector-set! segment 2 (+ (* raggio (cos beta)) stepx))
  		(vector-set! segment 3 (+ (- (* raggio (sin beta))) stepy))
  
			(gimp-pencil inLayer npoint segment )
  
  		(set! gcount (+ gcount arco))
   	  (gimp-displays-flush)
   	  
   );end while

	(gimp-undo-push-group-end inImage) 
;fine delle operazioni che potranno essere annullate con un solo undo

  );;let

  (gimp-displays-flush)  
  
) ;;def

(script-fu-register
 "script-fu-draw-spiral"
 _"<Image>/_ATG/_Curves/Draw _spiral"
 "Draw the spiral with the brush and color active."
 "Arch. Giuseppe Conte"
 "2008, Giuseppe Conte"
 "18 ottobre 2008 - Ver. 3.1"
 "RGB* GRAY* INDEXED*"
 SF-IMAGE "The Image" 0
 SF-DRAWABLE "The Layer" 0
 SF-ADJUSTMENT "X center" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Y center" '(0 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Number Spire" '(3 0 9999 1 10 0 1)
 SF-ADJUSTMENT "Segments for circle" '(60 0 9999 1 10 0 1)
)
