/* GIMP Exif Broswer
 * Copyright (C) 2004 William Skaggs <weskaggs@primate.ucdavis.edu>
 * Based on lib-gtk-exif-browser code from the libexif project
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of the Author of the
 * Software shall not be used in advertising or otherwise to promote the
 * sale, use or other dealings in this Software without prior written
 * authorization from the Author.
 */

#include "config.h"

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "main.h"
#include "interface.h"
#include "gtk-exif-browser.h"

#include "plugin-intl.h"


/*  Constants  */


/*  Local function prototypes  */

/*  Local variables  */

static PlugInUIVals *ui_state = NULL;


/*  Public functions  */

gboolean
dialog (gint32              image_ID,
	GimpDrawable       *drawable,
	PlugInVals         *vals,
	PlugInImageVals    *image_vals,
	PlugInDrawableVals *drawable_vals,
	PlugInUIVals       *ui_vals)
{
  GtkWidget *dlg;
  GtkWidget *browser;
  gboolean   run = FALSE;
  GimpParasite *parasite;
  ExifData *exif_data;

  ui_state = ui_vals;

  gimp_ui_init (PLUGIN_NAME, TRUE);

  dlg = gimp_dialog_new (_("GIMP Exif Browser"), PLUGIN_NAME,
                         NULL, 0,
			 gimp_standard_help_func, "plug-in-exif-browser",

			 GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			 GTK_STOCK_OK,     GTK_RESPONSE_OK,

			 NULL);

  browser = gtk_exif_browser_new ();
  gtk_widget_set_size_request (browser, 700, 400);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dlg)->vbox), browser);
  gtk_widget_show (browser);

  parasite = gimp_image_parasite_find (image_ID, "exif-data");
  if (parasite)
    {
      exif_data = exif_data_new_from_data (parasite->data, parasite->size);
      gimp_parasite_free (parasite);
      gtk_exif_browser_set_data (GTK_EXIF_BROWSER (browser), exif_data);
    }
  else
    {
      g_message ("This image has no exif data attached.");
    }

  gtk_widget_show (dlg);

  run = (gimp_dialog_run (GIMP_DIALOG (dlg)) == GTK_RESPONSE_OK);

  if (run)
    {
      /*  Save exif values  */
    }

  gtk_widget_destroy (dlg);

  return run;
}


