#!/usr/bin/env python
# -*- coding: utf-8 -*-
#Version 06.03.2011
#Author: Hans-G. Normann, Christine Barharn

from gimpfu import *
import gettext
import os
import sys
import locale

GAT_DIR = os.path.dirname(os.path.abspath(__file__))
GAT_LOC = ''
GAT_LANG = 'de'

s = locale.getdefaultlocale()
s = s[0]
if s.lower <> 'none':
  s = s.split('_')
  GAT_LANG = s[0]

if sys.platform.startswith('linux'):
  GAT_LOC = GAT_DIR + '/locale'
elif sys.platform.startswith('win'):
  GAT_LOC = GAT_DIR + r'\locale'
else:  
  sys.exit('Platform not supported')

# internationalziation i18n
trans = gettext.translation("gat_lines", GAT_LOC, [GAT_LANG], fallback=True) 
trans.install()


def gat_001(img, draw, dist, num, brush, painter, direction):
  _("""GIMP Atelier Tools: Scan Lines""")
  lay = gimp.Layer(img, 'GAT_Scan_Lines', img.width, img.height, draw.type, 100, NORMAL_MODE)
  lay.add_alpha
  pdb.gimp_image_add_layer(img, lay, 999)
  pdb.gimp_edit_clear(lay)
  oldbrush = pdb.gimp_context_get_brush()
  pdb.gimp_context_set_brush(brush)
  
  if (direction == 0 or direction ==2):
    i  = 1
    while i <= dist * num:
      if i > lay.height + dist:
        break

      if painter == 1:
        pdb.gimp_pencil(lay, 4, [0, i,img.width, i])
      else:
        pdb.gimp_paintbrush(lay, 0, 4, [0, i,img.width, i], PAINT_CONSTANT, 0)
      i = i + dist

  if (direction >= 1):
    
    i  = 1
    while i <= dist * num:
      if i > lay.width + dist:
        break

      if painter == 1:
        pdb.gimp_pencil(lay, 4, [i, 0, i,img.height])
      else:
        pdb.gimp_paintbrush(lay, 0, 4, [i, 0, i, img.height], PAINT_CONSTANT, 0)
      i = i + dist

  
  pdb.gimp_context_set_brush(oldbrush)
  

register("GimpAtelier_tools_008DE",
  _("GIMP Atelier Tools: Scan Lines"),
  _("creates scan lines"),
  "Hans-G. Normann, Christine Barharn",
  "© 2010, Hans-G. Normann, Christine Barharn. Licence GPL",
  "2010-11-16",
  _("<Image>/Filters/Gimp-Atelier/Scan Lines"),
  "*",
  [
    (PF_INT,    'dist',      _("Distance Between Lines"), 10),
    (PF_INT,    'num',       _("Number of lines"),        5),
    (PF_BRUSH,  'brush',     _("Brush"),                  "Circle Fuzzy (03)"),
    (PF_RADIO,  'painter',   _("Paint Tool:"),            1,                   ((_("Brush"), 0), (_("Pencil"),1))),
    (PF_OPTION, 'direction', _("Direction"),              0,                   [_("horizontal"),_("vertical"),_("both")])
  ],
  '',
  gat_001)

main()
