/* 
GIMP Plug-in Laso
Ondrej Fiala

curve.h

data structures for curve and points
*/

#ifndef __CURVE_H__
#define __CURVE_H__

typedef struct {
	gdouble x;
	gdouble y;
} Point;

typedef struct {
	Point *points;
	gint   _max;
	gint   _number;
} Curve;

/* NEVER set CURVE_MAX lover than 6 - interspacing the big hole 
   anyway <50 doesn't make sence
*/
#define CURVE_MAX   2000
#define CURVE_POINTS_DISTANCE_MIN   1.5
#define CURVE_POINTS_DISTANCE_MAX   20

gdouble get_module(gdouble dx, gdouble dy);

Point point_new (gdouble x, gdouble y);
void point_clear (Point *point);
void point_set (Point *point, gdouble x, gdouble y);
void point_set_interpolate (Point *point, Point** vector_field, gdouble x, gdouble y, gint width, gint height);
void point_multiple (Point *point, gdouble number);
Point point_copy (Point *point);
void point_print (Point *point);

Curve curve_new ();
void curve_free (Curve *curve); 
void curve_clear (Curve *curve);
gboolean curve_add (Curve *curve, Point *point);
gboolean curve_add_xy (Curve *curve, gdouble x, gdouble y);
gboolean curve_copy(Curve* new_curve,Curve *curve);

Curve curve_from_gimp_points (gint number_points,gdouble *points);
gdouble* curve_to_points (Curve *curve, gint *number_points);
gboolean curve_check_bounds(Curve *curve, gint width, gint height);
gboolean curve_interspace_points(Curve *curve);
gboolean curve_remove_points(Curve *curve);

Curve curve_to_bezier (Curve *curve);
void curve_min_count(Curve *curve, gdouble min_lenght, gint *num_stay);
void curve_diff(Curve *curve1, Curve *curve2, gdouble *diff);
void curve_multiple (Curve *curve, gdouble number);
void curve_sum_vector (Curve *curve, Curve *vector_curve);
void curve_divide_vector (Curve *curve, Curve *vector_curve);
void curve_print (Curve *curve);

#endif /* __CURVE_H__ */
