/* 
GIMP Plug-in Laso
Ondrej Fiala

edge.c

edge detection module
*/

#include <stdio.h>

#include <libgimp/gimp.h>

/* translations strings */
#include "config.h"
#include "plugin-intl.h"

#include "image.h"

/* macros for checking arrays bounds */
#define BW(value)  (value>(BOUNDS_WIDTH-1)?(BOUNDS_WIDTH-1):(value<0?0:value))
#define BH(value)  (value>(BOUNDS_HEIGHT-1)?(BOUNDS_HEIGHT-1):(value<0?0:value))

#define BLACK_REGION(val) ((val) > 128)
#define WHITE_REGION(val) ((val) <= 128)

/* functions */

static void
minmax  (gint  x1,
		 gint  x2,
		 gint  x3,
		 gint  x4,
		 gint  x5,
		 gint *min_result,
		 gint *max_result)
{
	gint min1, min2, max1, max2;

	if (x1 > x2) { max1=x1; min1=x2; } else { max1=x2; min1=x1; }
	if (x3 > x4) { max2=x3; min2=x4; } else { max2=x4; min2=x3; }
	if (min1 < min2)
		*min_result = MIN (min1, x5);
	else  *min_result = MIN (min2, x5);
	if (max1 > max2)
		*max_result = MAX (max1, x5);
	else  *max_result = MAX (max2, x5);
}

guint** laplacian (guint **image_intensity_field, GimpDrawable *drawable)
{
	gint BOUNDS_HEIGHT, BOUNDS_WIDTH, width, height;
	gint gradient, min, max;
	gint max_gradient = 0;

	gdouble scale = 1.0;
	guint **imf;

	gint i, j, temp, temp2, temp3;

	/* 2D fields */
	guint **laplace, **matrix;

	gimp_progress_init (_("Laplace Operator"));

	width  = drawable->width;
	BOUNDS_WIDTH = width;
	height = drawable->height;
	BOUNDS_HEIGHT = height;

	/* name shortcut */
	imf = image_intensity_field;

	/* temporary matrix */
	matrix = g_malloc(width * sizeof(guint *));
	for(i = 0; i < width; i++){
		matrix[i] = g_malloc(height * sizeof(guint));
	}

	/* 2D laplace */
	laplace = g_malloc(width * sizeof(guint *));
	for(i = 0; i < width; i++){
		laplace[i] = g_malloc(height * sizeof(guint));
	}

	/* hlavni cyklus po radcich */
	for (j=0;j<height;j++) {
		for (i=0;i<width;i++) {
			minmax ((gint)imf[i][BH(j-1)], (gint)imf[BW(i-1)][j], (gint)imf[i][j], (gint)imf[BW(i+1)][j],
					(gint)imf[i][BH(j+1)], &min, &max);

			gradient = (gint)(0.5 * MAX((max - (gint)imf[i][j]), ((gint)imf[i][j]- min)));
			max_gradient = MAX(abs (gradient), max_gradient);
			temp = imf[BW(i-1)][BH(j-1)] + imf[i][BH(j-1)]     + imf[BW(i+1)][BH(j-1)] +
				   imf[BW(i-1)][j]		- (8 * (gint)imf[i][j])	  + imf[BW(i+1)][j] +
				   imf[BW(i-1)][BH(j+1)] + imf[i][BH(j+1)]     + imf[BW(i+1)][BH(j+1)];

			matrix[i][j] = (guint)((temp) > 0) ? gradient : (128 + gradient);;
		}

		if ((j % 10) == 0)
			gimp_progress_update ((gdouble)j / (gdouble)(height) /2);
	}

	scale = (gdouble)(255.0 / (gdouble) max_gradient);

	/* corners */

	/* vetsi rozestup cerna/bila (hrana/nic) */
	for (j=0;j<height;j++)
	{
		for (i=0;i<width;i++)
		{
			temp = (gint)matrix[i][j];

			temp2 = (WHITE_REGION(temp) &&
				(BLACK_REGION (matrix[BW(i-1)][BH(j-1)]) ||
				 BLACK_REGION (matrix[i][BH(j-1)])   ||
				 BLACK_REGION (matrix[BW(i+1)][BH(j-1)]) ||
				 BLACK_REGION (matrix[BW(i-1)][j])   ||
				 BLACK_REGION (matrix[BW(i+1)][j])   ||
				 BLACK_REGION (matrix[BW(i-1)][BH(j+1)]) ||
				 BLACK_REGION (matrix[i][BH(j+1)])   ||
				 BLACK_REGION (matrix[BW(i+1)][BH(j+1)]) ));

			temp3 = (temp >= 128) ? (temp-128) : temp;

			laplace[i][j] = (temp2) ? (gint)(scale * temp3) : 0;			
		}

		if ((j % 10) == 0)
			gimp_progress_update (0.5 + ((gdouble)j / (gdouble)(height)) /2);
	}

	g_free(matrix);

	return laplace;
}

gdouble** laplacian_normalized (guint **image_intensity_field, GimpDrawable *drawable){
	gint i, j;
	gint max, min, width, height;

	/* 2D fields */
	guint **laplace;
	gdouble **normalized;

	/* initialization of bounds */
	max = 255;
	min = 0;

	width  = drawable->width;
	height = drawable->height;

	normalized = g_malloc(width * sizeof(gdouble *));
	for(i = 0; i < width; i++){
		normalized[i] = g_malloc(height * sizeof(gdouble));
	}	

	laplace = laplacian(image_intensity_field, drawable);

	/* normalization */
	for (j=0; j<height; j++) {
		for (i=0; i<width; i++) {
			normalized[i][j] = ((gdouble)laplace[i][j]-min)/(max-min); 
		}
	}
	g_free(laplace);

	return normalized;	
}
