/* 
GIMP Plug-in Laso
Ondrej Fiala

curve.h

data structures for curve and points
*/

#ifndef __FORCE_H__
#define __FORCE_H__

#define Inf (1<<30)

/* data structures */
#include "curve.h"

void tensile_force (Point *point, Curve *curve, gint index);
gdouble tensile_force_normalize(Curve *curve);
void flexure_force (Point *point, Curve *curve, gint index);

/* OPTIMALIZATION FORCES*/
gint force_stopping_point(Point *point,gdouble height);
gint force_stopping_point_normalized(Point *point,gdouble height);

/* IMAGE FORCES */
Point** image_force3x3(guint **laplace, GimpDrawable *drawable);
Point** image_force5x5(guint **laplace, GimpDrawable *drawable);
Point** image_force5x5_double(gdouble **laplace, GimpDrawable *drawable);

gint force_normalize(Curve *curve, gdouble max);
gint force_normalize_2(Curve *curve, gdouble max);

gint force_print(Curve *curve, Curve *vector_curve, gdouble multiple, GimpDrawable *drawable);

#endif /* __FORCE_H__ */
