/* 
GIMP Plug-in Laso
Ondrej Fiala

interface.c

pouzit Plug-in template - Michael Natterer
*/

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "main.h"

/* translations strings */
#include "config.h"
#include "plugin-intl.h"

#include "interface.h"

/*  Constants  */

#define SCALE_WIDTH        100
#define SPIN_BUTTON_WIDTH   50
#define RANDOM_SEED_WIDTH  100

#define TABLE_COL_SPACINGS  6
#define TABLE_ROW_SPACINGS  2

/*  Local function prototypes  */

static gboolean   dialog_image_constraint_func (gint32    image_id,
												gpointer  data);
static void dialog_gvf_callback (GtkWidget *widget,
								   gpointer   data);
static void dialog_gauss_callback (GtkWidget *widget,
								   gpointer   data);



/*  Local variables  */

static PlugInUIVals *ui_state = NULL;

/* pro posilani vice hodnot pres g_signal_connect */
typedef struct
{
    gint		*value;
    GtkObject	*obj;
}gauss_struct; 

typedef struct
{
    gint		*value;
    GtkObject	*obj1;
    GtkObject	*obj2;
}gvf_struct; 

/*  Public functions  */

gboolean
dialog (gint32              image_ID,
		GimpDrawable       *drawable,
		PlugInVals         *vals,
		PlugInImageVals    *image_vals,
		PlugInDrawableVals *drawable_vals,
		PlugInUIVals       *ui_vals)
{
	GtkWidget *dlg;
	GtkWidget *main_vbox;
	GtkWidget *frame;
	GtkWidget *table;
	GtkWidget *table2;
	GtkWidget *table3;
	GtkWidget *button;
	GtkObject *adj;
	gint       row;
	gboolean   run = FALSE;
	gvf_struct   gvf_in;
	gauss_struct   gauss_in;

	GtkWidget *radio_image[2];


	ui_state = ui_vals;

	gimp_ui_init (PLUGIN_NAME, TRUE);

	dlg = gimp_dialog_new (_("Laso Tool"), PLUGIN_NAME,
		NULL, 0,
		gimp_standard_help_func, "laso-plug-in",

		GTK_STOCK_OK,		GTK_RESPONSE_OK,
		GTK_STOCK_CANCEL,	GTK_RESPONSE_CANCEL,

		NULL);

	gtk_dialog_set_alternative_button_order (GTK_DIALOG (dlg),
		GTK_RESPONSE_CANCEL,
		GTK_RESPONSE_OK,
		-1);

	main_vbox = gtk_vbox_new (FALSE, 12);
	gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 12);
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dlg)->vbox), main_vbox);

	/*  gimp_scale_entry_new() examples  */

	frame = gimp_frame_new (_("Laso Tool Options"));
	gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show (frame);

	table = gtk_table_new (3, 3, FALSE);
	gtk_table_set_col_spacings (GTK_TABLE (table), TABLE_COL_SPACINGS);
	gtk_table_set_row_spacings (GTK_TABLE (table), TABLE_ROW_SPACINGS);
	gtk_container_add (GTK_CONTAINER (frame), table);
	gtk_widget_show (table);

	row = 0;
		
	/* 1. parametr */
	adj = gimp_scale_entry_new (GTK_TABLE (table), 0, row++,
		_("Iterations :"), SCALE_WIDTH, SPIN_BUTTON_WIDTH,
		vals->iterations, 1, 1000, 1, 50, 0,
		TRUE, 0, 0,
		_("Number of iterations"), NULL);
	g_signal_connect (adj, "value_changed",
		G_CALLBACK (gimp_int_adjustment_update),
		&vals->iterations);

	/* image force choose */
	frame = gimp_int_radio_group_new (TRUE, _("Image force"),
                                      G_CALLBACK (gimp_radio_button_update),
                                      &vals->image_force, 0,

                                      _("Gradient vector field"),
                                      1, &radio_image[0],
                                      _("E_dge map"),
                                      0, &radio_image[1],

                                      NULL);

	gimp_help_set_help_data(radio_image[0], _("GVF"), NULL);
	gimp_help_set_help_data (radio_image[1], _("5x5 matrix on edge map."), NULL);

	gimp_int_radio_group_set_active(GTK_RADIO_BUTTON (radio_image[0]), vals->image_force);
	gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show (frame);


	/* vahy jednotlivych sil */
	frame = gimp_frame_new (_("GVF parameters"));
	gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show (frame);

	table3 = gtk_table_new (5, 6, FALSE);
	gtk_table_set_col_spacings (GTK_TABLE (table3), TABLE_COL_SPACINGS);
	gtk_table_set_row_spacings (GTK_TABLE (table3), TABLE_ROW_SPACINGS);
	gtk_container_add (GTK_CONTAINER (frame), table3);
	gtk_widget_show (table3);

	row = 0;
	/* 1. parametr */
	adj = gimp_scale_entry_new (GTK_TABLE (table3), 0, row++,
		_("Iterations :"), SCALE_WIDTH, SPIN_BUTTON_WIDTH,
		vals->gvf_iterations, 10, 100, 5, 10, 0,
		TRUE, 0, 0,
		_("Number of GVF iterations"), NULL);
	g_signal_connect (adj, "value_changed",
		G_CALLBACK (gimp_int_adjustment_update),
		&vals->gvf_iterations);
	gvf_in.obj1 = adj;

	/* 2. parametr */
	adj = gimp_scale_entry_new (GTK_TABLE (table3), 0, row++,
		_("Noise parameter :"), SCALE_WIDTH, SPIN_BUTTON_WIDTH,
		vals->gvf_noise, 0.01, 0.3, 0.01, 0.1, 2,
		TRUE, 0, 0,
		_("Higher values in noisy images"), NULL);
	g_signal_connect (adj, "value_changed",
		G_CALLBACK (gimp_double_adjustment_update),
		&vals->gvf_noise);

	/* pristup k parametrum GVF */
	gvf_in.value = &vals->image_force;
	gvf_in.obj2 = adj;
	g_signal_connect (radio_image[0], "toggled",
		G_CALLBACK (dialog_gvf_callback),
		&gvf_in);
	gimp_scale_entry_set_sensitive(gvf_in.obj1,vals->image_force);
	gimp_scale_entry_set_sensitive(gvf_in.obj2,vals->image_force);

	/* vahy jednotlivych sil */
	frame = gimp_frame_new (_("Forces weights"));
	gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show (frame);

	table3 = gtk_table_new (5, 6, FALSE);
	gtk_table_set_col_spacings (GTK_TABLE (table3), TABLE_COL_SPACINGS);
	gtk_table_set_row_spacings (GTK_TABLE (table3), TABLE_ROW_SPACINGS);
	gtk_container_add (GTK_CONTAINER (frame), table3);
	gtk_widget_show (table3);

	row = 0;
	/* 1. vaha */
	adj = gimp_scale_entry_new (GTK_TABLE (table3), 0, row++,
		_("Tension :"), SCALE_WIDTH, SPIN_BUTTON_WIDTH,
		vals->tension, 0, 2, 0.01, 0.1, 2,
		TRUE, 0, 0,
		_("Weight of tensile force"), NULL);
	g_signal_connect (adj, "value_changed",
		G_CALLBACK (gimp_double_adjustment_update),
		&vals->tension);
	
	/* 2. vaha */
	adj = gimp_scale_entry_new (GTK_TABLE (table3), 0, row++,
		_("Rigidity :"), SCALE_WIDTH, SPIN_BUTTON_WIDTH,
		vals->flexure, 0, 2, 0.01, 0.1, 2,
		TRUE, 0, 0,
		_("Weight of flexural force"), NULL);
	g_signal_connect (adj, "value_changed",
		G_CALLBACK (gimp_double_adjustment_update),
		&vals->flexure);

	/* 3. vaha */
	adj = gimp_scale_entry_new (GTK_TABLE (table3), 0, row++,
		_("Image :"), SCALE_WIDTH, SPIN_BUTTON_WIDTH,
		vals->image_weight, 0, 3, 0.01, 0.1, 2,
		TRUE, 0, 0,
		_("Weight of image force"), NULL);
	g_signal_connect (adj, "value_changed",
		G_CALLBACK (gimp_double_adjustment_update),
		&vals->image_weight);

	/* zaskrtavaci tlacitka pri extra sily */
	button = gtk_check_button_new_with_mnemonic (_("_Edge-stopping force"));
	gtk_table_attach_defaults(GTK_TABLE(table3), button,0,2,3,4);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), vals->stopping);
	gtk_widget_show (button);
	g_signal_connect (button, "toggled",
		G_CALLBACK (gimp_toggle_button_update),
		&vals->stopping);

	button = gtk_check_button_new_with_mnemonic (_("Iterations force"));
	gtk_table_attach_defaults(GTK_TABLE(table3), button,0,2,4,5);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), vals->iterations_force);
	gtk_widget_show (button);
	g_signal_connect (button, "toggled",
		G_CALLBACK (gimp_toggle_button_update),
		&vals->iterations_force);

	/* menu vylepsenich */
	frame = gimp_frame_new (_("Improvements"));
	gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show (frame);

	table2 = gtk_table_new (3, 3, FALSE);
	gtk_table_set_col_spacings (GTK_TABLE (table2), TABLE_COL_SPACINGS);
	gtk_table_set_row_spacings (GTK_TABLE (table2), TABLE_ROW_SPACINGS);
	gtk_container_add (GTK_CONTAINER (frame), table2);
	gtk_widget_show (table2);

	row = 0;

	button = gtk_check_button_new_with_mnemonic (_("Optimalized number of iterations"));
	gtk_table_attach_defaults(GTK_TABLE(table2), button,0,2,0,1);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), vals->auto_iterations);
	gtk_widget_show (button);
	g_signal_connect (button, "toggled",
		G_CALLBACK (gimp_toggle_button_update),
		&vals->auto_iterations);
	row++;

	/* vypnuti/zapnuti Gauss blur */
	button = gtk_check_button_new_with_mnemonic (_("_Gaussian blur"));

	/* vyber kam button umistim */
	gtk_table_attach_defaults(GTK_TABLE(table2), button,0,3,1,2);

	row++;
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), vals->gaussian_blur);
	gtk_widget_show (button);

	g_signal_connect (button, "toggled",
		G_CALLBACK (gimp_toggle_button_update),
		&vals->gaussian_blur);

	/* Gauss blur - radius */
	adj = gimp_scale_entry_new (GTK_TABLE (table2), 0, row++,
		_("Blur radius :"), SCALE_WIDTH, SPIN_BUTTON_WIDTH,
		(gdouble)(vals->blur_radius), 0, 20, 0.25, 2, 2,
		TRUE, 0, 0,
		_("Smoothing the image"), NULL);

	gauss_in.value = &vals->gaussian_blur;
	gauss_in.obj = adj;
	g_signal_connect (button, "toggled",
		G_CALLBACK (dialog_gauss_callback),
		&gauss_in);

	gimp_scale_entry_set_sensitive(adj,vals->gaussian_blur);

	g_signal_connect (adj, "value_changed",
		G_CALLBACK (gimp_double_adjustment_update),
		&vals->blur_radius);

	button = gtk_check_button_new_with_mnemonic (_("Export path"));
	gtk_table_attach_defaults(GTK_TABLE(table2), button,0,2,5,6);
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), vals->export_path);
	gtk_widget_show (button);
	g_signal_connect (button, "toggled",
		G_CALLBACK (gimp_toggle_button_update),
		&vals->export_path);

	/*  Show the main containers  */

	gtk_widget_show (main_vbox);
	gtk_widget_show (dlg);

	run = (gimp_dialog_run (GIMP_DIALOG (dlg)) == GTK_RESPONSE_OK);

	if (run)
	{
		/*  Save ui values  */


		/* posledni faze pred spustenim */

	}

	gtk_widget_destroy (dlg);

	return run;
}


/*  Private functions  */

static gboolean
dialog_image_constraint_func (gint32    image_id,
							  gpointer  data)
{
	return (gimp_image_base_type (image_id) == GIMP_RGB);
}

static void
dialog_gvf_callback (GtkWidget *widget,
					   gpointer   data)
{
	gvf_struct *obj = (gvf_struct *) data;

	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget))) {
		*obj->value = TRUE;
	}
	else {
		*obj->value = FALSE;
	}
	gimp_scale_entry_set_sensitive(obj->obj1,*obj->value);
	gimp_scale_entry_set_sensitive(obj->obj2,*obj->value);

	#if DEBUGGING
		printf("GVF parameter: %d\n", *obj->value);	
	#endif	
}


static void
dialog_gauss_callback (GtkWidget *widget,
					   gpointer   data)
{
	gauss_struct *obj = (gauss_struct *) data;

	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget))) {
		*obj->value = TRUE;
	}
	else {
		*obj->value = FALSE;
	}
	gimp_scale_entry_set_sensitive(obj->obj,*obj->value);

	#if DEBUGGING
		printf("Gaussian blur: %d\n", *obj->value);	
	#endif	
}