/* 
GIMP Plug-in Laso
Ondrej Fiala

main.h

pouzit Plug-in template - Michael Natterer
- novejsi verze
*/

#ifndef __MAIN_H__
#define __MAIN_H__


typedef struct
{
  gint      iterations;
  gint      image_force;
  gint      gvf_iterations;
  gdouble   gvf_noise;
  gdouble	tension;
  gdouble	flexure;
  gdouble	image_weight;
  gint		stopping;
  gint		iterations_force;
  gint      auto_iterations;
  gint      gaussian_blur;
  gdouble	blur_radius;
  gint		export_path;

} PlugInVals;

typedef struct
{
  gint32    image_id;
} PlugInImageVals;

typedef struct
{
  gint32    drawable_id;
} PlugInDrawableVals;

typedef struct
{
  gboolean  chain_active;
} PlugInUIVals;


/*  Default values  */

extern const PlugInVals         default_vals;
extern const PlugInImageVals    default_image_vals;
extern const PlugInDrawableVals default_drawable_vals;
extern const PlugInUIVals       default_ui_vals;

#endif /* __MAIN_H__ */
