/* 
GIMP Plug-in Laso
Ondrej Fiala

render.c

pouzit Plug-in template - Michael Natterer
*/


#include <stdio.h>
#include <libgimp/gimp.h>

#include "main.h"


/* translations strings */
#include "config.h"
#include "plugin-intl.h"

#include "snake.h"
#include "image.h"

#include "render.h"

/*  Public functions  */

void
render (gint32              image_ID,
		GimpDrawable       *drawable,
		PlugInVals         *vals,
		PlugInImageVals    *image_vals,
		PlugInDrawableVals *drawable_vals
		)
{

	GimpParam* returns;
	int numReturns;
	GimpParam params[6];

	/* selection to path */
	GimpParam params_sel2path[3];

	GimpDrawable *new_drawable;
	gint32 new_drawable_ID;
	gint *vectors;
	gint *strokes;
	gint num_vectors;
	gint num_strokes;
	gint new_vector;
	gdouble *strokes_points;
	gint num_strokes_points;
	gboolean strokes_closed;
	gboolean empty_selection, selection_to_path, all_to_path;
	gint selection_id;

#if DEBUGGING
	/* vypis informaci o obrazku a vyberu */
	gint x1, y1, x2, y2;
	GimpDrawable *mask = NULL;
	gint selection_width, selection_height;
	gboolean return_bool;
	time_t start_time;
#endif

	/* hlidani undo */
	gboolean undo_OK = FALSE;
	undo_OK = gimp_image_undo_group_start(image_ID);

	empty_selection = FALSE;
	selection_to_path = FALSE;
	all_to_path = FALSE;


#if DEBUGGING
	start_time = clock();
	
	printf("Rozmery obrazku: %d x %d.\n", drawable->width,drawable->height);

	if (gimp_drawable_mask_bounds(drawable->drawable_id, &x1, &y1, &x2, &y2)) {
		/* klic pro upravy vyberu */
		selection_width = x2 - x1;
		selection_height = y2 - y1;
		printf("Rozmery vyberu: %d x %d.\n", selection_width,selection_height);
	}
	printf("Gaussian blur: %d, %f\n", vals->gaussian_blur, vals->blur_radius);
#endif


	/* INICIALIZACE KRIVKY 
	   vyber ma prednost pred cestou
	*/
	/* kontrola na existujici vyber */
	selection_id = gimp_image_get_selection(image_ID);
	if (gimp_selection_is_empty(image_ID))
	{
		empty_selection = TRUE;
		/* kontrola na existujici cestu */
		vectors = gimp_image_get_vectors(image_ID, &num_vectors);

		/* pokud neni cesta, udelam ji z vyberu */
		if (num_vectors == 0){	
			/* prace na celem obrazku */
			all_to_path = TRUE;	
		} else { // mame cestu, neni prazdna?
			/* kontrola na prazdnou caru */
			strokes = gimp_vectors_get_strokes(vectors[0],&num_strokes);
			if(num_strokes == 0){
				/* prace na celem obrazku */
				all_to_path = TRUE;	
			}
		}
	} else {
			selection_to_path = TRUE;	
	}

	/* selection => path */
	if(selection_to_path)
	{
		/* tvorba cesty z vyberu */
		params_sel2path[0].type = GIMP_PDB_INT32;
		params_sel2path[0].data.d_int32 = GIMP_RUN_NONINTERACTIVE;
		params_sel2path[1].type = GIMP_PDB_IMAGE;
		params_sel2path[1].data.d_image = image_ID;
		params_sel2path[2].type = GIMP_PDB_DRAWABLE;
		params_sel2path[2].data.d_drawable = drawable->drawable_id;
		returns = gimp_run_procedure2("plug_in_sel2path", &numReturns, 3, params_sel2path);

		num_vectors = 0;
		vectors = gimp_image_get_vectors(image_ID, &num_vectors); 
		/* zrusim aktualni vyber */
		gimp_selection_none(image_ID);
	}

#if DEBUGGING
	printf("After curve inicialization %2.3f sec\n", (float)(clock() - start_time) / CLOCKS_PER_SEC);
#endif

	/* creates new drawable for operations */

	new_drawable_ID = gimp_layer_new_from_drawable(drawable->drawable_id, image_ID);
	gimp_image_add_layer(image_ID,new_drawable_ID,-1);
	new_drawable = gimp_drawable_get(new_drawable_ID);


	if(vals->gaussian_blur == 1) {
		int success;
		#if DEBUGGING
			printf("Pouzit Gaussian blur.\n");
		#endif

		params[0].type = GIMP_PDB_INT32;
		params[0].data.d_int32 = GIMP_RUN_NONINTERACTIVE;
		params[1].type = GIMP_PDB_IMAGE;
		params[1].data.d_image = image_ID;
		params[2].type = GIMP_PDB_DRAWABLE;
		params[2].data.d_drawable = new_drawable->drawable_id;
		params[3].type = GIMP_PDB_FLOAT;
		params[3].data.d_float = vals->blur_radius;
		params[4].type = GIMP_PDB_INT32;
		params[4].data.d_int32 = 1;
		params[5].type = GIMP_PDB_INT32;
		params[5].data.d_int32 = 1;

		returns = gimp_run_procedure2("plug_in_gauss_iir", &numReturns, 6, params);
		success = returns && (numReturns > 0) && (returns[0].type == GIMP_PDB_STATUS) && (returns[0].data.d_status == GIMP_PDB_SUCCESS);
		gimp_destroy_params(returns, numReturns);
		/* pri neuspechu zalozit undo krok */
		if (! success) {
			if (undo_OK) {
				gimp_image_undo_group_end(image_ID);
			}
		}		
	}
#if DEBUGGING
	printf("After Gauss %2.3f sec\n", (float)(clock() - start_time) / CLOCKS_PER_SEC);
#endif


	/* prevod cesty na body */
	if(all_to_path) {
		/* body jen v rozich */
		image_get_bound_points(&num_strokes_points, &strokes_points, drawable);
	} else {
		/* mam neprazdnou cestu */
		strokes = gimp_vectors_get_strokes(vectors[0],&num_strokes);

		gimp_vectors_stroke_close (vectors[0], strokes[0]);
		gimp_vectors_stroke_get_points(vectors[0], strokes[0],&num_strokes_points,&strokes_points,&strokes_closed);
		#if DEBUGGING
			printf("Number of points on the stroke: %d\n", num_strokes_points);
		#endif

		/* vymazani docasne cesty */
		if(selection_to_path)
			gimp_image_remove_vectors(image_ID, vectors[0]);
	}

#if DEBUGGING
	printf("Before Snakes %2.3f sec\n", (float)(clock() - start_time) / CLOCKS_PER_SEC);
#endif

	/* matika */
	snake_iterate(&num_strokes_points, &strokes_points, vals, new_drawable);	


#if DEBUGGING
	printf("After Snakes %2.3f sec\n", (float)(clock() - start_time) / CLOCKS_PER_SEC);
#endif

	new_vector = gimp_vectors_new (image_ID,_("Laso path"));
	gimp_image_add_vectors(image_ID,new_vector,-1);

	gimp_vectors_stroke_new_from_points(new_vector,GIMP_VECTORS_STROKE_TYPE_BEZIER,
										num_strokes_points,strokes_points,TRUE);

	gimp_vectors_to_selection(new_vector,GIMP_CHANNEL_OP_REPLACE,TRUE,FALSE,0,0);
	if(!vals->export_path){
		gimp_image_remove_vectors(image_ID, new_vector);
	}

#if DEBUGGING
	printf("Elapsed %2.3f sec\n", (float)(clock() - start_time) / CLOCKS_PER_SEC);
	getch();
#endif

	/* delete temporary layer */
	gimp_image_remove_layer(image_ID, new_drawable->drawable_id);


	gimp_image_undo_group_end(image_ID);

	g_message (_("Done."));
}
