/* 
GIMP Plug-in Laso
Ondrej Fiala

snake.c

data structures for curve and points
*/


#include <stdio.h>
#include <libgimp/gimp.h>

// better than "gimpintl.h"

#include "main.h"

/* translations strings */
#include "config.h"
#include "plugin-intl.h"

#include "edge.h"
#include "force.h"
#include "image.h"

#include "snake.h"

/* MAIN snake function */
gint snake_iterate(gint *num_gimp_points, gdouble **gimp_points, PlugInVals *vals, GimpDrawable *drawable)
{
	Curve curve, curve_old, vector_tensile,vector_flexure,vector_stopping,vector_tensile_last,vector_flexure_last,vector_image, vector_iterations;
	Point point_image,point_tensile,point_flexure,point_stopping;
	gint i,j;
	gint x,y;
	Curve bezier;
	Point** image_vector_field;
	Point** igf;
	guint** image_field;
	gdouble **laplace_field_normalized;
	gint** imgf;
	gint width, height;
	gdouble diff_lenght;
	gint num_stay;
	Point zero;
	gdouble max_tensile, max_flexure, max_image;
	gdouble ifce,ifce_max;

	/* managing iterations */
	gboolean iteration_end;
	gint iterations;

#if DEBUGGING
	time_t start_time;
	start_time = clock();
	printf("Start Snakes %2.3f sec\n", (float)(clock() - start_time) / CLOCKS_PER_SEC);
#endif

	width = drawable->width;
	height = drawable->height;
	iteration_end = FALSE;
	if(vals->auto_iterations == 1){
		iterations = SNAKE_ITERATIONS;
	} else {
		iterations = vals->iterations;
	}
	point_tensile = point_new(0,0);
	point_flexure = point_new(0,0);
	point_stopping = point_new(0,0);
	point_image = point_new(0,0);
	zero = point_new(0,0);

	bezier = curve_new();

	curve = curve_from_gimp_points(*num_gimp_points,*gimp_points);

	/* master's check if everything goes good so far */
	if((curve._number<2)||(curve._number>CURVE_MAX))
		return FALSE;

	curve_old = curve_new();
	curve_check_bounds(&curve,width,height);

	vector_tensile = curve_new();
	vector_flexure = curve_new();
	vector_stopping = curve_new();
	vector_tensile_last = curve_new();
	vector_flexure_last = curve_new();
	vector_image = curve_new();
	vector_iterations = curve_new();

	max_tensile = -Inf;
	max_flexure = -Inf;
	max_image = -Inf;



	/* get image data */
	image_field = image_intensity_field(drawable);

#if DEBUGGING
	printf("Snakes - After GET_IMAGE_DATA %2.3f sec\n", (float)(clock() - start_time) / CLOCKS_PER_SEC);
#endif


	/* get edge map */
	laplace_field_normalized = laplacian_normalized(image_field, drawable);
	g_free(image_field);

#if DEBUGGING
	printf("Snakes - After Laplace %2.3f sec\n", (float)(clock() - start_time) / CLOCKS_PER_SEC);
#endif

	/* GVF */
	if(vals->image_force) {
		
		imgf = image_intensity_field(drawable);
		igf = image_gradient_field(laplace_field_normalized,drawable);


#if DEBUGGING
	printf("Snakes - After Gradient %2.3f sec\n", (float)(clock() - start_time) / CLOCKS_PER_SEC);
#endif
		image_vector_field = image_gvf(igf, vals->gvf_iterations, vals->gvf_noise, drawable);
		g_free(igf);

	/* image intensity */
	} else {
		image_vector_field = image_force5x5_double(laplace_field_normalized, drawable);
	}

#if DEBUGGING
	printf("Snakes - After GVF %2.3f sec\n", (float)(clock() - start_time) / CLOCKS_PER_SEC);
#endif


	gimp_progress_init (_("Snakes - Iterations"));
	j = 0;
	for(j = 0;(j < vals->iterations)&&(!iteration_end);j++){
		curve_clear(&vector_tensile_last);
		curve_clear(&vector_flexure_last);

		curve_copy(&vector_tensile_last,&vector_tensile);
		curve_copy(&vector_flexure_last,&vector_flexure);

		curve_clear(&vector_tensile);
		curve_clear(&vector_flexure);
		curve_clear(&vector_stopping);
		curve_clear(&vector_image);
		max_tensile = 0;
		max_flexure = 0;
		max_image = 0;

		for(i = 0;i < curve._number;i++){
			tensile_force(&point_tensile, &curve, i);
			max_tensile = MAX(get_module(point_tensile.x,point_tensile.y),max_tensile);
			flexure_force(&point_flexure, &curve, i);
			max_flexure = MAX(get_module(point_flexure.x,point_flexure.y),max_flexure);

			/* souradnice aktualniho bodu */
			x = (gint)(curve.points[i].x);
			if(x < 0){x = 0;}
			if(x >= width){x = width-1;}
			y = (gint)(curve.points[i].y);
			if(y < 0){y = 0;}
			if(y >= height){y = height-1;}

			/* IMAGE FUNCTION */
			/* bilinear interpolation */
			point_set_interpolate(&point_image,image_vector_field,curve.points[i].x,curve.points[i].y,width,height);

			max_image = MAX(get_module(point_image.x,point_image.y),max_image); 



			/* EDGE STOPPING */
			if (vals->stopping == 1) {
				force_stopping_point_normalized(&point_stopping,laplace_field_normalized[x][y]);
				curve_add(&vector_stopping,&point_stopping);
			}

			curve_add(&vector_tensile,&point_tensile);			
			curve_add(&vector_flexure,&point_flexure);
			curve_add(&vector_image,&point_image);
		}

		/* paths throught vector^2 - could be used in model modification
		force_normalize_2(&vector_tensile,1.0);
		force_normalize_2(&vector_flexure,1.0);
		*/

		/* normalizace vektoru */
		force_normalize(&vector_tensile,max_tensile);
		force_normalize(&vector_flexure,max_flexure);
		force_normalize(&vector_image,max_image);


		/* aplikace optimalizace EDGE STOPPING */
		if (vals->stopping == 1) {
			curve_divide_vector(&vector_tensile,&vector_stopping);			
			curve_divide_vector(&vector_flexure,&vector_stopping);
		}

		/* prepocitani funkci podle vah */
		curve_multiple(&vector_tensile,vals->tension);
		curve_multiple(&vector_flexure,vals->flexure);
		curve_multiple(&vector_image,vals->image_weight);


		/* secteni posunu do jednoho vektoru */
		curve_sum_vector(&vector_tensile,&vector_flexure);
		curve_sum_vector(&vector_tensile,&vector_image);	

		/* ITERATIONS FORCE */
		/* prepocet sil v zavislosti na cisle iterace	*/
		/* f(x) = (2 * MAX)/(j + MAX)			*/
		/* j = 0 .. (MAX-1) => ifce = 2 .. 1			*/
		if ((vals->iterations_force == 1)&&(vals->iterations > 1)) {
			curve_copy(&vector_iterations, &vector_tensile);

			ifce_max = (gdouble)(vals->iterations-1)/1;
			ifce = (2*(ifce_max))/((gdouble)j+ifce_max);
			curve_multiple(&vector_iterations,ifce);
		}

		/* FINAL CURVE ADJUSTMENT */
		if (vals->iterations_force == 1)
			curve_sum_vector(&curve,&vector_iterations);
		else
			curve_sum_vector(&curve,&vector_tensile);


		if ((j % 10) == 0){

			/* AUTO ITERATIONS */
			/* spocitat velikosti posunu a kolich jich je vetsich nez X */
			/*SNAKE_POINT_MOVE_MIN*/
			if(vals->auto_iterations == 1){
				curve_diff(&curve, &curve_old, &diff_lenght);
				curve_min_count(&vector_tensile, SNAKE_POINT_MOVE_MIN, &num_stay);
				#if DEBUGGING
					printf("CURVE_DIFF %f\t NUM_STAY %f\t POINTS %d\n", diff_lenght/curve._number, (gdouble)num_stay/curve._number, curve._number);
				#endif
			}

			/* optimilization of curve NUMBER OF POINTS */
			curve_interspace_points(&curve);
			curve_remove_points(&curve);


			if(vals->auto_iterations == 1){
				curve_copy(&curve_old, &curve);
				#if DEBUGGING
					printf("NUM_STAY %d FROM %d\n", num_stay, vector_tensile._number);
				#endif
			}

			if(curve._number <= 2) 
				iteration_end = TRUE;


			if((vals->auto_iterations == 1)&&((diff_lenght/curve._number) < SNAKE_POINT_DIFF_STOP)&&(((gdouble)num_stay / (gdouble)vector_tensile._number) > SNAKE_POINT_STAY_STOP)) {
				iteration_end = TRUE;
			}

			/* progress bar update */
			gimp_progress_update ((gdouble) j / (gdouble) (vals->iterations));
		}
	}

#if DEBUGGING
	printf("Number of iterations: %d\n", j);
#endif
	curve_check_bounds(&curve,width,height);

	bezier = curve_to_bezier(&curve);

	*gimp_points = curve_to_points(&bezier,num_gimp_points);

	g_free(image_vector_field);

	return 0;
}