/*
 * This is copyrighted software.  Originally uploaded at the GIMP Plugin
 * Registry (http://registry.gimp.org/).  This is to be distributed
 * ("conveyed") under the terms of version 3 of the GNU General Public License
 * (no other version, see the file "COPYING" for details).  THERE IS NO IMPLIED
 * WARRANTY FOR THIS PROGRAM.  USE AT YOUR OWN RISK.  For inquiries, email the
 * author at stamit@stamit.gr .  You may not remove this notice.
 */
#include "config.h"

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "main.h"
#include "interface.h"

#include "plugin-intl.h"


/*  Constants  */

//#define SCALE_WIDTH        180
//#define SPIN_BUTTON_WIDTH   75
//#define RANDOM_SEED_WIDTH  100


/*  Local function prototypes  */

//static gboolean   dialog_image_constraint_func (gint32    image_id,
//                                                gpointer  data);


/*  Local variables  */

static PlugInUIVals *ui_state = NULL;


/*  Public functions  */

gboolean dialog(gint32 image_ID, GimpDrawable *drawable, PlugInVals *vals, PlugInUIVals *ui_vals) {
  GtkWidget *dlg;
  GtkWidget *main_vbox;
  //GtkWidget *wid;
  //GtkObject *adj;
  //gint       row;
  gboolean   run = FALSE;
  //GimpUnit   unit;
  //gdouble    xres, yres;

  ui_state = ui_vals;

  gimp_ui_init (PLUGIN_NAME, TRUE);

  dlg = gimp_dialog_new(
  	_("Simple Interpolation"), PLUGIN_NAME,
	NULL, 0,
	gimp_standard_help_func, "plug-in-interpolate",
	GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	GTK_STOCK_OK,     GTK_RESPONSE_OK,
	NULL
  );

  main_vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 12);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dlg)->vbox), main_vbox);





  GtkWidget *chanindex_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (chanindex_hbox);
  gtk_container_add (GTK_CONTAINER (main_vbox), chanindex_hbox);

  GtkWidget *chanindex_label = gtk_label_new_with_mnemonic (_("_Input mask:"));
  gtk_widget_show (chanindex_label);
  gtk_box_pack_start (GTK_BOX (chanindex_hbox), chanindex_label, FALSE, FALSE, 6);
  gtk_label_set_justify (GTK_LABEL (chanindex_label), GTK_JUSTIFY_RIGHT);




  GtkWidget *chanid_combo = gimp_channel_combo_box_new(NULL, NULL);
  gtk_widget_show (chanid_combo);
  gimp_int_combo_box_set_active(GIMP_INT_COMBO_BOX(chanid_combo), vals->chanid);
  gtk_box_pack_start (GTK_BOX (chanindex_hbox), chanid_combo, FALSE, FALSE, 6);
  gtk_widget_set_tooltip_text(chanid_combo, _(
	"Which channel to use as the input mask."
  ));


  /*GtkObject *chanindex_adj = gtk_adjustment_new (vals->chanindex, -1, 65535, 1, 8, 8);
  GtkWidget *chanindex_spin = gtk_spin_button_new (GTK_ADJUSTMENT (chanindex_adj), 1, 0);
  gtk_widget_show (chanindex_spin);
  gtk_box_pack_start (GTK_BOX (chanindex_hbox), chanindex_spin, FALSE, FALSE, 6);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (chanindex_spin), TRUE);

  gtk_widget_set_tooltip_text(chanindex_spin, _(
	"Which channel to use as the input mask. "
	"0 is first channel, 1 is second and so on. "
	"Set to -1 to use the inverse of the selection (used by default if channel does not exist)."
  ));*/


  GtkWidget *usesel_hbox = gtk_hbox_new (FALSE, 10);
  gtk_widget_show (usesel_hbox);
  gtk_container_add (GTK_CONTAINER (main_vbox), usesel_hbox);


  GtkWidget *usesel = gtk_check_button_new_with_mnemonic(_("Use inverse of selection"));
  gtk_widget_show (usesel);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(usesel), vals->usesel);
  gtk_box_pack_start (GTK_BOX (usesel_hbox), usesel, FALSE, FALSE, 6);
  gtk_widget_set_tooltip_text(usesel, _(
  	"Use the inverse of the selection as the input mask."
  ));



  GtkWidget *halfsel = gtk_check_button_new_with_mnemonic(_("Read half-selected"));
  gtk_widget_show (halfsel);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(halfsel), vals->halfsel);
  gtk_box_pack_start (GTK_BOX (usesel_hbox), halfsel, FALSE, FALSE, 6);
  gtk_widget_set_tooltip_text(halfsel, _(
  	"Whether to read from input pixels whose corresponding input mask pixels have values less than 255. "
  	"If there is no input mask (first channel), the inverse of the selection is used."
  ));








  GtkWidget *window_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (window_hbox);
  gtk_container_add (GTK_CONTAINER (main_vbox), window_hbox);

  GtkWidget *window_label = gtk_label_new_with_mnemonic (_("_Window:"));
  gtk_widget_show (window_label);
  gtk_box_pack_start (GTK_BOX (window_hbox), window_label, FALSE, FALSE, 6);
  gtk_label_set_justify (GTK_LABEL (window_label), GTK_JUSTIFY_RIGHT);

  GtkObject *window_adj = gtk_adjustment_new (vals->window, 0, 1024, 1, 8, 8);
  GtkWidget *window_spin = gtk_spin_button_new (GTK_ADJUSTMENT (window_adj), 1, 0);
  gtk_widget_show (window_spin);
  gtk_box_pack_start (GTK_BOX (window_hbox), window_spin, FALSE, FALSE, 6);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (window_spin), TRUE);

  gtk_widget_set_tooltip_text(window_spin, _(
  	"Number of nearby pixels to sample for each output pixel, in order to calculate a weighted average. "
	"1 means a 3x3 rectangle, 2 means a 5x5 rectangle, and so on. "
	"Only pixels with mask values equal to 255 are read. "
	"If there is no input mask channel, the inverse of the selection is used."
  ));



  GtkWidget *kernel_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (kernel_hbox);
  gtk_container_add (GTK_CONTAINER (main_vbox), kernel_hbox);

  GtkWidget *kernel_label = gtk_label_new_with_mnemonic (_("_Kernel:"));
  gtk_widget_show (kernel_label);
  gtk_box_pack_start (GTK_BOX (kernel_hbox), kernel_label, FALSE, FALSE, 6);
  gtk_label_set_justify (GTK_LABEL (kernel_label), GTK_JUSTIFY_RIGHT);

  GtkWidget *kernel_combo = gtk_combo_box_new_text();
  gtk_widget_show (kernel_combo);
  gtk_combo_box_append_text(GTK_COMBO_BOX(kernel_combo), _("Constant"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(kernel_combo), _("Linear"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(kernel_combo), _("Square"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(kernel_combo), _("Inverse Linear"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(kernel_combo), _("Inverse Square"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(kernel_combo), _("Exponential"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(kernel_combo), _("Gaussian"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(kernel_combo), _("Inverse to the nth"));
  gtk_combo_box_set_active(GTK_COMBO_BOX(kernel_combo), (int)vals->kernel);
  gtk_box_pack_start (GTK_BOX (kernel_hbox), kernel_combo, FALSE, FALSE, 6);

  gtk_widget_set_tooltip_text(kernel_combo, _(
  	"The kernel has the weights for the averaging of the nearby pixels. "
  	"The weights are functions of the distance D from the center pixel. "
  	"Constant generates a white square of width Window+1+Window. "
  	"Linear is 1-D/s (cone with base 's', then a flat 0). "
  	"Square is 1-(D/s)^2 (again up to distance 's'). "
  	"Inverse Linear is 1/D . Inverse Square is 1/(D^2) . "
  	"Exponential is e^(-D) and the result is similar to smudging from the edges of the mask. "
  	"Gaussian is the standard Gaussian kernel with standard deviation 'S'. "
  	"Inverse to the nth is 1/(D^s)."
  ));




  GtkWidget *sigma_label = gtk_label_new_with_mnemonic (_("_S:"));
  gtk_widget_show (sigma_label);
  gtk_box_pack_start (GTK_BOX (kernel_hbox), sigma_label, FALSE, FALSE, 6);
  gtk_label_set_justify (GTK_LABEL (sigma_label), GTK_JUSTIFY_RIGHT);

  GtkObject *sigma_adj = gtk_adjustment_new (vals->sigma, 0.0, 1024, 1, 8, 8);
  GtkWidget *sigma_spin = gtk_spin_button_new (GTK_ADJUSTMENT (sigma_adj), 1, 2);
  gtk_widget_show (sigma_spin);
  gtk_box_pack_start (GTK_BOX (kernel_hbox), sigma_spin, FALSE, FALSE, 6);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (sigma_spin), TRUE);

  gtk_widget_set_tooltip_text(sigma_spin, _(
	"If kernel is Linear or Square, S is the radius after which the weights are zero. "
	"For Exponential it is a scale factor. For Gaussian it is the standard deviation."
	"For \"Inverse to the nth\" it is the exponent. "
	"Generally, the smaller the S the 'sharper' the result."
  ));



  GtkWidget *newlayer_check = gtk_check_button_new_with_mnemonic(_("New layer"));
  gtk_widget_show (newlayer_check);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(newlayer_check), vals->newlayer);
  gtk_box_pack_start (GTK_BOX (main_vbox), newlayer_check, FALSE, FALSE, 6);

  gtk_widget_set_tooltip_text(newlayer_check, _(
	"Make a new layer for the interpolation result. "
	"The new layer's alpha channel will be the selection. "
  ));









  GtkWidget *calcderivs_check = gtk_check_button_new_with_mnemonic(_("Calculate slopes"));
  gtk_widget_show (calcderivs_check);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(calcderivs_check), vals->calcderivs);
  gtk_box_pack_start (GTK_BOX (main_vbox), calcderivs_check, FALSE, FALSE, 6);

  gtk_widget_set_tooltip_text(calcderivs_check, _(
	"Whether to calculate a plane for each input pixel. "
	"This is how much the light intensity near that point increases or decreases, horizontally and vertically. "
	"This changes the way that the pixel affects nearby interpolated pixels. "
  ));




  GtkWidget *linwindow_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (linwindow_hbox);
  gtk_container_add (GTK_CONTAINER (main_vbox), linwindow_hbox);

  GtkWidget *linwindow_label = gtk_label_new_with_mnemonic (_("Lin. _Window:"));
  gtk_widget_show (linwindow_label);
  gtk_box_pack_start (GTK_BOX (linwindow_hbox), linwindow_label, FALSE, FALSE, 6);
  gtk_label_set_justify (GTK_LABEL (linwindow_label), GTK_JUSTIFY_RIGHT);

  GtkObject *linwindow_adj = gtk_adjustment_new (vals->linwindow, 0, 1024, 1, 8, 8);
  GtkWidget *linwindow_spin = gtk_spin_button_new (GTK_ADJUSTMENT (linwindow_adj), 1, 0);
  gtk_widget_show (linwindow_spin);
  gtk_box_pack_start (GTK_BOX (linwindow_hbox), linwindow_spin, FALSE, FALSE, 6);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (linwindow_spin), TRUE);

  gtk_widget_set_tooltip_text(linwindow_spin, _(
	"The size of the window to use for calculating the horizontal and vertical angles, as above."
  ));

  GtkWidget *linsymwin_check = gtk_check_button_new_with_mnemonic(_("Symm.win."));
  gtk_widget_show (linsymwin_check);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(linsymwin_check), vals->linsymwin);
  gtk_box_pack_start (GTK_BOX (linwindow_hbox), linsymwin_check, FALSE, FALSE, 6);

  gtk_widget_set_tooltip_text(linsymwin_check, _(
	"Whether to decrease the width or the height of the window near the edges of the image, "
	"so that it is symmetric around the center pixel."
  ));



  GtkWidget *lincenter_check = gtk_check_button_new_with_mnemonic(_("Re-center"));
  gtk_widget_show (lincenter_check);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lincenter_check), vals->lincenter);
  gtk_box_pack_start (GTK_BOX (linwindow_hbox), lincenter_check, FALSE, FALSE, 6);




  GtkWidget *linkernel_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (linkernel_hbox);
  gtk_container_add (GTK_CONTAINER (main_vbox), linkernel_hbox);

  GtkWidget *linkernel_label = gtk_label_new_with_mnemonic (_("Lin. _Kernel:"));
  gtk_widget_show (linkernel_label);
  gtk_box_pack_start (GTK_BOX (linkernel_hbox), linkernel_label, FALSE, FALSE, 6);
  gtk_label_set_justify (GTK_LABEL (linkernel_label), GTK_JUSTIFY_RIGHT);

  GtkWidget *linkernel_combo = gtk_combo_box_new_text();
  gtk_widget_show (linkernel_combo);
  gtk_combo_box_append_text(GTK_COMBO_BOX(linkernel_combo), _("Constant"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(linkernel_combo), _("Linear"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(linkernel_combo), _("Square"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(linkernel_combo), _("Inverse Linear"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(linkernel_combo), _("Inverse Square"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(linkernel_combo), _("Exponential"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(linkernel_combo), _("Gaussian"));
  gtk_combo_box_append_text(GTK_COMBO_BOX(linkernel_combo), _("Inverse to the nth"));
  gtk_combo_box_set_active(GTK_COMBO_BOX(linkernel_combo), (int)vals->linkernel);
  gtk_box_pack_start (GTK_BOX (linkernel_hbox), linkernel_combo, FALSE, FALSE, 6);

  gtk_widget_set_tooltip_text(linkernel_combo, _(
	"The type of kernel, as above."
  ));



  GtkWidget *linsigma_label = gtk_label_new_with_mnemonic (_("S:"));
  gtk_widget_show (linsigma_label);
  gtk_box_pack_start (GTK_BOX (linkernel_hbox), linsigma_label, FALSE, FALSE, 6);
  gtk_label_set_justify (GTK_LABEL (linsigma_label), GTK_JUSTIFY_RIGHT);

  GtkObject *linsigma_adj = gtk_adjustment_new (vals->linsigma, 0.0, 1024, 1, 8, 8);
  GtkWidget *linsigma_spin = gtk_spin_button_new (GTK_ADJUSTMENT (linsigma_adj), 1, 2);
  gtk_widget_show (linsigma_spin);
  gtk_box_pack_start (GTK_BOX (linkernel_hbox), linsigma_spin, FALSE, FALSE, 6);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (linsigma_spin), TRUE);

  gtk_widget_set_tooltip_text(linsigma_spin, _(
	"The parameter for the kernel, as above."
  ));



  /*GtkWidget *linnewlayer_check = gtk_check_button_new_with_mnemonic(_("New layer"));
  gtk_widget_show (linnewlayer_check);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(linnewlayer_check), vals->linnewlayer);
  gtk_box_pack_start (GTK_BOX (main_vbox), linnewlayer_check, FALSE, FALSE, 6);

  gtk_widget_set_tooltip_text(linnewlayer_check, _(
	"Make a new \"grain merge\" layer for the linear result. "
	"The new layer's alpha channel will be the selection."
  ));*/








  GtkWidget *changesel = gtk_check_button_new_with_mnemonic(_("Modify selection"));
  gtk_widget_show (changesel);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(changesel), vals->changesel);
  gtk_box_pack_start (GTK_BOX (main_vbox), changesel, FALSE, FALSE, 6);

  gtk_widget_set_tooltip_text(changesel, _(
	"Set new selection according to weight sums. "
	"This will shrink the selection so you can apply the filter again."
  ));






  GtkWidget *lowthres_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (lowthres_hbox);
  gtk_container_add (GTK_CONTAINER (main_vbox), lowthres_hbox);

  GtkWidget *lowthres_label = gtk_label_new_with_mnemonic (_("_Low threshold:"));
  gtk_widget_show (lowthres_label);
  gtk_box_pack_start (GTK_BOX (lowthres_hbox), lowthres_label, FALSE, FALSE, 6);
  gtk_label_set_justify (GTK_LABEL (lowthres_label), GTK_JUSTIFY_RIGHT);

  GtkObject *lowthres_adj = gtk_adjustment_new (vals->lowthres, -1073741824.0, 1073741824.0, 1, 9, 9);
  GtkWidget *lowthres_spin = gtk_spin_button_new (GTK_ADJUSTMENT (lowthres_adj), 1, 8);
  gtk_widget_show (lowthres_spin);
  gtk_box_pack_start (GTK_BOX (lowthres_hbox), lowthres_spin, FALSE, FALSE, 6);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (lowthres_spin), TRUE);

  gtk_widget_set_tooltip_text(lowthres_spin, _(
	"If the selection is modified, this is the weight-sum value that will give completely selected pixels. "
	"This must be smaller than \"High threshold\". "
	"Larger values here and in \"High threshold\" shrink the selection more."
  ));


  GtkWidget *highthres_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (highthres_hbox);
  gtk_container_add (GTK_CONTAINER (main_vbox), highthres_hbox);

  GtkWidget *highthres_label = gtk_label_new_with_mnemonic (_("_High threshold:"));
  gtk_widget_show (highthres_label);
  gtk_box_pack_start (GTK_BOX (highthres_hbox), highthres_label, FALSE, FALSE, 6);
  gtk_label_set_justify (GTK_LABEL (highthres_label), GTK_JUSTIFY_RIGHT);

  GtkObject *highthres_adj = gtk_adjustment_new (vals->highthres, -1073741824.0, 1073741824.0, 1, 9, 9);
  GtkWidget *highthres_spin = gtk_spin_button_new (GTK_ADJUSTMENT (highthres_adj), 1, 8);
  gtk_widget_show (highthres_spin);
  gtk_box_pack_start (GTK_BOX (highthres_hbox), highthres_spin, FALSE, FALSE, 6);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (highthres_spin), TRUE);

  gtk_widget_set_tooltip_text(highthres_spin, _(
	"If the selection is modified, this is the weight-sum value that will give completely unselected pixels. "
	"This must be larger than \"Low threshold\". "
	"Larger values here and in \"Low threshold\" shrink the selection more."
  ));



  GtkWidget *logthres = gtk_check_button_new_with_mnemonic(_("Log scale new selection"));
  gtk_widget_show (logthres);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(logthres), vals->logthres);
  gtk_box_pack_start (GTK_BOX (main_vbox), logthres, FALSE, FALSE, 6);

  gtk_widget_set_tooltip_text(logthres, _(
	"Use with Exponential and Gaussian kernels. "
	"By default there is a linear relation between the weight-sums and the new selection."
  ));



  GtkWidget *multmask = gtk_check_button_new_with_mnemonic(_("Multiply with input mask"));
  gtk_widget_show (multmask);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(multmask), vals->multmask);
  gtk_box_pack_start (GTK_BOX (main_vbox), multmask, FALSE, FALSE, 6);

  gtk_widget_set_tooltip_text(multmask, _(
	"Whether to multiply new selection with input mask. "
	"New selection is always multiplied with old selection."
  ));







  //GtkWidget *frame;
  //GtkWidget *table;
  //GtkWidget *hbox2;
//  /*  gimp_scale_entry_new() examples  */
//
//  frame = gimp_frame_new (_("ScaleEntry Examples"));
//  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, FALSE, 0);
//  gtk_widget_show (frame);
//
//  table = gtk_table_new (3, 3, FALSE);
//  gtk_table_set_col_spacings (GTK_TABLE (table), 6);
//  gtk_table_set_row_spacings (GTK_TABLE (table), 2);
//  gtk_container_add (GTK_CONTAINER (frame), table);
//  gtk_widget_show (table);
//
//  row = 0;
//
//  adj = gimp_scale_entry_new (GTK_TABLE (table), 0, row++,
//			      _("Dummy 1:"), SCALE_WIDTH, SPIN_BUTTON_WIDTH,
//			      vals->dummy1, 0, 100, 1, 10, 0,
//			      TRUE, 0, 0,
//			      _("Dummy scale entry 1"), NULL);
//  g_signal_connect (adj, "value_changed",
//                    G_CALLBACK (gimp_int_adjustment_update),
//                    &vals->dummy1);
//
//  adj = gimp_scale_entry_new (GTK_TABLE (table), 0, row++,
//			      _("Dummy 2:"), SCALE_WIDTH, SPIN_BUTTON_WIDTH,
//			      vals->dummy2, 0, 200, 1, 10, 0,
//			      TRUE, 0, 0,
//			      _("Dummy scale entry 2"), NULL);
//  g_signal_connect (adj, "value_changed",
//                    G_CALLBACK (gimp_int_adjustment_update),
//                    &vals->dummy2);
//
//  adj = gimp_scale_entry_new (GTK_TABLE (table), 0, row++,
//			      _("Dummy 3:"), SCALE_WIDTH, SPIN_BUTTON_WIDTH,
//			      vals->dummy3, -100, 100, 1, 10, 0,
//			      TRUE, 0, 0,
//			      _("Dummy scale entry 3"), NULL);
//  g_signal_connect (adj, "value_changed",
//                    G_CALLBACK (gimp_int_adjustment_update),
//                    &vals->dummy3);
//
//  /*  gimp_random_seed_new() example  */
//
//  frame = gimp_frame_new (_("A Random Seed Entry"));
//  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, FALSE, 0);
//  gtk_widget_show (frame);
//  hbox = gtk_hbox_new (FALSE, 6);
//  gtk_container_add (GTK_CONTAINER (frame), hbox);
//  gtk_widget_show (hbox);
//
//  hbox2 = gimp_random_seed_new (&vals->seed, &vals->random_seed);
//  gtk_widget_set_size_request (GTK_WIDGET (GIMP_RANDOM_SEED_SPINBUTTON (hbox2)),
//                               RANDOM_SEED_WIDTH, -1);
//  gtk_box_pack_start (GTK_BOX (hbox), hbox2, FALSE, FALSE, 0);
//  gtk_widget_show (hbox2);
//
//  /*  gimp_coordinates_new() example  */
//
//  frame = gimp_frame_new (_("A GimpCoordinates Widget\n"
//			   "Initialized with the Drawable's Size"));
//  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, FALSE, 0);
//  gtk_widget_show (frame);
//
//  hbox = gtk_hbox_new (FALSE, 4);
//  gtk_container_set_border_width (GTK_CONTAINER (hbox), 4);
//  gtk_container_add (GTK_CONTAINER (frame), hbox);
//  gtk_widget_show (hbox);
//
//  unit = gimp_image_get_unit (image_ID);
//  gimp_image_get_resolution (image_ID, &xres, &yres);
//
//  wid = gimp_coordinates_new (unit, "%p", TRUE, TRUE, SPIN_BUTTON_WIDTH,
//				      GIMP_SIZE_ENTRY_UPDATE_SIZE,
//
//				      ui_vals->chain_active, TRUE,
//
//				      _("Width:"), drawable->width, xres,
//				      1, GIMP_MAX_IMAGE_SIZE,
//				      0, drawable->width,
//
//				      _("Height:"), drawable->height, yres,
//				      1, GIMP_MAX_IMAGE_SIZE,
//				      0, drawable->height);
//  gtk_box_pack_start (GTK_BOX (hbox), wid, FALSE, FALSE, 0);
//  gtk_widget_show (wdid);
//
//  /*  Image and drawable menus  */
//
//  frame = gimp_frame_new (_("Image and Drawable Menu Examples"));
//  gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, FALSE, 0);
//  gtk_widget_show (frame);
//
//  table = gtk_table_new (3, 2, FALSE);
//  gtk_container_set_border_width (GTK_CONTAINER (table), 4);
//  gtk_table_set_col_spacings (GTK_TABLE (table), 4);
//  gtk_table_set_row_spacings (GTK_TABLE (table), 2);
//  gtk_container_add (GTK_CONTAINER (frame), table);
//  gtk_widget_show (table);
//
//  row = 0;
//
//  wid = gimp_layer_combo_box_new (NULL, NULL);
//  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (wid), drawable->drawable_id,
//                              G_CALLBACK (gimp_int_combo_box_get_active),
//                              &drawable_vals->drawable_id);
//
//  gimp_table_attach_aligned (GTK_TABLE (table), 0, row++,
//			     _("Layers:"), 0.0, 0.5, wid, 1, FALSE);
//
//  wid = gimp_image_combo_box_new (dialog_image_constraint_func, NULL);
//  gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (wid), image_ID,
//                              G_CALLBACK (gimp_int_combo_box_get_active),
//                              &image_vals->image_id);
//
//  gimp_table_attach_aligned (GTK_TABLE (table), 0, row++,
//			     _("RGB Images:"), 0.0, 0.5, wid, 1, FALSE);
//



  gtk_widget_show (main_vbox);
  gtk_widget_show (dlg);

  run = (gimp_dialog_run (GIMP_DIALOG (dlg)) == GTK_RESPONSE_OK);

  if (run)
    {
      /*  Save ui values  */
      //ui_state->chain_active =
      //  gimp_chain_button_get_active (GIMP_COORDINATES_CHAINBUTTON (wid));

          gimp_int_combo_box_get_active(GIMP_INT_COMBO_BOX(chanid_combo),&vals->chanid);
          vals->usesel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(usesel));
          if (vals->chanid==-1) vals->usesel = TRUE;
          vals->halfsel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(halfsel));

	  vals->window = gtk_adjustment_get_value(GTK_ADJUSTMENT(window_adj));
	  vals->sigma = gtk_adjustment_get_value(GTK_ADJUSTMENT(sigma_adj));
	  vals->kernel = gtk_combo_box_get_active(GTK_COMBO_BOX(kernel_combo));
          vals->newlayer = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(newlayer_check));

          vals->multmask = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(multmask));

          vals->calcderivs = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(calcderivs_check));
	  vals->linwindow = gtk_adjustment_get_value(GTK_ADJUSTMENT(linwindow_adj));
          vals->linsymwin = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(linsymwin_check));
          vals->lincenter = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lincenter_check));
	  vals->linsigma = gtk_adjustment_get_value(GTK_ADJUSTMENT(linsigma_adj));
	  vals->linkernel = gtk_combo_box_get_active(GTK_COMBO_BOX(linkernel_combo));
          //vals->linnewlayer = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(linnewlayer_check));

          vals->changesel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(changesel));
	  vals->lowthres = gtk_adjustment_get_value(GTK_ADJUSTMENT(lowthres_adj));
	  vals->highthres = gtk_adjustment_get_value(GTK_ADJUSTMENT(highthres_adj));
          vals->logthres = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(logthres));
    }

  gtk_widget_destroy (dlg);

  return run;
}


/*  Private functions  */

//static gboolean
//dialog_image_constraint_func (gint32    image_id,
//                              gpointer  data)
//{
//  return (gimp_image_base_type (image_id) == GIMP_RGB);
//}
