/*
 * This is copyrighted software.  Originally uploaded at the GIMP Plugin
 * Registry (http://registry.gimp.org/).  This is to be distributed
 * ("conveyed") under the terms of version 3 of the GNU General Public License
 * (no other version, see the file "COPYING" for details).  THERE IS NO IMPLIED
 * WARRANTY FOR THIS PROGRAM.  USE AT YOUR OWN RISK.  For inquiries, email the
 * author at stamit@stamit.gr .  You may not remove this notice.
 */
#ifndef __MAIN_H__
#define __MAIN_H__

typedef enum InterpolateKernelType {
	KERNEL_CONSTANT,
	KERNEL_LINEAR,
	KERNEL_SQUARE,
	KERNEL_INVLINEAR,
	KERNEL_INVSQUARE,
	KERNEL_EXPONENTIAL,
	KERNEL_GAUSSIAN,
	KERNEL_INVNTH,
} InterpolateKernelType;

typedef struct {
	gint chanid;
	gboolean usesel;
	gboolean halfsel;

	gint window;
	gfloat sigma;
	InterpolateKernelType kernel;
	gboolean newlayer;

	gboolean calcderivs;
	gint linwindow;
	gboolean lincenter;
	gboolean linsymwin;
	gfloat linsigma;
	InterpolateKernelType linkernel;
	//gboolean linnewlayer;  // TODO

	gboolean changesel;
	gfloat lowthres;
	gfloat highthres;
	gboolean logthres;
	gboolean multmask;
} PlugInVals;

typedef struct {
	gboolean dummy;
} PlugInUIVals;

/*  Default values  */
extern const PlugInVals         default_vals;
extern const PlugInUIVals       default_ui_vals;

#endif /* __MAIN_H__ */
