/*
 * This is copyrighted software.  Originally uploaded at the GIMP Plugin
 * Registry (http://registry.gimp.org/).  This is to be distributed
 * ("conveyed") under the terms of version 3 of the GNU General Public License
 * (no other version, see the file "COPYING" for details).  THERE IS NO IMPLIED
 * WARRANTY FOR THIS PROGRAM.  USE AT YOUR OWN RISK.  For inquiries, email the
 * author at stamit@stamit.gr .  You may not remove this notice.
 */
typedef struct Ring {
	gint left,top,right,bottom;
	gint inleft,intop,inwidth,inheight;
	GimpDrawable *dr;
	GimpPixelRgn pr;
	GimpImageType type;
	gint bpp;
	gint bpr;
	gint rowbase;
	gint rowcount;
	guchar *rows;
	gint y;
	gint window;
} Ring;

inline static void ring_init(Ring *ring, GimpDrawable *dr, gint left, gint top, gint right, gint bottom, gint window) {
	ring->left = left;
	ring->top = top;
	ring->right = right;
	ring->bottom = bottom;

	ring->inleft = MAX(left-window,0);
	ring->intop = MAX(top-window,0);
	ring->inwidth = MIN(right+window,dr->width)-ring->inleft;
	ring->inheight = MIN(bottom+window,dr->height)-ring->intop;

	ring->dr = dr;

	ring->type = gimp_drawable_type(dr->drawable_id);
	ring->bpp = gimp_drawable_bpp(dr->drawable_id);
	ring->bpr = ring->inwidth*ring->bpp;
	ring->rowbase = top-window;
	ring->rowcount = (1+2*window);
	ring->rows = g_new(guchar, ring->rowcount*ring->bpr);
	ring->y = top;
	ring->window = window;

	gimp_pixel_rgn_init(&ring->pr, dr,
		ring->inleft,
		ring->intop,
		ring->inwidth,
		ring->inheight,
	FALSE, FALSE);
	gint y;
	for (y = MAX(top-window,0) ;
	     y <= MIN(top+window,dr->height-1) ; ++y) {
		gimp_pixel_rgn_get_row(&ring->pr,
			ring->rows + (y-ring->rowbase)*ring->bpr,
			ring->inleft, y, ring->inwidth
		);
	}
}

inline static void ring_fini(Ring *ring) {
	g_free(ring->rows);
}

inline static gboolean ring_loop(Ring *ring) {
	return ring->y<ring->bottom;
}

inline static void ring_rotate(Ring *ring) {
	++ring->y;
	if (ring->y+ring->window < ring->dr->height) {
		gimp_pixel_rgn_get_row(&ring->pr,
			ring->rows + ((ring->y+ring->window-ring->rowbase)%ring->rowcount)*ring->bpr,
			ring->inleft, ring->y+ring->window, ring->inwidth
		);
	}
}

inline static guchar *ring_row(Ring *ring, gint y) {
	return ring->rows + ( ((y-ring->rowbase)%ring->rowcount)*ring->bpr + (ring->left-ring->inleft)*ring->bpp );
}
