/*
 * This is copyrighted software.  Originally uploaded at the GIMP Plugin
 * Registry (http://registry.gimp.org/).  This is to be distributed
 * ("conveyed") under the terms of version 3 of the GNU General Public License
 * (no other version, see the file "COPYING" for details).  THERE IS NO IMPLIED
 * WARRANTY FOR THIS PROGRAM.  USE AT YOUR OWN RISK.  For inquiries, email the
 * author at stamit@stamit.gr .  You may not remove this notice.
 */
#ifndef __MAIN_H__
#define __MAIN_H__

#include <libgimp/gimp.h>


typedef enum InterpolateKernelType {
	KERNEL_CONSTANT,
	KERNEL_LINEAR,
	KERNEL_SQUARE,
	KERNEL_INVLINEAR,
	KERNEL_INVSQUARE,
	KERNEL_EXPONENTIAL,
	KERNEL_GAUSSIAN,
	KERNEL_INVNTH,
	KERNEL_BRUSH,
	KERNEL_BRUSH_FLIPPED,
	KERNEL_BILINEAR,
	KERNEL_BINTH,
	KERNEL_SINC,
	KERNEL_SINC_LANCZOS,
	KERNEL_SINC_R,
} InterpolateKernelType;

typedef enum InterpolateMethod {
	METHOD_OLD_CENTER,
	METHOD_LEASTSQ_CENTER,
	METHOD_FLAT_AVERAGES,
	METHOD_LEASTSQ,
	METHOD_QUADRATIC,
} InterpolateMethod;

typedef struct {
	gint chanid;
	gboolean usesel;
	gint halfsel;

	gint window;
	gfloat sigma;
	InterpolateKernelType kernel;
	gboolean newlayer;

	gboolean slopes;
	InterpolateMethod method;
	gint linwindow;
	gfloat linsigma;
	InterpolateKernelType linkernel;
	gboolean linnewlayer;

	gboolean changesel;
	gfloat lowthres;
	gfloat highthres;
	gboolean logthres;
	gboolean multmask;

	gboolean all_white_input;

	gboolean gamma_compensation;
	gfloat gamma;
	gint grid, grid_y;
	gint offs, offs_y;

	gfloat norm;
	gfloat linnorm;

	gfloat slopesmult;

	gint window_y;
	gint linwindow_y;

	gfloat kernel_cap;
	gfloat kernel_base;
	gfloat linkernel_cap;
	gfloat linkernel_base;

	gboolean slopesmask;
	gint slopeschanid;
	gboolean slopesmaskwhite;
	gboolean slopessubsel;
	gint linhalfsel;
	gboolean slopesweights;
} PlugInVals;

typedef struct {
	gboolean preview;
	gboolean sepaxes;
} PlugInUIVals;

/*  Default values  */
extern const PlugInVals         default_vals;
extern const PlugInUIVals       default_ui_vals;

#endif /* __MAIN_H__ */
