/*
 * This is copyrighted software.  Originally uploaded at the GIMP Plugin
 * Registry (http://registry.gimp.org/).  This is to be distributed
 * ("conveyed") under the terms of version 3 of the GNU General Public License
 * (no other version, see the file "COPYING" for details).  THERE IS NO IMPLIED
 * WARRANTY FOR THIS PROGRAM.  USE AT YOUR OWN RISK.  For inquiries, email the
 * author at stamit@stamit.gr .  You may not remove this notice.
 */
typedef struct Ring {
	gint left,top,right,bottom;
	gint inleft,intop,inwidth,inheight;
	GimpDrawable *dr;
	GimpPixelRgn pr;
	GimpImageType type;
	gint bpp;
	gint bpr;
	gint rowbase;
	gint rowcount;
	guchar *rows;
	gint y;
	gint windowx;
	gint windowy;
} Ring;

inline static void ring_init(Ring *ring, GimpDrawable *dr, gint left, gint top, gint right, gint bottom, gint windowx, gint windowy) {
	ring->left = left;
	ring->top = top;
	ring->right = right;
	ring->bottom = bottom;

	ring->inleft = MAX(left-windowx,0);
	ring->intop = MAX(top-windowy,0);
	ring->inwidth = MIN(right+windowx,dr->width)-ring->inleft;
	ring->inheight = MIN(bottom+windowy,dr->height)-ring->intop;

	ring->dr = dr;

	ring->type = gimp_drawable_type(dr->drawable_id);
	ring->bpp = gimp_drawable_bpp(dr->drawable_id);
	ring->bpr = ring->inwidth*ring->bpp;
	ring->rowbase = top-windowy;
	ring->rowcount = (1+2*windowy);
	ring->rows = g_new(guchar, ring->rowcount*ring->bpr);
	ring->y = top;
	ring->windowx = windowx;
	ring->windowy = windowy;

	gimp_pixel_rgn_init(&ring->pr, dr,
		ring->inleft,
		ring->intop,
		ring->inwidth,
		ring->inheight,
	FALSE, FALSE);
	gint y;
	for (y = MAX(top-windowy,0) ;
	     y <= MIN(top+windowy,dr->height-1) ; ++y) {
		gimp_pixel_rgn_get_row(&ring->pr,
			ring->rows + (y-ring->rowbase)*ring->bpr,
			ring->inleft, y, ring->inwidth
		);
	}
}

inline static void ring_fini(Ring *ring) {
	g_free(ring->rows);
}

inline static gboolean ring_loop(Ring *ring) {
	return ring->y<ring->bottom;
}

inline static void ring_rotate(Ring *ring) {
	++ring->y;
	if (ring->y+ring->windowy < ring->dr->height) {
		gimp_pixel_rgn_get_row(&ring->pr,
			ring->rows + ((ring->y+ring->windowy-ring->rowbase)%ring->rowcount)*ring->bpr,
			ring->inleft, ring->y+ring->windowy, ring->inwidth
		);
	}
}

inline static guchar *ring_row(Ring *ring) {
	return ring->rows + ( ((ring->y-ring->rowbase)%ring->rowcount)*ring->bpr + (ring->left-ring->inleft)*ring->bpp );
}
inline static guchar *ring_row_delta(Ring *ring, gint deltay) {
	return ring->rows + ( ((ring->y+deltay-ring->rowbase)%ring->rowcount)*ring->bpr + (ring->left-ring->inleft)*ring->bpp );
}

inline static gint ring_min_deltay(Ring *ring) {
	return MAX(-ring->windowy, -ring->y);
}
inline static gint ring_max_deltay(Ring *ring) {
	return MIN(ring->windowy, ring->dr->height-1-ring->y);
}
inline static gint ring_min_deltax(Ring *ring, gint x) {
	return MAX(-ring->windowx, -x);
}
inline static gint ring_max_deltax(Ring *ring, gint x) {
	return MIN(ring->windowx, ring->dr->width-1-x);
}
