/* GIMP Plug-in Toy
 * Copyright (C) 2011  Rüdiger Schneider <remschneid@web.de> (the "Author").
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of the Author of the
 * Software shall not be used in advertising or otherwise to promote the
 * sale, use or other dealings in this Software without prior written
 * authorization from the Author.
 */

#ifndef __INTERFACE_H__
#define __INTERFACE_H__

gboolean toy_dialog(gint32 image_ID,GimpDrawable *drawable);
void draw_gradient(GimpDrawable *drawable,GimpPreviewArea *preview);
void toy_variables_init();
void toy_realize_callback(GtkWidget *widget);
gboolean toy_expose_callback(GtkWidget *widget,GdkEvent *event);
gboolean pressed_keys(GtkWidget *widget,GdkEventKey *key);
gboolean released_keys(GtkWidget *widget,GdkEventKey *key);
void mouse_released(GtkWidget *widget,GdkEvent *event);
gboolean motion_and_mouse(GtkWidget *widget,GdkEvent *event);
void recalc_handle_position(gint x,gint y,gboolean both);
gdouble round_value(gdouble in);
void toy_value_changed(GtkWidget *widget);
void toy_update_preview(gint x0,gint y0,gint x1,gint y1);
void gimp_int_adjustment_update_cs(GtkAdjustment *adjustment,gpointer data);
void gimp_double_adjustment_update_r(GtkAdjustment *adjustment,gpointer data);
void gimp_double_adjustment_update_m(GtkAdjustment *adjustment,gpointer data);

#endif /* __INTERFACE_H__ */
