/* GIMP Plug-in Toy
 * Copyright (C) 2011  Rüdiger Schneider <remschneid@web.de> (the "Author").
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of the Author of the
 * Software shall not be used in advertising or otherwise to promote the
 * sale, use or other dealings in this Software without prior written
 * authorization from the Author.
 */

#ifndef __MAIN_H__
#define __MAIN_H__

typedef enum
{
  BLUR_NORMAL,
  BLUR_CAMERA
} BlurMethod;

typedef struct
{
	gint8 type;
	gint8 transparency;
	gint *coordinates;
	gboolean active;
	gpointer *next;
} ToyObjects;

typedef struct
{  
	gint contrast;
	gint saturation;
	gdouble radius;
	gdouble start[2],end[2];
	ToyObjects *toyobjects;
	BlurMethod method;
} ToyVals;

typedef struct
{  
	gint preview_width;
	gint preview_height;
	gint16 maxpreview;
	gint32 tmpimg_id;
	gint32 background_id;
	GimpDrawable *drawable;
	GimpDrawable *preview_drawable;
	guchar *pic_buffer;
	guchar *preview_buffer;
	gchar *csbuffer;
	gchar *alpbuffer;
	gdouble pre2img;
	GtkWidget *preview;
	gboolean radius_changed;
	gboolean mask_changed;
	gboolean contrastsaturation_changed;
} TmpVals;

typedef struct 
{
	gint8 offsetx;
	gint8 offsety;
	gint8 handlesize;
	gint8 active_tool;
	gint difference_x;
	gint difference_y;
	gint coordinates[4];
	cairo_surface_t *starthandle;
	cairo_surface_t *middlehandle;
	cairo_surface_t *endhandle;
	GtkAdjustment *startx;
	GtkAdjustment *starty;
	GtkAdjustment *endx;
	GtkAdjustment *endy;
	gboolean inhandle1;
	gboolean inhandle2;
	gboolean button_down;
	gboolean gradient_hidden;
	gboolean show_line;
} HandleVals;

typedef struct 
{
  guchar **luts;
  gint     nchannels;
} GimpLut;

#define PROCEDURE_NAME   "plug-in-toy"
#define GRADIENTNAME "toygradient"
#define MAXPREVIEWSIZE 400

extern gint preview_idle;
extern gboolean is27;
extern ToyVals	toyvals;
extern TmpVals tmpvals;
extern HandleVals handlevals;
extern gchar *toygradient;
extern gchar *oldgradient;
void get_from_gimprc();
void save_to_gimprc();
void free_toy_objects();
extern void toy();
extern gboolean toy_dialog(gint32 image_ID,GimpDrawable *drawable);
extern void free_buffers_and_tempimage();
extern void restore_original_gradient();

#endif /* __MAIN_H__ */
