/* GIMP Plug-in Toy
 * Copyright (C) 2011  Rüdiger Schneider <remschneid@web.de> (the "Author").
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHOR BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of the Author of the
 * Software shall not be used in advertising or otherwise to promote the
 * sale, use or other dealings in this Software without prior written
 * authorization from the Author.
 */

#ifndef __RENDER_H__
#define __RENDER_H__

typedef gfloat (*GimpLutFunc) (gint nchannels,gint channel,gfloat value);

GimpLut* gimp_lut_new(void);
void gimp_lut_setup(GimpLut *lut,GimpLutFunc func,gint bytes);
void gimp_lut_free(GimpLut *lut);
void separate_alpha(guchar *buffer,gint width,gint bytes);
void multiply_alpha(guchar *buffer,gint width,gint bytes);
gfloat contrast_lut_func(gint bytes,gint channel,gfloat value);
void process_pixel(GimpLut *lut,guchar *buffer,gint bytes);
void handle_layers_and_image(gboolean preview);
void toy();
void saturation(guchar *buffer,gint bytes);
void contrastsaturation_and_gauss(GimpLut *lut,GimpDrawable *drawable,gint x1,gint y1,gint width,gint height);
void transfer_pixels(const gdouble *src1,const gdouble *src2,guchar *dest,gint bytes,gint width);
void find_iir_constants(gdouble *n_p,gdouble *n_m,gdouble *d_p,gdouble *d_m,gdouble *bd_p,gdouble *bd_m,gdouble  std_dev);
gboolean gimp_image_insert_layer_wrapper(gint32 image_ID,gint32 layer_ID,gint32 parent_ID,gint position);

#endif /* __RENDER_H__ */
