/* 
 * Copyright (C) 2005 Alexandre Heitor Schmidt <alexsmith@solis.coop.br>
 * (the "Author").
 * All Rights Reserved.
 *
 * This file is part of GIMP Image Subtraction Plug-In.
 * Foobar is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * GIMP Image Subtraction Plug-In is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * GIMP Image Subtraction Plug-In; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 */

#include "config.h"

#include <libgimp/gimp.h>
#include <libgimp/gimpui.h>

#include "main.h"
#include "interface.h"

#include "plugin-intl.h"


/*  Constants  */

#define SCALE_WIDTH        180
#define SPIN_BUTTON_WIDTH   75

/*  Public functions  */

gboolean
can_be_added(   gint32 image_id,
                gint32 drawable_id,
                gpointer data) {
                    
    return gimp_drawable_is_rgb(drawable_id);
}

gboolean
dialog (PlugInVals *vals)
{
    GtkWidget *dlg;
    GtkWidget *main_vbox;
    GtkWidget *frame;
    GtkWidget *table;
    GtkWidget *combo_layer1;
    GtkWidget *combo_layer2;
    gint       row;
    gboolean   run = FALSE;
    GtkObject *adj;
    
    gimp_ui_init (PLUGIN_NAME, TRUE);

    dlg = gimp_dialog_new (_("Image subtraction"),
                           PLUGIN_NAME,
                           NULL, 0,
                           gimp_standard_help_func, "image-subtraction",
                           GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                           GTK_STOCK_OK,     GTK_RESPONSE_OK,
                           NULL);

    main_vbox = gtk_vbox_new (FALSE, 12);
    gtk_container_set_border_width (GTK_CONTAINER (main_vbox), 12);
    gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dlg)->vbox), main_vbox);

    frame = gimp_frame_new (_("Layers selection"));
    gtk_box_pack_start (GTK_BOX (main_vbox), frame, FALSE, FALSE, 0);
    gtk_widget_show (frame);

    table = gtk_table_new (4, 2, FALSE);
    gtk_container_set_border_width (GTK_CONTAINER (table), 4);
    gtk_table_set_col_spacings (GTK_TABLE (table), 4);
    gtk_table_set_row_spacings (GTK_TABLE (table), 2);
    gtk_container_add (GTK_CONTAINER (frame), table);
    gtk_widget_show (table);
    
    row = 0;

    combo_layer1 = gimp_layer_combo_box_new (can_be_added, NULL);
    gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo_layer1), vals->drawable_id1,
                                G_CALLBACK (gimp_int_combo_box_get_active),
                                &vals->drawable_id1);

    gimp_table_attach_aligned (GTK_TABLE (table), 0, row++,
                               _("Master layer:"), 0.0, 0.5, combo_layer1, 1, FALSE);

    combo_layer2 = gimp_layer_combo_box_new (can_be_added, NULL);
    gimp_int_combo_box_connect (GIMP_INT_COMBO_BOX (combo_layer2), vals->drawable_id2,
                                G_CALLBACK (gimp_int_combo_box_get_active),
                                &vals->drawable_id2);

    gimp_table_attach_aligned (GTK_TABLE (table), 0, row++,
                               _("Slave layer:"), 0.0, 0.5, combo_layer2, 1, FALSE);

    adj = gimp_scale_entry_new (GTK_TABLE (table), 0, row++,
                                _("Threshold %:"), SCALE_WIDTH, SPIN_BUTTON_WIDTH,
                                vals->threshold, 0, 100, 1, 10, 0,
                                TRUE, 0, 0,
                                _("Set to 0 for no threshold"), NULL);
    g_signal_connect (adj, "value_changed",
                      G_CALLBACK (gimp_int_adjustment_update),
                      &vals->threshold);

    gtk_widget_show (main_vbox);
    gtk_widget_show (dlg);

    // wait until user presses OK or Cancel
    run = (gimp_dialog_run (GIMP_DIALOG (dlg)) == GTK_RESPONSE_OK);

    gtk_widget_destroy (dlg);

    return run;
}
