/* 
 * Copyright (C) 2005 Alexandre Heitor Schmidt <alexsmith@solis.coop.br>
 * (the "Author").
 * All Rights Reserved.
 *
 * This file is part of GIMP Image Subtraction Plug-In.
 * Foobar is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * GIMP Image Subtraction Plug-In is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * GIMP Image Subtraction Plug-In; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 */

#ifndef __PLUGIN_INTL_H__
#define __PLUGIN_INTL_H__


#ifndef GETTEXT_PACKAGE
#error "config.h must be included prior to plugin-intl.h"
#endif

#include <libintl.h>

#define _(String) gettext (String)

#ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#else
#    define N_(String) (String)
#endif


#endif /* __PLUGIN_INTL_H__ */
