#!/usr/bin/python
# -*- coding: utf8 -*-
"""Plug-in Builder"""

import gettext,os.path,string,gtk
locale_dir = os.path.join(os.path.dirname(os.path.abspath(__file__)),'locale')

gettext.install('plugb',\
                locale_dir,\
                unicode=True)
template="""#!/usr/bin/python
# -*- coding: utf8 -*-
# Generated by Gimp IDE
def plugin_main(*args):
$text$

register(
        "$id$",
        _("$shortname$"),
        _("$help$"),
        _("$author$"),
        _("$copyright$"),
        "$date$",
        "$menupath$",
        "$imgtype$",
        [],
        [],
        plugin_main)
main()
"""

class PlugInBuilder:
    """Show Dialog and process_them"""
    def __init__(self,UI_file,text):
        self.text = text
        self.wTree         = gtk.glade.XML(UI_file, "PluginMaster")
        self.wTree.signal_autoconnect(self)
        self.dlg           = self.wTree.get_widget("PluginMaster")
        self.id_ed         = self.wTree.get_widget("id_ed")
        self.shortname_ed  = self.wTree.get_widget("shortname_ed")
        self.help_ed       = self.wTree.get_widget("help_ed")
        self.autor_ed      = self.wTree.get_widget("autor_ed")
        self.copyright_ed  = self.wTree.get_widget("copyright_ed")
        self.date_ed       = self.wTree.get_widget("date_ed")
        self.mnu_ed        = self.wTree.get_widget("mnu_ed")
        self.img_type_ed   = self.wTree.get_widget("img_type_ed")
        self.fileselButton = self.wTree.get_widget("path_ed")
        self.filename=''
        self.localizeDialog()
        result = self.dlg.run()
        print "result:",result
        self.dlg.destroy()

    def on_file_select(self,widget,**kw):
        """Fileopen button handler"""
        filename = None
        chooser = gtk.FileChooserDialog(_("Open File..."), self.dlg,
                                        gtk.FILE_CHOOSER_ACTION_SAVE,
                                        (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
                                         gtk.STOCK_OPEN, gtk.RESPONSE_OK))

        response = chooser.run()
        if response == gtk.RESPONSE_OK: 
            filename = chooser.get_filename()
            self.fileselButton.set_text(filename)
        chooser.destroy()
        

    def on_save_clicked(self,widget,**kw):
        """Click save button"""
        text=self.text
        self.filename = self.fileselButton.get_text()
        if self.filename:
            result_text=""
            buf = []
            for l in text.split('\n'):
                buf.append('\t'+l)
            result_text=string.join(buf,'')
            plugin_text = template
            plugin_text = plugin_text.replace('$id$',        self.id_ed.get_text())
            plugin_text = plugin_text.replace('$shortname$', self.shortname_ed.get_text())
            plugin_text = plugin_text.replace('$help$',      self.help_ed.get_text())
            plugin_text = plugin_text.replace('$author$',    self.autor_ed.get_text())
            plugin_text = plugin_text.replace('$copyright$', self.date_ed.get_text())
            plugin_text = plugin_text.replace('$menupath$',  self.mnu_ed.get_text())
            plugin_text = plugin_text.replace('$imgtype$',   self.img_type_ed.get_text())
            plugin_text = plugin_text.replace('$text$',      result_text)
#            print "Filename:",self.filename
#            print plugin_text
            f = open(self.filename,'w')
            f.write(plugin_text)
            f.close()
            self.dlg.response(gtk.RESPONSE_OK)
        else:
            dialog = gtk.MessageDialog(None,
                                   gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                                   gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, _('You not set filename'))
            dialog.run()
            dialog.destroy()

    def on_cancel_clicked(self,widget,**kw):
        """Click cancel button"""
        self.dlg.response(gtk.RESPONSE_CANCEL)
        
    def localizeDialog(self):
        """Set localized texts in dialog"""
        self.shortname_ed.set_text(_("Dummy Plug-In"))
        self.help_ed.set_text(_("Dummy Plug-in generated by Gimp IDE"))
        self.wTree.get_widget("id_lbl").set_text(_("Unique Identifier of Plug-In"))
        self.wTree.get_widget("shortname_lbl").set_text(_("Short name of Plug-In"))
        self.wTree.get_widget("help_lbl").set_text(_("Deatiled name for help"))
        self.wTree.get_widget("autor_lbl").set_text(_("Autor"))
        self.wTree.get_widget("copyright_lbl").set_text(_("Copyright"))
        self.wTree.get_widget("date_lbl").set_text(_("Date"))
        self.wTree.get_widget("mnu_lbl").set_text(_("Menu path (start <Image> or <Toolbox>"))
        self.wTree.get_widget("img_type_lbl").set_text(_("Type of image (* or RGB*, GRAY*, etc)"))
        self.wTree.get_widget("path_lbl").set_text(_("Path to save"))
        
        
