#!/usr/bin/python
# -*- coding: utf8 -*-
"""Execute file"""

import sys
import string,os.path
from traceback import print_exc, format_exception

from localize import _

class Error:
    """
    An Error is a string message with a fail/succeed boolean value 
    It can be returned out of a function for display elsewhere and retain
    use for if checks.
    """

    def __init__(self,message,success=False):
        self.message = message
        self.success = success

    def __call__(self):
        return self.success

    def __str__(self):
        return self.message

def listf(data):
    buffer = ""
    for line in data:
        buffer = buffer + line + "\n"
    return buffer

def recompile( modulename ):
    """
    first, see if the module can be imported at all...
    """
    try:
        tmp = __import__(modulename)
    except:
        return Error(_("Couldn't import module %s") % modulename)

    """
    Use the imported module to determine its actual path
    """
    pycfile = tmp.__file__
    modulepath = string.replace(pycfile, ".pyc", ".py")

    """
    Try to open the specified module as a file
    """
    try:
        code=open(modulepath, 'rU').read()
    except:
        return Error(_("Error opening file: %s .  Does it exist?") % modulepath )

    """
    see if the file we opened can compile.  If not, return the error that it gives.
    if compile() fails, the module will not be replaced.
    """
    try:
        compile(code, modulename, "exec")
    except:
       return Error(_("Error in compilation: %s ") % str(sys.exc_info()[0]) +"\r\n" + listf(format_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)) )
    else:
        """
        Ok, it compiled.  But will it execute without error?
        """
        try:
            execfile(modulepath)
        except:
            return Error(_("Error in execution: %s") % str(sys.exc_info()[0]) +"\r\n" + listf(format_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)) )
        else:
            """
            at this point, the code both compiled and ran without error.  Load it up
            replacing the original code.
            """

            reload( sys.modules[modulename] )

    return Error(_("Module successfully recompiled"), True)

def execute_file(filename):
    result = None
    dirname    = os.path.dirname(filename)
    shortfilename = os.path.basename(filename)
    if shortfilename[-3:].lower()!='.py':
        return Error(_("Script must have '.py' extension"), True)
    modulename = shortfilename[:-3]
    #Check the path in sys.path
    in_syspath = False
    this_in_syspath = False
    if dirname in sys.path:
           in_syspath      = True
           this_in_syspath = True
    if not in_syspath:
            sys.path.append(dirname)
#    result = recompile( modulename )
    try:
#            print "Exec file"
            execfile(filename)
#            print "Exec file Ok"
            result = Error(_("Module successfully recompiled"), True)
    except:
            result=Error(_("Error in execution: %s") % str(sys.exc_info()[0]) +"\r\n" + listf(format_exception(sys.exc_type, sys.exc_value, sys.exc_traceback)) )

    if this_in_syspath:
        sys.path.remove(dirname)
    return result
